/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.thedigsite;

import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.conditional.ObjectCondition;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.npc.DialogRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.util.Operation;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.var.VarplayerRequirement;
import com.questhelper.requirements.widget.WidgetTextRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ItemStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.THE_DIG_SITE)
public class TheDigSite
extends BasicQuestHelper {
    ItemRequirement pestleAndMortar;
    ItemRequirement vialHighlighted;
    ItemRequirement tinderbox;
    ItemRequirement tea;
    ItemRequirement ropes2;
    ItemRequirement rope;
    ItemRequirement opal;
    ItemRequirement charcoal;
    ItemRequirement specimenBrush;
    ItemRequirement specimenJar;
    ItemRequirement panningTray;
    ItemRequirement panningTrayFull;
    ItemRequirement trowel;
    ItemRequirement varrock2;
    ItemRequirement digsiteTeleports;
    ItemRequirement sealedLetter;
    ItemRequirement specialCup;
    ItemRequirement teddybear;
    ItemRequirement skull;
    ItemRequirement nitro;
    ItemRequirement nitrate;
    ItemRequirement chemicalCompound;
    ItemRequirement groundCharcoal;
    ItemRequirement invitation;
    ItemRequirement talisman;
    ItemRequirement mixedChemicals;
    ItemRequirement mixedChemicals2;
    ItemRequirement arcenia;
    ItemRequirement powder;
    ItemRequirement liquid;
    ItemRequirement tablet;
    ItemRequirement key;
    ItemRequirement unstampedLetter;
    ItemRequirement trowelHighlighted;
    ItemRequirement tinderboxHighlighted;
    ItemRequirement chemicalCompoundHighlighted;
    Requirement talkedToFemaleStudent;
    Requirement talkedToOrangeStudent;
    Requirement talkedToGreenStudent;
    Requirement talkedToGuide;
    Requirement letterStamped;
    Requirement hasTeddy;
    Requirement hasSkull;
    Requirement hasSpecialCup;
    Requirement femaleStudentQ1Learnt;
    Requirement orangeStudentQ1Learnt;
    Requirement greenStudentQ1Learnt;
    Requirement femaleStudentQ2Learnt;
    Requirement orangeStudentQ2Learnt;
    Requirement greenStudentQ2Learnt;
    Requirement femaleStudentQ3Learnt;
    Requirement femaleExtorting;
    Requirement orangeStudentQ3Learnt;
    Requirement greenStudentQ3Learnt;
    Requirement syncedUp;
    Requirement syncedUp2;
    Requirement syncedUp3;
    Requirement givenTalismanIn;
    Requirement rope1Added;
    Requirement rope2Added;
    Requirement inUndergroundTemple1;
    Requirement inDougRoom;
    Requirement openedBarrel;
    Requirement searchedBricks;
    Requirement hasKeyOrPowderOrMixtures;
    Requirement openPowderChestNearby;
    Requirement inUndergroundTemple2;
    Requirement knowStateAsJustStartedQuest;
    Requirement knowStateAsJustCompletedFirstExam;
    Requirement knowStateAsJustCompletedSecondExam;
    QuestStep talkToExaminer;
    QuestStep talkToHaig;
    QuestStep talkToExaminer2;
    QuestStep searchBush;
    QuestStep takeTray;
    QuestStep talkToGuide;
    QuestStep panWater;
    QuestStep pickpocketWorkmen;
    QuestStep talkToFemaleStudent;
    QuestStep talkToFemaleStudent2;
    QuestStep talkToOrangeStudent;
    QuestStep talkToOrangeStudent2;
    QuestStep talkToGreenStudent;
    QuestStep talkToGreenStudent2;
    QuestStep takeTest1;
    QuestStep talkToFemaleStudent3;
    QuestStep talkToOrangeStudent3;
    QuestStep talkToGreenStudent3;
    QuestStep takeTest2;
    QuestStep talkToFemaleStudent4;
    QuestStep takeTest3;
    QuestStep getJar;
    QuestStep getBrush;
    QuestStep digForTalisman;
    QuestStep talkToExpert;
    QuestStep useInvitationOnWorkman;
    QuestStep useRopeOnWinch;
    QuestStep goDownWinch;
    QuestStep pickUpRoot;
    QuestStep searchBricks;
    QuestStep goUpRope;
    QuestStep goDownToDoug;
    QuestStep talkToDoug;
    QuestStep goUpFromDoug;
    QuestStep unlockChest;
    QuestStep searchChest;
    QuestStep useTrowelOnBarrel;
    QuestStep useVialOnBarrel;
    QuestStep usePowderOnExpert;
    QuestStep useLiquidOnExpert;
    QuestStep mixNitroWithNitrate;
    QuestStep grindCharcoal;
    QuestStep addCharcoal;
    QuestStep addRoot;
    QuestStep goDownToExplode;
    QuestStep useCompound;
    QuestStep useTinderbox;
    QuestStep takeTablet;
    QuestStep useTabletOnExpert;
    QuestStep syncStep;
    QuestStep talkToFemaleStudent5;
    QuestStep talkToOrangeStudent4;
    QuestStep talkToGreenStudent4;
    QuestStep useRopeOnWinch2;
    QuestStep goDownToExplode2;
    QuestStep goDownForTablet;
    QuestStep goUpWithTablet;
    QuestStep searchPanningTray;
    Zone undergroundTemple1;
    Zone dougRoom;
    Zone undergroundTemple2;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToExaminer);
        ConditionalStep returnWithLetter = new ConditionalStep((QuestHelper)this, this.talkToHaig, new Requirement[0]);
        returnWithLetter.addStep(new Conditions(LogicType.NOR, this.knowStateAsJustStartedQuest), this.talkToExaminer);
        returnWithLetter.addStep(this.letterStamped, this.talkToExaminer2);
        steps.put(1, returnWithLetter);
        ConditionalStep goTakeTest1 = new ConditionalStep((QuestHelper)this, this.syncStep, new Requirement[0]);
        goTakeTest1.addStep(new Conditions(LogicType.NOR, this.knowStateAsJustCompletedFirstExam), this.takeTest1);
        goTakeTest1.addStep(new Conditions(this.femaleStudentQ1Learnt, this.orangeStudentQ1Learnt, this.greenStudentQ1Learnt), this.takeTest1);
        goTakeTest1.addStep(new Conditions(this.femaleStudentQ1Learnt, this.orangeStudentQ1Learnt, this.talkedToGreenStudent), this.talkToGreenStudent2);
        goTakeTest1.addStep(new Conditions(this.femaleStudentQ1Learnt, this.orangeStudentQ1Learnt, this.hasSkull, this.specimenBrush), this.talkToGreenStudent);
        goTakeTest1.addStep(new Conditions(this.femaleStudentQ1Learnt, this.talkedToOrangeStudent, this.hasSkull, this.specimenBrush), this.talkToOrangeStudent2);
        goTakeTest1.addStep(new Conditions(this.femaleStudentQ1Learnt, this.hasSpecialCup, this.hasSkull, this.specimenBrush), this.talkToOrangeStudent);
        goTakeTest1.addStep(new Conditions(this.talkedToFemaleStudent, this.hasSpecialCup, this.hasSkull, this.specimenBrush), this.talkToFemaleStudent2);
        goTakeTest1.addStep(new Conditions(this.hasTeddy, this.hasSpecialCup, this.hasSkull, this.specimenBrush), this.talkToFemaleStudent);
        goTakeTest1.addStep(new Conditions(this.syncedUp, this.hasTeddy, this.hasSpecialCup), this.pickpocketWorkmen);
        goTakeTest1.addStep(new Conditions(this.syncedUp, this.hasTeddy, this.panningTrayFull, this.talkedToGuide), this.searchPanningTray);
        goTakeTest1.addStep(new Conditions(this.syncedUp, this.hasTeddy, this.panningTray, this.talkedToGuide), this.panWater);
        goTakeTest1.addStep(new Conditions(this.syncedUp, this.hasTeddy, this.panningTray), this.talkToGuide);
        goTakeTest1.addStep(new Conditions(this.syncedUp, this.hasTeddy), this.takeTray);
        goTakeTest1.addStep(this.syncedUp, this.searchBush);
        steps.put(2, goTakeTest1);
        ConditionalStep goTakeTest2 = new ConditionalStep((QuestHelper)this, this.syncStep, new Requirement[0]);
        goTakeTest1.addStep(new Conditions(LogicType.NOR, this.knowStateAsJustCompletedSecondExam), this.takeTest2);
        goTakeTest2.addStep(new Conditions(this.syncedUp2, this.femaleStudentQ2Learnt, this.orangeStudentQ2Learnt, this.greenStudentQ2Learnt), this.takeTest2);
        goTakeTest2.addStep(new Conditions(this.syncedUp2, this.femaleStudentQ2Learnt, this.orangeStudentQ2Learnt), this.talkToGreenStudent3);
        goTakeTest2.addStep(new Conditions(this.syncedUp2, this.femaleStudentQ2Learnt), this.talkToOrangeStudent3);
        goTakeTest2.addStep(this.syncedUp2, this.talkToFemaleStudent3);
        steps.put(3, goTakeTest2);
        ConditionalStep goTakeTest3 = new ConditionalStep((QuestHelper)this, this.syncStep, new Requirement[0]);
        goTakeTest3.addStep(new Conditions(this.femaleStudentQ3Learnt, this.orangeStudentQ3Learnt, this.greenStudentQ3Learnt), this.takeTest3);
        goTakeTest3.addStep(new Conditions(this.syncedUp3, this.femaleStudentQ3Learnt, this.orangeStudentQ3Learnt), this.talkToGreenStudent4);
        goTakeTest3.addStep(new Conditions(this.syncedUp3, this.femaleStudentQ3Learnt), this.talkToOrangeStudent4);
        goTakeTest3.addStep(new Conditions(this.syncedUp3, this.femaleExtorting), this.talkToFemaleStudent5);
        goTakeTest3.addStep(this.syncedUp3, this.talkToFemaleStudent4);
        steps.put(4, goTakeTest3);
        ConditionalStep findTalisman = new ConditionalStep((QuestHelper)this, this.getJar, new Requirement[0]);
        findTalisman.addStep(new Conditions(this.givenTalismanIn), this.useInvitationOnWorkman);
        findTalisman.addStep(new Conditions(this.talisman), this.talkToExpert);
        findTalisman.addStep(new Conditions(this.specimenJar, this.specimenBrush), this.digForTalisman);
        findTalisman.addStep(new Conditions(this.specimenJar), this.getBrush);
        steps.put(5, findTalisman);
        ConditionalStep learnHowToMakeExplosives = new ConditionalStep((QuestHelper)this, this.useRopeOnWinch2, new Requirement[0]);
        learnHowToMakeExplosives.addStep(this.inDougRoom, this.talkToDoug);
        learnHowToMakeExplosives.addStep(new Conditions(this.inUndergroundTemple1, this.arcenia), this.goUpRope);
        learnHowToMakeExplosives.addStep(this.inUndergroundTemple1, this.pickUpRoot);
        learnHowToMakeExplosives.addStep(new Conditions(this.rope2Added), this.goDownToDoug);
        ConditionalStep makeExplosives = new ConditionalStep((QuestHelper)this, this.goDownWinch, new Requirement[0]);
        makeExplosives.addStep(new Conditions(this.chemicalCompound, this.inUndergroundTemple1), this.useCompound);
        makeExplosives.addStep(this.inDougRoom, this.goUpFromDoug);
        makeExplosives.addStep(new Conditions(this.inUndergroundTemple1, this.arcenia), this.goUpRope);
        makeExplosives.addStep(this.inUndergroundTemple1, this.pickUpRoot);
        makeExplosives.addStep(new Conditions(this.chemicalCompound), this.goDownToExplode);
        makeExplosives.addStep(new Conditions(this.arcenia, this.mixedChemicals2), this.addRoot);
        makeExplosives.addStep(new Conditions(this.arcenia, this.mixedChemicals, this.groundCharcoal), this.addCharcoal);
        makeExplosives.addStep(new Conditions(this.arcenia, this.mixedChemicals, this.charcoal), this.grindCharcoal);
        makeExplosives.addStep(new Conditions(this.arcenia, this.nitrate, this.nitro), this.mixNitroWithNitrate);
        makeExplosives.addStep(new Conditions(this.arcenia, this.powder, this.nitro), this.usePowderOnExpert);
        makeExplosives.addStep(new Conditions(this.arcenia, this.powder, this.liquid), this.useLiquidOnExpert);
        makeExplosives.addStep(new Conditions(this.arcenia, this.powder, this.liquid), this.useVialOnBarrel);
        makeExplosives.addStep(new Conditions(this.arcenia, this.powder, this.openedBarrel), this.useVialOnBarrel);
        makeExplosives.addStep(new Conditions(this.arcenia, this.powder), this.useTrowelOnBarrel);
        makeExplosives.addStep(new Conditions(this.openPowderChestNearby, this.arcenia), this.searchChest);
        makeExplosives.addStep(this.arcenia, this.unlockChest);
        ConditionalStep discovery = new ConditionalStep((QuestHelper)this, this.useRopeOnWinch, new Requirement[0]);
        discovery.addStep(this.hasKeyOrPowderOrMixtures, makeExplosives);
        discovery.addStep(this.searchedBricks, learnHowToMakeExplosives);
        discovery.addStep(new Conditions(this.inUndergroundTemple1, this.arcenia), this.searchBricks);
        discovery.addStep(this.inUndergroundTemple1, this.pickUpRoot);
        discovery.addStep(this.rope1Added, this.goDownWinch);
        steps.put(6, discovery);
        ConditionalStep explodeWall = new ConditionalStep((QuestHelper)this, this.goDownToExplode2, new Requirement[0]);
        explodeWall.addStep(this.inUndergroundTemple1, this.useTinderbox);
        steps.put(7, explodeWall);
        ConditionalStep completeQuest = new ConditionalStep((QuestHelper)this, this.goDownForTablet, new Requirement[0]);
        completeQuest.addStep(new Conditions(this.tablet.alsoCheckBank(this.questBank), this.inUndergroundTemple2), this.goUpWithTablet);
        completeQuest.addStep(new Conditions(this.tablet.alsoCheckBank(this.questBank)), this.useTabletOnExpert);
        completeQuest.addStep(this.inUndergroundTemple2, this.takeTablet);
        steps.put(8, completeQuest);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.pestleAndMortar = new ItemRequirement("Pestle and mortar", 233).isNotConsumed();
        this.pestleAndMortar.setHighlightInInventory(true);
        this.vialHighlighted = new ItemRequirement("Vial", 229);
        this.vialHighlighted.setHighlightInInventory(true);
        this.tinderbox = new ItemRequirement("Tinderbox", 590).isNotConsumed();
        this.tinderboxHighlighted = this.tinderbox.highlighted();
        this.tea = new ItemRequirement("Cup of tea", 1978);
        this.ropes2 = new ItemRequirement("Rope", 954, 2);
        this.rope = new ItemRequirement("Rope", 954);
        this.rope.setHighlightInInventory(true);
        this.opal = new ItemRequirement("Opal", 1609);
        this.opal.setTooltip("You can get one by panning at the Digsite");
        this.opal.addAlternates(1625);
        this.charcoal = new ItemRequirement("Charcoal", 973);
        this.charcoal.setTooltip("Obtainable during quest by searching specimen trays");
        this.charcoal.setHighlightInInventory(true);
        this.specimenBrush = new ItemRequirement("Specimen brush", 670).isNotConsumed();
        this.specimenJar = new ItemRequirement("Specimen jar", 669).isNotConsumed();
        this.panningTray = new ItemRequirement("Panning tray", 677).isNotConsumed();
        this.panningTray.addAlternates(678, 679);
        this.panningTrayFull = new ItemRequirement("Panning tray", 679).isNotConsumed();
        this.trowel = new ItemRequirement("Trowel", 676).isNotConsumed();
        this.trowel.setTooltip("You can get another from one of the Examiners");
        this.trowelHighlighted = new ItemRequirement("Trowel", 676).isNotConsumed();
        this.trowelHighlighted.setHighlightInInventory(true);
        this.trowelHighlighted.setTooltip("You can get another from one of the Examiners");
        this.varrock2 = new ItemRequirement("Varrock teleports", 8007, 2);
        this.digsiteTeleports = new ItemRequirement("Digsite teleports", 12403, 2);
        this.sealedLetter = new ItemRequirement("Sealed letter", 683);
        this.sealedLetter.setTooltip("You can get another from Curator Haig in the Varrock Museum");
        this.specialCup = new ItemRequirement("Special cup", 672);
        this.teddybear = new ItemRequirement("Teddy", 673);
        this.skull = new ItemRequirement("Animal skull", 671);
        this.nitro = new ItemRequirement("Nitroglycerin", 703);
        this.nitro.setHighlightInInventory(true);
        this.nitrate = new ItemRequirement("Ammonium nitrate", 701);
        this.nitrate.setHighlightInInventory(true);
        this.chemicalCompound = new ItemRequirement("Chemical compound", 707);
        this.chemicalCompoundHighlighted = new ItemRequirement("Chemical compound", 707);
        this.chemicalCompoundHighlighted.setHighlightInInventory(true);
        this.groundCharcoal = new ItemRequirement("Ground charcoal", 704);
        this.groundCharcoal.setTooltip("You can make this by use a pestle and mortar on some charcoal. You can get charcoal from one of the specimen trays in the Digsite");
        this.groundCharcoal.setHighlightInInventory(true);
        this.invitation = new ItemRequirement("Invitation letter", 696);
        this.invitation.setTooltip("You can get another from the Archaeological expert");
        this.invitation.setHighlightInInventory(true);
        this.talisman = new ItemRequirement("Ancient talisman", 681);
        this.mixedChemicals = new ItemRequirement("Mixed chemicals", 705);
        this.mixedChemicals.setHighlightInInventory(true);
        this.mixedChemicals2 = new ItemRequirement("Mixed chemicals", 706);
        this.mixedChemicals2.setHighlightInInventory(true);
        this.arcenia = new ItemRequirement("Arcenia root", 708);
        this.arcenia.setHighlightInInventory(true);
        this.powder = new ItemRequirement("Chemical powder", 700);
        this.powder.setHighlightInInventory(true);
        this.liquid = new ItemRequirement("Unidentified liquid", 702);
        this.liquid.setHighlightInInventory(true);
        this.tablet = new ItemRequirement("Stone tablet", 699);
        this.tablet.setHighlightInInventory(true);
        this.key = new ItemRequirement("Chest key", 709);
        this.key.setHighlightInInventory(true);
        this.unstampedLetter = new ItemRequirement("Unstamped letter", 682);
        this.unstampedLetter.setTooltip("You can get another from the Exam Centre's examiners");
    }

    public void loadZones() {
        this.undergroundTemple1 = new Zone(new WorldPoint(3359, 9800, 0), new WorldPoint(3393, 9855, 0));
        this.undergroundTemple2 = new Zone(new WorldPoint(3360, 9734, 0), new WorldPoint(3392, 9790, 0));
        this.dougRoom = new Zone(new WorldPoint(3340, 9809, 0), new WorldPoint(3357, 9826, 0));
    }

    public void setupConditions() {
        this.inUndergroundTemple1 = new ZoneRequirement(this.undergroundTemple1);
        this.inUndergroundTemple2 = new ZoneRequirement(this.undergroundTemple2);
        this.inDougRoom = new ZoneRequirement(this.dougRoom);
        this.knowStateAsJustStartedQuest = new Conditions(true, new VarplayerRequirement(131, 1, Operation.LESS_EQUAL));
        this.knowStateAsJustCompletedFirstExam = new Conditions(true, new VarplayerRequirement(131, 2, Operation.LESS_EQUAL));
        this.knowStateAsJustCompletedSecondExam = new Conditions(true, new VarplayerRequirement(131, 3, Operation.LESS_EQUAL));
        this.syncedUp = new Conditions(true, LogicType.OR, this.knowStateAsJustStartedQuest, new WidgetTextRequirement(119, 2, "The Dig Site"));
        this.syncedUp2 = new Conditions(true, LogicType.OR, this.knowStateAsJustCompletedFirstExam, new WidgetTextRequirement(119, 2, "The Dig Site"), new DialogRequirement("You got all the questions correct. Well done!"), new DialogRequirement("Hey! Excellent!"));
        this.syncedUp3 = new Conditions(true, LogicType.OR, this.knowStateAsJustCompletedSecondExam, new WidgetTextRequirement(119, 2, "The Dig Site"), new DialogRequirement("You got all the questions correct, well done!"), new DialogRequirement("Great, I'm getting good at this."));
        this.talkedToGuide = new VarbitRequirement(2544, 1);
        this.tea = this.tea.hideConditioned(this.talkedToGuide);
        this.talkedToFemaleStudent = new Conditions(true, LogicType.OR, new DialogRequirement("Hey! My lucky mascot!"), new WidgetTextRequirement(119, 3, true, "I should talk to her to see if she can help"));
        this.femaleStudentQ1Learnt = new Conditions(true, LogicType.OR, new DialogRequirement("The proper health and safety points are"), new WidgetTextRequirement(119, 3, true, "She gave me an answer"));
        WidgetTextRequirement orangeGivenAnswer1Diary = new WidgetTextRequirement(119, 3, true, "He gave me an answer to one of the questions");
        orangeGivenAnswer1Diary.addRange(20, 35);
        this.talkedToOrangeStudent = new Conditions(true, LogicType.OR, new DialogRequirement("Look what I found!"), new WidgetTextRequirement(119, 3, true, "<str>to find it and return it to him."));
        this.orangeStudentQ1Learnt = new Conditions(true, LogicType.OR, new DialogRequirement("The people eligible to use the digsite are:"), orangeGivenAnswer1Diary);
        WidgetTextRequirement greenGivenAnswer1Diary = new WidgetTextRequirement(119, 3, true, "He gave me an answer to one of the questions");
        greenGivenAnswer1Diary.addRange(0, 19);
        this.talkedToGreenStudent = new Conditions(true, LogicType.OR, new DialogRequirement("Oh wow! You've found it!"), new WidgetTextRequirement(119, 3, true, "<str>to him; maybe someone has picked it up?"));
        this.greenStudentQ1Learnt = new Conditions(true, LogicType.OR, new DialogRequirement("The study of Earth Sciences is:"), greenGivenAnswer1Diary);
        WidgetTextRequirement femaleGivenAnswer2Diary = new WidgetTextRequirement(119, 3, true, "<str>I need to speak to the student in the purple skirt about");
        femaleGivenAnswer2Diary.addRange(43, 52);
        this.femaleStudentQ2Learnt = new Conditions(true, LogicType.OR, new DialogRequirement("Finds handling: Finds must"), femaleGivenAnswer2Diary);
        WidgetTextRequirement orangeGivenAnswer2Diary = new WidgetTextRequirement(119, 3, true, "<str>I need to speak to the student in the orange top about the");
        orangeGivenAnswer2Diary.addRange(43, 52);
        this.orangeStudentQ2Learnt = new Conditions(true, LogicType.OR, new DialogRequirement("Correct sample transportation: "), orangeGivenAnswer2Diary);
        WidgetTextRequirement greenGivenAnswer2Diary = new WidgetTextRequirement(119, 3, true, "<str>I need to speak to the student in the green top about the");
        greenGivenAnswer2Diary.addRange(43, 52);
        this.greenStudentQ2Learnt = new Conditions(true, LogicType.OR, new DialogRequirement("Correct rock pick usage: Always handle"), greenGivenAnswer2Diary);
        this.femaleExtorting = new Conditions(true, LogicType.OR, new DialogRequirement("OK, I'll see what I can turn up for you."), new DialogRequirement("Well, I have seen people get them from panning"), new WidgetTextRequirement(119, 3, true, "I need to bring her an opal"));
        WidgetTextRequirement femaleGivenAnswer3Diary = new WidgetTextRequirement(119, 3, true, "<str>I need to speak to the student in the purple skirt about");
        femaleGivenAnswer3Diary.addRange(56, 63);
        this.femaleStudentQ3Learnt = new Conditions(true, LogicType.OR, new DialogRequirement("Sample preparation: Samples cleaned"), femaleGivenAnswer3Diary);
        WidgetTextRequirement orangeGivenAnswer3Diary = new WidgetTextRequirement(119, 3, true, "<str>I need to speak to the student in the orange top about the");
        orangeGivenAnswer3Diary.addRange(56, 63);
        this.orangeStudentQ3Learnt = new Conditions(true, LogicType.OR, new DialogRequirement("The proper technique for handling bones is: Handle"), orangeGivenAnswer3Diary);
        WidgetTextRequirement greenGivenAnswer3Diary = new WidgetTextRequirement(119, 3, true, "<str>I need to speak to the student in the green top about the");
        greenGivenAnswer3Diary.addRange(56, 63);
        this.greenStudentQ3Learnt = new Conditions(true, LogicType.OR, new DialogRequirement("Specimen brush use: Brush carefully"), greenGivenAnswer3Diary);
        this.givenTalismanIn = new VarbitRequirement(2550, 1);
        this.rope1Added = new VarbitRequirement(2545, 1);
        this.rope2Added = new VarbitRequirement(2546, 1);
        this.hasTeddy = new Conditions(LogicType.OR, this.teddybear, this.talkedToFemaleStudent);
        this.hasSkull = new Conditions(LogicType.OR, this.skull, this.talkedToGreenStudent);
        this.hasSpecialCup = new Conditions(LogicType.OR, this.specialCup, this.talkedToOrangeStudent);
        this.letterStamped = new VarbitRequirement(2552, 1);
        this.searchedBricks = new VarbitRequirement(2549, 1);
        this.openPowderChestNearby = new ObjectCondition(2360);
        this.openedBarrel = new VarbitRequirement(2547, 1);
        this.hasKeyOrPowderOrMixtures = new Conditions(LogicType.OR, this.key, this.powder, this.nitrate, this.mixedChemicals, this.mixedChemicals2, this.chemicalCompound, this.openPowderChestNearby);
    }

    public void setupSteps() {
        this.talkToExaminer = new NpcStep((QuestHelper)this, 3635, new WorldPoint(3362, 3337, 0), "Talk to an Examiner in the Exam Centre south east of Varrock.", new Requirement[0]);
        this.talkToExaminer.addDialogStep("Can I take an exam?");
        ((NpcStep)this.talkToExaminer).addAlternateNpcs(3636, 3637);
        this.talkToHaig = new NpcStep((QuestHelper)this, 5214, new WorldPoint(3257, 3448, 0), "Talk to Curator Haig in the Varrock Museum.", this.unstampedLetter);
        this.talkToExaminer2 = new NpcStep((QuestHelper)this, 3635, new WorldPoint(3362, 3337, 0), "Return to an Examiner in the Exam Centre south east of Varrock.", this.sealedLetter);
        this.searchBush = new ObjectStep((QuestHelper)this, 2358, new WorldPoint(3357, 3372, 0), "Search the bushes north of the Exam Centre for a teddy.", new Requirement[0]);
        this.takeTray = new DetailedQuestStep((QuestHelper)this, new WorldPoint(3369, 3378, 0), "Pick up the tray in the south east of the dig site.", this.panningTray);
        this.talkToGuide = new NpcStep((QuestHelper)this, 3640, new WorldPoint(3385, 3386, 0), "Talk to the Panning Guide nearby.", this.tea);
        this.panWater = new ObjectStep((QuestHelper)this, 2363, new WorldPoint(3384, 3381, 0), "Pan in the river for a special cup.", this.panningTray);
        this.searchPanningTray = new DetailedQuestStep((QuestHelper)this, "Search the panning tray.", this.panningTrayFull.highlighted());
        this.panWater.addSubSteps(this.searchPanningTray);
        this.pickpocketWorkmen = new NpcStep((QuestHelper)this, 3628, new WorldPoint(3372, 3390, 0), "Pickpocket workmen until you get an animal skull and a specimen brush.", true, new Requirement[0]);
        ((NpcStep)this.pickpocketWorkmen).addAlternateNpcs(3630, 3631);
        ((NpcStep)this.pickpocketWorkmen).setMaxRoamRange(100);
        this.talkToFemaleStudent = new NpcStep((QuestHelper)this, 3634, new WorldPoint(3345, 3425, 0), "Talk to the female student in the north west of the Digsite twice.", this.teddybear);
        this.talkToOrangeStudent = new NpcStep((QuestHelper)this, 3633, new WorldPoint(3369, 3419, 0), "Talk to the student in an orange shirt in the north east of the Digsite twice.", this.specialCup);
        this.talkToGreenStudent = new NpcStep((QuestHelper)this, 3632, new WorldPoint(3362, 3398, 0), "Talk to the student in a green shirt in the south of the Digsite twice.", this.skull);
        this.talkToFemaleStudent2 = new NpcStep((QuestHelper)this, 3634, new WorldPoint(3345, 3425, 0), "Talk to the female student in the north west of the Digsite.", new Requirement[0]);
        this.talkToOrangeStudent2 = new NpcStep((QuestHelper)this, 3633, new WorldPoint(3369, 3419, 0), "Talk to the student in an orange shirt in the north east of the Digsite.", new Requirement[0]);
        this.talkToGreenStudent2 = new NpcStep((QuestHelper)this, 3632, new WorldPoint(3362, 3398, 0), "Talk to the student in a green shirt in the south of the Digsite.", new Requirement[0]);
        this.talkToFemaleStudent.addSubSteps(this.talkToFemaleStudent2);
        this.talkToOrangeStudent.addSubSteps(this.talkToOrangeStudent2);
        this.talkToGreenStudent.addSubSteps(this.talkToGreenStudent2);
        this.takeTest1 = new NpcStep((QuestHelper)this, 3635, new WorldPoint(3362, 3337, 0), "Talk to an Examiner in the Exam Centre to take the first test.", new Requirement[0]);
        this.takeTest1.addDialogSteps("Yes, I certainly am.", "The study of the earth, its contents and history.", "All that have passed the appropriate Earth Sciences exam.", "Gloves and boots to be worn at all times; proper tools must be used.");
        this.talkToFemaleStudent3 = new NpcStep((QuestHelper)this, 3634, new WorldPoint(3345, 3425, 0), "Talk to the female student in the north west of the Digsite.", new Requirement[0]);
        this.talkToOrangeStudent3 = new NpcStep((QuestHelper)this, 3633, new WorldPoint(3369, 3419, 0), "Talk to the student in an orange shirt in the north east of the Digsite.", new Requirement[0]);
        this.talkToGreenStudent3 = new NpcStep((QuestHelper)this, 3632, new WorldPoint(3362, 3398, 0), "Talk to the student in a green shirt in the south of the Digsite.", new Requirement[0]);
        this.takeTest2 = new NpcStep((QuestHelper)this, 3635, new WorldPoint(3362, 3337, 0), "Talk to an Examiner in the Exam Centre to take the second test.", new Requirement[0]);
        this.takeTest2.addDialogSteps("I am ready for the next exam.", "Samples taken in rough form; kept only in sealed containers.", "Finds must be carefully handled, and gloves worn.", "Always handle with care; strike cleanly on its cleaving point.");
        this.talkToFemaleStudent4 = new NpcStep((QuestHelper)this, 3634, new WorldPoint(3345, 3425, 0), "Talk to the female student in the north west of the Digsite.", this.opal);
        this.talkToFemaleStudent5 = new NpcStep((QuestHelper)this, 3634, new WorldPoint(3345, 3425, 0), "Talk to the female student again.", this.opal);
        this.talkToOrangeStudent4 = new NpcStep((QuestHelper)this, 3633, new WorldPoint(3369, 3419, 0), "Talk to the student in an orange shirt in the north east of the Digsite.", new Requirement[0]);
        this.talkToGreenStudent4 = new NpcStep((QuestHelper)this, 3632, new WorldPoint(3362, 3398, 0), "Talk to the student in a green shirt in the south of the Digsite.", new Requirement[0]);
        this.takeTest3 = new NpcStep((QuestHelper)this, 3635, new WorldPoint(3362, 3337, 0), "Talk to an Examiner in the Exam Centre to take the third test.", new Requirement[0]);
        this.takeTest3.addDialogSteps("I am ready for the last exam...", "Samples cleaned, and carried only in specimen jars.", "Brush carefully and slowly using short strokes.", "Handle bones very carefully and keep them away from other samples.");
        this.getJar = new ObjectStep((QuestHelper)this, 17302, new WorldPoint(3355, 3332, 0), "Search the cupboard on the south wall of the west room of the Exam Centre for a specimen jar.", new Requirement[0]);
        ((ObjectStep)this.getJar).addAlternateObjects(17303);
        this.getBrush = new NpcStep((QuestHelper)this, 3628, new WorldPoint(3372, 3390, 0), "Pickpocket workmen until you get a specimen brush.", true, new Requirement[0]);
        ((NpcStep)this.getBrush).addAlternateNpcs(3630, 3631);
        ((NpcStep)this.getBrush).setMaxRoamRange(100);
        this.digForTalisman = new ObjectStep((QuestHelper)this, 2377, new WorldPoint(3374, 3438, 0), "Dig in the north east dig spot in the Digsite until you get a talisman.", this.trowelHighlighted, this.specimenJar, this.specimenBrush);
        this.digForTalisman.addIcon(676);
        this.talkToExpert = new NpcStep((QuestHelper)this, 3639, new WorldPoint(3357, 3334, 0), "Talk Archaeological expert in the Exam Centre.", this.talisman);
        this.useInvitationOnWorkman = new NpcStep((QuestHelper)this, 3628, new WorldPoint(3360, 3415, 0), "Use the invitation on any workman.", true, this.invitation);
        this.useInvitationOnWorkman.addIcon(696);
        this.useInvitationOnWorkman.addDialogStep("I lost the letter you gave me.");
        ((NpcStep)this.useInvitationOnWorkman).addAlternateNpcs(3630, 3631);
        ((NpcStep)this.useInvitationOnWorkman).setMaxRoamRange(100);
        this.useRopeOnWinch = new ObjectStep((QuestHelper)this, 2350, new WorldPoint(3353, 3417, 0), "Use a rope on the west winch.", this.rope);
        this.useRopeOnWinch.addIcon(954);
        this.goDownWinch = new ObjectStep((QuestHelper)this, 2350, new WorldPoint(3353, 3417, 0), "Climb down the west winch.", new Requirement[0]);
        this.pickUpRoot = new ItemStep((QuestHelper)this, "Pick up some arcenia root.", this.arcenia);
        this.searchBricks = new ObjectStep((QuestHelper)this, 2362, new WorldPoint(3378, 9824, 0), "Search the bricks to the south.", new Requirement[0]);
        this.goUpRope = new ObjectStep((QuestHelper)this, 2353, new WorldPoint(3369, 9826, 0), "Climb back to the surface.", new Requirement[0]);
        this.useRopeOnWinch2 = new ObjectStep((QuestHelper)this, 2351, new WorldPoint(3370, 3429, 0), "Use a rope on the north east winch.", this.rope);
        this.useRopeOnWinch2.addIcon(954);
        this.goDownToDoug = new ObjectStep((QuestHelper)this, 2351, new WorldPoint(3370, 3429, 0), "Climb down the north east winch.", new Requirement[0]);
        this.talkToDoug = new NpcStep((QuestHelper)this, 3629, new WorldPoint(3351, 9819, 0), "Talk to Doug Deeping.", new Requirement[0]);
        this.talkToDoug.addDialogStep("How could I move a large pile of rocks?");
        this.goUpFromDoug = new ObjectStep((QuestHelper)this, 2352, new WorldPoint(3352, 9816, 0), "Leave Doug's cave.", new Requirement[0]);
        this.unlockChest = new ObjectStep((QuestHelper)this, 2361, new WorldPoint(3374, 3378, 0), "Use the key on the chest in the tent in the south of the Digsite.", this.key);
        this.unlockChest.addIcon(709);
        this.searchChest = new ObjectStep((QuestHelper)this, 2360, new WorldPoint(3374, 3378, 0), "Search the chest.", new Requirement[0]);
        this.useTrowelOnBarrel = new ObjectStep((QuestHelper)this, 2359, new WorldPoint(3364, 3378, 0), "Use a trowel on the barrel west of the chest's tent.", this.trowelHighlighted);
        this.useTrowelOnBarrel.addIcon(676);
        this.useVialOnBarrel = new ObjectStep((QuestHelper)this, 2359, new WorldPoint(3364, 3378, 0), "Use a vial on the barrel west of the chest's tent.", this.vialHighlighted);
        this.useVialOnBarrel.addIcon(229);
        this.usePowderOnExpert = new NpcStep((QuestHelper)this, 3639, new WorldPoint(3357, 3334, 0), "Use the powder on the Archaeological expert in the Exam Centre.", this.powder);
        this.usePowderOnExpert.addIcon(700);
        this.useLiquidOnExpert = new NpcStep((QuestHelper)this, 3639, new WorldPoint(3357, 3334, 0), "(DO NOT LEFT CLICK) Right-click use the liquid on the Archaeological expert in the Exam Centre.", this.liquid);
        this.useLiquidOnExpert.addIcon(702);
        this.mixNitroWithNitrate = new DetailedQuestStep((QuestHelper)this, "Mix the nitroglycerin and ammonium nitrate together.", this.nitro, this.nitrate);
        this.grindCharcoal = new DetailedQuestStep((QuestHelper)this, "Grind charcoal with a pestle and mortar.", this.pestleAndMortar, this.charcoal);
        this.addCharcoal = new DetailedQuestStep((QuestHelper)this, "Add charcoal to the vial.", this.groundCharcoal, this.mixedChemicals);
        this.addRoot = new DetailedQuestStep((QuestHelper)this, "Add arcenia root to the vial.", this.arcenia, this.mixedChemicals2);
        this.goDownToExplode = new ObjectStep((QuestHelper)this, 2350, new WorldPoint(3353, 3417, 0), "Climb down the rope on the west winch.", this.chemicalCompound, this.tinderbox);
        this.goDownToExplode2 = new ObjectStep((QuestHelper)this, 2350, new WorldPoint(3353, 3417, 0), "Climb down the rope on the west winch.", this.tinderbox);
        this.goDownToExplode.addSubSteps(this.goDownToExplode2);
        this.useCompound = new ObjectStep((QuestHelper)this, 2362, new WorldPoint(3378, 9824, 0), "Use the compound on the bricks to the south.", this.chemicalCompoundHighlighted);
        this.useCompound.addIcon(707);
        this.useTinderbox = new ObjectStep((QuestHelper)this, 2362, new WorldPoint(3378, 9824, 0), "Use a tinderbox on the bricks to the south.", this.tinderboxHighlighted);
        this.useTinderbox.addIcon(590);
        this.takeTablet = new ObjectStep((QuestHelper)this, 17369, new WorldPoint(3373, 9746, 0), "Take the stone tablet in the south room.", new Requirement[0]);
        this.goDownForTablet = new ObjectStep((QuestHelper)this, 2350, new WorldPoint(3353, 3417, 0), "Climb down the rope on the west winch.", new Requirement[0]);
        this.takeTablet.addSubSteps(this.goDownForTablet);
        this.goUpWithTablet = new ObjectStep((QuestHelper)this, 2353, new WorldPoint(3369, 9762, 0), "Use the tablet on the Archaeological expert in the Exam Centre to complete the quest.", this.tablet);
        this.useTabletOnExpert = new NpcStep((QuestHelper)this, 3639, new WorldPoint(3357, 3334, 0), "Use the tablet on the Archaeological expert in the Exam Centre to complete the quest.", this.tablet);
        this.useTabletOnExpert.addIcon(699);
        this.useTabletOnExpert.addSubSteps(this.goUpWithTablet);
        this.syncStep = new DetailedQuestStep((QuestHelper)this, "Open the quest's journal to sync your current quest state.", new Requirement[0]);
    }

    @Override
    public List<String> getNotes() {
        return Collections.singletonList("This quest helper is susceptible to getting out of sync with the actual quest. If this happens to you, opening up the quest's journal should fix it.");
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.pestleAndMortar, this.vialHighlighted, this.tinderbox, this.tea, this.ropes2, this.opal, this.charcoal);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.digsiteTeleports, this.varrock2);
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new SkillRequirement(Skill.AGILITY, 10, true));
        req.add(new SkillRequirement(Skill.HERBLORE, 10, true));
        req.add(new SkillRequirement(Skill.THIEVING, 25));
        return req;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(2);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Arrays.asList(new ExperienceReward(Skill.MINING, 15300), new ExperienceReward(Skill.HERBLORE, 2000));
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Collections.singletonList(new ItemReward("Gold Bars", 2357, 2));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Collections.singletonList(new UnlockReward("Ability to clean specimens in the Varrock Museum"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting off", Arrays.asList(this.talkToExaminer, this.talkToHaig, this.talkToExaminer2, this.searchBush, this.takeTray, this.talkToGuide, this.panWater, this.pickpocketWorkmen, this.talkToFemaleStudent, this.talkToFemaleStudent2, this.talkToOrangeStudent, this.talkToOrangeStudent2, this.talkToGreenStudent, this.talkToGreenStudent2, this.takeTest1), this.tea));
        allSteps.add(new PanelDetails("Exam 2", Arrays.asList(this.talkToFemaleStudent3, this.talkToOrangeStudent3, this.talkToGreenStudent3, this.takeTest2), new Requirement[0]));
        allSteps.add(new PanelDetails("Exam 3", Arrays.asList(this.talkToFemaleStudent4, this.talkToFemaleStudent5, this.talkToOrangeStudent4, this.talkToGreenStudent4, this.takeTest3), this.opal));
        allSteps.add(new PanelDetails("Discovery", Arrays.asList(this.getJar, this.digForTalisman, this.talkToExpert, this.useInvitationOnWorkman), this.trowel, this.specimenBrush));
        allSteps.add(new PanelDetails("Digging deeper", Arrays.asList(this.useRopeOnWinch, this.goDownWinch, this.pickUpRoot, this.searchBricks, this.goUpRope, this.useRopeOnWinch2, this.goDownToDoug, this.talkToDoug, this.goUpFromDoug, this.unlockChest, this.searchChest, this.useTrowelOnBarrel, this.useVialOnBarrel, this.useLiquidOnExpert, this.usePowderOnExpert, this.mixNitroWithNitrate, this.grindCharcoal, this.addCharcoal, this.addRoot, this.goDownToExplode, this.useCompound, this.useTinderbox, this.takeTablet, this.useTabletOnExpert), this.ropes2, this.pestleAndMortar, this.vialHighlighted, this.tinderboxHighlighted, this.charcoal));
        return allSteps;
    }
}

