/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.thedepthsofdespair;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.Favour;
import com.questhelper.requirements.player.FavourRequirement;
import com.questhelper.requirements.player.InInstanceRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ItemStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.THE_DEPTHS_OF_DESPAIR)
public class TheDepthsOfDespair
extends BasicQuestHelper {
    ItemRequirement weapon;
    ItemRequirement dramenStaff;
    ItemRequirement foodIfLowLevel;
    ItemRequirement superEnergyOrStamina;
    ItemRequirement xericsTalisman;
    ItemRequirement skillsNecklace;
    ItemRequirement varlamoreEnvoy;
    ItemRequirement royalAccordOfTwill;
    Requirement inVineryHouse;
    Requirement inArceuusLibrary;
    Requirement inCaves;
    Requirement inFirstAreaOfCaves;
    Requirement inSecondAreaOfCaves;
    Requirement inThirdAreaOfCaves;
    Requirement downstairsInCaves;
    QuestStep talkToLordKandur;
    QuestStep talkToChefOlivia;
    QuestStep talkToGalana;
    QuestStep findTheVarlamoreEnvoy;
    QuestStep readTheVarlamoreEnvoy;
    QuestStep enterCrabclawCaves;
    QuestStep goThroughCrevice;
    QuestStep stepOverSteppingStones;
    QuestStep climbPastRocks;
    QuestStep enterTunnelEntrance;
    QuestStep talkToArturHosidius;
    QuestStep killSandSnake;
    QuestStep searchChest;
    QuestStep talkToLordKandurAgain;
    Zone houseWestOfVinery;
    Zone arceuusLibraryF1;
    Zone arceuusLibraryF2;
    Zone arceuusLibraryF3;
    Zone crabclawCaves;
    Zone crabclawCavesPart1A;
    Zone crabclawCavesPart1B;
    Zone crabclawCavesPart2;
    Zone crabclawCavesPart3;
    Zone crabclawCavesDownstairs;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        ConditionalStep goTalkToLordKandur = new ConditionalStep((QuestHelper)this, this.talkToLordKandur, this.inVineryHouse);
        steps.put(0, goTalkToLordKandur);
        ConditionalStep goTalkToChefOlivia = new ConditionalStep((QuestHelper)this, this.talkToChefOlivia, this.inVineryHouse);
        steps.put(1, goTalkToChefOlivia);
        ConditionalStep goTalkToGalana = new ConditionalStep((QuestHelper)this, this.talkToGalana, this.inArceuusLibrary);
        steps.put(2, goTalkToGalana);
        ConditionalStep findAndReadTheVarlamoreEnvoy = new ConditionalStep((QuestHelper)this, this.findTheVarlamoreEnvoy, new Requirement[0]);
        findAndReadTheVarlamoreEnvoy.addStep(this.varlamoreEnvoy.alsoCheckBank(this.questBank), this.readTheVarlamoreEnvoy);
        steps.put(3, findAndReadTheVarlamoreEnvoy);
        steps.put(4, this.enterCrabclawCaves);
        ConditionalStep stepEnterLowerCaves = new ConditionalStep((QuestHelper)this, this.enterCrabclawCaves, new Requirement[0]);
        stepEnterLowerCaves.addStep(this.inFirstAreaOfCaves, this.goThroughCrevice);
        stepEnterLowerCaves.addStep(this.inSecondAreaOfCaves, this.stepOverSteppingStones);
        stepEnterLowerCaves.addStep(this.inThirdAreaOfCaves, this.climbPastRocks);
        stepEnterLowerCaves.addStep(this.inCaves, this.enterTunnelEntrance);
        steps.put(6, stepEnterLowerCaves);
        ConditionalStep stepTalkToArturHosidius = new ConditionalStep((QuestHelper)this, (QuestStep)stepEnterLowerCaves, new Requirement[0]);
        stepTalkToArturHosidius.addStep(this.downstairsInCaves, this.talkToArturHosidius);
        steps.put(7, stepTalkToArturHosidius);
        ConditionalStep stepKillSandSnake = new ConditionalStep((QuestHelper)this, (QuestStep)stepEnterLowerCaves, new Requirement[0]);
        stepKillSandSnake.addStep(this.downstairsInCaves, this.killSandSnake);
        steps.put(8, stepKillSandSnake);
        ConditionalStep stepSearchChest = new ConditionalStep((QuestHelper)this, (QuestStep)stepEnterLowerCaves, new Requirement[0]);
        stepSearchChest.addStep(this.downstairsInCaves, this.searchChest);
        steps.put(9, stepSearchChest);
        steps.put(10, this.talkToLordKandurAgain);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.xericsTalisman = new ItemRequirement("Xeric's Talisman", 13393).isNotConsumed();
        this.skillsNecklace = new ItemRequirement("Skills necklace", ItemCollections.SKILLS_NECKLACES).isNotConsumed();
        this.superEnergyOrStamina = new ItemRequirement("Super Energy or Stamina potions", -1, -1);
        this.dramenStaff = new ItemRequirement("Access to Fairy Rings", 772).isNotConsumed();
        this.dramenStaff.addAlternates(9084);
        this.foodIfLowLevel = new ItemRequirement("Food (if low level)", -1, -1);
        this.foodIfLowLevel.setDisplayItemId(BankSlotIcons.getFood());
        this.weapon = new ItemRequirement("A Weapon", -1, -1).isNotConsumed();
        this.weapon.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.varlamoreEnvoy = new ItemRequirement("Varlamore Envoy", 21756);
        this.varlamoreEnvoy.setHighlightInInventory(true);
        this.royalAccordOfTwill = new ItemRequirement("Royal Accord of Twill", 21758);
    }

    public void loadZones() {
        this.houseWestOfVinery = new Zone(new WorldPoint(1810, 3550, 0), new WorldPoint(1820, 3560, 0));
        this.arceuusLibraryF1 = new Zone(new WorldPoint(1607, 3831, 0), new WorldPoint(1658, 3784, 0));
        this.arceuusLibraryF2 = new Zone(new WorldPoint(1607, 3831, 1), new WorldPoint(1658, 3784, 1));
        this.arceuusLibraryF3 = new Zone(new WorldPoint(1607, 3831, 2), new WorldPoint(1658, 3784, 2));
        this.crabclawCaves = new Zone(new WorldPoint(1644, 9851, 0), new WorldPoint(1728, 9793, 0));
        this.crabclawCavesPart1A = new Zone(new WorldPoint(1644, 9851, 0), new WorldPoint(1722, 9823, 0));
        this.crabclawCavesPart1B = new Zone(new WorldPoint(1665, 9823, 0), new WorldPoint(1707, 9813, 0));
        this.crabclawCavesPart2 = new Zone(new WorldPoint(1703, 9821, 0), new WorldPoint(1724, 9792, 0));
        this.crabclawCavesPart3 = new Zone(new WorldPoint(1688, 9804, 0), new WorldPoint(1703, 9794, 0));
        this.crabclawCavesDownstairs = new Zone(new WorldPoint(1670, 9763, 0), new WorldPoint(1701, 9742, 0));
    }

    public void setupConditions() {
        this.inVineryHouse = new ZoneRequirement(this.houseWestOfVinery);
        this.inArceuusLibrary = new ZoneRequirement(this.arceuusLibraryF1, this.arceuusLibraryF2, this.arceuusLibraryF3);
        this.inCaves = new ZoneRequirement(this.crabclawCaves);
        this.inFirstAreaOfCaves = new ZoneRequirement(this.crabclawCavesPart1A, this.crabclawCavesPart1B);
        this.inSecondAreaOfCaves = new ZoneRequirement(this.crabclawCavesPart2);
        this.inThirdAreaOfCaves = new ZoneRequirement(this.crabclawCavesPart3);
        ZoneRequirement cavesDownstairs = new ZoneRequirement(this.crabclawCavesDownstairs);
        this.downstairsInCaves = new Conditions(cavesDownstairs, new InInstanceRequirement());
    }

    public void setupSteps() {
        this.talkToLordKandur = new NpcStep((QuestHelper)this, 11033, new WorldPoint(1782, 3572, 0), "Talk to Lord Kandur Hosidius in the house west of the vinery.", new Requirement[0]);
        this.talkToLordKandur.addDialogSteps("Anything I can help you with?", "Yes.");
        this.talkToChefOlivia = new NpcStep((QuestHelper)this, 7901, new WorldPoint(1776, 3567, 0), "Speak to Chef Olivia in Lord Kandur's kitchen.", new Requirement[0]);
        this.talkToGalana = new NpcStep((QuestHelper)this, 7902, new WorldPoint(1649, 3824, 0), "Speak to Galana in the Arceuus Library.", new Requirement[0]);
        this.findTheVarlamoreEnvoy = new ItemStep((QuestHelper)this, "Find the Varlamore Envoy. Ask Galana for the approximate location if you can't find it.", this.varlamoreEnvoy);
        this.readTheVarlamoreEnvoy = new DetailedQuestStep((QuestHelper)this, "Read the Varlamore Envoy.", this.varlamoreEnvoy);
        this.enterCrabclawCaves = new ObjectStep((QuestHelper)this, 31690, new WorldPoint(1645, 3450, 0), "Enter the Crabclaw Caves.", new Requirement[0]);
        this.goThroughCrevice = new ObjectStep((QuestHelper)this, 31695, new WorldPoint(1711, 9823, 0), "Enter the crevice. Kill a sandcrab for the easy diary while you're here.", new Requirement[0]);
        this.stepOverSteppingStones = new ObjectStep((QuestHelper)this, 31699, new WorldPoint(1706, 9800, 0), "Cross the stepping stones.", new Requirement[0]);
        this.climbPastRocks = new ObjectStep((QuestHelper)this, 31697, new WorldPoint(1688, 9801, 0), "Climb the rocks.", new Requirement[0]);
        this.enterTunnelEntrance = new ObjectStep((QuestHelper)this, 31692, new WorldPoint(1672, 9800, 0), "Climb down the tunnel at the end.", new Requirement[0]);
        this.talkToArturHosidius = new NpcStep((QuestHelper)this, 7899, "Speak to Artur Hosidius.", new Requirement[0]);
        this.killSandSnake = new NpcStep((QuestHelper)this, 7903, "Kill the Sand Snake.", new Requirement[0]);
        this.searchChest = new ObjectStep((QuestHelper)this, 31703, "Search the chest.", new Requirement[0]);
        this.talkToLordKandurAgain = new NpcStep((QuestHelper)this, 11033, new WorldPoint(1782, 3572, 0), "Return to Lord Kandur Hosidius and talk to him.", new Requirement[0]);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.skillsNecklace, this.xericsTalisman, this.foodIfLowLevel, this.superEnergyOrStamina, this.dramenStaff);
    }

    @Override
    public List<String> getCombatRequirements() {
        return Collections.singletonList("Sand Snake (level 36)");
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new QuestRequirement(QuestHelperQuest.CLIENT_OF_KOUREND, QuestState.FINISHED));
        req.add(new QuestRequirement(QuestHelperQuest.X_MARKS_THE_SPOT, QuestState.FINISHED));
        req.add(new FavourRequirement(Favour.HOSIDIUS, 20));
        req.add(new SkillRequirement(Skill.AGILITY, 18, false));
        return req;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Collections.singletonList(new ExperienceReward(Skill.AGILITY, 1500));
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Arrays.asList(new ItemReward("Coins", 995, 4000), new ItemReward("Hosidius Favour Certificate", 21759, 1), new ItemReward("A Kharedst's Memoirs page", 21760, 1));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting off", Arrays.asList(this.talkToLordKandur, this.talkToChefOlivia), new Requirement[0]));
        allSteps.add(new PanelDetails("The Envoy to Varlamore", Arrays.asList(this.talkToGalana, this.findTheVarlamoreEnvoy, this.readTheVarlamoreEnvoy), new Requirement[0]));
        allSteps.add(new PanelDetails("The Crabclaw Caves", Arrays.asList(this.enterCrabclawCaves, this.goThroughCrevice, this.stepOverSteppingStones, this.climbPastRocks, this.enterTunnelEntrance, this.talkToArturHosidius, this.killSandSnake, this.searchChest), this.foodIfLowLevel, this.weapon));
        allSteps.add(new PanelDetails("Finishing up", Collections.singletonList(this.talkToLordKandurAgain), new Requirement[0]));
        return allSteps;
    }
}

