/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.thecorsaircurse;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.util.Operation;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.DigStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.THE_CORSAIR_CURSE)
public class TheCorsairCurse
extends BasicQuestHelper {
    ItemRequirement spade;
    ItemRequirement tinderbox;
    ItemRequirement ogreArtfact;
    ItemRequirement combatGear;
    Requirement inCove;
    Requirement inCavern;
    Requirement inIthoiHut;
    Requirement inGnocciHut;
    Requirement inArsenHut;
    Requirement inShip;
    Requirement talkedToIthoi;
    Requirement talkedToGnocci;
    Requirement talkedToArsen;
    Requirement talkedToColin;
    Requirement foundDoll;
    Requirement returnedToothPick;
    Requirement lookedThroughTelescope;
    Requirement finishedGnocci;
    Requirement finishedArsen;
    Requirement finishedColin;
    QuestStep talkToTockFarm;
    QuestStep talkToTockRimmington;
    QuestStep returnToCove;
    QuestStep goUpToIthoi;
    QuestStep talkToIthoi;
    QuestStep goDownFromIthoi;
    QuestStep goUpToArsen;
    QuestStep talkToArsen;
    QuestStep goUpToColin;
    QuestStep talkToColin;
    QuestStep goDownFromArsen;
    QuestStep goUpToGnocci;
    QuestStep talkToGnocci;
    QuestStep grabTinderbox;
    QuestStep goDownFromGnocci;
    QuestStep pickUpSpade;
    QuestStep goOntoShip;
    QuestStep talkToTockShip;
    QuestStep leaveShip;
    QuestStep goDownToTess;
    QuestStep talkToTess;
    QuestStep goUpFromTess;
    QuestStep goUpToIthoi2;
    QuestStep lookThroughTelescope;
    QuestStep goDownFromIthoi2;
    QuestStep digSand;
    QuestStep goUpToGnocci2;
    QuestStep talkToGnocci2;
    QuestStep goDownFromGnocci2;
    QuestStep goUpToArsen2;
    QuestStep goUpToColin2;
    QuestStep talkToArsen2;
    QuestStep talkToColin2;
    QuestStep talkToTockShip2;
    QuestStep goOntoShip2;
    QuestStep leaveShip2;
    QuestStep goUpToGnocci3;
    QuestStep talkToGnocci3;
    QuestStep goDownFromGnocci3;
    QuestStep goUpToArsen3;
    QuestStep talkToArsen3;
    QuestStep goDownFromArsen3;
    QuestStep goUpToIthoi3;
    QuestStep talkToIthoi2;
    QuestStep goDownFromIthoi3;
    QuestStep goOntoShip3;
    QuestStep talkToTockShip3;
    QuestStep useTinderboxOnWood;
    QuestStep goUpToIthoiToKill;
    QuestStep killIthoi;
    QuestStep goOntoShip4;
    QuestStep talkToTockShip4;
    Zone cove;
    Zone cavern;
    Zone ithoiHut;
    Zone gnocciHut;
    Zone arsenHut;
    Zone ship;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToTockFarm);
        steps.put(5, this.talkToTockFarm);
        steps.put(10, this.talkToTockRimmington);
        ConditionalStep solveCurses = new ConditionalStep((QuestHelper)this, this.goUpToIthoi, new Requirement[0]);
        solveCurses.addStep(new Conditions(this.talkedToIthoi, this.finishedArsen, this.lookedThroughTelescope, this.finishedGnocci, this.inArsenHut), this.talkToColin2);
        solveCurses.addStep(new Conditions(this.talkedToIthoi, this.finishedArsen, this.lookedThroughTelescope, this.finishedGnocci), this.goUpToColin2);
        solveCurses.addStep(new Conditions(this.talkedToIthoi, this.returnedToothPick, this.lookedThroughTelescope, this.finishedGnocci, this.inArsenHut), this.talkToArsen2);
        solveCurses.addStep(new Conditions(this.talkedToIthoi, this.returnedToothPick, this.lookedThroughTelescope, this.finishedGnocci, this.inGnocciHut), this.goDownFromGnocci2);
        solveCurses.addStep(new Conditions(this.talkedToIthoi, this.returnedToothPick, this.lookedThroughTelescope, this.finishedGnocci), this.goUpToArsen2);
        solveCurses.addStep(new Conditions(this.talkedToIthoi, this.returnedToothPick, this.lookedThroughTelescope, this.foundDoll, this.inGnocciHut), this.talkToGnocci2);
        solveCurses.addStep(new Conditions(this.talkedToIthoi, this.returnedToothPick, this.lookedThroughTelescope, this.foundDoll), this.goUpToGnocci2);
        solveCurses.addStep(new Conditions(this.talkedToIthoi, this.returnedToothPick, this.lookedThroughTelescope, this.foundDoll, this.inIthoiHut), this.goDownFromIthoi2);
        solveCurses.addStep(new Conditions(this.talkedToIthoi, this.returnedToothPick, this.talkedToColin, this.foundDoll, this.inIthoiHut), this.lookThroughTelescope);
        solveCurses.addStep(new Conditions(this.talkedToIthoi, this.returnedToothPick, this.talkedToColin, this.foundDoll), this.goUpToIthoi2);
        solveCurses.addStep(new Conditions(this.talkedToIthoi, this.returnedToothPick, this.talkedToColin, this.spade), this.digSand);
        solveCurses.addStep(new Conditions(this.talkedToIthoi, this.talkedToArsen, this.talkedToColin, this.talkedToGnocci, this.inCavern, this.ogreArtfact), this.talkToTess);
        solveCurses.addStep(new Conditions(this.talkedToIthoi, this.talkedToArsen, this.talkedToColin, this.talkedToGnocci, this.inShip, this.ogreArtfact), this.leaveShip);
        solveCurses.addStep(new Conditions(this.talkedToIthoi, this.talkedToArsen, this.talkedToColin, this.talkedToGnocci, this.ogreArtfact), this.goDownToTess);
        solveCurses.addStep(new Conditions(this.talkedToIthoi, this.talkedToArsen, this.talkedToColin, this.talkedToGnocci, this.spade, this.inShip), this.talkToTockShip);
        solveCurses.addStep(new Conditions(this.talkedToIthoi, this.talkedToArsen, this.talkedToColin, this.talkedToGnocci, this.spade), this.goOntoShip);
        solveCurses.addStep(new Conditions(this.talkedToIthoi, this.talkedToArsen, this.talkedToColin, this.talkedToGnocci, this.inGnocciHut, this.tinderbox), this.pickUpSpade);
        solveCurses.addStep(new Conditions(this.talkedToIthoi, this.talkedToArsen, this.talkedToColin, this.talkedToGnocci, this.inGnocciHut), this.grabTinderbox);
        solveCurses.addStep(new Conditions(this.talkedToIthoi, this.talkedToArsen, this.talkedToColin, this.talkedToGnocci), this.pickUpSpade);
        solveCurses.addStep(new Conditions(this.talkedToIthoi, this.talkedToArsen, this.talkedToColin, this.inGnocciHut), this.talkToGnocci);
        solveCurses.addStep(new Conditions(this.talkedToIthoi, this.talkedToArsen, this.talkedToColin, this.inArsenHut), this.goDownFromArsen);
        solveCurses.addStep(new Conditions(this.talkedToIthoi, this.talkedToArsen, this.talkedToColin), this.goUpToGnocci);
        solveCurses.addStep(new Conditions(this.talkedToIthoi, this.talkedToArsen, this.inArsenHut), this.talkToColin);
        solveCurses.addStep(new Conditions(this.talkedToIthoi, this.talkedToArsen), this.goUpToColin);
        solveCurses.addStep(new Conditions(this.talkedToIthoi, this.inArsenHut), this.talkToArsen);
        solveCurses.addStep(new Conditions(this.talkedToIthoi, this.inIthoiHut), this.goDownFromIthoi);
        solveCurses.addStep(this.talkedToIthoi, this.goUpToArsen);
        solveCurses.addStep(this.inIthoiHut, this.talkToIthoi);
        solveCurses.addStep(this.inCavern, this.goUpFromTess);
        steps.put(15, solveCurses);
        ConditionalStep returnToTock = new ConditionalStep((QuestHelper)this, this.goOntoShip2, new Requirement[0]);
        returnToTock.addStep(this.inShip, this.talkToTockShip2);
        steps.put(20, returnToTock);
        ConditionalStep solveFoodMystery = new ConditionalStep((QuestHelper)this, this.goUpToGnocci3, new Requirement[0]);
        solveFoodMystery.addStep(this.inGnocciHut, this.talkToGnocci3);
        solveFoodMystery.addStep(this.inShip, this.leaveShip2);
        steps.put(25, solveFoodMystery);
        ConditionalStep solveFoodWithArsen = new ConditionalStep((QuestHelper)this, this.grabTinderbox, new Requirement[0]);
        solveFoodWithArsen.addStep(this.inArsenHut, this.talkToArsen3);
        solveFoodWithArsen.addStep(new Conditions(this.tinderbox, this.inGnocciHut), this.goDownFromGnocci3);
        solveFoodWithArsen.addStep(this.tinderbox, this.goUpToArsen3);
        steps.put(30, solveFoodWithArsen);
        ConditionalStep solveFoodWithIthoi = new ConditionalStep((QuestHelper)this, this.grabTinderbox, new Requirement[0]);
        solveFoodWithIthoi.addStep(this.inArsenHut, this.goDownFromArsen3);
        solveFoodWithIthoi.addStep(new Conditions(this.tinderbox, this.inIthoiHut), this.talkToIthoi2);
        solveFoodWithIthoi.addStep(this.tinderbox, this.goUpToIthoi3);
        steps.put(35, solveFoodWithIthoi);
        steps.put(40, solveFoodWithIthoi);
        ConditionalStep burnIthoi = new ConditionalStep((QuestHelper)this, this.useTinderboxOnWood, new Requirement[0]);
        burnIthoi.addStep(this.inIthoiHut, this.goDownFromIthoi3);
        steps.put(45, burnIthoi);
        steps.put(49, new DetailedQuestStep((QuestHelper)this, "Watch the cutscene.", new Requirement[0]));
        ConditionalStep returnToTockWithAnswers = new ConditionalStep((QuestHelper)this, this.goOntoShip3, new Requirement[0]);
        returnToTockWithAnswers.addStep(this.inShip, this.talkToTockShip3);
        steps.put(50, returnToTockWithAnswers);
        ConditionalStep goAndKillIthoi = new ConditionalStep((QuestHelper)this, this.goUpToIthoiToKill, new Requirement[0]);
        goAndKillIthoi.addStep(this.inIthoiHut, this.killIthoi);
        steps.put(52, goAndKillIthoi);
        ConditionalStep finishQuest = new ConditionalStep((QuestHelper)this, this.goOntoShip4, new Requirement[0]);
        finishQuest.addStep(this.inShip, this.talkToTockShip4);
        steps.put(55, finishQuest);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.combatGear = new ItemRequirement("Combat gear + food to defeat Ithoi (level 34), who uses magic", -1, -1).isNotConsumed();
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.spade = new ItemRequirement("Spade", 952).isNotConsumed();
        this.tinderbox = new ItemRequirement("Tinderbox", 590).isNotConsumed();
        this.ogreArtfact = new ItemRequirement("Ogre artefact", 21837);
    }

    public void loadZones() {
        this.cove = new Zone(new WorldPoint(2308, 2806, 0), new WorldPoint(2705, 3136, 2));
        this.ithoiHut = new Zone(new WorldPoint(2527, 2835, 1), new WorldPoint(2532, 2841, 1));
        this.gnocciHut = new Zone(new WorldPoint(2543, 2860, 1), new WorldPoint(2547, 2864, 1));
        this.arsenHut = new Zone(new WorldPoint(2553, 2853, 1), new WorldPoint(2559, 2859, 1));
        this.ship = new Zone(new WorldPoint(2573, 2835, 1), new WorldPoint(2583, 2837, 1));
        this.cavern = new Zone(new WorldPoint(1876, 8960, 1), new WorldPoint(2073, 9093, 1));
    }

    public void setupConditions() {
        this.inCove = new ZoneRequirement(this.cove);
        this.inIthoiHut = new ZoneRequirement(this.ithoiHut);
        this.inGnocciHut = new ZoneRequirement(this.gnocciHut);
        this.inArsenHut = new ZoneRequirement(this.arsenHut);
        this.inShip = new ZoneRequirement(this.ship);
        this.inCavern = new ZoneRequirement(this.cavern);
        this.talkedToIthoi = new VarbitRequirement(6075, 1);
        this.talkedToArsen = new VarbitRequirement(6074, 2, Operation.GREATER_EQUAL);
        this.returnedToothPick = new VarbitRequirement(6074, 4);
        this.finishedArsen = new VarbitRequirement(6074, 6, Operation.GREATER_EQUAL);
        this.talkedToColin = new VarbitRequirement(6072, 1, Operation.GREATER_EQUAL);
        this.lookedThroughTelescope = new VarbitRequirement(6072, 2);
        this.finishedColin = new VarbitRequirement(6072, 3);
        this.talkedToGnocci = new VarbitRequirement(6073, 1);
        this.foundDoll = new VarbitRequirement(6073, 2);
        this.finishedGnocci = new VarbitRequirement(6073, 3);
    }

    public void setupSteps() {
        this.talkToTockFarm = new NpcStep((QuestHelper)this, 7956, new WorldPoint(3030, 3273, 0), "Talk to Captain Tock north of Port Sarim.", new Requirement[0]);
        this.talkToTockFarm.addDialogStep("What kind of help do you need?");
        this.talkToTockFarm.addDialogStep("Sure, I'll try to help with your curse.");
        this.talkToTockRimmington = new NpcStep((QuestHelper)this, 7956, new WorldPoint(2910, 3226, 0), "Talk to Captain Tock west of Rimmington.", new Requirement[0]);
        this.talkToTockRimmington.addDialogStep("Okay, I'm ready go to Corsair Cove.");
        this.returnToCove = new NpcStep((QuestHelper)this, 7958, new WorldPoint(2910, 3226, 0), "Return to Corsair Cove.", new Requirement[0]);
        this.returnToCove.addDialogStep("Let's go.");
        this.goUpToIthoi = new ObjectStep((QuestHelper)this, 31735, new WorldPoint(2531, 2833, 0), "Talk to Ithoi in the south western hut.", new Requirement[0]);
        this.talkToIthoi = new NpcStep((QuestHelper)this, 7961, new WorldPoint(2529, 2840, 1), "Talk to Ithoi in the south western hut.", new Requirement[0]);
        this.talkToIthoi.addDialogStep("I hear you've been cursed.");
        this.talkToIthoi.addSubSteps(this.goUpToIthoi);
        this.goDownFromIthoi = new ObjectStep((QuestHelper)this, 31735, new WorldPoint(2529, 2834, 1), "Talk to Arsen in the central hut.", new Requirement[0]);
        this.goUpToGnocci = new ObjectStep((QuestHelper)this, 31733, new WorldPoint(2549, 2862, 0), "Talk to Gnocci in the north west hut.", new Requirement[0]);
        this.talkToGnocci = new NpcStep((QuestHelper)this, 7970, new WorldPoint(2545, 2863, 1), "Talk to Gnocci in the north west hut.", new Requirement[0]);
        this.talkToGnocci.addDialogStep("I hear you've been cursed.");
        this.talkToGnocci.addSubSteps(this.goUpToGnocci, this.goDownFromIthoi);
        this.goDownFromGnocci = new ObjectStep((QuestHelper)this, 31734, new WorldPoint(2548, 2862, 1), "Talk to Chief Tess down the hole west of the Cove.", new Requirement[0]);
        this.goUpToArsen = new ObjectStep((QuestHelper)this, 31733, new WorldPoint(2555, 2856, 0), "Talk to Arsen in the central hut.", new Requirement[0]);
        this.talkToArsen = new NpcStep((QuestHelper)this, 7976, new WorldPoint(2554, 2859, 1), "Talk to Arsen in the central hut.", new Requirement[0]);
        this.talkToArsen.addDialogStep("I hear you've been cursed.");
        this.talkToArsen.addSubSteps(this.goDownFromIthoi, this.goUpToArsen);
        this.goUpToColin = new ObjectStep((QuestHelper)this, 31733, new WorldPoint(2555, 2856, 0), "Talk to Colin in the central hut.", new Requirement[0]);
        this.talkToColin = new NpcStep((QuestHelper)this, 7965, new WorldPoint(2558, 2858, 1), "Talk to Colin in the central hut.", new Requirement[0]);
        this.talkToColin.addDialogStep("I hear you've been cursed.");
        this.talkToColin.addSubSteps(this.goUpToColin);
        this.goDownFromArsen = new ObjectStep((QuestHelper)this, 31734, new WorldPoint(2555, 2855, 1), "Talk to Gnocci in the north west hut.", new Requirement[0]);
        this.grabTinderbox = new ObjectStep((QuestHelper)this, 31634, new WorldPoint(2543, 2862, 1), "Pick up the tinderbox next to Gnocci.", this.tinderbox);
        this.pickUpSpade = new ObjectStep((QuestHelper)this, 31585, new WorldPoint(2552, 2846, 0), "Take the spade in the south of the Corsair Cove.", new Requirement[0]);
        this.talkToTockShip = new NpcStep((QuestHelper)this, 7958, new WorldPoint(2574, 2835, 1), "Talk to Captain Tock on the ship.", new Requirement[0]);
        this.talkToTockShip.addDialogStep("Arsen says he gave you a sacred ogre relic.");
        this.talkToTockShip.addDialogStep("About that sacred ogre relic...");
        this.goOntoShip = new ObjectStep((QuestHelper)this, 31756, new WorldPoint(2578, 2839, 0), "Talk to Captain Tock on the ship.", new Requirement[0]);
        this.leaveShip = new ObjectStep((QuestHelper)this, 31756, new WorldPoint(2578, 2838, 1), "Enter the hole west of the Corsair Cove and talk to Chief Tess.", new Requirement[0]);
        this.goDownToTess = new ObjectStep((QuestHelper)this, 31791, new WorldPoint(2523, 2861, 0), "Enter the hole west of the Corsair Cove and talk to Chief Tess.", new Requirement[0]);
        this.talkToTess = new NpcStep((QuestHelper)this, 7988, new WorldPoint(2012, 9006, 1), "Talk to Chief Tess.", new Requirement[0]);
        this.talkToTess.addSubSteps(this.goDownToTess, this.leaveShip);
        this.talkToTess.addDialogStep("I've come to return what Arsen stole.");
        this.goUpFromTess = new ObjectStep((QuestHelper)this, 31790, new WorldPoint(2012, 9005, 1), "Leave the cavern.", new Requirement[0]);
        this.digSand = new DigStep((QuestHelper)this, new WorldPoint(2504, 2840, 0), "Dig next to the tree south west of the Cove.", new Requirement[0]);
        this.digSand.addDialogStep("Search for the possessed doll and face the consequences.");
        this.digSand.addSubSteps(this.goUpFromTess);
        this.goUpToIthoi2 = new ObjectStep((QuestHelper)this, 31735, new WorldPoint(2531, 2833, 0), "Go look through Ithoi's telescope.", new Requirement[0]);
        this.lookThroughTelescope = new ObjectStep((QuestHelper)this, 31632, new WorldPoint(2528, 2835, 1), "Go look through Ithoi's telescope.", new Requirement[0]);
        this.lookThroughTelescope.addSubSteps(this.goUpToIthoi2);
        this.goDownFromIthoi2 = new ObjectStep((QuestHelper)this, 31735, new WorldPoint(2529, 2834, 1), "Leave Ithoi's hut.", new Requirement[0]);
        this.goUpToGnocci2 = new ObjectStep((QuestHelper)this, 31733, new WorldPoint(2549, 2862, 0), "Talk to Gnocci in the north west hut.", new Requirement[0]);
        this.talkToGnocci2 = new NpcStep((QuestHelper)this, 7970, new WorldPoint(2545, 2863, 1), "Talk to Gnocci in the north west hut.", new Requirement[0]);
        this.talkToGnocci2.addSubSteps(this.goUpToGnocci2, this.goDownFromIthoi2);
        this.goDownFromGnocci2 = new ObjectStep((QuestHelper)this, 31734, new WorldPoint(2548, 2862, 1), "Talk to Arsen.", new Requirement[0]);
        this.goUpToArsen2 = new ObjectStep((QuestHelper)this, 31733, new WorldPoint(2555, 2856, 0), "Talk to Arsen in the central hut.", new Requirement[0]);
        this.talkToArsen2 = new NpcStep((QuestHelper)this, 7976, new WorldPoint(2554, 2859, 1), "Talk to Arsen in the central hut.", new Requirement[0]);
        this.talkToArsen2.addSubSteps(this.goUpToArsen2, this.goDownFromGnocci2);
        this.goUpToColin2 = new ObjectStep((QuestHelper)this, 31733, new WorldPoint(2555, 2856, 0), "Talk to Colin in the central hut.", new Requirement[0]);
        this.talkToColin2 = new NpcStep((QuestHelper)this, 7965, new WorldPoint(2558, 2858, 1), "Talk to Colin in the central hut.", new Requirement[0]);
        this.talkToColin2.addSubSteps(this.goUpToColin);
        this.goOntoShip2 = new ObjectStep((QuestHelper)this, 31756, new WorldPoint(2578, 2839, 0), "Talk to Captain Tock on the ship.", new Requirement[0]);
        this.talkToTockShip2 = new NpcStep((QuestHelper)this, 7958, new WorldPoint(2574, 2835, 1), "Talk to Captain Tock on the ship.", new Requirement[0]);
        this.talkToTockShip2.addDialogStep("I've ruled out all the Corsairs' theories...");
        this.talkToTockShip2.addDialogStep("So what do I do now?");
        this.talkToTockShip2.addSubSteps(this.goOntoShip2);
        this.leaveShip2 = new ObjectStep((QuestHelper)this, 31756, new WorldPoint(2578, 2838, 1), "Talk to Gnocci in the north west hut.", new Requirement[0]);
        this.goUpToGnocci3 = new ObjectStep((QuestHelper)this, 31733, new WorldPoint(2549, 2862, 0), "Talk to Gnocci in the north west hut.", new Requirement[0]);
        this.talkToGnocci3 = new NpcStep((QuestHelper)this, 7970, new WorldPoint(2545, 2863, 1), "Talk to Gnocci in the north west hut.", new Requirement[0]);
        this.talkToGnocci3.addDialogStep("I hear it happened straight after dinner.");
        this.talkToGnocci3.addSubSteps(this.goUpToGnocci3, this.leaveShip2);
        this.goDownFromGnocci3 = new ObjectStep((QuestHelper)this, 31734, new WorldPoint(2548, 2862, 1), "Talk to Arsen.", new Requirement[0]);
        this.goUpToArsen3 = new ObjectStep((QuestHelper)this, 31733, new WorldPoint(2555, 2856, 0), "Talk to Arsen in the central hut.", new Requirement[0]);
        this.talkToArsen3 = new NpcStep((QuestHelper)this, 7976, new WorldPoint(2554, 2859, 1), "Talk to Arsen in the central hut.", new Requirement[0]);
        this.talkToArsen3.addDialogStep("I hear Ithoi cooked the meal you ate that night.");
        this.talkToArsen3.addSubSteps(this.goUpToArsen3, this.goDownFromGnocci3);
        this.goDownFromArsen3 = new ObjectStep((QuestHelper)this, 31734, new WorldPoint(2555, 2855, 1), "Talk to Ithoi in the south western hut.", new Requirement[0]);
        this.goUpToIthoi3 = new ObjectStep((QuestHelper)this, 31735, new WorldPoint(2531, 2833, 0), "Talk to Ithoi in the south western hut.", new Requirement[0]);
        this.talkToIthoi2 = new NpcStep((QuestHelper)this, 7961, new WorldPoint(2529, 2840, 1), "Talk to Ithoi.", new Requirement[0]);
        this.talkToIthoi2.addSubSteps(this.goUpToIthoi3, this.goDownFromArsen3);
        this.talkToIthoi2.addDialogStep("I bet I can prove you're well enough to get up.");
        this.talkToIthoi2.addDialogStep("I know you've faked the curse.");
        this.talkToIthoi2.addDialogStep("I hear you cooked the meal they ate before getting sick.");
        this.talkToIthoi2.addDialogStep("Maybe because the Captain's thinking of firing you.");
        this.goDownFromIthoi3 = new ObjectStep((QuestHelper)this, 31735, new WorldPoint(2529, 2834, 1), "Use your tinderbox on the driftwood under Ithoi's hut.", new Requirement[0]);
        this.useTinderboxOnWood = new ObjectStep((QuestHelper)this, 31724, new WorldPoint(2531, 2838, 0), "Use your tinderbox on the driftwood under Ithoi's hut.", this.tinderbox);
        this.useTinderboxOnWood.addIcon(590);
        this.useTinderboxOnWood.addSubSteps(this.goDownFromIthoi3);
        this.goOntoShip3 = new ObjectStep((QuestHelper)this, 31756, new WorldPoint(2578, 2839, 0), "Talk to Captain Tock on the ship.", new Requirement[0]);
        this.talkToTockShip3 = new NpcStep((QuestHelper)this, 7958, new WorldPoint(2574, 2835, 1), "Talk to Captain Tock on the ship.", new Requirement[0]);
        this.talkToTockShip3.addDialogStep("I've seen Ithoi running around. He's not sick at all.");
        this.talkToTockShip3.addSubSteps(this.goOntoShip3);
        this.goUpToIthoiToKill = new ObjectStep((QuestHelper)this, 31735, new WorldPoint(2531, 2833, 0), "Go kill Ithoi (level 35) in his hut.", new Requirement[0]);
        this.goUpToIthoiToKill.addDialogStep("I'll be back.");
        this.killIthoi = new NpcStep((QuestHelper)this, 7964, new WorldPoint(2529, 2840, 1), "Kill Ithoi (level 35).", new Requirement[0]);
        this.killIthoi.addSubSteps(this.goUpToIthoiToKill);
        this.goOntoShip4 = new ObjectStep((QuestHelper)this, 31756, new WorldPoint(2578, 2839, 0), "Talk to Captain Tock on the ship to finish the quest.", new Requirement[0]);
        this.talkToTockShip4 = new NpcStep((QuestHelper)this, 7958, new WorldPoint(2574, 2835, 1), "Talk to Captain Tock on the ship to finish the quest.", new Requirement[0]);
        this.talkToTockShip4.addDialogStep("I've killed Ithoi for poisoning your crew.");
        this.talkToTockShip4.addSubSteps(this.goOntoShip4);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.combatGear);
        return reqs;
    }

    @Override
    public List<String> getCombatRequirements() {
        ArrayList<String> reqs = new ArrayList<String>();
        reqs.add("Ithoi the Navigator (level 34)");
        return reqs;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(2);
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Collections.singletonList(new UnlockReward("Access to Yusuf's Bank in the Corsair Cove."));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Travel to the cove", Arrays.asList(this.talkToTockFarm, this.talkToTockRimmington), this.combatGear));
        allSteps.add(new PanelDetails("Solve the curse", Arrays.asList(this.talkToIthoi, this.talkToGnocci, this.talkToArsen, this.talkToColin, this.grabTinderbox, this.pickUpSpade, this.talkToTockShip, this.talkToTess, this.digSand, this.lookThroughTelescope, this.talkToGnocci2, this.talkToArsen2, this.talkToColin2), new Requirement[0]));
        allSteps.add(new PanelDetails("Discover betrayal", Arrays.asList(this.talkToTockShip2, this.talkToGnocci3, this.talkToArsen3, this.talkToIthoi2, this.useTinderboxOnWood, this.talkToTockShip3), new Requirement[0]));
        allSteps.add(new PanelDetails("Deal with Ithoi", Arrays.asList(this.killIthoi, this.talkToTockShip4), new Requirement[0]));
        return allSteps;
    }
}

