/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.theascentofarceuus;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.npc.NpcHintArrowRequirement;
import com.questhelper.requirements.player.Favour;
import com.questhelper.requirements.player.FavourRequirement;
import com.questhelper.requirements.player.InInstanceRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.THE_ASCENT_OF_ARCEUUS)
public class TheAscentOfArceuus
extends BasicQuestHelper {
    ItemRequirement combatGear;
    ItemRequirement dramenStaff;
    ItemRequirement battlefrontTeleports2;
    ItemRequirement xericsTalisman;
    ItemRequirement skillsNecklace;
    Requirement inTowerInstance;
    Requirement inTowerF1;
    Requirement inKaruulm;
    Requirement inCastle;
    Requirement foundTrack1;
    Requirement foundTrack2;
    Requirement foundTrack3;
    Requirement foundTrack4;
    Requirement foundTrack5;
    Requirement trappedSoulNearby;
    QuestStep talkToMori;
    QuestStep goUpToAndrews;
    QuestStep talkToAndrews;
    QuestStep returnToMori;
    QuestStep enterTowerOfMagic;
    QuestStep killTormentedSouls;
    QuestStep goUpstairsTowerOfMagic;
    QuestStep talkToArceuus;
    QuestStep enterKaruulm;
    QuestStep talkToKaal;
    QuestStep leaveKaal;
    QuestStep inspectGrave;
    QuestStep inspectTrack1;
    QuestStep inspectTrack2;
    QuestStep inspectTrack3;
    QuestStep inspectTrack4;
    QuestStep inspectTrack5;
    QuestStep inspectTrack6;
    QuestStep killTrappedSoul;
    QuestStep enterKaruulmAgain;
    QuestStep talkToKaalAgain;
    QuestStep searchRocks;
    QuestStep goUpstairsInTowerToFinish;
    QuestStep talkToArceuusToFinish;
    Zone towerF0;
    Zone towerF1;
    Zone karuulm;
    Zone castle;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToMori);
        ConditionalStep goTalkToAndrews = new ConditionalStep((QuestHelper)this, this.goUpToAndrews, new Requirement[0]);
        goTalkToAndrews.addStep(this.inCastle, this.talkToAndrews);
        steps.put(1, goTalkToAndrews);
        steps.put(2, this.returnToMori);
        ConditionalStep goDefeatSouls = new ConditionalStep((QuestHelper)this, this.enterTowerOfMagic, new Requirement[0]);
        goDefeatSouls.addStep(this.inTowerInstance, this.killTormentedSouls);
        steps.put(3, goDefeatSouls);
        steps.put(4, goDefeatSouls);
        ConditionalStep goTalkToArceuus = new ConditionalStep((QuestHelper)this, this.goUpstairsTowerOfMagic, new Requirement[0]);
        goTalkToArceuus.addStep(this.inTowerF1, this.talkToArceuus);
        steps.put(5, goTalkToArceuus);
        steps.put(6, goTalkToArceuus);
        ConditionalStep goTalkToKaal = new ConditionalStep((QuestHelper)this, this.enterKaruulm, new Requirement[0]);
        goTalkToKaal.addStep(this.inKaruulm, this.talkToKaal);
        steps.put(7, goTalkToKaal);
        ConditionalStep goInspectGrave = new ConditionalStep((QuestHelper)this, this.inspectGrave, new Requirement[0]);
        goInspectGrave.addStep(this.inKaruulm, this.leaveKaal);
        steps.put(8, goInspectGrave);
        ConditionalStep trackingSteps = new ConditionalStep((QuestHelper)this, this.inspectTrack1, new Requirement[0]);
        trackingSteps.addStep(this.foundTrack5, this.inspectTrack6);
        trackingSteps.addStep(this.foundTrack4, this.inspectTrack5);
        trackingSteps.addStep(this.foundTrack3, this.inspectTrack4);
        trackingSteps.addStep(this.foundTrack2, this.inspectTrack3);
        trackingSteps.addStep(this.foundTrack1, this.inspectTrack2);
        steps.put(9, trackingSteps);
        ConditionalStep goKillTrappedSoul = new ConditionalStep((QuestHelper)this, this.inspectTrack6, new Requirement[0]);
        goKillTrappedSoul.addStep(this.trappedSoulNearby, this.killTrappedSoul);
        steps.put(10, goKillTrappedSoul);
        ConditionalStep goReturnToKaal = new ConditionalStep((QuestHelper)this, this.enterKaruulmAgain, new Requirement[0]);
        goReturnToKaal.addStep(this.inKaruulm, this.talkToKaalAgain);
        steps.put(11, goReturnToKaal);
        steps.put(12, this.searchRocks);
        ConditionalStep goFinishQuest = new ConditionalStep((QuestHelper)this, this.goUpstairsInTowerToFinish, new Requirement[0]);
        goFinishQuest.addStep(this.inTowerF1, this.talkToArceuusToFinish);
        steps.put(13, goFinishQuest);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.dramenStaff = new ItemRequirement("Access to Fairy Rings", 772).isNotConsumed();
        this.dramenStaff.addAlternates(9084);
        this.battlefrontTeleports2 = new ItemRequirement("Battlefront teleports", 22949, 2);
        this.xericsTalisman = new ItemRequirement("Xeric's Talisman", 13393).isNotConsumed();
        this.skillsNecklace = new ItemRequirement("Skills necklace", ItemCollections.SKILLS_NECKLACES).isNotConsumed();
        this.combatGear = new ItemRequirement("Combat gear", -1, -1).isNotConsumed();
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
    }

    public void loadZones() {
        this.towerF0 = new Zone(new WorldPoint(1563, 3802, 0), new WorldPoint(1595, 3836, 0));
        this.towerF1 = new Zone(new WorldPoint(1563, 3802, 1), new WorldPoint(1595, 3836, 1));
        this.castle = new Zone(new WorldPoint(1591, 3654, 1), new WorldPoint(1628, 3692, 1));
        this.karuulm = new Zone(new WorldPoint(1249, 10144, 0), new WorldPoint(1385, 10286, 0));
    }

    public void setupConditions() {
        this.inTowerInstance = new Conditions(new InInstanceRequirement(), new ZoneRequirement(this.towerF0));
        this.inTowerF1 = new ZoneRequirement(this.towerF1);
        this.inCastle = new ZoneRequirement(this.castle);
        this.inKaruulm = new ZoneRequirement(this.karuulm);
        this.foundTrack1 = new VarbitRequirement(7860, 1);
        this.foundTrack2 = new VarbitRequirement(7861, 1);
        this.foundTrack3 = new VarbitRequirement(7862, 1);
        this.foundTrack4 = new VarbitRequirement(7863, 1);
        this.foundTrack5 = new VarbitRequirement(7864, 1);
        this.trappedSoulNearby = new NpcHintArrowRequirement(8514);
    }

    public void setupSteps() {
        this.talkToMori = new NpcStep((QuestHelper)this, 8501, new WorldPoint(1698, 3742, 0), "Talk to Mori in Arceuus.", new Requirement[0]);
        this.talkToMori.addDialogSteps("What can I do to help?", "We should let someone know about this.", "Yes.", "Of course I'll help.");
        this.goUpToAndrews = new ObjectStep((QuestHelper)this, 11807, new WorldPoint(1616, 3681, 0), "Talk to Councillor Andrews in Kourend Castle.", new Requirement[0]);
        this.talkToAndrews = new NpcStep((QuestHelper)this, 11152, new WorldPoint(1620, 3673, 1), "Talk to Councillor Andrews in Kourend Castle.", new Requirement[0]);
        this.talkToAndrews.addDialogStep("There's been a death in Arceuus.");
        this.talkToAndrews.addSubSteps(this.goUpToAndrews);
        this.returnToMori = new NpcStep((QuestHelper)this, 8501, new WorldPoint(1698, 3742, 0), "Return to Mori in Arceuus.", new Requirement[0]);
        this.returnToMori.addDialogStep("What should we do now?");
        this.enterTowerOfMagic = new ObjectStep((QuestHelper)this, 33570, new WorldPoint(1596, 3820, 0), "Enter the Tower of Magic in Arceuus, ready to fight some level 16 Tormented Souls.", this.combatGear);
        this.enterTowerOfMagic.addDialogStep("Yes.");
        this.killTormentedSouls = new NpcStep((QuestHelper)this, 8512, new WorldPoint(1585, 3821, 0), "Defeat the tormented souls.", true, this.combatGear);
        ((NpcStep)this.killTormentedSouls).addAlternateNpcs(8513);
        this.goUpstairsTowerOfMagic = new ObjectStep((QuestHelper)this, 33575, new WorldPoint(1585, 3821, 0), "Go up the stairs in the Tower of Magic.", new Requirement[0]);
        this.talkToArceuus = new NpcStep((QuestHelper)this, 8504, new WorldPoint(1580, 3821, 1), "Talk to Lord Trobin Arceuus.", new Requirement[0]);
        ((NpcStep)this.talkToArceuus).addAlternateNpcs(8505);
        this.enterKaruulm = new ObjectStep((QuestHelper)this, 34359, new WorldPoint(1311, 3807, 0), "Go down the elevator on Mount Karuulm.", new Requirement[0]);
        this.talkToKaal = new NpcStep((QuestHelper)this, 8602, new WorldPoint(1312, 10211, 0), "Talk to Kaal-Ket-Jor.", new Requirement[0]);
        this.leaveKaal = new ObjectStep((QuestHelper)this, 34514, new WorldPoint(1312, 10186, 0), "Inspect the ancient grave south of Mount Karuulm.", new Requirement[0]);
        this.inspectGrave = new ObjectStep((QuestHelper)this, 34602, new WorldPoint(1349, 3737, 0), "Inspect the ancient grave south of Mount Karuulm.", this.combatGear);
        this.inspectGrave.addSubSteps(this.leaveKaal);
        this.inspectTrack1 = new ObjectStep((QuestHelper)this, 34622, new WorldPoint(1335, 3743, 0), "Inspect plants and bushes until you uncover the full path.", new Requirement[0]);
        this.inspectTrack2 = new ObjectStep((QuestHelper)this, 34623, new WorldPoint(1317, 3750, 0), "Inspect plants and bushes until you uncover the full path.", new Requirement[0]);
        this.inspectTrack3 = new ObjectStep((QuestHelper)this, 34623, new WorldPoint(1305, 3750, 0), "Inspect plants and bushes until you uncover the full path.", new Requirement[0]);
        this.inspectTrack4 = new ObjectStep((QuestHelper)this, 34621, new WorldPoint(1288, 3751, 0), "Inspect plants and bushes until you uncover the full path.", new Requirement[0]);
        this.inspectTrack5 = new ObjectStep((QuestHelper)this, 34624, new WorldPoint(1286, 3738, 0), "Inspect plants and bushes until you uncover the full path.", new Requirement[0]);
        this.inspectTrack1.addSubSteps(this.inspectTrack2, this.inspectTrack3, this.inspectTrack4, this.inspectTrack5);
        this.inspectTrack6 = new ObjectStep((QuestHelper)this, 34625, new WorldPoint(1282, 3726, 0), "Inspect the final plant and kill the Trapped Soul (level 30) which appears.", this.combatGear);
        this.killTrappedSoul = new NpcStep((QuestHelper)this, 8514, new WorldPoint(1281, 3724, 0), "Kill the Trapped Soul.", new Requirement[0]);
        this.inspectTrack6.addSubSteps(this.killTrappedSoul);
        this.enterKaruulmAgain = new ObjectStep((QuestHelper)this, 34359, new WorldPoint(1311, 3807, 0), "Return to Kaal-Ket-Jor.", new Requirement[0]);
        this.talkToKaalAgain = new NpcStep((QuestHelper)this, 8602, new WorldPoint(1312, 10211, 0), "Return to Kaal-Ket-Jor.", new Requirement[0]);
        this.talkToKaalAgain.addSubSteps(this.enterKaruulmAgain);
        this.searchRocks = new ObjectStep((QuestHelper)this, 33595, new WorldPoint(1710, 3882, 0), "Inspect the rocks near the Arceuus Altar until you find a device.", true, new Requirement[0]);
        ((ObjectStep)this.searchRocks).addAlternateObjects(33593);
        this.goUpstairsInTowerToFinish = new ObjectStep((QuestHelper)this, 33575, new WorldPoint(1585, 3821, 0), "Return to Lord Trobin Arceuus to finish the quest.", new Requirement[0]);
        this.talkToArceuusToFinish = new NpcStep((QuestHelper)this, 8505, new WorldPoint(1580, 3821, 1), "Talk to Lord Trobin Arceuus to finish the quest.", new Requirement[0]);
        this.talkToArceuusToFinish.addSubSteps(this.goUpstairsInTowerToFinish);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.combatGear, this.dramenStaff, this.battlefrontTeleports2, this.xericsTalisman, this.skillsNecklace);
    }

    @Override
    public List<String> getCombatRequirements() {
        return Arrays.asList("5 Tormented Souls (level 16)", "Trapped Soul (level 30)");
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new QuestRequirement(QuestHelperQuest.X_MARKS_THE_SPOT, QuestState.FINISHED));
        req.add(new QuestRequirement(QuestHelperQuest.CLIENT_OF_KOUREND, QuestState.FINISHED));
        req.add(new FavourRequirement(Favour.ARCEUUS, 20));
        req.add(new SkillRequirement(Skill.HUNTER, 12));
        return req;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Arrays.asList(new ExperienceReward(Skill.HUNTER, 1500), new ExperienceReward(Skill.RUNECRAFT, 500));
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Arrays.asList(new ItemReward("Coins", 995, 2000), new ItemReward("Arceuus Favour Certificate", 22777, 1), new ItemReward("A Kharedst's Memoirs page", 21760, 1));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting off", Arrays.asList(this.talkToMori, this.talkToAndrews, this.returnToMori, this.enterTowerOfMagic, this.killTormentedSouls, this.goUpstairsTowerOfMagic, this.talkToArceuus), new Requirement[0]));
        allSteps.add(new PanelDetails("Freeing a Soul", Arrays.asList(this.talkToKaal, this.inspectGrave, this.inspectTrack1, this.inspectTrack6, this.talkToKaalAgain), this.combatGear));
        allSteps.add(new PanelDetails("Saving Arceuus", Arrays.asList(this.searchRocks, this.talkToArceuusToFinish), new Requirement[0]));
        return allSteps;
    }
}

