/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.templeoftheeye;

import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.questinfo.QuestVarbits;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.Operation;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.TEMPLE_OF_THE_EYE)
public class TempleOfTheEye
extends BasicQuestHelper {
    ItemRequirement bucketOfWater;
    ItemRequirement strongTea;
    ItemRequirement eyeAmulet;
    ItemRequirement chisel;
    ItemRequirement pickaxe;
    ItemRequirement abyssalIncantation;
    ItemRequirement varrockTeleport;
    ItemRequirement alKharidTeleport;
    Requirement inAbyss;
    Requirement canTeleportFromHerbert;
    Requirement thrownBucket;
    Requirement givenAmuletBack;
    Requirement inWizardBasement;
    Requirement canTeleportFromPersten;
    Requirement inWizardFloorOne;
    Requirement felixPuzzleNotSeen;
    Requirement tamaraPuzzleNotSeen;
    Requirement cordeliaPuzzleNotSeen;
    Requirement inTempleOfTheEye;
    Requirement felixRiftTalk;
    Requirement tamaraRiftTalk;
    Requirement cordeliaRiftTalk;
    Requirement mysteriousVisionSeen;
    Requirement inTempleOfTheEyeTutorial;
    QuestStep talkToPersten1;
    QuestStep finishTalkToPersten1;
    QuestStep talkToMage1;
    QuestStep getTeaForMage;
    QuestStep talkToMage2;
    QuestStep finishTalkToMage2;
    QuestStep teleportViaHerbert;
    QuestStep talkToDarkMage1;
    QuestStep finishTalkToDarkMage1;
    QuestStep talkToMageInWildy;
    QuestStep talkToDarkMage2;
    QuestStep talkToPersten2;
    QuestStep finishTalkToPersten2;
    QuestStep teleportToArchmage;
    QuestStep goDownToArchmage;
    QuestStep talktoArchmage1;
    QuestStep finishTalkingToArchmage1;
    QuestStep goUpToTraibornBasement;
    QuestStep goUpToTraiborn;
    QuestStep talktoTrailborn1;
    QuestStep talkToFelix;
    QuestStep talkToTamara;
    QuestStep talkToCordelia;
    QuestStep talktoTrailborn2;
    QuestStep goDownToArchmageFloorOne;
    QuestStep goDownToArchmage2;
    QuestStep talktoArchmage2;
    QuestStep performIncantation;
    QuestStep enterWizardBasement;
    QuestStep enterPortal;
    QuestStep templeCutscene1;
    QuestStep talkToFelix2;
    QuestStep talkToTamara2;
    QuestStep talkToCordelia2;
    QuestStep talkToPersten3;
    QuestStep templeCutscene2;
    QuestStep debrief;
    QuestStep guardiansTutorial;
    QuestStep templeCutscene3;
    QuestStep finishQuest;
    ObjectStep touchRunes;
    Zone abyss;
    Zone wizardBasement;
    Zone wizardFloorOne;
    Zone templeOfTheEye;
    Zone templeOfTheEye2;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.setupRequirements();
        this.setupZones();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToPersten1);
        steps.put(5, this.finishTalkToPersten1);
        steps.put(10, this.talkToMage1);
        ConditionalStep fetchHerbertsTea = new ConditionalStep((QuestHelper)this, this.getTeaForMage, new Requirement[0]);
        fetchHerbertsTea.addStep(new Conditions(this.strongTea, this.bucketOfWater, this.eyeAmulet), this.talkToMage2);
        steps.put(15, fetchHerbertsTea);
        steps.put(20, this.finishTalkToMage2);
        ConditionalStep teleportAbyss = new ConditionalStep((QuestHelper)this, this.talkToMageInWildy, new Requirement[0]);
        teleportAbyss.addStep(this.inAbyss, this.talkToDarkMage1);
        teleportAbyss.addStep(this.canTeleportFromHerbert, this.teleportViaHerbert);
        teleportAbyss.addRequirement(this.bucketOfWater);
        steps.put(25, teleportAbyss);
        ConditionalStep goTalkToDarkMage1 = new ConditionalStep((QuestHelper)this, this.talkToMageInWildy, new Requirement[0]);
        goTalkToDarkMage1.addStep(this.inAbyss, this.finishTalkToDarkMage1);
        steps.put(30, goTalkToDarkMage1);
        ConditionalStep goTouchRunes = new ConditionalStep((QuestHelper)this, this.talkToMageInWildy, new Requirement[0]);
        goTouchRunes.addStep(this.inAbyss, this.touchRunes);
        steps.put(35, goTouchRunes);
        ConditionalStep goTalkToDarkMage2 = new ConditionalStep((QuestHelper)this, this.talkToMageInWildy, new Requirement[0]);
        goTalkToDarkMage2.addStep(this.inAbyss, this.talkToDarkMage2);
        steps.put(40, goTalkToDarkMage2);
        steps.put(45, this.talkToPersten2);
        steps.put(50, this.talkToPersten2);
        steps.put(55, this.finishTalkToPersten2);
        ConditionalStep goTalkToArchmage = new ConditionalStep((QuestHelper)this, this.goDownToArchmage, new Requirement[0]);
        goTalkToArchmage.addStep(this.canTeleportFromPersten, this.teleportToArchmage);
        goTalkToArchmage.addStep(this.inWizardBasement, this.talktoArchmage1);
        goTalkToArchmage.addRequirement(this.abyssalIncantation);
        steps.put(60, goTalkToArchmage);
        steps.put(65, this.finishTalkingToArchmage1);
        ConditionalStep goTalkToTraiborn1 = new ConditionalStep((QuestHelper)this, this.goUpToTraiborn, new Requirement[0]);
        goTalkToTraiborn1.addStep(this.inWizardBasement, this.goUpToTraibornBasement);
        goTalkToTraiborn1.addStep(this.inWizardFloorOne, this.talktoTrailborn1);
        steps.put(70, goTalkToTraiborn1);
        ConditionalStep solveTraibornsPuzzle = new ConditionalStep((QuestHelper)this, this.goUpToTraiborn, new Requirement[0]);
        solveTraibornsPuzzle.addStep(new Conditions(this.inWizardFloorOne, this.felixPuzzleNotSeen), this.talkToFelix);
        solveTraibornsPuzzle.addStep(new Conditions(this.inWizardFloorOne, this.tamaraPuzzleNotSeen), this.talkToTamara);
        solveTraibornsPuzzle.addStep(new Conditions(this.inWizardFloorOne, this.cordeliaPuzzleNotSeen), this.talkToCordelia);
        steps.put(75, solveTraibornsPuzzle);
        ConditionalStep goTalkToTraiborn2 = new ConditionalStep((QuestHelper)this, this.goUpToTraiborn, new Requirement[0]);
        goTalkToTraiborn2.addStep(this.inWizardBasement, this.goUpToTraibornBasement);
        goTalkToTraiborn2.addStep(this.inWizardFloorOne, this.talktoTrailborn2);
        steps.put(80, goTalkToTraiborn2);
        ConditionalStep goTalkToArchmage2 = new ConditionalStep((QuestHelper)this, this.goDownToArchmage2, new Requirement[0]);
        goTalkToArchmage2.addStep(this.inWizardFloorOne, this.goDownToArchmageFloorOne);
        goTalkToArchmage2.addStep(this.inWizardBasement, this.talktoArchmage2);
        steps.put(85, goTalkToArchmage2);
        ConditionalStep goBeginIncantation = new ConditionalStep((QuestHelper)this, this.goDownToArchmage2, new Requirement[0]);
        goBeginIncantation.addStep(this.inWizardBasement, this.performIncantation);
        steps.put(90, goBeginIncantation);
        steps.put(95, this.templeCutscene1);
        ConditionalStep investigateTemple = new ConditionalStep((QuestHelper)this, this.enterWizardBasement, new Requirement[0]);
        investigateTemple.addStep(this.inWizardBasement, this.enterPortal);
        investigateTemple.addStep(new Conditions(this.inTempleOfTheEye, this.felixRiftTalk), this.talkToFelix2);
        investigateTemple.addStep(new Conditions(this.inTempleOfTheEye, this.tamaraRiftTalk), this.talkToTamara2);
        investigateTemple.addStep(new Conditions(this.inTempleOfTheEye, this.cordeliaRiftTalk), this.talkToCordelia2);
        steps.put(100, investigateTemple);
        ConditionalStep goTalkToPerstenTemple = new ConditionalStep((QuestHelper)this, this.enterWizardBasement, new Requirement[0]);
        goTalkToPerstenTemple.addStep(this.inWizardBasement, this.enterPortal);
        goTalkToPerstenTemple.addStep(this.inTempleOfTheEye, this.talkToPersten3);
        goTalkToPerstenTemple.addStep(this.mysteriousVisionSeen, this.templeCutscene2);
        steps.put(105, goTalkToPerstenTemple);
        ConditionalStep debriefAfterVision = new ConditionalStep((QuestHelper)this, this.enterWizardBasement, new Requirement[0]);
        debriefAfterVision.addStep(this.inWizardBasement, this.enterPortal);
        debriefAfterVision.addStep(this.inTempleOfTheEye, this.debrief);
        steps.put(110, debriefAfterVision);
        ConditionalStep doGuardiansTutorial = new ConditionalStep((QuestHelper)this, this.enterWizardBasement, new Requirement[0]);
        doGuardiansTutorial.addStep(this.inWizardBasement, this.enterPortal);
        doGuardiansTutorial.addStep(this.inTempleOfTheEyeTutorial, this.guardiansTutorial);
        steps.put(115, doGuardiansTutorial);
        ConditionalStep finishGuardiansTutorial = new ConditionalStep((QuestHelper)this, this.enterWizardBasement, new Requirement[0]);
        finishGuardiansTutorial.addStep(this.inWizardBasement, this.enterPortal);
        finishGuardiansTutorial.addStep(this.inTempleOfTheEyeTutorial, this.templeCutscene3);
        steps.put(120, finishGuardiansTutorial);
        ConditionalStep doFinishQuest = new ConditionalStep((QuestHelper)this, this.enterWizardBasement, new Requirement[0]);
        doFinishQuest.addStep(this.inWizardBasement, this.finishQuest);
        steps.put(125, doFinishQuest);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.bucketOfWater = new ItemRequirement("Bucket of water", 1929);
        this.chisel = new ItemRequirement("Chisel", 1755);
        this.chisel.canBeObtainedDuringQuest();
        this.pickaxe = new ItemRequirement("Pickaxe", ItemCollections.PICKAXES);
        this.pickaxe.canBeObtainedDuringQuest();
        this.varrockTeleport = new ItemRequirement("Method of teleportation to Varrock", 8007);
        this.alKharidTeleport = new ItemRequirement("Method of teleportation to Al Kharid", ItemCollections.RING_OF_DUELINGS);
        this.alKharidTeleport.addAlternates(ItemCollections.AMULET_OF_GLORIES);
        this.alKharidTeleport.addAlternates(8008);
        this.strongTea = new ItemRequirement("Strong Cup of Tea", 26904);
        this.eyeAmulet = new ItemRequirement("Eye Amulet", 26903);
        this.eyeAmulet.setTooltip("You can get another from Wizard Persten if you lost it");
        this.abyssalIncantation = new ItemRequirement("Abyssal Incantation", 26905);
        this.abyssalIncantation.setTooltip("You can get another from the Dark Mage in the Abyss if you lost it. If already shown to Wizard Persten, you can get another from her instead");
    }

    public void setupConditions() {
        this.inAbyss = new ZoneRequirement(this.abyss);
        this.inWizardBasement = new ZoneRequirement(this.wizardBasement);
        this.inWizardFloorOne = new ZoneRequirement(this.wizardFloorOne);
        this.inTempleOfTheEye = new ZoneRequirement(this.templeOfTheEye);
        this.inTempleOfTheEyeTutorial = new ZoneRequirement(this.templeOfTheEye2);
        this.canTeleportFromHerbert = new VarbitRequirement(13740, 0);
        this.thrownBucket = new VarbitRequirement(QuestVarbits.QUEST_TEMPLE_OF_THE_EYE.getId(), 30, Operation.GREATER_EQUAL);
        this.givenAmuletBack = new VarbitRequirement(QuestVarbits.QUEST_TEMPLE_OF_THE_EYE.getId(), 55, Operation.GREATER_EQUAL);
        this.canTeleportFromPersten = new VarbitRequirement(13753, 0);
        this.felixPuzzleNotSeen = new VarbitRequirement(13743, 0);
        this.tamaraPuzzleNotSeen = new VarbitRequirement(13742, 0);
        this.cordeliaPuzzleNotSeen = new VarbitRequirement(13744, 0);
        this.felixRiftTalk = new VarbitRequirement(13755, 0);
        this.tamaraRiftTalk = new VarbitRequirement(13754, 0);
        this.cordeliaRiftTalk = new VarbitRequirement(13756, 0);
        this.mysteriousVisionSeen = new VarbitRequirement(12139, 1);
    }

    public void setupZones() {
        this.abyss = new Zone(new WorldPoint(3010, 4803, 0), new WorldPoint(3070, 4862, 0));
        this.wizardBasement = new Zone(new WorldPoint(3094, 9553, 0), new WorldPoint(3125, 9582, 0));
        this.wizardFloorOne = new Zone(new WorldPoint(3101, 3153, 1), new WorldPoint(3116, 3167, 1));
        this.templeOfTheEye = new Zone(new WorldPoint(2370, 5627, 0), new WorldPoint(2425, 5682, 0));
        this.templeOfTheEye2 = new Zone(new WorldPoint(2433, 5698, 0), new WorldPoint(3648, 9523, 0));
    }

    public void setupSteps() {
        this.talkToPersten1 = new NpcStep((QuestHelper)this, 11436, new WorldPoint(3285, 3232, 0), "Talk to Wizard Persten east of the Al Kharid gate.", new Requirement[0]);
        this.talkToPersten1.addDialogStep("What's a wizard doing in Al Kharid?");
        this.talkToPersten1.addDialogStep("Yes.");
        this.finishTalkToPersten1 = new NpcStep((QuestHelper)this, 11436, new WorldPoint(3285, 3232, 0), "Talk to Wizard Persten east of the Al Kharid gate.", new Requirement[0]);
        this.talkToPersten1.addSubSteps(this.finishTalkToPersten1);
        this.talkToMage1 = new NpcStep((QuestHelper)this, 2582, new WorldPoint(3258, 3383, 0), "Talk to Mage of Zamorak in the Varrock chaos temple.", this.eyeAmulet);
        this.talkToMage1.addDialogStep("I need your help with an amulet.");
        this.getTeaForMage = new NpcStep((QuestHelper)this, 8687, new WorldPoint(3271, 3411, 0), "Talk to Tea Seller near the Varrock east gate.", new Requirement[0]);
        this.getTeaForMage.addDialogStep("Could I have a strong cup of tea?");
        this.talkToMage2 = new NpcStep((QuestHelper)this, 2582, new WorldPoint(3258, 3383, 0), "Give the strong tea to the Mage of Zamorak in the Varrock chaos temple.", this.strongTea, this.bucketOfWater, this.eyeAmulet);
        this.talkToMage2.addDialogStep("Could you help me with that amulet now?");
        this.talkToMage2.addDialogStep("Yes.");
        this.finishTalkToMage2 = new NpcStep((QuestHelper)this, 2582, new WorldPoint(3258, 3383, 0), "Talk to Mage of Zamorak in the Varrock chaos temple.", this.bucketOfWater.hideConditioned(this.thrownBucket), this.eyeAmulet);
        this.talkToMage2.addDialogStep("Could you help me with that amulet now?");
        this.talkToMage2.addSubSteps(this.finishTalkToMage2);
        this.teleportViaHerbert = new NpcStep((QuestHelper)this, 2582, new WorldPoint(3258, 3383, 0), "Ask the Mage of Zamorak in Varrock to teleport you to the Abyss (this can only be used once).", this.bucketOfWater.hideConditioned(this.thrownBucket), this.eyeAmulet);
        this.teleportViaHerbert.addDialogStep("Could you help me with that amulet now?");
        this.teleportViaHerbert.addDialogStep("Yes.");
        this.talkToMageInWildy = new NpcStep((QuestHelper)this, 2581, new WorldPoint(3102, 3557, 0), "Return to the Abyss by talking to the Mage of Zamorak in the Wilderness north of Edgeville. BRING NOTHING BUT QUEST ITEMS AS YOU CAN BE KILLED BY OTHER PLAYERS HERE.", this.bucketOfWater.hideConditioned(this.thrownBucket), this.eyeAmulet);
        this.talkToMageInWildy.addDialogStep("Could you teleport me to the Abyss?");
        this.talkToDarkMage1 = new NpcStep((QuestHelper)this, 2583, new WorldPoint(3039, 4834, 0), "Talk to Dark Mage in the Abyss.", this.bucketOfWater.hideConditioned(this.thrownBucket), this.eyeAmulet);
        this.talkToDarkMage1.addDialogStep("I need your help with an amulet.");
        this.finishTalkToDarkMage1 = new NpcStep((QuestHelper)this, 2583, new WorldPoint(3039, 4834, 0), "Talk to Dark Mage in the Abyss.", this.bucketOfWater.hideConditioned(this.thrownBucket), this.eyeAmulet);
        this.talkToDarkMage1.addSubSteps(this.talkToMageInWildy, this.teleportViaHerbert, this.finishTalkToDarkMage1);
        this.touchRunes = new ObjectStep((QuestHelper)this, 43768, "Interact with the runic energy (pattern is different for everyone). Click each rune type until all turn white.", this.eyeAmulet);
        this.touchRunes.addAlternateObjects(43769, 43770, 43771, 43772, 43773);
        this.touchRunes.setHideWorldArrow(true);
        this.talkToDarkMage2 = new NpcStep((QuestHelper)this, 2583, new WorldPoint(3039, 4834, 0), "Talk to Dark Mage in the Abyss.", this.eyeAmulet);
        this.talkToPersten2 = new NpcStep((QuestHelper)this, 11436, new WorldPoint(3285, 3232, 0), "Talk to Wizard Persten east of the Al Kharid gate.", this.eyeAmulet.hideConditioned(this.givenAmuletBack), this.abyssalIncantation);
        this.talkToPersten2.addDialogStep("About that incantation...");
        this.finishTalkToPersten2 = new NpcStep((QuestHelper)this, 11436, new WorldPoint(3285, 3232, 0), "Talk to Wizard Persten east of the Al Kharid gate.", this.eyeAmulet.hideConditioned(this.givenAmuletBack), this.abyssalIncantation);
        this.talkToPersten2.addSubSteps(this.finishTalkToPersten2);
        this.teleportToArchmage = new NpcStep((QuestHelper)this, 11436, new WorldPoint(3285, 3232, 0), "Ask Wizard Persten to teleport you to the Wizards' Tower.", new Requirement[0]);
        this.teleportToArchmage.addDialogStep("Yes.");
        this.goDownToArchmage = new ObjectStep((QuestHelper)this, 2147, new WorldPoint(3104, 3162, 0), "Bring the Abyssal Incantation to Sedridor in the Wizard Tower's basement.", this.abyssalIncantation);
        this.talktoArchmage1 = new NpcStep((QuestHelper)this, 11433, new WorldPoint(3104, 9571, 0), "Bring the Abyssal Incantation to Sedridor in the Wizard Tower's basement.", this.abyssalIncantation);
        this.talktoArchmage1.addDialogStep("I need your help with an incantation.");
        this.finishTalkingToArchmage1 = new NpcStep((QuestHelper)this, 11433, new WorldPoint(3104, 9571, 0), "Finish listening to Sedridor.", new Requirement[0]);
        this.finishTalkingToArchmage1.addDialogSteps("I need your help with an incantation.", "Can you help me with that incantation?");
        this.talktoArchmage1.addSubSteps(this.teleportToArchmage, this.goDownToArchmage, this.finishTalkingToArchmage1);
        this.goUpToTraibornBasement = new ObjectStep((QuestHelper)this, 2148, new WorldPoint(3103, 9576, 0), "Speak to Wizard Traiborn on the Wizards' Tower 1st floor.", new Requirement[0]);
        this.goUpToTraiborn = new ObjectStep((QuestHelper)this, 12536, new WorldPoint(3103, 3159, 0), "Speak to Wizard Traiborn on the Wizards' Tower 1st floor.", new Requirement[0]);
        this.talktoTrailborn1 = new NpcStep((QuestHelper)this, 5081, new WorldPoint(3112, 3162, 1), "Speak to Wizard Traiborn on the Wizards' Tower 1st floor.", new Requirement[0]);
        this.talktoTrailborn1.addDialogStep("I need your apprentices to help with an incantation.");
        this.talktoTrailborn1.addSubSteps(this.goUpToTraibornBasement, this.goUpToTraiborn);
        this.talkToFelix = new NpcStep((QuestHelper)this, 11446, new WorldPoint(3112, 3162, 1), "Get puzzle from Apprentice Felix.", new Requirement[0]);
        this.talkToTamara = new NpcStep((QuestHelper)this, 11440, new WorldPoint(3112, 3162, 1), "Get puzzle from Apprentice Tamara.", new Requirement[0]);
        this.talkToCordelia = new NpcStep((QuestHelper)this, 11443, new WorldPoint(3112, 3162, 1), "Get puzzle from Apprentice Cordelia.", new Requirement[0]);
        this.talktoTrailborn2 = new NpcStep((QuestHelper)this, 5081, new WorldPoint(3112, 3162, 1), "Tell Wizard Traiborn the solution to his puzzle is: 11", new Requirement[0]);
        this.talktoTrailborn2.addDialogStep("I think I know what a thingummywut is!");
        this.goDownToArchmageFloorOne = new ObjectStep((QuestHelper)this, 12537, new WorldPoint(3103, 3159, 1), "Speak to Archmage Sedridor in the Wizard's Tower basement.", new Requirement[0]);
        this.goDownToArchmageFloorOne.addDialogStep("Down");
        this.goDownToArchmage2 = new ObjectStep((QuestHelper)this, 2147, new WorldPoint(3104, 3162, 0), "Speak to Archmage Sedridor in the Wizard's Tower basement.", new Requirement[0]);
        this.talktoArchmage2 = new NpcStep((QuestHelper)this, 11433, new WorldPoint(3104, 9571, 0), "Speak to Archmage Sedridor in the Wizard's Tower basement.", new Requirement[0]);
        this.talktoArchmage2.addSubSteps(this.goDownToArchmageFloorOne, this.goDownToArchmage2);
        this.performIncantation = new NpcStep((QuestHelper)this, 11433, new WorldPoint(3104, 9571, 0), "Speak to Archmage Sedridor to begin the incantation.", new Requirement[0]);
        this.performIncantation.addDialogStep("Let's do it.");
        this.performIncantation.addDialogStep("So we're ready to perform the incantation?");
        this.enterWizardBasement = new ObjectStep((QuestHelper)this, 2147, new WorldPoint(3104, 3162, 0), "Go to the Wizard's Tower basement.", new Requirement[0]);
        this.enterPortal = new ObjectStep((QuestHelper)this, 43765, new WorldPoint(3104, 9574, 0), "Enter the portal to the Temple of the Eye.", new Requirement[0]);
        this.templeCutscene1 = new DetailedQuestStep((QuestHelper)this, "Enter the Temple of the Eye.", new Requirement[0]);
        this.templeCutscene1.addSubSteps(this.enterPortal);
        this.talkToFelix2 = new NpcStep((QuestHelper)this, 11448, new WorldPoint(2401, 5643, 0), "Talk to Apprentice Felix.", new Requirement[0]);
        this.talkToTamara2 = new NpcStep((QuestHelper)this, 11442, new WorldPoint(2385, 5659, 0), "Talk to Apprentice Tamara.", new Requirement[0]);
        this.talkToCordelia2 = new NpcStep((QuestHelper)this, 11445, new WorldPoint(2397, 5677, 0), "Talk to Apprentice Cordelia.", new Requirement[0]);
        this.talkToPersten3 = new NpcStep((QuestHelper)this, 11439, new WorldPoint(2400, 5667, 0), "Speak with Wizard Persten.", new Requirement[0]);
        this.templeCutscene2 = new DetailedQuestStep((QuestHelper)this, "Experience the vision.", new Requirement[0]);
        this.debrief = new DetailedQuestStep((QuestHelper)this, "Debrief with Wizard Persten and the apprentices.", new Requirement[0]);
        this.guardiansTutorial = new DetailedQuestStep((QuestHelper)this, "Complete the Guardians of the Rift tutorial.", this.pickaxe, this.chisel);
        this.templeCutscene3 = new DetailedQuestStep((QuestHelper)this, "Listen to the Great Guardian.", new Requirement[0]);
        this.guardiansTutorial.addSubSteps(this.templeCutscene3);
        this.finishQuest = new NpcStep((QuestHelper)this, 11433, new WorldPoint(3104, 9571, 0), "Speak to Archmage Sedridor in the Wizard's Tower basement to finish the quest.", new Requirement[0]);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.bucketOfWater);
        reqs.add(this.chisel);
        reqs.add(this.pickaxe);
        return reqs;
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.varrockTeleport);
        reqs.add(this.alKharidTeleport);
        return reqs;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Collections.singletonList(new ItemReward("Medium pouch", 5510));
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Collections.singletonList(new ExperienceReward(Skill.RUNECRAFT, 9210));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Collections.singletonList(new UnlockReward("Access to the Guardians of the Rift minigame"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("An Eye for a Favour", Arrays.asList(this.talkToPersten1), Collections.emptyList(), Arrays.asList(this.varrockTeleport)));
        allSteps.add(new PanelDetails("Herbert and the Dark Mage", Arrays.asList(this.talkToMage1, this.getTeaForMage, this.talkToMage2, this.talkToDarkMage1, this.touchRunes, this.talkToDarkMage2), Arrays.asList(this.bucketOfWater, this.eyeAmulet), Arrays.asList(this.alKharidTeleport)));
        allSteps.add(new PanelDetails("Help from Some Wizards", Arrays.asList(this.talkToPersten2, this.talktoArchmage1, this.talktoTrailborn1, this.talkToFelix, this.talkToTamara, this.talkToCordelia, this.talktoTrailborn2), this.abyssalIncantation));
        allSteps.add(new PanelDetails("Enter the Gate", Arrays.asList(this.talktoArchmage2, this.performIncantation, this.templeCutscene1, this.talkToFelix2, this.talkToTamara2, this.talkToCordelia2, this.talkToPersten3, this.templeCutscene2, this.debrief), new Requirement[0]));
        allSteps.add(new PanelDetails("Guardians of the Rift", Arrays.asList(this.guardiansTutorial, this.finishQuest), this.pickaxe, this.chisel));
        return allSteps;
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new QuestRequirement(QuestHelperQuest.ENTER_THE_ABYSS, QuestState.FINISHED));
        req.add(new SkillRequirement(Skill.RUNECRAFT, 10));
        return req;
    }
}

