/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.templeofikov;

import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.conditional.NpcCondition;
import com.questhelper.requirements.conditional.ObjectCondition;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.item.ItemRequirements;
import com.questhelper.requirements.player.FreeInventorySlotRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.player.WeightRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.util.Operation;
import com.questhelper.requirements.widget.WidgetTextRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ItemStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.TEMPLE_OF_IKOV)
public class TempleOfIkov
extends BasicQuestHelper {
    ItemRequirement pendantOfLucien;
    ItemRequirement bootsOfLightness;
    ItemRequirement limpwurt20;
    ItemRequirement yewOrBetterBow;
    ItemRequirement knife;
    ItemRequirement lightSource;
    ItemRequirement lever;
    ItemRequirement iceArrows20;
    ItemRequirement iceArrows;
    ItemRequirement shinyKey;
    ItemRequirement armadylPendant;
    ItemRequirement staffOfArmadyl;
    ItemRequirement pendantOfLucienEquipped;
    ItemRequirement bootsOfLightnessEquipped;
    ItemRequirement iceArrowsEquipped;
    Requirement emptyInventorySpot;
    Requirement belowMinus1Weight;
    Requirement below4Weight;
    Requirement inEntryRoom;
    Requirement inNorthRoom;
    Requirement inBootsRoom;
    Requirement dontHaveBoots;
    Requirement inMainOrNorthRoom;
    Requirement leverNearby;
    Requirement pulledLever;
    Requirement inArrowRoom;
    Requirement hasEnoughArrows;
    Requirement lesNearby;
    Requirement inLesRoom;
    Requirement inWitchRoom;
    Requirement inDemonArea;
    Requirement inArmaRoom;
    QuestStep talkToLucien;
    QuestStep prepare;
    QuestStep prepareBelow0;
    QuestStep enterDungeonForBoots;
    QuestStep enterDungeon;
    QuestStep goDownToBoots;
    QuestStep getBoots;
    QuestStep goUpFromBoots;
    QuestStep pickUpLever;
    QuestStep useLeverOnHole;
    QuestStep pullLever;
    QuestStep enterArrowRoom;
    QuestStep returnToMainRoom;
    QuestStep goSearchThievingLever;
    QuestStep goPullThievingLever;
    QuestStep fightLes;
    QuestStep tryToEnterWitchRoom;
    QuestStep enterDungeonKilledLes;
    QuestStep enterLesDoor;
    QuestStep giveWineldaLimps;
    QuestStep talkToWinelda;
    QuestStep enterDungeonGivenLimps;
    QuestStep enterFromMcgrubbors;
    QuestStep pickUpKey;
    QuestStep pushWall;
    QuestStep makeChoice;
    QuestStep killLucien;
    QuestStep bringStaffToLucien;
    QuestStep returnToLucien;
    ObjectStep collectArrows;
    Zone entryRoom1;
    Zone entryRoom2;
    Zone northRoom1;
    Zone northRoom2;
    Zone bootsRoom;
    Zone arrowRoom1;
    Zone arrowRoom2;
    Zone arrowRoom3;
    Zone lesRoom;
    Zone witchRoom;
    Zone demonArea1;
    Zone demonArea2;
    Zone demonArea3;
    Zone demonArea4;
    Zone armaRoom1;
    Zone armaRoom2;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToLucien);
        ConditionalStep getLeverPiece = new ConditionalStep((QuestHelper)this, this.prepare, new Requirement[0]);
        getLeverPiece.addStep(new Conditions(this.iceArrows, this.inMainOrNorthRoom), this.goSearchThievingLever);
        getLeverPiece.addStep(new Conditions(this.hasEnoughArrows, this.inArrowRoom), this.returnToMainRoom);
        getLeverPiece.addStep(this.inArrowRoom, this.collectArrows);
        getLeverPiece.addStep(new Conditions(this.inMainOrNorthRoom, this.pulledLever), this.enterArrowRoom);
        getLeverPiece.addStep(this.leverNearby, this.pullLever);
        getLeverPiece.addStep(new Conditions(this.inMainOrNorthRoom, this.lever), this.useLeverOnHole);
        getLeverPiece.addStep(new Conditions(this.inBootsRoom, this.lever), this.goUpFromBoots);
        getLeverPiece.addStep(this.lever, this.enterDungeon);
        getLeverPiece.addStep(new Conditions(this.inMainOrNorthRoom, this.belowMinus1Weight), this.pickUpLever);
        getLeverPiece.addStep(new Conditions(this.inBootsRoom, new Conditions(LogicType.OR, this.belowMinus1Weight, this.bootsOfLightness)), this.goUpFromBoots);
        getLeverPiece.addStep(this.inBootsRoom, this.getBoots);
        getLeverPiece.addStep(new Conditions(this.inMainOrNorthRoom, this.below4Weight, this.dontHaveBoots), this.goDownToBoots);
        getLeverPiece.addStep(this.belowMinus1Weight, this.enterDungeon);
        getLeverPiece.addStep(new Conditions(this.below4Weight, this.bootsOfLightness), this.prepareBelow0);
        getLeverPiece.addStep(this.below4Weight, this.enterDungeonForBoots);
        steps.put(10, getLeverPiece);
        ConditionalStep pullLeverForLes = new ConditionalStep((QuestHelper)this, this.prepare, new Requirement[0]);
        pullLeverForLes.addStep(new Conditions(this.iceArrows, this.inMainOrNorthRoom), this.goPullThievingLever);
        pullLeverForLes.addStep(new Conditions(this.hasEnoughArrows, this.inArrowRoom), this.returnToMainRoom);
        pullLeverForLes.addStep(this.inArrowRoom, this.collectArrows);
        pullLeverForLes.addStep(this.leverNearby, this.pullLever);
        pullLeverForLes.addStep(new Conditions(this.inMainOrNorthRoom, this.lever), this.useLeverOnHole);
        pullLeverForLes.addStep(new Conditions(this.inBootsRoom, this.lever), this.goUpFromBoots);
        pullLeverForLes.addStep(this.lever, this.enterDungeon);
        pullLeverForLes.addStep(new Conditions(this.inMainOrNorthRoom, this.belowMinus1Weight), this.pickUpLever);
        pullLeverForLes.addStep(new Conditions(this.inBootsRoom, new Conditions(LogicType.OR, this.belowMinus1Weight, this.bootsOfLightness)), this.goUpFromBoots);
        pullLeverForLes.addStep(this.inBootsRoom, this.getBoots);
        pullLeverForLes.addStep(new Conditions(this.inMainOrNorthRoom, this.below4Weight, this.dontHaveBoots), this.goDownToBoots);
        pullLeverForLes.addStep(this.belowMinus1Weight, this.enterDungeon);
        pullLeverForLes.addStep(new Conditions(this.below4Weight, this.bootsOfLightness), this.prepareBelow0);
        pullLeverForLes.addStep(this.below4Weight, this.enterDungeonForBoots);
        steps.put(20, pullLeverForLes);
        ConditionalStep goFightLes = new ConditionalStep((QuestHelper)this, this.prepare, new Requirement[0]);
        goFightLes.addStep(new Conditions(this.inLesRoom, this.lesNearby), this.fightLes);
        goFightLes.addStep(new Conditions(this.iceArrows, this.inMainOrNorthRoom), this.tryToEnterWitchRoom);
        goFightLes.addStep(new Conditions(this.hasEnoughArrows, this.inArrowRoom), this.returnToMainRoom);
        goFightLes.addStep(this.inArrowRoom, this.collectArrows);
        goFightLes.addStep(this.leverNearby, this.pullLever);
        goFightLes.addStep(new Conditions(this.inMainOrNorthRoom, this.lever), this.useLeverOnHole);
        goFightLes.addStep(new Conditions(this.inBootsRoom, this.lever), this.goUpFromBoots);
        goFightLes.addStep(this.lever, this.enterDungeon);
        goFightLes.addStep(new Conditions(this.inMainOrNorthRoom, this.belowMinus1Weight), this.pickUpLever);
        goFightLes.addStep(new Conditions(this.inBootsRoom, new Conditions(LogicType.OR, this.belowMinus1Weight, this.bootsOfLightness)), this.goUpFromBoots);
        goFightLes.addStep(this.inBootsRoom, this.getBoots);
        goFightLes.addStep(new Conditions(this.inMainOrNorthRoom, this.below4Weight, this.dontHaveBoots), this.goDownToBoots);
        goFightLes.addStep(this.belowMinus1Weight, this.enterDungeon);
        goFightLes.addStep(new Conditions(this.below4Weight, this.bootsOfLightness), this.prepareBelow0);
        goFightLes.addStep(this.below4Weight, this.enterDungeonForBoots);
        steps.put(30, goFightLes);
        ConditionalStep goToWitch = new ConditionalStep((QuestHelper)this, this.enterDungeonKilledLes, new Requirement[0]);
        goToWitch.addStep(this.inWitchRoom, this.giveWineldaLimps);
        goToWitch.addStep(this.inMainOrNorthRoom, this.enterLesDoor);
        steps.put(40, goToWitch);
        steps.put(50, goToWitch);
        ConditionalStep goodOrBadPath = new ConditionalStep((QuestHelper)this, this.enterDungeonGivenLimps, new Requirement[0]);
        goodOrBadPath.addStep(this.staffOfArmadyl.alsoCheckBank(this.questBank), this.bringStaffToLucien);
        goodOrBadPath.addStep(new Conditions(this.inArmaRoom, this.shinyKey), this.makeChoice);
        goodOrBadPath.addStep(new Conditions(this.inDemonArea, this.shinyKey), this.pushWall);
        goodOrBadPath.addStep(new Conditions(LogicType.OR, this.inArmaRoom, this.inDemonArea), this.pickUpKey);
        goodOrBadPath.addStep(new Conditions(LogicType.OR, this.inMainOrNorthRoom, this.inWitchRoom), this.talkToWinelda);
        goodOrBadPath.addStep(this.shinyKey.alsoCheckBank(this.questBank), this.enterFromMcgrubbors);
        steps.put(60, goodOrBadPath);
        steps.put(70, this.killLucien);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.pendantOfLucien = new ItemRequirement("Pendant of lucien", 86).isNotConsumed();
        this.pendantOfLucien.canBeObtainedDuringQuest();
        this.pendantOfLucienEquipped = this.pendantOfLucien.equipped();
        this.bootsOfLightness = new ItemRequirement("Boots of lightness", 88).isNotConsumed();
        this.bootsOfLightnessEquipped = this.bootsOfLightness.equipped();
        this.limpwurt20 = new ItemRequirement("Limpwurt (unnoted)", 225, 20);
        this.yewOrBetterBow = new ItemRequirement("Yew, magic, or dark bow", 857).isNotConsumed();
        this.yewOrBetterBow.addAlternates(855, 10282, 861, 12788, 859, 11235);
        this.knife = new ItemRequirement("Knife to get the boots of lightness", 946).isNotConsumed();
        this.lightSource = new ItemRequirement("A light source to get the boots of lightness", ItemCollections.LIGHT_SOURCES).isNotConsumed();
        this.iceArrows20 = new ItemRequirement("Ice arrows", 78, 20);
        this.iceArrows = new ItemRequirement("Ice arrows", 78);
        this.iceArrowsEquipped = new ItemRequirement("Ice arrows", 78, 1, true);
        this.lever = new ItemRequirement("Lever", 83);
        this.lever.setHighlightInInventory(true);
        this.shinyKey = new ItemRequirement("Shiny key", 85);
        this.armadylPendant = new ItemRequirement("Armadyl pendant", 87, 1, true);
        this.armadylPendant.setHighlightInInventory(true);
        this.staffOfArmadyl = new ItemRequirement("Staff of Armadyl", 84);
        this.emptyInventorySpot = new FreeInventorySlotRequirement(1);
    }

    public void loadZones() {
        this.entryRoom1 = new Zone(new WorldPoint(2647, 9803, 0), new WorldPoint(2680, 9814, 0));
        this.entryRoom2 = new Zone(new WorldPoint(2670, 9801, 0), new WorldPoint(2680, 9804, 0));
        this.northRoom1 = new Zone(new WorldPoint(2634, 9815, 0), new WorldPoint(2674, 9857, 0));
        this.northRoom2 = new Zone(new WorldPoint(2634, 9804, 0), new WorldPoint(2647, 9815, 0));
        this.bootsRoom = new Zone(new WorldPoint(2637, 9759, 0), new WorldPoint(2654, 9767, 0));
        this.arrowRoom1 = new Zone(new WorldPoint(2657, 9785, 0), new WorldPoint(2692, 9800, 0));
        this.arrowRoom2 = new Zone(new WorldPoint(2657, 9799, 0), new WorldPoint(2666, 9802, 0));
        this.arrowRoom3 = new Zone(new WorldPoint(2682, 9799, 0), new WorldPoint(2749, 9852, 0));
        this.lesRoom = new Zone(new WorldPoint(2639, 9858, 0), new WorldPoint(2651, 9870, 0));
        this.witchRoom = new Zone(new WorldPoint(2642, 9871, 0), new WorldPoint(2659, 9879, 0));
        this.demonArea1 = new Zone(new WorldPoint(2625, 9856, 0), new WorldPoint(2638, 9893, 0));
        this.demonArea2 = new Zone(new WorldPoint(2639, 9880, 0), new WorldPoint(2664, 9892, 0));
        this.demonArea3 = new Zone(new WorldPoint(2654, 9893, 0), new WorldPoint(2661, 9896, 0));
        this.demonArea4 = new Zone(new WorldPoint(2659, 9871, 0), new WorldPoint(2665, 9879, 0));
        this.armaRoom1 = new Zone(new WorldPoint(2633, 9894, 0), new WorldPoint(2651, 9914, 0));
        this.armaRoom2 = new Zone(new WorldPoint(2642, 9893, 0), new WorldPoint(2645, 9893, 0));
    }

    public void setupConditions() {
        this.dontHaveBoots = new ItemRequirements(LogicType.NOR, this.bootsOfLightness);
        this.below4Weight = new WeightRequirement(4, Operation.LESS_EQUAL);
        this.belowMinus1Weight = new WeightRequirement(-1, Operation.LESS_EQUAL);
        this.inEntryRoom = new ZoneRequirement(this.entryRoom1, this.entryRoom2);
        this.inNorthRoom = new ZoneRequirement(this.northRoom1, this.northRoom2);
        this.inLesRoom = new ZoneRequirement(this.lesRoom);
        this.inBootsRoom = new ZoneRequirement(this.bootsRoom);
        this.inMainOrNorthRoom = new Conditions(LogicType.OR, this.inEntryRoom, this.inNorthRoom, this.inLesRoom);
        this.pulledLever = new Conditions(true, LogicType.OR, new WidgetTextRequirement(229, 1, "You hear the clunking of some hidden machinery."));
        this.leverNearby = new ObjectCondition(87, new WorldPoint(2671, 9804, 0));
        this.inArrowRoom = new ZoneRequirement(this.arrowRoom1, this.arrowRoom2, this.arrowRoom3);
        this.hasEnoughArrows = new Conditions(true, LogicType.OR, this.iceArrows20);
        this.lesNearby = new NpcCondition(3448);
        this.inWitchRoom = new ZoneRequirement(this.witchRoom);
        this.inDemonArea = new ZoneRequirement(this.demonArea1, this.demonArea2, this.demonArea3, this.demonArea4);
        this.inArmaRoom = new ZoneRequirement(this.armaRoom1, this.armaRoom2);
    }

    public void setupSteps() {
        this.talkToLucien = new NpcStep((QuestHelper)this, 3444, new WorldPoint(2573, 3321, 0), "Talk to Lucien in the pub north of East Ardougne castle.", this.emptyInventorySpot);
        this.talkToLucien.addDialogSteps("I'm a mighty hero!", "That sounds like a laugh!");
        this.prepare = new DetailedQuestStep((QuestHelper)this, "Get your weight below 0kg. You can get boots of lightness from the Temple of Ikov north of East Ardougne for -4.5kg.", this.pendantOfLucienEquipped, this.limpwurt20, this.yewOrBetterBow);
        this.prepareBelow0 = new DetailedQuestStep((QuestHelper)this, "Get your weight below 0kg.", this.pendantOfLucienEquipped, this.limpwurt20, this.yewOrBetterBow);
        this.prepare.addSubSteps(this.prepareBelow0);
        this.enterDungeonForBoots = new ObjectStep((QuestHelper)this, 17384, new WorldPoint(2677, 3405, 0), "Enter the Temple of Ikov. You can get Boots of Lightness inside to get -4.5kg.", this.pendantOfLucienEquipped, this.knife, this.lightSource, this.limpwurt20, this.yewOrBetterBow);
        this.enterDungeon = new ObjectStep((QuestHelper)this, 17384, new WorldPoint(2677, 3405, 0), "Enter the Temple of Ikov north of East Ardougne.", this.pendantOfLucienEquipped, this.yewOrBetterBow, this.limpwurt20);
        this.enterDungeon.addSubSteps(this.enterDungeonForBoots);
        this.goDownToBoots = new ObjectStep((QuestHelper)this, 98, new WorldPoint(2651, 9805, 0), "Go down the west stairs to get boots of lightness.", this.lightSource, this.knife);
        this.getBoots = new ItemStep((QuestHelper)this, "Get the boots of lightness in the north east corner.", this.bootsOfLightnessEquipped);
        this.goUpFromBoots = new ObjectStep((QuestHelper)this, 96, new WorldPoint(2639, 9764, 0), "Go back upstairs.", new Requirement[0]);
        this.pickUpLever = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2637, 9819, 0), "Cross the bridge in the north room and pick up the lever whilst weighing less than 0kg.", this.pendantOfLucien.equipped(), this.lever);
        this.useLeverOnHole = new ObjectStep((QuestHelper)this, 86, new WorldPoint(2671, 9804, 0), "Use the lever on the lever bracket in the entrance room.", this.lever);
        this.pullLever = new ObjectStep((QuestHelper)this, 87, new WorldPoint(2671, 9804, 0), "Pull the lever.", new Requirement[0]);
        this.enterArrowRoom = new ObjectStep((QuestHelper)this, 89, new WorldPoint(2662, 9803, 0), "Enter the south gate.", new Requirement[0]);
        this.collectArrows = new ObjectStep((QuestHelper)this, 103, "Search the chests in the ice area of this room until you have at least 20 Ice Arrows or more to be safe. A random chest has the arrows each time.", this.iceArrows20);
        this.collectArrows.setHideWorldArrow(true);
        this.collectArrows.addAlternateObjects(104);
        this.returnToMainRoom = new ObjectStep((QuestHelper)this, 89, new WorldPoint(2662, 9803, 0), "Return back to the entry room when you have enough arrows.", new Requirement[0]);
        this.goSearchThievingLever = new ObjectStep((QuestHelper)this, 91, new WorldPoint(2665, 9855, 0), "Go into the north room, then on the north side right-click search the lever there for traps, then pull it.", new Requirement[0]);
        this.goPullThievingLever = new ObjectStep((QuestHelper)this, 91, new WorldPoint(2665, 9855, 0), "Go into the north room, then on the north side pull the lever.", new Requirement[0]);
        this.goSearchThievingLever.addSubSteps(this.goPullThievingLever);
        this.tryToEnterWitchRoom = new ObjectStep((QuestHelper)this, 93, new WorldPoint(2646, 9870, 0), "Try to enter the far north door. Be prepared to fight Lesarkus, who can only be hurt by ice arrows.", this.yewOrBetterBow, this.iceArrowsEquipped);
        this.fightLes = new NpcStep((QuestHelper)this, 3448, new WorldPoint(2646, 9866, 0), "Kill the Fire Warrior of Lesarkus. He can only be hurt by the ice arrows.", this.yewOrBetterBow, this.iceArrowsEquipped);
        this.enterDungeonKilledLes = new ObjectStep((QuestHelper)this, 17384, new WorldPoint(2677, 3405, 0), "Enter the Temple of Ikov north of East Ardougne.", this.pendantOfLucienEquipped, this.limpwurt20);
        this.enterLesDoor = new ObjectStep((QuestHelper)this, 93, new WorldPoint(2646, 9870, 0), "Go all the way north and talk to Winelda there.", this.pendantOfLucienEquipped, this.limpwurt20);
        this.enterLesDoor.addSubSteps(this.enterDungeonKilledLes);
        this.giveWineldaLimps = new NpcStep((QuestHelper)this, 3447, new WorldPoint(2655, 9876, 0), "Give Winelda 20 unnoted limpwurts.", this.limpwurt20);
        this.enterDungeonGivenLimps = new ObjectStep((QuestHelper)this, 17384, new WorldPoint(2677, 3405, 0), "Enter the Temple of Ikov north of East Ardougne. If you got the shiny key, get it and enter via Mcgrubber's wood west of Seers' Village.", this.pendantOfLucienEquipped);
        this.enterFromMcgrubbors = new ObjectStep((QuestHelper)this, 17384, new WorldPoint(2659, 3492, 0), "Enter the house at Mcgrubbor's wood and go down the ladder.", this.shinyKey);
        this.talkToWinelda = new NpcStep((QuestHelper)this, 3447, new WorldPoint(2655, 9876, 0), "Talk to Winelda in the far north of the dungeon.", new Requirement[0]);
        this.pickUpKey = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2628, 9859, 0), "Follow the path around past the skeletons and lesser demons until you find a shiny key. Pick it up.", this.shinyKey);
        this.pushWall = new ObjectStep((QuestHelper)this, 1597, new WorldPoint(2643, 9892, 0), "Push the wall on the north side of this area.", new Requirement[0]);
        this.pushWall.addSubSteps(this.enterDungeonGivenLimps, this.enterFromMcgrubbors);
        this.makeChoice = new DetailedQuestStep((QuestHelper)this, "You can now choose to either help Lucien or help the Guardians of Armadyl. To help Lucien, simply pick up the Staff of Armadyl. To help the guardians, remove the pendant of lucien and talk to one of them.", new Requirement[0]);
        this.makeChoice.addDialogStep("I seek the Staff of Armadyl.");
        this.makeChoice.addDialogStep("Lucien will give me a grand reward for it!");
        this.makeChoice.addDialogStep("You're right, it's time for my yearly bath.");
        this.makeChoice.addDialogStep("Ok! I'll help!");
        this.killLucien = new NpcStep((QuestHelper)this, 3443, new WorldPoint(3122, 3484, 0), "Equip the Armadyl Pendant and kill Lucien in the house west of the Grand Exchange.", this.armadylPendant);
        this.bringStaffToLucien = new NpcStep((QuestHelper)this, 3443, new WorldPoint(3122, 3484, 0), "Bring the Staff of Armadyl to Lucien in the house west of the Grand Exchange.", this.staffOfArmadyl);
        this.bringStaffToLucien.addDialogSteps("Yes! Here it is.");
        this.returnToLucien = new DetailedQuestStep((QuestHelper)this, "Either return to Lucien west of the Grand Exchange with the Staff of Armadyl, or kill him whilst wearing the Pendant of Armadyl.", new Requirement[0]);
        this.returnToLucien.addSubSteps(this.killLucien, this.bringStaffToLucien);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.yewOrBetterBow);
        reqs.add(this.limpwurt20);
        reqs.add(this.knife);
        reqs.add(this.lightSource);
        return reqs;
    }

    @Override
    public List<String> getCombatRequirements() {
        ArrayList<String> reqs = new ArrayList<String>();
        reqs.add("Able to survive multiple aggressive spiders (level 61) and demons (level 82)");
        reqs.add("Fire Warrior of Lesarkus (level 84) with ranged");
        reqs.add("If siding with Lucien, Guardian of Armadyl (level 43)");
        return reqs;
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new SkillRequirement(Skill.THIEVING, 42, true));
        req.add(new SkillRequirement(Skill.RANGED, 40));
        return req;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Arrays.asList(new ExperienceReward(Skill.RANGED, 10500), new ExperienceReward(Skill.FLETCHING, 8000));
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Collections.singletonList(new ItemReward("Boots of Lightness", 88, 1));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting off", Collections.singletonList(this.talkToLucien), new Requirement[0]));
        allSteps.add(new PanelDetails("Defeat Lesarkus", Arrays.asList(this.prepare, this.enterDungeon, this.goDownToBoots, this.getBoots, this.goUpFromBoots, this.pickUpLever, this.useLeverOnHole, this.pullLever, this.enterArrowRoom, this.collectArrows, this.returnToMainRoom, this.goSearchThievingLever, this.tryToEnterWitchRoom, this.fightLes), this.pendantOfLucien, this.yewOrBetterBow, this.knife, this.lightSource, this.limpwurt20));
        allSteps.add(new PanelDetails("Explore deeper", Arrays.asList(this.enterLesDoor, this.giveWineldaLimps, this.pickUpKey, this.pushWall, this.makeChoice, this.returnToLucien), new Requirement[0]));
        return allSteps;
    }
}

