/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.tearsofguthix;

import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestPointRequirement;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.TEARS_OF_GUTHIX)
public class TearsOfGuthix
extends BasicQuestHelper {
    ItemRequirement litSapphireLantern;
    ItemRequirement chisel;
    ItemRequirement tinderbox;
    ItemRequirement pickaxe;
    ItemRequirement rope;
    ItemRequirement litSapphireLanternHighlighted;
    ItemRequirement ropeHighlighted;
    ItemRequirement tinderboxHighlighted;
    ItemRequirement pickaxeHighlighted;
    ItemRequirement chiselHighlighted;
    ItemRequirement rockHighlighted;
    ItemRequirement stoneBowl;
    Requirement inSwamp;
    Requirement inJunaRoom;
    Requirement atRocks;
    Requirement addedRope;
    QuestStep addRope;
    QuestStep enterSwamp;
    QuestStep enterJunaRoom;
    QuestStep talkToJuna;
    QuestStep useLanternOnLightCreature;
    QuestStep mineRock;
    QuestStep useChiselOnRock;
    QuestStep talkToJunaToFinish;
    Zone swamp;
    Zone junaRoom;
    Zone rocks;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        this.setupZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        ConditionalStep getToJunaRoom = new ConditionalStep((QuestHelper)this, this.addRope, new Requirement[0]);
        getToJunaRoom.addStep(this.inSwamp, this.enterJunaRoom);
        getToJunaRoom.addStep(this.addedRope, this.enterSwamp);
        ConditionalStep goTalkToJuna = new ConditionalStep((QuestHelper)this, (QuestStep)getToJunaRoom, new Requirement[0]);
        goTalkToJuna.addStep(this.inJunaRoom, this.talkToJuna);
        steps.put(0, goTalkToJuna);
        ConditionalStep goGetRock = new ConditionalStep((QuestHelper)this, (QuestStep)getToJunaRoom, new Requirement[0]);
        goGetRock.addStep(new Conditions(this.stoneBowl.alsoCheckBank(this.questBank), this.inJunaRoom), this.talkToJunaToFinish);
        goGetRock.addStep(this.rockHighlighted, this.useChiselOnRock);
        goGetRock.addStep(this.atRocks, this.mineRock);
        goGetRock.addStep(this.inJunaRoom, this.useLanternOnLightCreature);
        steps.put(1, goGetRock);
        return steps;
    }

    private void setupZones() {
        this.swamp = new Zone(new WorldPoint(3138, 9536, 0), new WorldPoint(3261, 9601, 0));
        this.junaRoom = new Zone(new WorldPoint(3205, 9484, 0), new WorldPoint(3263, 9537, 2));
        this.rocks = new Zone(new WorldPoint(3209, 9486, 2), new WorldPoint(3238, 9508, 2));
    }

    @Override
    public void setupRequirements() {
        this.litSapphireLantern = new ItemRequirement("Sapphire lantern", 4702).isNotConsumed();
        this.litSapphireLantern.setTooltip("You can make this by using a cut sapphire on a bullseye lantern");
        this.chisel = new ItemRequirement("Chisel", 1755).isNotConsumed();
        this.tinderbox = new ItemRequirement("Tinderbox", 590).isNotConsumed();
        this.pickaxe = new ItemRequirement("Any pickaxe", ItemCollections.PICKAXES).isNotConsumed();
        this.rope = new ItemRequirement("Rope", 954);
        this.litSapphireLanternHighlighted = new ItemRequirement("Sapphire lantern", 4702);
        this.litSapphireLanternHighlighted.setTooltip("You can make this by using a cut sapphire on a bullseye lantern");
        this.litSapphireLanternHighlighted.setHighlightInInventory(true);
        this.chiselHighlighted = new ItemRequirement("Chisel", 1755);
        this.chiselHighlighted.setHighlightInInventory(true);
        this.tinderboxHighlighted = new ItemRequirement("Tinderbox", 590);
        this.tinderboxHighlighted.setHighlightInInventory(true);
        this.pickaxeHighlighted = new ItemRequirement("Any pickaxe", ItemCollections.PICKAXES);
        this.pickaxeHighlighted.setHighlightInInventory(true);
        this.ropeHighlighted = new ItemRequirement("Rope", 954);
        this.ropeHighlighted.setHighlightInInventory(true);
        this.rockHighlighted = new ItemRequirement("Magic stone", 4703);
        this.rockHighlighted.setHighlightInInventory(true);
        this.stoneBowl = new ItemRequirement("Stone bowl", 4704);
    }

    private void setupConditions() {
        this.inSwamp = new ZoneRequirement(this.swamp);
        this.inJunaRoom = new ZoneRequirement(this.junaRoom);
        this.atRocks = new ZoneRequirement(this.rocks);
        this.addedRope = new VarbitRequirement(279, 1);
    }

    private void setupSteps() {
        this.addRope = new ObjectStep((QuestHelper)this, 5947, new WorldPoint(3169, 3172, 0), "Enter the hole to Lumbridge swamp.", this.ropeHighlighted, this.litSapphireLantern, this.chisel, this.pickaxe, this.tinderbox);
        this.addRope.addIcon(954);
        this.enterSwamp = new ObjectStep((QuestHelper)this, 5947, new WorldPoint(3169, 3172, 0), "Enter the hole to Lumbridge swamp.", this.litSapphireLantern, this.chisel, this.pickaxe, this.tinderbox);
        this.enterSwamp.addSubSteps(this.addRope);
        this.enterJunaRoom = new ObjectStep((QuestHelper)this, 6659, new WorldPoint(3226, 9540, 0), "Enter the cave in the south east corner of the swamp.", new Requirement[0]);
        this.talkToJuna = new ObjectStep((QuestHelper)this, 3193, new WorldPoint(3252, 9517, 2), "Talk to Juna.", new Requirement[0]);
        this.talkToJuna.addDialogStep("Okay...");
        this.useLanternOnLightCreature = new NpcStep((QuestHelper)this, 5783, new WorldPoint(3228, 9518, 2), "Go back up the rocks and use the lit sapphire lantern on one of the light creatures nearby.", this.litSapphireLanternHighlighted);
        this.mineRock = new ObjectStep((QuestHelper)this, 6670, new WorldPoint(3229, 9497, 2), "Mine one of the rocks.", this.pickaxe);
        this.useChiselOnRock = new DetailedQuestStep((QuestHelper)this, "Use a chisel on the magic stone.", this.chiselHighlighted, this.rockHighlighted);
        this.talkToJunaToFinish = new ObjectStep((QuestHelper)this, 3193, new WorldPoint(3252, 9517, 2), "Talk to Juna to complete the quest.", new Requirement[0]);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.rope, this.litSapphireLantern, this.tinderbox, this.chisel, this.pickaxe);
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new QuestPointRequirement(43));
        req.add(new SkillRequirement(Skill.FIREMAKING, 49, true));
        req.add(new SkillRequirement(Skill.CRAFTING, 20));
        req.add(new SkillRequirement(Skill.MINING, 20));
        return req;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Collections.singletonList(new ExperienceReward(Skill.CRAFTING, 1000));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Collections.singletonList(new UnlockReward("Access to Tears of Guthix"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Making a bowl", Arrays.asList(this.enterSwamp, this.enterJunaRoom, this.talkToJuna, this.useLanternOnLightCreature, this.mineRock, this.useChiselOnRock, this.talkToJunaToFinish), this.rope, this.litSapphireLantern, this.tinderbox, this.chisel, this.pickaxe));
        return allSteps;
    }
}

