/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.taleoftherighteous;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.conditional.NpcCondition;
import com.questhelper.requirements.conditional.ObjectCondition;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.Favour;
import com.questhelper.requirements.player.FavourRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.TALE_OF_THE_RIGHTEOUS)
public class TaleOfTheRighteous
extends BasicQuestHelper {
    ItemRequirement pickaxe;
    ItemRequirement rangedWeapon;
    ItemRequirement runesForCombat;
    ItemRequirement rope;
    ItemRequirement combatGear;
    ItemRequirement meleeWeapon;
    ItemRequirement antiPoison;
    ItemRequirement xericTalisman;
    Requirement inArchive;
    Requirement inPuzzleRoom;
    Requirement strangeObjectEast;
    Requirement strangeObjectWest;
    Requirement isSouthWestWhite;
    Requirement isSouthEastWhite;
    Requirement isNorthWestWhite;
    Requirement isNorthEastWhite;
    Requirement inShiroRoom;
    Requirement inCavern;
    Requirement rockfallNearby;
    Requirement boulderBlockingPath;
    Requirement corruptLizardmanNearby;
    QuestStep talkToPhileas;
    QuestStep teleportToArchive;
    QuestStep talkToPagida;
    QuestStep pushStrangeDeviceWest;
    QuestStep attackWithMagic;
    QuestStep attackWithMelee;
    QuestStep pushStrangeDeviceEast;
    QuestStep attackWithRanged;
    QuestStep investigateSkeleton;
    QuestStep talkToPhileasAgain;
    QuestStep goUpToShiro;
    QuestStep talkToShiro;
    QuestStep talkToDuffy;
    QuestStep useRopeOnCrevice;
    QuestStep enterCrevice;
    QuestStep mineRockfall;
    QuestStep pushBoulder;
    QuestStep tryToEnterBarrier;
    QuestStep killLizardman;
    QuestStep inspectUnstableAltar;
    QuestStep leaveCave;
    QuestStep returnToDuffy;
    QuestStep enterCreviceAgain;
    QuestStep talkToDuffyInCrevice;
    QuestStep talkToGnosi;
    QuestStep returnUpToShiro;
    QuestStep returnToShiro;
    QuestStep returnToPhileasTent;
    QuestStep goUpToShrioToFinish;
    QuestStep finishQuest;
    Zone archive;
    Zone puzzleRoom;
    Zone shiroRoom;
    Zone cavern;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToPhileas);
        ConditionalStep travelToPuzzle = new ConditionalStep((QuestHelper)this, this.teleportToArchive, new Requirement[0]);
        travelToPuzzle.addStep(new Conditions(this.inPuzzleRoom, this.strangeObjectEast, this.isSouthWestWhite, this.isNorthWestWhite), this.attackWithRanged);
        travelToPuzzle.addStep(new Conditions(this.inPuzzleRoom, this.isSouthWestWhite, this.isNorthWestWhite), this.pushStrangeDeviceEast);
        travelToPuzzle.addStep(new Conditions(this.inPuzzleRoom, this.strangeObjectWest, this.isSouthWestWhite), this.attackWithMelee);
        travelToPuzzle.addStep(new Conditions(this.inPuzzleRoom, this.strangeObjectWest), this.attackWithMagic);
        travelToPuzzle.addStep(this.inPuzzleRoom, this.pushStrangeDeviceWest);
        travelToPuzzle.addStep(this.inArchive, this.talkToPagida);
        steps.put(1, travelToPuzzle);
        steps.put(2, travelToPuzzle);
        steps.put(3, travelToPuzzle);
        ConditionalStep getSkeletonItem = new ConditionalStep((QuestHelper)this, this.teleportToArchive, new Requirement[0]);
        getSkeletonItem.addStep(this.inPuzzleRoom, this.investigateSkeleton);
        getSkeletonItem.addStep(this.inArchive, this.talkToPagida);
        steps.put(4, getSkeletonItem);
        steps.put(5, this.talkToPhileasAgain);
        ConditionalStep reportToShiro = new ConditionalStep((QuestHelper)this, this.goUpToShiro, new Requirement[0]);
        reportToShiro.addStep(this.inShiroRoom, this.talkToShiro);
        steps.put(6, reportToShiro);
        steps.put(7, this.talkToDuffy);
        steps.put(8, this.useRopeOnCrevice);
        ConditionalStep goIntoCavern = new ConditionalStep((QuestHelper)this, this.enterCrevice, new Requirement[0]);
        goIntoCavern.addStep(this.corruptLizardmanNearby, this.killLizardman);
        goIntoCavern.addStep(new Conditions(this.inCavern, this.rockfallNearby), this.mineRockfall);
        goIntoCavern.addStep(new Conditions(this.inCavern, this.boulderBlockingPath), this.pushBoulder);
        goIntoCavern.addStep(this.inCavern, this.tryToEnterBarrier);
        steps.put(9, goIntoCavern);
        ConditionalStep investigateAltar = new ConditionalStep((QuestHelper)this, this.enterCrevice, new Requirement[0]);
        investigateAltar.addStep(this.inCavern, this.inspectUnstableAltar);
        steps.put(10, investigateAltar);
        ConditionalStep returnToSurface = new ConditionalStep((QuestHelper)this, this.returnToDuffy, new Requirement[0]);
        returnToSurface.addStep(this.inCavern, this.leaveCave);
        steps.put(11, returnToSurface);
        ConditionalStep enterCaveAgain = new ConditionalStep((QuestHelper)this, this.enterCreviceAgain, new Requirement[0]);
        enterCaveAgain.addStep(this.inCavern, this.talkToDuffyInCrevice);
        steps.put(12, enterCaveAgain);
        ConditionalStep talkWithGnosi = new ConditionalStep((QuestHelper)this, this.enterCreviceAgain, new Requirement[0]);
        talkWithGnosi.addStep(this.inCavern, this.talkToGnosi);
        steps.put(13, talkWithGnosi);
        ConditionalStep reportBackToShiro = new ConditionalStep((QuestHelper)this, this.returnUpToShiro, new Requirement[0]);
        reportBackToShiro.addStep(this.inShiroRoom, this.returnToShiro);
        steps.put(14, reportBackToShiro);
        steps.put(15, this.returnToPhileasTent);
        ConditionalStep finishOffTheQuest = new ConditionalStep((QuestHelper)this, this.goUpToShrioToFinish, new Requirement[0]);
        finishOffTheQuest.addStep(this.inShiroRoom, this.finishQuest);
        steps.put(16, finishOffTheQuest);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.pickaxe = new ItemRequirement("A pickaxe", ItemCollections.PICKAXES).isNotConsumed();
        this.rangedWeapon = new ItemRequirement("Any ranged weapon + ammo", -1, -1).isNotConsumed();
        this.rangedWeapon.setDisplayItemId(BankSlotIcons.getRangedCombatGear());
        this.runesForCombat = new ItemRequirement("Runes for a few casts of a combat spell", -1, -1);
        this.runesForCombat.setDisplayItemId(560);
        this.rope = new ItemRequirement("Rope", 954).isNotConsumed();
        this.combatGear = new ItemRequirement("Combat gear for a level 46 corrupt lizardman", -1, -1).isNotConsumed();
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.xericTalisman = new ItemRequirement("Xeric's Talisman", 13393).isNotConsumed();
        this.meleeWeapon = new ItemRequirement("A melee weapon, or your bare hands", -1, -1).isNotConsumed();
        this.meleeWeapon.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.antiPoison = new ItemRequirement("Antipoison for lizardmen", ItemCollections.ANTIPOISONS);
    }

    public void loadZones() {
        this.archive = new Zone(new WorldPoint(1538, 10210, 0), new WorldPoint(1565, 10237, 0));
        this.puzzleRoom = new Zone(new WorldPoint(1563, 10186, 0), new WorldPoint(1591, 10213, 0));
        this.shiroRoom = new Zone(new WorldPoint(1480, 3640, 1), new WorldPoint(1489, 3631, 1));
        this.cavern = new Zone(new WorldPoint(1157, 9928, 0), new WorldPoint(1205, 9977, 0));
    }

    public void setupConditions() {
        this.inArchive = new ZoneRequirement(this.archive);
        this.inPuzzleRoom = new ZoneRequirement(this.puzzleRoom);
        this.inShiroRoom = new ZoneRequirement(this.shiroRoom);
        this.inCavern = new ZoneRequirement(this.cavern);
        this.strangeObjectEast = new NpcCondition(7598, new WorldPoint(1581, 10200, 0));
        this.strangeObjectWest = new NpcCondition(7598, new WorldPoint(1575, 10200, 0));
        this.isSouthWestWhite = new ObjectCondition(31960, new WorldPoint(1574, 10196, 0));
        this.isSouthEastWhite = new ObjectCondition(31960, new WorldPoint(1581, 10196, 0));
        this.isNorthWestWhite = new ObjectCondition(31960, new WorldPoint(1574, 10203, 0));
        this.isNorthEastWhite = new ObjectCondition(31960, new WorldPoint(1581, 10203, 0));
        this.rockfallNearby = new ObjectCondition(32503, new WorldPoint(1182, 9974, 0));
        this.boulderBlockingPath = new ObjectCondition(32504, new WorldPoint(1201, 9960, 0));
        this.corruptLizardmanNearby = new NpcCondition(8000);
    }

    public void setupSteps() {
        this.talkToPhileas = new NpcStep((QuestHelper)this, 7999, new WorldPoint(1542, 3570, 0), "Talk to Phileas Rimor in Shayzien.", new Requirement[0]);
        this.talkToPhileas.addDialogStep("Do you need help with anything?");
        this.talkToPhileas.addDialogStep("Yes.");
        this.talkToPhileas.addDialogStep("What do you need?");
        this.teleportToArchive = new NpcStep((QuestHelper)this, 7614, new WorldPoint(1625, 3808, 0), "Bring a melee weapon, ranged weapon, and runes for magic attacks and teleport with Archeio in the Arceuus Library.", this.rangedWeapon, this.runesForCombat);
        this.teleportToArchive.addDialogStep("Yes please!");
        this.talkToPagida = new NpcStep((QuestHelper)this, 7608, new WorldPoint(1553, 10223, 0), "Talk to Pagida in the Library Historical Archive.", new Requirement[0]);
        this.talkToPagida.addDialogStep("I have a question about King Shayzien VII.");
        this.talkToPagida.addDialogStep("Yes please.");
        this.pushStrangeDeviceWest = new NpcStep((QuestHelper)this, 7598, new WorldPoint(1580, 10199, 0), "Push the Strange Device all the way to the west.", new Requirement[0]);
        this.pushStrangeDeviceEast = new NpcStep((QuestHelper)this, 7598, new WorldPoint(1580, 10199, 0), "Push the Strange Device all the way to the east.", new Requirement[0]);
        this.attackWithMagic = new NpcStep((QuestHelper)this, 7598, new WorldPoint(1580, 10199, 0), "Attack the Strange Device with magic from the north side.", this.runesForCombat);
        this.attackWithMagic.addIcon(558);
        this.attackWithRanged = new NpcStep((QuestHelper)this, 7598, new WorldPoint(1580, 10199, 0), "Attack the Strange Device with ranged from the south side.", this.rangedWeapon);
        this.attackWithRanged.addIcon(882);
        this.attackWithMelee = new NpcStep((QuestHelper)this, 7598, new WorldPoint(1580, 10199, 0), "Attack the Strange Device with melee from the south side.", this.meleeWeapon);
        this.attackWithMelee.addIcon(1277);
        this.investigateSkeleton = new ObjectStep((QuestHelper)this, 31962, new WorldPoint(1577, 10213, 0), "Investigate the skeleton in the north cell.", new Requirement[0]);
        this.talkToPhileasAgain = new NpcStep((QuestHelper)this, 7999, new WorldPoint(1542, 3570, 0), "Report back to Phileas Rimor in Shayzien.", new Requirement[0]);
        this.goUpToShiro = new ObjectStep((QuestHelper)this, 42207, new WorldPoint(1481, 3633, 0), "Talk to Shiro upstairs in the War Tent located on the west side of the Shayzien Encampment.", new Requirement[0]);
        this.talkToShiro = new NpcStep((QuestHelper)this, 11038, new WorldPoint(1484, 3634, 1), "Talk to Shiro upstairs in the War Tent located on the west side of the Shayzien Encampment.", new Requirement[0]);
        this.talkToShiro.addSubSteps(this.goUpToShiro);
        this.talkToDuffy = new NpcStep((QuestHelper)this, 8163, new WorldPoint(1278, 3561, 0), "Travel to Mount Quidamortem and talk to Historian Duffy.", new Requirement[0]);
        this.useRopeOnCrevice = new ObjectStep((QuestHelper)this, 32502, new WorldPoint(1215, 3559, 0), "Use a rope on the crevice west side of Quidamortem.", this.rope, this.pickaxe, this.combatGear);
        this.useRopeOnCrevice.addIcon(954);
        this.enterCrevice = new ObjectStep((QuestHelper)this, 32502, new WorldPoint(1215, 3559, 0), "Enter the crevice west side of Quidamortem, ready to fight a corrupted lizardman (level 46).", this.pickaxe, this.combatGear);
        this.enterCrevice.addDialogStep("Yes.");
        this.mineRockfall = new ObjectStep((QuestHelper)this, 32503, new WorldPoint(1182, 9974, 0), "Mine the rockfall.", this.pickaxe);
        this.pushBoulder = new ObjectStep((QuestHelper)this, 32504, new WorldPoint(1201, 9960, 0), "Push the boulder further along the path.", new Requirement[0]);
        this.tryToEnterBarrier = new ObjectStep((QuestHelper)this, 32507, new WorldPoint(1172, 9947, 0), "Attempt to enter the magic gate to the south room. You will need to kill the corrupted lizardman who appears.", new Requirement[0]);
        this.killLizardman = new NpcStep((QuestHelper)this, 8000, new WorldPoint(1172, 9947, 0), "Kill the corrupt lizardman.", new Requirement[0]);
        this.tryToEnterBarrier.addSubSteps(this.killLizardman);
        this.inspectUnstableAltar = new ObjectStep((QuestHelper)this, 32508, new WorldPoint(1172, 9929, 0), "Inspect the Unstable Altar in the south room.", new Requirement[0]);
        this.leaveCave = new ObjectStep((QuestHelper)this, 31967, new WorldPoint(1168, 9973, 0), "Leave the cavern. You can hop worlds to appear back at the entrance.", new Requirement[0]);
        this.returnToDuffy = new NpcStep((QuestHelper)this, 8163, new WorldPoint(1278, 3561, 0), "Return to Historian Duffy.", new Requirement[0]);
        this.enterCreviceAgain = new ObjectStep((QuestHelper)this, 32502, new WorldPoint(1215, 3559, 0), "Enter the crevice west side of Quidamortem again.", new Requirement[0]);
        this.enterCreviceAgain.addDialogStep("Yes.");
        this.talkToDuffyInCrevice = new NpcStep((QuestHelper)this, 8007, new WorldPoint(1172, 9929, 0), "Talk to Historian Duffy near the Unstable Altar.", new Requirement[0]);
        this.talkToGnosi = new NpcStep((QuestHelper)this, 8006, new WorldPoint(1172, 9929, 0), "Talk to Gnosi near the Unstable Altar.", new Requirement[0]);
        this.returnUpToShiro = new ObjectStep((QuestHelper)this, 42207, new WorldPoint(1481, 3633, 0), "Return to Shiro upstairs in the War Tent located on the west side of the Shayzien Encampment.", new Requirement[0]);
        this.returnToShiro = new NpcStep((QuestHelper)this, 11038, new WorldPoint(1484, 3634, 1), "Return to Shiro upstairs in the War Tent located on the west side of the Shayzien Encampment.", new Requirement[0]);
        this.returnToShiro.addSubSteps(this.returnUpToShiro);
        this.returnToPhileasTent = new DetailedQuestStep((QuestHelper)this, new WorldPoint(1542, 3570, 0), "Return to Phileas Rimor's house in Shayzien.", new Requirement[0]);
        this.goUpToShrioToFinish = new ObjectStep((QuestHelper)this, 42207, new WorldPoint(1481, 3633, 0), "Return to Shiro upstairs in the War Tent in west Shayzien to complete the quest.", new Requirement[0]);
        this.finishQuest = new NpcStep((QuestHelper)this, 11038, new WorldPoint(1484, 3634, 1), "Return to Shiro upstairs in the War Tent in west Shayzien to complete the quest.", new Requirement[0]);
        this.finishQuest.addSubSteps(this.goUpToShrioToFinish);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.pickaxe);
        reqs.add(this.runesForCombat);
        reqs.add(this.rangedWeapon);
        reqs.add(this.rope);
        return reqs;
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.xericTalisman);
        reqs.add(this.antiPoison);
        return reqs;
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new QuestRequirement(QuestHelperQuest.X_MARKS_THE_SPOT, QuestState.FINISHED));
        req.add(new QuestRequirement(QuestHelperQuest.CLIENT_OF_KOUREND, QuestState.FINISHED));
        req.add(new FavourRequirement(Favour.SHAYZIEN, 20));
        req.add(new SkillRequirement(Skill.STRENGTH, 16));
        req.add(new SkillRequirement(Skill.MINING, 10));
        return req;
    }

    @Override
    public List<String> getCombatRequirements() {
        ArrayList<String> reqs = new ArrayList<String>();
        reqs.add("Corrupt Lizardman (level 46)");
        return reqs;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Arrays.asList(new ItemReward("Coins", 995, 8000), new ItemReward("Shayzien Favour Certificate", 22365, 1), new ItemReward("A Memoir Page", 21760, 1));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting off", Collections.singletonList(this.talkToPhileas), new Requirement[0]));
        allSteps.add(new PanelDetails("Discovery", Arrays.asList(this.teleportToArchive, this.talkToPagida, this.pushStrangeDeviceWest, this.attackWithMagic, this.attackWithMelee, this.pushStrangeDeviceEast, this.attackWithRanged, this.investigateSkeleton, this.talkToPhileasAgain, this.talkToShiro), this.rangedWeapon, this.runesForCombat));
        allSteps.add(new PanelDetails("Investigate Quidamortem", Arrays.asList(this.talkToDuffy, this.useRopeOnCrevice, this.enterCrevice, this.mineRockfall, this.pushBoulder, this.tryToEnterBarrier, this.inspectUnstableAltar, this.returnToDuffy, this.enterCreviceAgain, this.talkToDuffyInCrevice, this.talkToGnosi), this.rope, this.pickaxe, this.combatGear));
        allSteps.add(new PanelDetails("Finishing off", Arrays.asList(this.returnToShiro, this.returnToPhileasTent, this.finishQuest), new Requirement[0]));
        return allSteps;
    }
}

