/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.swansong;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.helpers.quests.swansong.FishMonkfish;
import com.questhelper.helpers.quests.swansong.FixWall;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questhelpers.QuestUtil;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.conditional.NpcCondition;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestPointRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.Operation;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.SWAN_SONG)
public class SwanSong
extends BasicQuestHelper {
    ItemRequirement mist10;
    ItemRequirement lava10;
    ItemRequirement blood5;
    ItemRequirement bones7;
    ItemRequirement pot;
    ItemRequirement potLid;
    ItemRequirement ironBar5;
    ItemRequirement log;
    ItemRequirement tinderbox;
    ItemRequirement hammer;
    ItemRequirement brownApron;
    ItemRequirement monkfish5;
    ItemRequirement rawMonkfish5;
    ItemRequirement combatGear;
    ItemRequirement potHiglight;
    ItemRequirement potLidHiglight;
    ItemRequirement tinderboxHiglight;
    ItemRequirement ironBar5Higlight;
    ItemRequirement logHiglight;
    ItemRequirement ironSheet5;
    ItemRequirement smallNet;
    ItemRequirement airtightPot;
    ItemRequirement combatGearRanged;
    ItemRequirement boneSeeds;
    ItemRequirement hammerPanel;
    ItemRequirement draynorTeleport;
    ItemRequirement piscTeleport;
    ItemRequirement yanilleTeleport;
    ItemRequirement craftingGuildTeleport;
    ItemRequirement cookingGauntlets;
    Requirement inColonyEntrance;
    Requirement talkedToFranklin;
    Requirement addedLog;
    Requirement litLog;
    Requirement wall1Fixed;
    Requirement wall2Fixed;
    Requirement wall3Fixed;
    Requirement wall4Fixed;
    Requirement wall5Fixed;
    Requirement wallsFixed;
    Requirement talkedToArnold;
    Requirement finishedFranklin;
    Requirement inBasement;
    Requirement queenNearby;
    DetailedQuestStep talkToHerman;
    DetailedQuestStep talkToWom;
    DetailedQuestStep talkToWomAtColony;
    DetailedQuestStep kill79Trolls;
    DetailedQuestStep talkToHermanInBuilding;
    DetailedQuestStep talkToFranklin;
    DetailedQuestStep enterColony;
    DetailedQuestStep useLog;
    DetailedQuestStep useTinderbox;
    DetailedQuestStep talkToArnold;
    DetailedQuestStep talkToFranklinAgain;
    DetailedQuestStep talkToHermanAfterTasks;
    DetailedQuestStep enterWizardsBasement;
    DetailedQuestStep talkToFruscone;
    DetailedQuestStep talkToMalignius;
    DetailedQuestStep talkToCrafter;
    DetailedQuestStep makeAirtightPot;
    DetailedQuestStep talkToMaligniusWithPot;
    DetailedQuestStep talkToHermanForFinalFight;
    DetailedQuestStep killQueen;
    DetailedQuestStep talkToHermanToFinish;
    DetailedQuestStep talkToHermanWithPot;
    FixWall repairWall;
    FishMonkfish fishAndCookMonkfish;
    Zone colonyEntrance;
    Zone basement;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToHerman);
        steps.put(5, this.talkToHerman);
        steps.put(10, this.talkToWom);
        steps.put(15, this.talkToWom);
        steps.put(20, this.talkToWom);
        steps.put(30, this.talkToWomAtColony);
        steps.put(40, this.talkToWomAtColony);
        ConditionalStep defeatTrolls = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterColony, new Requirement[0]);
        defeatTrolls.addStep(this.inColonyEntrance, this.kill79Trolls);
        steps.put(50, defeatTrolls);
        steps.put(55, this.talkToHermanInBuilding);
        steps.put(60, this.talkToHermanInBuilding);
        steps.put(65, this.talkToHermanInBuilding);
        ConditionalStep completeTasks = new ConditionalStep((QuestHelper)this, (QuestStep)this.talkToFranklin, new Requirement[0]);
        completeTasks.addStep(new Conditions(this.talkedToArnold, this.finishedFranklin), this.fishAndCookMonkfish);
        completeTasks.addStep(this.finishedFranklin, this.talkToArnold);
        completeTasks.addStep(this.wallsFixed, this.talkToFranklinAgain);
        completeTasks.addStep(this.litLog, this.repairWall);
        completeTasks.addStep(this.addedLog, this.useTinderbox);
        completeTasks.addStep(this.talkedToFranklin, this.useLog);
        steps.put(70, completeTasks);
        steps.put(80, this.talkToHermanAfterTasks);
        ConditionalStep goTalkToFru = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterWizardsBasement, new Requirement[0]);
        goTalkToFru.addStep(this.inBasement, this.talkToFruscone);
        steps.put(90, goTalkToFru);
        steps.put(95, goTalkToFru);
        steps.put(100, this.talkToMalignius);
        steps.put(110, this.talkToMalignius);
        steps.put(120, this.talkToCrafter);
        ConditionalStep getPotToMal = new ConditionalStep((QuestHelper)this, (QuestStep)this.makeAirtightPot, new Requirement[0]);
        getPotToMal.addStep(this.airtightPot, this.talkToMaligniusWithPot);
        steps.put(130, getPotToMal);
        steps.put(140, this.talkToHermanWithPot);
        ConditionalStep bossFight = new ConditionalStep((QuestHelper)this, (QuestStep)this.talkToHermanForFinalFight, new Requirement[0]);
        bossFight.addStep(this.queenNearby, this.killQueen);
        steps.put(150, this.talkToHermanForFinalFight);
        steps.put(160, this.talkToHermanForFinalFight);
        steps.put(170, this.killQueen);
        steps.put(180, this.talkToHermanToFinish);
        steps.put(190, this.talkToHermanToFinish);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.mist10 = new ItemRequirement("Mist rune", 4695, 10);
        this.lava10 = new ItemRequirement("Lava rune", 4699, 10);
        this.blood5 = new ItemRequirement("Blood rune", 565, 5);
        this.bones7 = new ItemRequirement("Bones", 526, 7);
        this.bones7.setTooltip("Obtainable during the quest, just pick up bones when killing the sea trolls.");
        this.pot = new ItemRequirement("Pot", 1931);
        this.potLid = new ItemRequirement("Pot lid", 4440);
        this.airtightPot = new ItemRequirement("Airtight pot", 4436);
        this.ironBar5 = new ItemRequirement("Iron bar", 2351, 5);
        this.log = new ItemRequirement("Any log", 1511);
        this.log.addAlternates(1521, 1519, 1517, 1515, 1513, 6333, 6332, 19669);
        this.tinderbox = new ItemRequirement("Tinderbox", 590).isNotConsumed();
        this.potHiglight = new ItemRequirement("Pot", 1931);
        this.potHiglight.setHighlightInInventory(true);
        this.potLidHiglight = new ItemRequirement("Pot lid", 4440);
        this.potLidHiglight.setTooltip("You can make one from wet clay on a potter's wheel");
        this.potLidHiglight.setHighlightInInventory(true);
        this.ironBar5Higlight = new ItemRequirement("Iron bar", 2351, 5);
        this.ironBar5Higlight.setHighlightInInventory(true);
        this.logHiglight = new ItemRequirement("Any log", 1511);
        this.logHiglight.addAlternates(1521, 1519, 1517, 1515, 1513, 6333, 6332, 19669);
        this.logHiglight.setHighlightInInventory(true);
        this.tinderboxHiglight = this.tinderbox.highlighted();
        this.draynorTeleport = new ItemRequirement("Teleport to Draynor Village", ItemCollections.AMULET_OF_GLORIES);
        this.piscTeleport = new ItemRequirement("Piscatoris teleport", 12408);
        this.yanilleTeleport = new ItemRequirement("Yanille teleport or Nightmare Zone minigame teleport", 8012);
        this.craftingGuildTeleport = new ItemRequirement("Crafting Guild teleport", ItemCollections.SKILLS_NECKLACES);
        this.cookingGauntlets = new ItemRequirement("Cooking gauntlets for lower burn chance on monkfish", 775);
        this.smallNet = new ItemRequirement("Small fishing net", 303).isNotConsumed();
        this.smallNet.setTooltip("You can get one from Arnold");
        this.hammerPanel = new ItemRequirement("Hammer (obtainable in quest)", ItemCollections.HAMMER).isNotConsumed();
        this.hammer = new ItemRequirement("Hammer", ItemCollections.HAMMER).isNotConsumed();
        this.hammer.setTooltip("Franklin will give you one");
        this.brownApron = new ItemRequirement("Brown apron", 1757, 1, true).isNotConsumed();
        this.brownApron.setHighlightInInventory(true);
        this.brownApron.setTooltip("Malignius will give you one");
        this.monkfish5 = new ItemRequirement("Fresh monkfish", 7943, 5);
        this.rawMonkfish5 = new ItemRequirement("Fresh monkfish", 7942, 5);
        this.combatGear = new ItemRequirement("Combat gear", -1, -1).isNotConsumed();
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.combatGearRanged = new ItemRequirement("Ranged or melee combat gear", -1, -1).isNotConsumed();
        this.combatGearRanged.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.ironSheet5 = new ItemRequirement("Iron sheet", 7941, 5);
        this.boneSeeds = new ItemRequirement("Bone seed", 7950);
        this.boneSeeds.setTooltip("You can get more by bringing Malignius another airtight pot");
    }

    public void loadZones() {
        this.colonyEntrance = new Zone(new WorldPoint(2338, 3653, 0), new WorldPoint(2349, 3662, 0));
        this.basement = new Zone(new WorldPoint(2582, 9484, 0), new WorldPoint(2594, 9489, 0));
    }

    public void setupConditions() {
        this.inColonyEntrance = new ZoneRequirement(this.colonyEntrance);
        this.inBasement = new ZoneRequirement(this.basement);
        this.talkedToFranklin = new VarbitRequirement(2099, 1);
        this.addedLog = new VarbitRequirement(2099, 2);
        this.litLog = new VarbitRequirement(2099, 3);
        this.wall1Fixed = new VarbitRequirement(2100, 1);
        this.wall2Fixed = new VarbitRequirement(2101, 1);
        this.wall3Fixed = new VarbitRequirement(2102, 1);
        this.wall4Fixed = new VarbitRequirement(2103, 1);
        this.wall5Fixed = new VarbitRequirement(2104, 1);
        this.wallsFixed = new Conditions(this.wall1Fixed, this.wall2Fixed, this.wall3Fixed, this.wall4Fixed, this.wall5Fixed);
        this.talkedToArnold = new VarbitRequirement(2105, 1, Operation.GREATER_EQUAL);
        this.finishedFranklin = new VarbitRequirement(2099, 4);
        this.queenNearby = new NpcCondition(4315);
    }

    public void setupSteps() {
        this.talkToHerman = new NpcStep((QuestHelper)this, 4291, new WorldPoint(2345, 3651, 0), "Talk to Herman Carnos outside the Fishing Colony.", new Requirement[0]);
        this.talkToHerman.addTeleport(this.piscTeleport);
        this.talkToHerman.addDialogSteps("What's the rush?", "Do you need any help?", "I'm a brave adventurer! Can I try?", "Yes.");
        this.talkToWom = new NpcStep((QuestHelper)this, 2108, new WorldPoint(3089, 3253, 0), "Talk to the Wise Old Man in Draynor Village.", this.blood5, this.lava10, this.mist10);
        this.talkToWom.addTeleport(this.draynorTeleport);
        this.talkToWom.addDialogSteps("Draynor Village", "You used to be a famous adventurer, didn't you?");
        this.talkToWomAtColony = new NpcStep((QuestHelper)this, 2112, new WorldPoint(2345, 3651, 0), "Talk to the Wise Old Man outside the Fishing Colony. Be prepared to fight sea trolls.", this.combatGear);
        this.talkToWomAtColony.addTeleport(this.piscTeleport);
        this.talkToWomAtColony.addDialogStep("I'm ready to fight.");
        this.enterColony = new ObjectStep((QuestHelper)this, 12656, new WorldPoint(2344, 3651, 0), "Enter the Fishing Colony, prepared to fight trolls.", this.combatGear, this.log, this.tinderbox, this.ironBar5, this.hammer);
        this.talkToWomAtColony.addSubSteps(this.enterColony);
        this.kill79Trolls = new NpcStep((QuestHelper)this, 4308, new WorldPoint(2343, 3657, 0), "Kill the sea trolls.", true, new Requirement[0]);
        this.talkToHermanInBuilding = new NpcStep((QuestHelper)this, 4291, new WorldPoint(2354, 3683, 0), "Talk to Herman in the east of the Fishing Colony.", new Requirement[0]);
        this.talkToFranklin = new NpcStep((QuestHelper)this, 4292, new WorldPoint(2341, 3667, 0), "Talk to Franklin in the middle of the Fishing Colony.", new Requirement[0]);
        this.useLog = new ObjectStep((QuestHelper)this, 13702, new WorldPoint(2344, 3676, 0), "Add some logs to the firebox in the building with a furnace.", this.logHiglight);
        this.useLog.addIcon(1511);
        this.useTinderbox = new ObjectStep((QuestHelper)this, 13702, new WorldPoint(2344, 3676, 0), "Light the logs in the firebox in the building with a furnace.", this.tinderboxHiglight);
        this.useTinderbox.addIcon(590);
        this.repairWall = new FixWall(this);
        this.talkToArnold = new NpcStep((QuestHelper)this, 4293, new WorldPoint(2329, 3688, 0), "Talk to Arnold at the bank in the Fishing Colony.", new Requirement[0]);
        this.fishAndCookMonkfish = new FishMonkfish(this);
        this.talkToFranklinAgain = new NpcStep((QuestHelper)this, 4292, new WorldPoint(2341, 3667, 0), "Talk to Franklin again.", new Requirement[0]);
        this.talkToHermanAfterTasks = new NpcStep((QuestHelper)this, 4291, new WorldPoint(2354, 3683, 0), "Talk to Herman in the east of the colony again.", new Requirement[0]);
        this.enterWizardsBasement = new ObjectStep((QuestHelper)this, 17384, new WorldPoint(2594, 3085, 0), "Talk to Wizard Frumscone in the Wizards' Guild basement.", new Requirement[0]);
        this.enterWizardsBasement.addTeleport(this.yanilleTeleport);
        this.talkToFruscone = new NpcStep((QuestHelper)this, 3246, new WorldPoint(2587, 9488, 0), "Talk to Wizard Frumscone in the Wizards' Guild basement.", new Requirement[0]);
        this.talkToFruscone.addDialogStep("I'll see what the necromancer needs me to do.");
        this.talkToFruscone.addSubSteps(this.enterWizardsBasement);
        this.talkToMalignius = new NpcStep((QuestHelper)this, 1783, new WorldPoint(2993, 3269, 0), "Talk to Malignius Mortifer near Port Sarim.", this.bones7);
        this.talkToMalignius.addDialogStep("I need help with saving a fishing colony.");
        this.talkToMalignius.addTeleport(this.craftingGuildTeleport);
        this.talkToCrafter = new NpcStep((QuestHelper)this, 5812, new WorldPoint(2937, 3290, 0), "Talk to a Master Crafter with dreadlocks in the Crafting Guild.", this.brownApron);
        this.talkToCrafter.addDialogStep("Swan Song.");
        this.makeAirtightPot = new DetailedQuestStep((QuestHelper)this, "Add a pot lid to a pot.", this.potHiglight, this.potLidHiglight);
        this.talkToMaligniusWithPot = new NpcStep((QuestHelper)this, 1783, new WorldPoint(2993, 3269, 0), "Bring the airtight pot and 7 bones to Malignius Mortifer near Port Sarim. Make sure you're equipped for the fight before speaking to Malignus.", this.airtightPot);
        this.talkToMaligniusWithPot.addDialogStep("I've spoken to the master crafter...");
        this.talkToHermanWithPot = new NpcStep((QuestHelper)this, 4291, new WorldPoint(2354, 3683, 0), "Be prepared to fight, and talk to Herman in the colony.", this.combatGearRanged, this.boneSeeds);
        this.talkToHermanWithPot.addDialogSteps("I've lost the army!");
        this.talkToHermanForFinalFight = new NpcStep((QuestHelper)this, 4291, new WorldPoint(2354, 3683, 0), "Be prepared to fight, and talk to Herman in the colony.", this.combatGearRanged);
        this.talkToHermanForFinalFight.addDialogStep("I'm ready. Let's fight!");
        this.talkToHermanForFinalFight.addSubSteps(this.talkToHermanWithPot);
        this.killQueen = new NpcStep((QuestHelper)this, 4315, new WorldPoint(2347, 3704, 0), "Kill the Sea Troll Queen.", this.combatGearRanged);
        this.killQueen.addDialogStep("No, I'm ready to move on with the quest.");
        this.talkToHermanToFinish = new NpcStep((QuestHelper)this, 4291, new WorldPoint(2354, 3683, 0), "Talk to Herman to finish the quest.", new Requirement[0]);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.mist10, this.lava10, this.blood5, this.bones7, this.pot, this.potLid, this.ironBar5, this.log, this.tinderbox, this.hammerPanel);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.draynorTeleport, this.piscTeleport.quantity(2), this.yanilleTeleport, this.craftingGuildTeleport, this.cookingGauntlets);
    }

    @Override
    public List<String> getCombatRequirements() {
        ArrayList<String> reqs = new ArrayList<String>();
        reqs.add("11 Sea trolls (levels 65/79/87/101)");
        reqs.add("Sea troll queen (level 170)");
        return reqs;
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new QuestPointRequirement(100));
        req.add(new QuestRequirement(QuestHelperQuest.ONE_SMALL_FAVOUR, QuestState.FINISHED));
        req.add(new QuestRequirement(QuestHelperQuest.GARDEN_OF_TRANQUILLITY, QuestState.FINISHED));
        req.add(new SkillRequirement(Skill.MAGIC, 66, true));
        req.add(new SkillRequirement(Skill.COOKING, 62, true));
        req.add(new SkillRequirement(Skill.FISHING, 62, true));
        req.add(new SkillRequirement(Skill.SMITHING, 45, true));
        req.add(new SkillRequirement(Skill.CRAFTING, 40, true));
        req.add(new SkillRequirement(Skill.FIREMAKING, 42));
        return req;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(2);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Arrays.asList(new ExperienceReward(Skill.MAGIC, 15000), new ExperienceReward(Skill.PRAYER, 10000), new ExperienceReward(Skill.FISHING, 50000));
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Collections.singletonList(new ItemReward("Coins", 995, 25000));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("Access to the Piscatoris Fishing Colony"), new UnlockReward("The ability to fish Monkfish"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting off", Arrays.asList(this.talkToHerman, this.talkToWom), Arrays.asList(this.blood5, this.mist10, this.lava10), Arrays.asList(this.piscTeleport, this.draynorTeleport)));
        allSteps.add(new PanelDetails("Entering the colony", Arrays.asList(this.talkToWomAtColony, this.kill79Trolls, this.talkToHermanInBuilding), Arrays.asList(this.combatGear, this.log, this.tinderbox, this.ironBar5, this.hammerPanel), Collections.singletonList(this.piscTeleport)));
        List<QuestStep> helpingSteps = QuestUtil.toArrayList(this.talkToFranklin, this.useLog, this.useTinderbox);
        helpingSteps.addAll(this.repairWall.getDisplaySteps());
        helpingSteps.add(this.talkToFranklinAgain);
        allSteps.add(new PanelDetails("Helping Franklin", helpingSteps, Arrays.asList(this.combatGear, this.log, this.tinderbox, this.ironBar5, this.hammerPanel)));
        List<QuestStep> helpingArnoldSteps = QuestUtil.toArrayList(this.talkToArnold);
        helpingArnoldSteps.addAll(this.fishAndCookMonkfish.getSteps());
        helpingArnoldSteps.add(this.talkToHermanAfterTasks);
        allSteps.add(new PanelDetails("Helping Arnold", helpingArnoldSteps, Collections.singletonList(this.combatGear), Collections.singletonList(this.cookingGauntlets)));
        allSteps.add(new PanelDetails("Making an army", Arrays.asList(this.talkToFruscone, this.talkToMalignius, this.talkToCrafter, this.makeAirtightPot, this.talkToMaligniusWithPot), Arrays.asList(this.bones7, this.pot, this.potLid, this.combatGearRanged), Arrays.asList(this.yanilleTeleport, this.craftingGuildTeleport)));
        allSteps.add(new PanelDetails("Defeating the trolls", Arrays.asList(this.talkToHermanForFinalFight, this.killQueen, this.talkToHermanToFinish), this.combatGearRanged));
        return allSteps;
    }
}

