/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.swansong;

import com.questhelper.collections.ItemCollections;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.steps.DetailedOwnerStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.Arrays;
import java.util.Collection;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameTick;
import net.runelite.client.eventbus.Subscribe;

public class FixWall
extends DetailedOwnerStep {
    DetailedQuestStep useIronBar;
    DetailedQuestStep repairWall1;
    DetailedQuestStep repairWall2;
    DetailedQuestStep repairWall3;
    DetailedQuestStep repairWall4;
    DetailedQuestStep repairWall5;
    ItemRequirement ironSheets;
    ItemRequirement ironBars;
    ItemRequirement hammer;

    public FixWall(QuestHelper questHelper) {
        super(questHelper, new Requirement[0]);
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        this.updateSteps();
    }

    @Override
    protected void updateSteps() {
        int wall1Fixed = this.client.getVarbitValue(2100);
        int wall2Fixed = this.client.getVarbitValue(2101);
        int wall3Fixed = this.client.getVarbitValue(2102);
        int wall4Fixed = this.client.getVarbitValue(2103);
        int wall5Fixed = this.client.getVarbitValue(2104);
        int wallsToRepair = 5 - (wall1Fixed + wall2Fixed + wall3Fixed + wall4Fixed + wall5Fixed);
        this.ironBars.setQuantity(wallsToRepair);
        this.ironSheets.setQuantity(wallsToRepair);
        if (this.ironSheets.check(this.client)) {
            if (wall1Fixed == 0) {
                this.startUpStep(this.repairWall1);
            } else if (wall2Fixed == 0) {
                this.startUpStep(this.repairWall2);
            } else if (wall3Fixed == 0) {
                this.startUpStep(this.repairWall3);
            } else if (wall4Fixed == 0) {
                this.startUpStep(this.repairWall4);
            } else if (wall5Fixed == 0) {
                this.startUpStep(this.repairWall5);
            }
        } else {
            this.startUpStep(this.useIronBar);
        }
    }

    @Override
    protected void setupSteps() {
        this.ironSheets = new ItemRequirement("Iron sheet", 7941, 5);
        this.ironBars = new ItemRequirement("Iron bars", 2351, 5);
        this.hammer = new ItemRequirement("Hammer", ItemCollections.HAMMER);
        this.hammer.setTooltip("Franklin will give you one");
        this.ironBars.setHighlightInInventory(true);
        this.ironSheets.setHighlightInInventory(true);
        this.useIronBar = new ObjectStep(this.getQuestHelper(), 13701, new WorldPoint(2342, 3676, 0), "Flatten 5 iron bars using the metal press.", this.ironBars);
        this.useIronBar.addIcon(2351);
        this.repairWall1 = new ObjectStep(this.getQuestHelper(), 13612, new WorldPoint(2311, 3688, 0), "Repair the west wall.", this.ironSheets, this.hammer);
        this.repairWall1.addIcon(7941);
        this.repairWall2 = new ObjectStep(this.getQuestHelper(), 13613, new WorldPoint(2311, 3687, 0), "Repair the west wall.", this.ironSheets, this.hammer);
        this.repairWall2.addIcon(7941);
        this.repairWall3 = new ObjectStep(this.getQuestHelper(), 13614, new WorldPoint(2311, 3686, 0), "Repair the west wall.", this.ironSheets, this.hammer);
        this.repairWall3.addIcon(7941);
        this.repairWall4 = new ObjectStep(this.getQuestHelper(), 13699, new WorldPoint(2311, 3685, 0), "Repair the west wall.", this.ironSheets, this.hammer);
        this.repairWall4.addIcon(7941);
        this.repairWall5 = new ObjectStep(this.getQuestHelper(), 13700, new WorldPoint(2311, 3684, 0), "Repair the west wall.", this.ironSheets, this.hammer);
        this.repairWall5.addIcon(7941);
        this.repairWall1.addSubSteps(this.repairWall2, this.repairWall3, this.repairWall4, this.repairWall5);
    }

    @Override
    public Collection<QuestStep> getSteps() {
        return Arrays.asList(this.useIronBar, this.repairWall1, this.repairWall2, this.repairWall3, this.repairWall4, this.repairWall5);
    }

    public Collection<DetailedQuestStep> getDisplaySteps() {
        return Arrays.asList(this.useIronBar, this.repairWall1);
    }
}

