/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.swansong;

import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.steps.DetailedOwnerStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.Arrays;
import java.util.Collection;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameTick;
import net.runelite.client.eventbus.Subscribe;

public class FishMonkfish
extends DetailedOwnerStep {
    DetailedQuestStep fishMonkfish;
    DetailedQuestStep cookMonkfish;
    DetailedQuestStep talkToArnoldWithMonkfish;
    ItemRequirement cookedMonkfish;
    ItemRequirement rawMonkfish;
    ItemRequirement combatGear;
    ItemRequirement smallNet;

    public FishMonkfish(QuestHelper questHelper) {
        super(questHelper, new Requirement[0]);
        this.smallNet.setTooltip("You can get one from Arnold");
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        this.updateSteps();
    }

    @Override
    protected void updateSteps() {
        int numHandedIn = this.client.getVarbitValue(2105) - 1;
        ItemContainer inventory = this.client.getItemContainer(InventoryID.INVENTORY);
        int numRaw = 0;
        int numCooked = 0;
        if (inventory != null) {
            Item[] inventoryItems;
            for (Item item : inventoryItems = inventory.getItems()) {
                if (item.getId() == 7942) {
                    ++numRaw;
                    continue;
                }
                if (item.getId() != 7943) continue;
                ++numCooked;
            }
        }
        if (numHandedIn + numCooked >= 5) {
            this.cookedMonkfish.setQuantity(5 - numHandedIn);
            this.startUpStep(this.talkToArnoldWithMonkfish);
        } else if (numHandedIn + numRaw + numCooked >= 5) {
            this.rawMonkfish.setQuantity(5 - numCooked - numHandedIn);
            this.startUpStep(this.cookMonkfish);
        } else {
            this.startUpStep(this.fishMonkfish);
        }
    }

    @Override
    protected void setupSteps() {
        this.cookedMonkfish = new ItemRequirement("Fresh monkfish", 7943, 5);
        this.rawMonkfish = new ItemRequirement("Fresh monkfish", 7942, 5);
        this.combatGear = new ItemRequirement("Combat gear", -1, -1);
        this.smallNet = new ItemRequirement("Small fishing net", 303);
        this.fishMonkfish = new ObjectStep(this.getQuestHelper(), 13477, new WorldPoint(2311, 3696, 0), "Fish at least 5 fresh monkfish. Sea Trolls will appear, and you'll need to kill them.", this.smallNet, this.combatGear);
        this.cookMonkfish = new ObjectStep(this.getQuestHelper(), 12611, new WorldPoint(2316, 3669, 0), "Cook 5 monkfish. If you burn any, catch some more.", this.rawMonkfish);
        this.talkToArnoldWithMonkfish = new NpcStep(this.getQuestHelper(), 4293, new WorldPoint(2329, 3688, 0), "Bring the monkfish to Arnold at the bank.", this.cookedMonkfish);
    }

    @Override
    public Collection<QuestStep> getSteps() {
        return Arrays.asList(this.fishMonkfish, this.cookMonkfish, this.talkToArnoldWithMonkfish);
    }
}

