/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.spiritsoftheelid;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.player.SpellbookRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.util.Spellbook;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.SPIRITS_OF_THE_ELID)
public class SpiritsOfTheElid
extends BasicQuestHelper {
    ItemRequirement airRune;
    ItemRequirement lawRune;
    ItemRequirement needle;
    ItemRequirement thread;
    ItemRequirement crushWep;
    ItemRequirement stabWep;
    ItemRequirement slashWep;
    ItemRequirement lightSource;
    ItemRequirement knife;
    ItemRequirement rope;
    ItemRequirement pickaxe;
    ItemRequirement bow;
    ItemRequirement arrows;
    ItemRequirement tornRobeTop;
    ItemRequirement tornRobeBottom;
    ItemRequirement robeOfElidinisTop;
    ItemRequirement robeOfElidinisBottom;
    ItemRequirement ancestralKey;
    ItemRequirement shoes;
    ItemRequirement soles;
    ItemRequirement statuette;
    ItemRequirement robeOfElidinisTopEquipped;
    ItemRequirement robeOfElidinisBottomEquipped;
    ItemRequirement combatGear;
    ItemRequirement waterskins;
    ItemRequirement shantaypass;
    ItemRequirement coins;
    ItemRequirement spear;
    ItemRequirement food;
    ItemRequirement necklaceOfPassage;
    QuestStep speakToAwusah;
    QuestStep speakToGhaslor;
    QuestStep openCuboard;
    QuestStep useNeedleTornRobes;
    QuestStep useNeedleTornRobesTop;
    QuestStep telegrabKey;
    QuestStep enterCave;
    QuestStep useAncestralKey;
    QuestStep openStabDoor;
    QuestStep openStabDoorAfterGolem;
    QuestStep clearChannel;
    QuestStep openSlashDoor;
    QuestStep openSlashDoorAfterGolem;
    QuestStep clearChannel2;
    QuestStep openCrushDoor;
    QuestStep openCrushDoorAfterGolem;
    QuestStep clearChannel3;
    QuestStep openFarNorthDoor;
    QuestStep speakToSpirits;
    QuestStep speakToAwusah2;
    QuestStep takeShoes;
    QuestStep leaveAwusah;
    QuestStep cutShoes;
    QuestStep enterCrevice;
    QuestStep talkToGenie;
    QuestStep talkToGenieAgain;
    QuestStep useStatuette;
    Requirement hasTornRobeTop;
    Requirement whiteGolem;
    Requirement greyGolem;
    Requirement blackGolem;
    Requirement stabChannel;
    Requirement slashChannel;
    Requirement crushChannel;
    Requirement normalBook;
    Requirement inCaveEntrance;
    Requirement inWhiteGolemRoom;
    Requirement inGreyGolemRoom;
    Requirement inBlackGolemRoom;
    Requirement notAwusahHouse;
    Requirement insideCrevice;
    Requirement inSourceCave;
    Zone riverElidCaveEntrance;
    Zone whiteGolemRoom;
    Zone greyGolemRoom;
    Zone blackGolemRoom;
    Zone outsideAwusahHouse;
    Zone creviceOutsideNardah;
    Zone sourceCave;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.setupRequirements();
        this.setupZones();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.speakToAwusah);
        steps.put(10, this.speakToGhaslor);
        ConditionalStep getRobesAndKey = new ConditionalStep((QuestHelper)this, this.openCuboard, new Requirement[0]);
        getRobesAndKey.addStep(new Conditions(this.robeOfElidinisTop, this.robeOfElidinisBottom, this.ancestralKey), this.enterCave);
        getRobesAndKey.addStep(new Conditions(this.robeOfElidinisTop, this.robeOfElidinisBottom), this.telegrabKey);
        getRobesAndKey.addStep(new Conditions(this.hasTornRobeTop, this.robeOfElidinisBottom), this.useNeedleTornRobesTop);
        getRobesAndKey.addStep(new Conditions(this.tornRobeBottom, this.hasTornRobeTop), this.useNeedleTornRobes);
        steps.put(20, getRobesAndKey);
        ConditionalStep goUseKey = new ConditionalStep((QuestHelper)this, this.enterCave, new Requirement[0]);
        goUseKey.addStep(this.inCaveEntrance, this.useAncestralKey);
        steps.put(25, goUseKey);
        ConditionalStep clearChannels = new ConditionalStep((QuestHelper)this, this.enterCave, new Requirement[0]);
        clearChannels.addStep(new Conditions(this.inSourceCave, this.crushChannel), this.openFarNorthDoor);
        clearChannels.addStep(new Conditions(this.inSourceCave, this.inBlackGolemRoom), this.clearChannel3);
        clearChannels.addStep(new Conditions(this.inSourceCave, this.blackGolem), this.openCrushDoorAfterGolem);
        clearChannels.addStep(new Conditions(this.inSourceCave, this.slashChannel), this.openCrushDoor);
        clearChannels.addStep(new Conditions(this.inSourceCave, this.inGreyGolemRoom), this.clearChannel2);
        clearChannels.addStep(new Conditions(this.inSourceCave, this.greyGolem), this.openSlashDoorAfterGolem);
        clearChannels.addStep(new Conditions(this.inSourceCave, this.stabChannel), this.openSlashDoor);
        clearChannels.addStep(new Conditions(this.inSourceCave, this.inWhiteGolemRoom), this.clearChannel);
        clearChannels.addStep(new Conditions(this.inSourceCave, this.whiteGolem), this.openStabDoorAfterGolem);
        clearChannels.addStep(this.inSourceCave, this.openStabDoor);
        steps.put(27, clearChannels);
        ConditionalStep goSpeakToSpirits = new ConditionalStep((QuestHelper)this, this.enterCave, new Requirement[0]);
        goSpeakToSpirits.addStep(this.inSourceCave, this.speakToSpirits);
        steps.put(30, goSpeakToSpirits);
        steps.put(35, this.speakToAwusah2);
        ConditionalStep creviceSteps = new ConditionalStep((QuestHelper)this, this.takeShoes, new Requirement[0]);
        creviceSteps.addStep(this.insideCrevice, this.talkToGenie);
        creviceSteps.addStep(this.soles.alsoCheckBank(this.questBank), this.enterCrevice);
        creviceSteps.addStep(new Conditions(this.shoes, this.notAwusahHouse), this.cutShoes);
        creviceSteps.addStep(new Conditions(this.shoes), this.leaveAwusah);
        steps.put(40, creviceSteps);
        steps.put(50, this.talkToGenieAgain);
        steps.put(55, this.useStatuette);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.airRune = new ItemRequirement("Air Rune", 556, 1);
        this.lawRune = new ItemRequirement("Law Rune", 563, 1);
        this.needle = new ItemRequirement("Needle", 1733, 1).isNotConsumed();
        this.needle.setHighlightInInventory(true);
        this.thread = new ItemRequirement("Thread", 1734, 2);
        this.crushWep = new ItemRequirement("Crush Weapon Style", -1, 1).isNotConsumed();
        this.crushWep.setDisplayItemId(1432);
        this.stabWep = new ItemRequirement("Stab Weapon Style", -1, 1).isNotConsumed();
        this.stabWep.setDisplayItemId(1289);
        this.slashWep = new ItemRequirement("Slash Weapon Style", -1, 1).isNotConsumed();
        this.slashWep.setDisplayItemId(1333);
        this.lightSource = new ItemRequirement("Lightsource", ItemCollections.LIGHT_SOURCES, 1).isNotConsumed();
        this.knife = new ItemRequirement("Knife", 946).highlighted().isNotConsumed();
        this.rope = new ItemRequirement("Rope", 954).highlighted();
        this.pickaxe = new ItemRequirement("Any Pickaxe", ItemCollections.PICKAXES, 1).isNotConsumed();
        this.bow = new ItemRequirement("Any bow", ItemCollections.BOWS, 1, true).isNotConsumed();
        this.bow.setTooltip("Short bow obtainable during quest east of the cave entrance");
        this.arrows = new ItemRequirement("Arrows for bow", ItemCollections.METAL_ARROWS, 1, true);
        this.arrows.setTooltip("Bronze arrows obtainable during quest south of cave entrance");
        this.normalBook = new SpellbookRequirement(Spellbook.NORMAL);
        this.tornRobeTop = new ItemRequirement("Torn Robe (top)", 6788, 1);
        this.tornRobeTop.setHighlightInInventory(true);
        this.tornRobeBottom = new ItemRequirement("Torn Robe (bottom)", 6789, 1);
        this.tornRobeBottom.setHighlightInInventory(true);
        this.robeOfElidinisTop = new ItemRequirement("Robe of Elidinis (top)", 6786);
        this.robeOfElidinisBottom = new ItemRequirement("Robe of Elidinis (bottom)", 6787);
        this.robeOfElidinisTopEquipped = new ItemRequirement("Robe of Elidinis (top)", 6786, 1, true);
        this.robeOfElidinisBottomEquipped = new ItemRequirement("Robe of Elidinis (bottom)", 6787, 1, true);
        this.ancestralKey = new ItemRequirement("Ancestral Key", 6792, 1);
        this.ancestralKey.setHighlightInInventory(true);
        this.shoes = new ItemRequirement("Shoes", 6790, 1);
        this.shoes.setHighlightInInventory(true);
        this.soles = new ItemRequirement("Sole", 6791, 1);
        this.statuette = new ItemRequirement("Statuette", 6785, 1);
        this.statuette.setHighlightInInventory(true);
        this.combatGear = new ItemRequirement("Combat Gear", -1, 1);
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.waterskins = new ItemRequirement("Waterskins", 1823, -1);
        this.waterskins.addAlternates(1825, 1827, 1829);
        this.shantaypass = new ItemRequirement("Shantay Passes", 1854, -1);
        this.coins = new ItemRequirement("Coins for magic carpet", ItemCollections.COINS, -1);
        this.spear = new ItemRequirement("Spear or Hasta for the 3 weapon styles", -1, 1);
        this.spear.setDisplayItemId(1249);
        this.food = new ItemRequirement("Food", ItemCollections.GOOD_EATING_FOOD, -1);
        this.necklaceOfPassage = new ItemRequirement("Necklace of Passage", ItemCollections.NECKLACE_OF_PASSAGES, 1);
    }

    public void setupZones() {
        this.sourceCave = new Zone(new WorldPoint(3336, 9532, 0), new WorldPoint(3384, 9600, 0));
        this.riverElidCaveEntrance = new Zone(new WorldPoint(3343, 9532, 0), new WorldPoint(3356, 9544, 0));
        this.whiteGolemRoom = new Zone(new WorldPoint(3360, 9535, 0), new WorldPoint(3369, 9542, 0));
        this.greyGolemRoom = new Zone(new WorldPoint(3374, 9543, 0), new WorldPoint(3381, 9550, 0));
        this.blackGolemRoom = new Zone(new WorldPoint(3372, 9553, 0), new WorldPoint(3380, 9561, 0));
        this.outsideAwusahHouse = new Zone(new WorldPoint(3435, 2885, 0), new WorldPoint(3387, 2949, 0));
        this.creviceOutsideNardah = new Zone(new WorldPoint(3362, 9298, 0), new WorldPoint(3380, 9329, 0));
    }

    public void setupConditions() {
        this.hasTornRobeTop = new Conditions(LogicType.OR, this.tornRobeTop, this.robeOfElidinisTop);
        this.inSourceCave = new ZoneRequirement(this.sourceCave);
        this.inCaveEntrance = new ZoneRequirement(this.riverElidCaveEntrance);
        this.inWhiteGolemRoom = new ZoneRequirement(this.whiteGolemRoom);
        this.inGreyGolemRoom = new ZoneRequirement(this.greyGolemRoom);
        this.inBlackGolemRoom = new ZoneRequirement(this.blackGolemRoom);
        this.notAwusahHouse = new ZoneRequirement(this.outsideAwusahHouse);
        this.insideCrevice = new ZoneRequirement(this.creviceOutsideNardah);
        this.whiteGolem = new VarbitRequirement(1447, 1);
        this.greyGolem = new VarbitRequirement(1448, 1);
        this.blackGolem = new VarbitRequirement(1446, 1);
        this.stabChannel = new VarbitRequirement(1450, 1);
        this.slashChannel = new VarbitRequirement(1449, 1);
        this.crushChannel = new VarbitRequirement(1451, 1);
    }

    public void setupSteps() {
        this.speakToAwusah = new NpcStep((QuestHelper)this, 4756, new WorldPoint(3443, 2915, 0), "Speak to Awusah the Mayor in Nardah.", new Requirement[0]);
        this.speakToAwusah.addDialogSteps("I am an adventurer in search of quests.", "Any idea how you got this curse?", "Yes.", "Ok I will have a look around and see what I can do.");
        this.speakToGhaslor = new NpcStep((QuestHelper)this, 4745, new WorldPoint(3441, 2932, 0), "Speak to Ghaslor the Elder, just north of Awusah.", new Requirement[0]);
        this.speakToGhaslor.addDialogSteps("I am trying to find out the cause of this town's curse.", "River spirits, what are they?");
        this.openCuboard = new ObjectStep((QuestHelper)this, 10384, new WorldPoint(3420, 2930, 0), "Open and search the cupboard in the north-west corner of the house that is north of the fountain.", new Requirement[0]);
        ((ObjectStep)this.openCuboard).addAlternateObjects(10385);
        this.useNeedleTornRobes = new DetailedQuestStep((QuestHelper)this, "Use the needle and thread on the torn robes (both top and bottom).", this.needle, this.tornRobeBottom);
        this.useNeedleTornRobesTop = new DetailedQuestStep((QuestHelper)this, "Use the needle and thread on the torn robes (both top and bottom).", this.needle, this.tornRobeTop);
        this.useNeedleTornRobes.addSubSteps(this.useNeedleTornRobesTop);
        this.telegrabKey = new ObjectStep((QuestHelper)this, 10490, new WorldPoint(3432, 2929, 0), "Cast telegrab on the ancestral key on the table.", this.normalBook, this.airRune, this.lawRune);
        this.enterCave = new ObjectStep((QuestHelper)this, 6382, new WorldPoint(3370, 3132, 0), "Enter the cave north-west of Nardah where the river turns into a waterfall.", this.rope);
        this.enterCave.addIcon(954);
        this.useAncestralKey = new ObjectStep((QuestHelper)this, 10427, new WorldPoint(3353, 9544, 0), "Equip the Robes of Elidinis and use the ancestral key on the door.", this.ancestralKey, this.robeOfElidinisTopEquipped, this.robeOfElidinisBottomEquipped);
        ((ObjectStep)this.useAncestralKey).addAlternateObjects(10429);
        this.useAncestralKey.addIcon(6792);
        this.openStabDoor = new ObjectStep((QuestHelper)this, 10420, new WorldPoint(3365, 9542, 0), "Open the door to the south and fight the White Golem (level-75).  You can only damage the Golem with the stab attack style.", this.stabWep);
        this.openStabDoorAfterGolem = new ObjectStep((QuestHelper)this, 10420, new WorldPoint(3365, 9542, 0), "Open the southern door again.", new Requirement[0]);
        this.openStabDoor.addSubSteps(this.openStabDoorAfterGolem);
        this.clearChannel = new ObjectStep((QuestHelper)this, 10407, new WorldPoint(3365, 9538, 0), "Clear the Water Channel then leave the room.", new Requirement[0]);
        this.openSlashDoor = new ObjectStep((QuestHelper)this, 10421, new WorldPoint(3374, 9547, 0), "Open the door to the east and fight the Grey Golem (level-75).  You can only damage the Golem with the slash attack style.", this.slashWep);
        this.openSlashDoorAfterGolem = new ObjectStep((QuestHelper)this, 10421, new WorldPoint(3374, 9547, 0), "Open the eastern door again.", new Requirement[0]);
        this.openSlashDoor.addSubSteps(this.openSlashDoorAfterGolem);
        this.clearChannel2 = new ObjectStep((QuestHelper)this, 10405, new WorldPoint(3378, 9547, 0), "Clear the Water Channel then leave the room.", this.pickaxe);
        this.openCrushDoor = new ObjectStep((QuestHelper)this, 10419, new WorldPoint(3372, 9556, 0), "Open the door to the north-eastern and fight the Black Golem (level-75).  You can only damge the Golem with the crush attack style.", this.crushWep);
        this.openCrushDoorAfterGolem = new ObjectStep((QuestHelper)this, 10419, new WorldPoint(3372, 9556, 0), "Open the north-eastern door again.", new Requirement[0]);
        this.openCrushDoor.addSubSteps(this.openCrushDoorAfterGolem);
        this.clearChannel3 = new NpcStep((QuestHelper)this, 4763, new WorldPoint(3376, 9557, 0), "Clear the Water Channel by shooting the target then leave the room.", this.bow, this.arrows);
        this.openFarNorthDoor = new ObjectStep((QuestHelper)this, 10423, new WorldPoint(3354, 9558, 0), "Open the door to the north near the lake.", new Requirement[0]);
        this.speakToSpirits = new NpcStep((QuestHelper)this, 4739, new WorldPoint(3364, 9589, 0), "Talk to the Water Spirits on the north side of the lake.", true, new Requirement[0]);
        ((NpcStep)this.speakToSpirits).addAlternateNpcs(4740);
        ((NpcStep)this.speakToSpirits).addAlternateNpcs(4741);
        this.speakToSpirits.addDialogSteps("I come as an emissary from the people of Nardah.", "Is there anything they can do to get their fountain working again?");
        this.speakToAwusah2 = new NpcStep((QuestHelper)this, 4756, new WorldPoint(3443, 2915, 0), "Return to Nardah and speak to Awusah the Mayor.", new Requirement[0]);
        this.takeShoes = new DetailedQuestStep((QuestHelper)this, new WorldPoint(3439, 2913, 0), "Take the shoes near the doorway then leave Awusah's house.", this.shoes);
        this.leaveAwusah = new DetailedQuestStep((QuestHelper)this, new WorldPoint(3431, 2915, 0), "Leave Awusah's home.", new Requirement[0]);
        this.takeShoes.addSubSteps(this.leaveAwusah);
        this.cutShoes = new DetailedQuestStep((QuestHelper)this, "Use a knife on the shoes to cut out the sole.", this.knife, this.shoes);
        this.enterCrevice = new ObjectStep((QuestHelper)this, 10416, new WorldPoint(3373, 2905, 0), "Enter the crevice to the west of Nardah.", this.rope, this.lightSource);
        this.enterCrevice.addIcon(954);
        this.talkToGenie = new NpcStep((QuestHelper)this, 4738, new WorldPoint(3371, 9320, 0), "Talk to the Genie in the Crevice.", new Requirement[0]);
        this.talkToGenie.addDialogSteps("I'm after a statue that was thrown down here.", "Maybe I can make a deal for it?", "Ok I agree to the deal.");
        this.talkToGenieAgain = new NpcStep((QuestHelper)this, 4738, new WorldPoint(3371, 9320, 0), "Talk to the Genie again with the sole.", this.soles);
        this.useStatuette = new ObjectStep((QuestHelper)this, 10389, new WorldPoint(3427, 2930, 0), "Return to Nardah and use the statuette on the statuette plinth in the northern house.", this.statuette);
        this.useStatuette.addIcon(6785);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.airRune, this.lawRune, this.needle, this.thread, this.crushWep, this.stabWep, this.slashWep, this.lightSource, this.knife, this.rope, this.pickaxe, this.bow, this.arrows);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.combatGear, this.waterskins, this.necklaceOfPassage, this.spear, this.coins, this.food);
    }

    @Override
    public List<String> getCombatRequirements() {
        ArrayList<String> reqs = new ArrayList<String>();
        reqs.add("Black Golem, Grey Golem, White Golem (Level 75)");
        return reqs;
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> reqs = new ArrayList<Requirement>();
        reqs.add(new SkillRequirement(Skill.MAGIC, 33, true));
        reqs.add(new SkillRequirement(Skill.RANGED, 37, true));
        reqs.add(new SkillRequirement(Skill.MINING, 37, true));
        reqs.add(new SkillRequirement(Skill.THIEVING, 37, true));
        reqs.add(this.normalBook);
        return reqs;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(2);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Arrays.asList(new ExperienceReward(Skill.PRAYER, 8000), new ExperienceReward(Skill.THIEVING, 1000), new ExperienceReward(Skill.MAGIC, 1000));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Collections.singletonList(new UnlockReward("Access to Nardah's Fountain and Shrine"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting Off", Arrays.asList(this.speakToAwusah, this.speakToGhaslor, this.openCuboard, this.useNeedleTornRobes, this.telegrabKey), this.airRune, this.lawRune, this.needle, this.thread));
        allSteps.add(new PanelDetails("The Golems", Arrays.asList(this.enterCave, this.useAncestralKey, this.openStabDoor, this.clearChannel, this.openSlashDoor, this.clearChannel2, this.openCrushDoor, this.clearChannel3, this.openFarNorthDoor, this.speakToSpirits), this.ancestralKey, this.robeOfElidinisTop, this.robeOfElidinisBottom, this.rope, this.pickaxe, this.bow, this.arrows, this.crushWep, this.stabWep, this.slashWep));
        allSteps.add(new PanelDetails("The Genie", Arrays.asList(this.speakToAwusah2, this.takeShoes, this.cutShoes, this.enterCrevice, this.talkToGenie, this.talkToGenieAgain, this.useStatuette), this.knife, this.rope, this.lightSource));
        return allSteps;
    }
}

