/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.songoftheelves;

import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questhelpers.QuestUtil;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.List;
import net.runelite.api.coords.WorldPoint;

public class MeilyrLightPuzzle
extends ConditionalStep {
    Zone f0;
    Zone f1;
    Zone f2;
    Zone f0SW;
    Zone f2SW;
    Zone f2E;
    Zone f2NW;
    Zone f2M;
    ItemRequirement handMirrorHighlighted;
    ItemRequirement redCrystalHighlighted;
    ItemRequirement fracturedCrystalHighlighted;
    ItemRequirement greenCrystalHighlighted;
    ItemRequirement cyanCrystalHighlighted;
    ItemRequirement yellowCrystalHighlighted;
    DetailedQuestStep resetPuzzle;
    DetailedQuestStep p1Pillar1;
    DetailedQuestStep p1Pillar2;
    DetailedQuestStep p1Pillar3;
    DetailedQuestStep p1Pillar4;
    DetailedQuestStep p1Pillar5;
    DetailedQuestStep p1Pillar6;
    DetailedQuestStep p1Pillar7;
    DetailedQuestStep p1Pillar8;
    DetailedQuestStep p1Pillar9;
    DetailedQuestStep p1Pillar10;
    DetailedQuestStep p1Pillar11;
    DetailedQuestStep p1Pillar12;
    DetailedQuestStep p1Pillar13;
    DetailedQuestStep p1Pillar14;
    DetailedQuestStep p1Pillar15;
    DetailedQuestStep p1Pillar16;
    DetailedQuestStep p1Pillar17;
    DetailedQuestStep p1Pillar18;
    DetailedQuestStep p1Pillar19;
    DetailedQuestStep climbAcrossBooks;
    DetailedQuestStep collectMirrors;
    DetailedQuestStep talkToAmlodd;
    DetailedQuestStep f0ToF1NW;
    DetailedQuestStep f1ToF0NW;
    DetailedQuestStep f2ToF1NW;
    DetailedQuestStep f0ToF1Middle;
    DetailedQuestStep f1ToF0SW;
    DetailedQuestStep f0ToF1SW;
    DetailedQuestStep f1ToF2SW;
    DetailedQuestStep f2ToF1SW;
    DetailedQuestStep f2ToF1;
    DetailedQuestStep f1ToF2E;
    DetailedQuestStep f2ToF1E;
    DetailedQuestStep f1ToF2NW;
    ConditionalStep goToF0NW;
    ConditionalStep goToF1NW;
    ConditionalStep goToF0Middle;
    ConditionalStep goToF0SW;
    ConditionalStep goToF1SW;
    ConditionalStep goToF2SW;
    ConditionalStep goDownToF1SW;
    ConditionalStep goToF2E;
    ConditionalStep goToF2NW;
    Requirement hasMirrorsAndCrystal;
    Requirement onF1;
    Requirement onF2;
    Requirement onF0;
    Requirement onF0SW;
    Requirement onF2E;
    Requirement onF2SW;
    Requirement onF2NW;
    Requirement onF2M;
    Requirement notResetAmlodd;
    Requirement r1;
    Requirement r2;
    Requirement r3;
    Requirement r4;
    Requirement r5;
    Requirement r6;
    Requirement r7;
    Requirement r8;
    Requirement r9;
    Requirement r10;
    Requirement r11;
    Requirement r12;
    Requirement r13;
    Requirement r14;
    Requirement r15;
    Requirement r16;
    Requirement r17;
    Requirement r18;

    public MeilyrLightPuzzle(QuestHelper questHelper, ConditionalStep goToF1Steps, ConditionalStep goToF0Steps) {
        super(questHelper, (QuestStep)goToF1Steps, new Requirement[0]);
        this.setupItemRequirements();
        this.setupZones();
        this.setupConditions();
        this.setupSteps();
        this.setupConditionalSteps();
        this.collectMirrors.addSubSteps(goToF1Steps);
        this.goToF0Middle = goToF0Steps;
        this.addStep(new Conditions(this.onF1, this.notResetAmlodd), this.resetPuzzle);
        this.addStep(new Conditions(this.notResetAmlodd), goToF1Steps);
        this.addStep(new Conditions(new Conditions(LogicType.OR, this.onF2M, this.onF2NW), this.r18), this.p1Pillar19);
        this.addStep(new Conditions(new Conditions(LogicType.OR, this.onF2M, this.onF2NW), this.r17), this.p1Pillar18);
        this.addStep(new Conditions(this.onF2M, this.r16), this.p1Pillar17);
        this.addStep(new Conditions(this.onF2M, this.r15), this.p1Pillar16);
        this.addStep(new Conditions(this.onF2NW, this.r15), this.climbAcrossBooks);
        this.addStep(new Conditions(this.r15), this.goToF2NW);
        this.addStep(new Conditions(this.onF2E, this.r14), this.p1Pillar15);
        this.addStep(new Conditions(this.onF2E, this.r13), this.p1Pillar14);
        this.addStep(new Conditions(this.r13), this.goToF2E);
        this.addStep(new Conditions(this.onF1, this.r12), this.p1Pillar13);
        this.addStep(new Conditions(this.r12), this.goDownToF1SW);
        this.addStep(new Conditions(this.onF2, this.r11), this.p1Pillar12);
        this.addStep(new Conditions(this.r11), this.goToF2SW);
        this.addStep(new Conditions(this.onF1, this.r10), this.p1Pillar11);
        this.addStep(new Conditions(this.r10), this.goToF1SW);
        this.addStep(new Conditions(this.onF0SW, this.r9), this.p1Pillar10);
        this.addStep(new Conditions(this.onF0SW, this.r8), this.p1Pillar9);
        this.addStep(new Conditions(this.r8), this.goToF0SW);
        this.addStep(new Conditions(this.onF0, this.r7), this.p1Pillar8);
        this.addStep(new Conditions(this.onF0, this.r6), this.p1Pillar7);
        this.addStep(new Conditions(this.onF0, this.r5), this.p1Pillar6);
        this.addStep(new Conditions(this.onF0, this.r4), this.p1Pillar5);
        this.addStep(new Conditions(this.onF0, this.r3), this.p1Pillar4);
        this.addStep(new Conditions(this.onF0, this.r2), this.p1Pillar3);
        this.addStep(new Conditions(this.r2), this.goToF0Middle);
        this.addStep(new Conditions(this.onF1, this.r1), this.p1Pillar2);
        this.addStep(new Conditions(this.onF1, this.hasMirrorsAndCrystal), this.p1Pillar1);
        this.addStep(this.onF1, this.collectMirrors);
    }

    protected void setupItemRequirements() {
        this.handMirrorHighlighted = new ItemRequirement("Hand mirror", 23775);
        this.handMirrorHighlighted.setHighlightInInventory(true);
        this.redCrystalHighlighted = new ItemRequirement("Red crystal", 23776);
        this.redCrystalHighlighted.setHighlightInInventory(true);
        this.fracturedCrystalHighlighted = new ItemRequirement("Fractured crystal", 23784);
        this.fracturedCrystalHighlighted.setHighlightInInventory(true);
        this.greenCrystalHighlighted = new ItemRequirement("Green crystal", 23778);
        this.greenCrystalHighlighted.setHighlightInInventory(true);
        this.cyanCrystalHighlighted = new ItemRequirement("Cyan crystal", 23779);
        this.cyanCrystalHighlighted.setHighlightInInventory(true);
        this.yellowCrystalHighlighted = new ItemRequirement("Yellow crystal", 23777);
        this.yellowCrystalHighlighted.setHighlightInInventory(true);
    }

    protected void setupConditionalSteps() {
        this.goToF0NW = new ConditionalStep(this.getQuestHelper(), (QuestStep)this.talkToAmlodd, "Go to the bottom floor of the library.", new Requirement[0]);
        this.goToF0NW.addStep(this.onF1, this.f1ToF0NW);
        this.goToF0NW.addStep(this.onF2, this.f2ToF1NW);
        this.goToF1NW = new ConditionalStep(this.getQuestHelper(), (QuestStep)this.talkToAmlodd, "Go to the middle floor of the library.", new Requirement[0]);
        this.goToF1NW.addStep(this.onF2, this.f2ToF1NW);
        this.goToF1NW.addStep(this.onF0, this.f0ToF1NW);
        this.goToF0SW = new ConditionalStep(this.getQuestHelper(), (QuestStep)this.talkToAmlodd, "Go back up to the middle floor, then back down the south west stairs.", new Requirement[0]);
        this.goToF0SW.addStep(this.onF1, this.f1ToF0SW);
        this.goToF0SW.addStep(this.onF0, this.f0ToF1Middle);
        this.goToF1SW = new ConditionalStep(this.getQuestHelper(), (QuestStep)this.talkToAmlodd, "Go back up to the middle floor.", new Requirement[0]);
        this.goToF1SW.addStep(this.onF2, this.f2ToF1NW);
        this.goToF1SW.addStep(this.onF0SW, this.f0ToF1SW);
        this.goToF1SW.addStep(this.onF0, this.f0ToF1Middle);
        this.goToF2SW = new ConditionalStep(this.getQuestHelper(), (QuestStep)this.talkToAmlodd, "Go up to the top floor by the south west stairs.", new Requirement[0]);
        this.goToF2SW.addStep(this.onF1, this.f1ToF2SW);
        this.goToF2SW.addStep(this.onF0SW, this.f0ToF1SW);
        this.goToF2SW.addStep(this.onF0, this.f0ToF1Middle);
        this.goDownToF1SW = new ConditionalStep(this.getQuestHelper(), (QuestStep)this.talkToAmlodd, "Go to the middle floor.", new Requirement[0]);
        this.goDownToF1SW.addStep(this.onF2SW, this.f2ToF1SW);
        this.goDownToF1SW.addStep(this.onF2, this.f2ToF1);
        this.goDownToF1SW.addStep(this.onF0SW, this.f0ToF1SW);
        this.goDownToF1SW.addStep(this.onF0, this.f0ToF1Middle);
        this.goToF2E = new ConditionalStep(this.getQuestHelper(), (QuestStep)this.talkToAmlodd, "Go to the top floor by the east stairs.", new Requirement[0]);
        this.goToF2E.addStep(this.onF2SW, this.f2ToF1SW);
        this.goToF2E.addStep(this.onF2, this.f2ToF1);
        this.goToF2E.addStep(this.onF1, this.f1ToF2E);
        this.goToF2E.addStep(this.onF0SW, this.f0ToF1SW);
        this.goToF2E.addStep(this.onF0, this.f0ToF1Middle);
        this.goToF2NW = new ConditionalStep(this.getQuestHelper(), (QuestStep)this.talkToAmlodd, "Go back to the middle floor, then up to the top floor by the north west stairs.", new Requirement[0]);
        this.goToF2NW.addStep(this.onF2SW, this.f2ToF1SW);
        this.goToF2NW.addStep(this.onF2E, this.f2ToF1E);
        this.goToF2NW.addStep(this.onF1, this.f1ToF2NW);
        this.goToF2NW.addStep(this.onF0SW, this.f0ToF1SW);
        this.goToF2NW.addStep(this.onF0, this.f0ToF1Middle);
    }

    protected void setupZones() {
        this.f0SW = new Zone(new WorldPoint(2566, 6115, 0), new WorldPoint(2588, 6150, 0));
        this.f0 = new Zone(new WorldPoint(2565, 6080, 0), new WorldPoint(2740, 6204, 0));
        this.f1 = new Zone(new WorldPoint(2565, 6080, 1), new WorldPoint(2740, 6204, 1));
        this.f2 = new Zone(new WorldPoint(2565, 6080, 2), new WorldPoint(2740, 6204, 2));
        this.f2SW = new Zone(new WorldPoint(2565, 6080, 2), new WorldPoint(2585, 6149, 2));
        this.f2E = new Zone(new WorldPoint(2617, 6124, 2), new WorldPoint(2680, 6165, 2));
        this.f2NW = new Zone(new WorldPoint(2566, 6150, 2), new WorldPoint(2601, 6203, 2));
        this.f2M = new Zone(new WorldPoint(2604, 6135, 2), new WorldPoint(2612, 6173, 2));
    }

    protected void setupSteps() {
        this.talkToAmlodd = new NpcStep(this.getQuestHelper(), 8898, new WorldPoint(2353, 3179, 0), "Talk to Lord Amlodd in Lletya.", new Requirement[0]);
        this.talkToAmlodd.addDialogStep("Yes.");
        this.collectMirrors = new ObjectStep(this.getQuestHelper(), 35076, new WorldPoint(2623, 6118, 1), "Collect all the items from the dispenser in the central room.", new Requirement[0]);
        this.collectMirrors.setWorldMapPoint(new WorldPoint(2815, 6118, 1));
        this.collectMirrors.addDialogStep("Take everything.");
        this.resetPuzzle = new ObjectStep(this.getQuestHelper(), 35076, new WorldPoint(2623, 6118, 1), "Pull the lever in the dispenser in the central room.", new Requirement[0]);
        this.resetPuzzle.setWorldMapPoint(new WorldPoint(2815, 6118, 1));
        this.resetPuzzle.addDialogSteps("Pull the lever.", "Pull it.");
        this.p1Pillar1 = new ObjectStep(this.getQuestHelper(), 35287, new WorldPoint(2609, 6158, 1), "Add a mirror to a pillar to the north. Rotate it to point the light east.", this.handMirrorHighlighted);
        this.p1Pillar1.setWorldMapPoint(new WorldPoint(2801, 6158, 1));
        this.p1Pillar1.addIcon(23775);
        this.p1Pillar2 = new ObjectStep(this.getQuestHelper(), 35293, new WorldPoint(2623, 6158, 1), "Add a mirror to a pillar to the east. Rotate it to point the light down.", this.handMirrorHighlighted);
        this.p1Pillar2.setWorldMapPoint(new WorldPoint(2815, 6158, 1));
        this.p1Pillar2.addIcon(23775);
        this.p1Pillar3 = new ObjectStep(this.getQuestHelper(), 36705, new WorldPoint(2623, 6158, 0), "Add a mirror to the pillar near the stairs. Rotate it to point the light south.", this.handMirrorHighlighted);
        this.p1Pillar3.addIcon(23775);
        this.p1Pillar4 = new ObjectStep(this.getQuestHelper(), 35151, new WorldPoint(2623, 6130, 0), "Add a mirror to the pillar to the south. Rotate it to point the light west.", this.handMirrorHighlighted);
        this.p1Pillar4.addIcon(23775);
        this.p1Pillar5 = new ObjectStep(this.getQuestHelper(), 35145, new WorldPoint(2609, 6130, 0), "Add a mirror to the pillar to the west. Rotate it to point the light south.", this.handMirrorHighlighted);
        this.p1Pillar5.addIcon(23775);
        this.p1Pillar6 = new ObjectStep(this.getQuestHelper(), 35144, new WorldPoint(2609, 6116, 0), "Add a mirror to the pillar to the south. Rotate it to point the light west.", this.handMirrorHighlighted);
        this.p1Pillar6.addIcon(23775);
        this.p1Pillar7 = new ObjectStep(this.getQuestHelper(), 35138, new WorldPoint(2595, 6116, 0), "Add a mirror to the pillar to the west. Rotate it to point the light north.", this.handMirrorHighlighted);
        this.p1Pillar7.addIcon(23775);
        this.p1Pillar8 = new ObjectStep(this.getQuestHelper(), 35139, new WorldPoint(2595, 6130, 0), "Add a mirror to the pillar to the north. Rotate it to point the light west.", this.handMirrorHighlighted);
        this.p1Pillar8.addIcon(23775);
        this.p1Pillar9 = new ObjectStep(this.getQuestHelper(), 35137, new WorldPoint(2581, 6130, 0), "Add a mirror to the marked pillar. Rotate it to point the light north.", this.handMirrorHighlighted);
        this.p1Pillar9.addIcon(23775);
        this.p1Pillar10 = new ObjectStep(this.getQuestHelper(), 8802, new WorldPoint(2581, 6144, 0), "Add a mirror to the pillar to the north. Rotate it to point the light up.", this.handMirrorHighlighted);
        this.p1Pillar10.addIcon(23775);
        this.p1Pillar11 = new ObjectStep(this.getQuestHelper(), 35264, new WorldPoint(2581, 6144, 1), "Add a red crystal to the pillar to the north.", this.redCrystalHighlighted);
        this.p1Pillar11.setWorldMapPoint(new WorldPoint(2773, 6144, 1));
        this.p1Pillar11.addIcon(23776);
        this.p1Pillar12 = new ObjectStep(this.getQuestHelper(), 35089, new WorldPoint(2581, 6144, 2), "Add a mirror to the pillar to the north. Rotate it to point the light north.", this.handMirrorHighlighted);
        this.p1Pillar12.setWorldMapPoint(new WorldPoint(2965, 6144, 2));
        this.p1Pillar12.addIcon(23775);
        this.p1Pillar13 = new ObjectStep(this.getQuestHelper(), 35303, new WorldPoint(2637, 6144, 1), "Add a mirror to a pillar to the east. Rotate it to point the light up.", this.handMirrorHighlighted);
        this.p1Pillar13.setWorldMapPoint(new WorldPoint(2829, 6144, 1));
        this.p1Pillar13.addIcon(23775);
        this.p1Pillar14 = new ObjectStep(this.getQuestHelper(), 35108, new WorldPoint(2637, 6144, 2), "Add a mirror to a pillar to the west. Rotate it to point the light north.", this.handMirrorHighlighted);
        this.p1Pillar14.setWorldMapPoint(new WorldPoint(3021, 6144, 2));
        this.p1Pillar14.addIcon(23775);
        this.p1Pillar15 = new ObjectStep(this.getQuestHelper(), 35109, new WorldPoint(2637, 6158, 2), "Add a mirror to a pillar to the north. Rotate it to point the light west.", this.handMirrorHighlighted);
        this.p1Pillar15.setWorldMapPoint(new WorldPoint(3021, 6158, 2));
        this.p1Pillar15.addIcon(23775);
        this.p1Pillar16 = new ObjectStep(this.getQuestHelper(), 35101, new WorldPoint(2609, 6158, 2), "Add a mirror to the marked pillar. You'll need to climb across the floating books to reach it. Rotate it to point the light north.", this.handMirrorHighlighted);
        this.p1Pillar16.setWorldMapPoint(new WorldPoint(2993, 6158, 2));
        this.p1Pillar16.addIcon(23775);
        this.p1Pillar17 = new ObjectStep(this.getQuestHelper(), 35102, new WorldPoint(2609, 6172, 2), "Add a mirror to the pillar to the north. Rotate it to point the light west.", this.handMirrorHighlighted);
        this.p1Pillar17.setWorldMapPoint(new WorldPoint(2993, 6172, 2));
        this.p1Pillar17.addIcon(23775);
        this.p1Pillar18 = new ObjectStep(this.getQuestHelper(), 35095, new WorldPoint(2595, 6172, 2), "Add a mirror to the pillar to the west. Rotate it to point the light south.", this.handMirrorHighlighted);
        this.p1Pillar18.setWorldMapPoint(new WorldPoint(2979, 6172, 2));
        this.p1Pillar18.addIcon(23775);
        this.p1Pillar19 = new ObjectStep(this.getQuestHelper(), 35094, new WorldPoint(2595, 6158, 2), "Add a mirror to the pillar to the south. Rotate it to point the light west.", this.handMirrorHighlighted);
        this.p1Pillar19.setWorldMapPoint(new WorldPoint(2979, 6158, 2));
        this.p1Pillar19.addIcon(23775);
        this.climbAcrossBooks = new ObjectStep(this.getQuestHelper(), 35078, new WorldPoint(2598, 6173, 2), "Climb across the books to the south east.", new Requirement[0]);
        this.climbAcrossBooks.setWorldMapPoint(new WorldPoint(2982, 6173, 2));
        this.f0ToF1NW = new ObjectStep(this.getQuestHelper(), 35387, new WorldPoint(2581, 6203, 0), "", new Requirement[0]);
        this.f1ToF0NW = new ObjectStep(this.getQuestHelper(), 35389, new WorldPoint(2581, 6203, 1), "", new Requirement[0]);
        this.f1ToF0NW.addDialogStep("Climb down.");
        this.f1ToF0NW.setWorldMapPoint(new WorldPoint(2773, 6203, 1));
        this.f2ToF1NW = new ObjectStep(this.getQuestHelper(), 35388, new WorldPoint(2581, 6203, 2), "", new Requirement[0]);
        this.f2ToF1NW.setWorldMapPoint(new WorldPoint(2965, 6203, 2));
        this.f1ToF2NW = new ObjectStep(this.getQuestHelper(), 35389, new WorldPoint(2581, 6203, 1), "", new Requirement[0]);
        this.f1ToF2NW.addDialogStep("Climb up.");
        this.f1ToF2NW.setWorldMapPoint(new WorldPoint(2773, 6203, 1));
        this.f0ToF1Middle = new ObjectStep(this.getQuestHelper(), 35387, new WorldPoint(2626, 6153, 0), "", new Requirement[0]);
        this.f1ToF0SW = new ObjectStep(this.getQuestHelper(), 35389, new WorldPoint(2584, 6123, 1), "", new Requirement[0]);
        this.f1ToF0SW.addDialogStep("Climb down.");
        this.f1ToF0SW.setWorldMapPoint(new WorldPoint(2776, 6123, 1));
        this.f0ToF1SW = new ObjectStep(this.getQuestHelper(), 35387, new WorldPoint(2584, 6137, 0), "", new Requirement[0]);
        this.f1ToF2SW = new ObjectStep(this.getQuestHelper(), 35389, new WorldPoint(2584, 6137, 1), "", new Requirement[0]);
        this.f1ToF2SW.addDialogStep("Climb up.");
        this.f1ToF2SW.setWorldMapPoint(new WorldPoint(2776, 6137, 1));
        this.f2ToF1SW = new ObjectStep(this.getQuestHelper(), 35388, new WorldPoint(2584, 6137, 2), "", new Requirement[0]);
        this.f2ToF1SW.addDialogStep("Climb up.");
        this.f2ToF1SW.setWorldMapPoint(new WorldPoint(2776, 6137, 1));
        this.f2ToF1 = new ObjectStep(this.getQuestHelper(), 35388, new WorldPoint(2634, 6166, 2), "", new Requirement[0]);
        this.f2ToF1.setWorldMapPoint(new WorldPoint(3017, 6154, 2));
        this.f1ToF2E = new ObjectStep(this.getQuestHelper(), 35387, new WorldPoint(2682, 6144, 1), "", new Requirement[0]);
        this.f1ToF2E.setWorldMapPoint(new WorldPoint(2874, 6154, 1));
        this.f2ToF1E = new ObjectStep(this.getQuestHelper(), 35388, new WorldPoint(2682, 6144, 2), "", new Requirement[0]);
        this.f2ToF1E.setWorldMapPoint(new WorldPoint(3066, 6154, 2));
    }

    protected void setupConditions() {
        this.hasMirrorsAndCrystal = new Conditions(this.handMirrorHighlighted, this.redCrystalHighlighted, this.fracturedCrystalHighlighted, this.yellowCrystalHighlighted);
        this.onF0 = new ZoneRequirement(this.f0);
        this.onF0SW = new ZoneRequirement(this.f0SW);
        this.onF1 = new ZoneRequirement(this.f1);
        this.onF2 = new ZoneRequirement(this.f2);
        this.onF2SW = new ZoneRequirement(this.f2SW);
        this.onF2E = new ZoneRequirement(this.f2E);
        this.onF2NW = new ZoneRequirement(this.f2NW);
        this.onF2M = new ZoneRequirement(this.f2M);
        int BLUE = 3;
        int MAGENTA = 4;
        int YELLOW = 6;
        int GREEN = 7;
        this.notResetAmlodd = new VarbitRequirement(8861, GREEN);
        this.r1 = new VarbitRequirement(8971, MAGENTA);
        this.r2 = new VarbitRequirement(8586, MAGENTA);
        this.r3 = new VarbitRequirement(8858, MAGENTA);
        this.r4 = new VarbitRequirement(8854, BLUE);
        this.r5 = new VarbitRequirement(8853, BLUE);
        this.r6 = new VarbitRequirement(8843, BLUE);
        this.r7 = new VarbitRequirement(8842, BLUE);
        this.r8 = new VarbitRequirement(8838, BLUE);
        this.r9 = new VarbitRequirement(8837, BLUE);
        this.r10 = new VarbitRequirement(8581, BLUE);
        this.r11 = new VarbitRequirement(8603, MAGENTA);
        this.r12 = new VarbitRequirement(8733, MAGENTA);
        this.r13 = new VarbitRequirement(8602, YELLOW);
        this.r14 = new VarbitRequirement(8764, YELLOW);
        this.r15 = new VarbitRequirement(8742, YELLOW);
        this.r16 = new VarbitRequirement(8741, YELLOW);
        this.r17 = new VarbitRequirement(8739, YELLOW);
        this.r18 = new VarbitRequirement(8738, YELLOW);
    }

    public List<QuestStep> getDisplaySteps() {
        return QuestUtil.toArrayList(this.resetPuzzle, this.collectMirrors, this.p1Pillar1, this.p1Pillar2, this.goToF0Middle, this.p1Pillar3, this.p1Pillar4, this.p1Pillar5, this.p1Pillar6, this.p1Pillar7, this.p1Pillar8, this.goToF0SW, this.p1Pillar9, this.p1Pillar10, this.goToF1SW, this.p1Pillar11, this.goToF2SW, this.p1Pillar12, this.goDownToF1SW, this.p1Pillar13, this.goToF2E, this.p1Pillar14, this.p1Pillar15, this.goToF2NW, this.climbAcrossBooks, this.p1Pillar16, this.p1Pillar17, this.p1Pillar18, this.p1Pillar19);
    }
}

