/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.songoftheelves;

import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questhelpers.QuestUtil;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.List;
import net.runelite.api.coords.WorldPoint;

public class CrwysLightPuzzle
extends ConditionalStep {
    Zone f0;
    Zone f1;
    Zone f2;
    ItemRequirement handMirrorHighlighted;
    ItemRequirement redCrystalHighlighted;
    ItemRequirement fracturedCrystalHighlighted;
    ItemRequirement greenCrystalHighlighted;
    ItemRequirement cyanCrystalHighlighted;
    DetailedQuestStep resetPuzzle;
    DetailedQuestStep p1Pillar1;
    DetailedQuestStep p1Pillar2;
    DetailedQuestStep p1Pillar3;
    DetailedQuestStep p1Pillar4;
    DetailedQuestStep p1Pillar5;
    DetailedQuestStep p1Pillar6;
    DetailedQuestStep p1Pillar7;
    DetailedQuestStep p1Pillar8;
    DetailedQuestStep p1Pillar9;
    DetailedQuestStep p1Pillar10;
    DetailedQuestStep p1Pillar11;
    DetailedQuestStep p1Pillar12;
    DetailedQuestStep p1Pillar13;
    DetailedQuestStep collectMirrors;
    DetailedQuestStep talkToAmlodd;
    DetailedQuestStep goF0ToF1;
    DetailedQuestStep goF1ToF0;
    DetailedQuestStep goF2ToF1;
    DetailedQuestStep goF1ToF2;
    ConditionalStep goToF0;
    ConditionalStep goToF1;
    ConditionalStep goToF2;
    Requirement hasMirrorsAndCrystal;
    Requirement onF1;
    Requirement onF2;
    Requirement onF0;
    Requirement notResetCadarn;
    Requirement r1;
    Requirement r2;
    Requirement r3;
    Requirement r4;
    Requirement r5;
    Requirement r6;
    Requirement r7;
    Requirement r8;
    Requirement r9;
    Requirement r10;
    Requirement r11;
    Requirement r12;

    public CrwysLightPuzzle(QuestHelper questHelper, ConditionalStep goToF1Steps) {
        super(questHelper, (QuestStep)goToF1Steps, new Requirement[0]);
        this.setupItemRequirements();
        this.setupZones();
        this.setupConditions();
        this.setupSteps();
        this.setupConditionalSteps();
        this.collectMirrors.addSubSteps(goToF1Steps);
        this.addStep(new Conditions(this.onF1, this.notResetCadarn), this.resetPuzzle);
        this.addStep(new Conditions(this.notResetCadarn), goToF1Steps);
        this.addStep(new Conditions(this.onF1, this.r12), this.p1Pillar13);
        this.addStep(new Conditions(this.r12), this.goToF1);
        this.addStep(new Conditions(this.onF2, this.r11), this.p1Pillar12);
        this.addStep(new Conditions(this.onF2, this.r10), this.p1Pillar11);
        this.addStep(new Conditions(this.r10), this.goToF2);
        this.addStep(new Conditions(this.onF1, this.r9), this.p1Pillar10);
        this.addStep(new Conditions(this.r9), this.goToF1);
        this.addStep(new Conditions(this.onF0, this.r8), this.p1Pillar9);
        this.addStep(new Conditions(this.onF0, this.r7), this.p1Pillar8);
        this.addStep(new Conditions(this.r7), this.goToF0);
        this.addStep(new Conditions(this.onF1, this.r6), this.p1Pillar7);
        this.addStep(new Conditions(this.onF1, this.r5), this.p1Pillar6);
        this.addStep(new Conditions(this.onF1, this.r4), this.p1Pillar5);
        this.addStep(new Conditions(this.onF1, this.r3), this.p1Pillar4);
        this.addStep(new Conditions(this.onF1, this.r2), this.p1Pillar3);
        this.addStep(new Conditions(this.onF1, this.r1), this.p1Pillar2);
        this.addStep(new Conditions(this.onF1, this.hasMirrorsAndCrystal), this.p1Pillar1);
        this.addStep(new Conditions(this.onF1, this.notResetCadarn), this.resetPuzzle);
        this.addStep(this.onF1, this.collectMirrors);
    }

    protected void setupSteps() {
        this.talkToAmlodd = new NpcStep(this.getQuestHelper(), 8898, new WorldPoint(2353, 3179, 0), "Talk to Lord Amlodd in Lletya.", new Requirement[0]);
        this.talkToAmlodd.addDialogStep("Yes.");
        this.collectMirrors = new ObjectStep(this.getQuestHelper(), 35076, new WorldPoint(2623, 6118, 1), "Collect all the items from the dispenser in the central room.", new Requirement[0]);
        this.collectMirrors.setWorldMapPoint(new WorldPoint(2815, 6118, 1));
        this.collectMirrors.addDialogStep("Take everything.");
        this.resetPuzzle = new ObjectStep(this.getQuestHelper(), 35076, new WorldPoint(2623, 6118, 1), "Pull the lever in the dispenser in the central room.", new Requirement[0]);
        this.resetPuzzle.setWorldMapPoint(new WorldPoint(2815, 6118, 1));
        this.resetPuzzle.addDialogSteps("Pull the lever.", "Pull it.");
        this.p1Pillar1 = new ObjectStep(this.getQuestHelper(), 35286, new WorldPoint(2609, 6144, 1), "Add a mirror to a pillar to the north. Rotate it to point the light west.", this.handMirrorHighlighted);
        this.p1Pillar1.setWorldMapPoint(new WorldPoint(2801, 6144, 1));
        this.p1Pillar1.addIcon(23775);
        this.p1Pillar2 = new ObjectStep(this.getQuestHelper(), 35276, new WorldPoint(2595, 6144, 1), "Add a mirror to the pillar to the west. Rotate it to point the light north.", this.handMirrorHighlighted);
        this.p1Pillar2.setWorldMapPoint(new WorldPoint(2787, 6144, 1));
        this.p1Pillar2.addIcon(23775);
        this.p1Pillar3 = new ObjectStep(this.getQuestHelper(), 35277, new WorldPoint(2595, 6158, 1), "Add a mirror to the pillar to the north. Rotate it to point the light west.", this.handMirrorHighlighted);
        this.p1Pillar3.setWorldMapPoint(new WorldPoint(2787, 6158, 1));
        this.p1Pillar3.addIcon(23775);
        this.p1Pillar4 = new ObjectStep(this.getQuestHelper(), 35266, new WorldPoint(2581, 6158, 1), "Add a fractured crystal to the pillar to the west.", this.fracturedCrystalHighlighted);
        this.p1Pillar4.setWorldMapPoint(new WorldPoint(2773, 6158, 1));
        this.p1Pillar4.addIcon(23784);
        this.p1Pillar5 = new ObjectStep(this.getQuestHelper(), 35257, new WorldPoint(2567, 6158, 1), "Add a mirror to the pillar to the west. Rotate it to point the light north.", this.handMirrorHighlighted);
        this.p1Pillar5.setWorldMapPoint(new WorldPoint(2759, 6158, 1));
        this.p1Pillar5.addIcon(23775);
        this.p1Pillar6 = new ObjectStep(this.getQuestHelper(), 35258, new WorldPoint(2567, 6172, 1), "Add a green crystal to the pillar to the north.", this.greenCrystalHighlighted);
        this.p1Pillar6.setWorldMapPoint(new WorldPoint(2759, 6172, 1));
        this.p1Pillar6.addIcon(23778);
        this.p1Pillar7 = new ObjectStep(this.getQuestHelper(), 35259, new WorldPoint(2567, 6200, 1), "Run around to the north and add a mirror to the pillar there. Rotate it to point the light down.", this.handMirrorHighlighted);
        this.p1Pillar7.setWorldMapPoint(new WorldPoint(2759, 6200, 1));
        this.p1Pillar7.addIcon(23775);
        this.p1Pillar8 = new ObjectStep(this.getQuestHelper(), 3361, new WorldPoint(2567, 6200, 0), "Add a mirror to the pillar in the north west. Rotate it to point the light east.", this.handMirrorHighlighted);
        this.p1Pillar8.addIcon(23775);
        this.p1Pillar9 = new ObjectStep(this.getQuestHelper(), 8806, new WorldPoint(2581, 6200, 0), "Add a mirror to the pillar to the east. Rotate it to point the light up.", this.handMirrorHighlighted);
        this.p1Pillar9.addIcon(23775);
        this.p1Pillar10 = new ObjectStep(this.getQuestHelper(), 35270, new WorldPoint(2581, 6200, 1), "Add the cyan crystal to the pillar next to the stairs.", this.cyanCrystalHighlighted);
        this.p1Pillar10.setWorldMapPoint(new WorldPoint(2773, 6200, 1));
        this.p1Pillar10.addIcon(23779);
        this.p1Pillar11 = new ObjectStep(this.getQuestHelper(), 35092, new WorldPoint(2581, 6200, 2), "Add a mirror to the pillar next to the stairs. Rotate it to point the light south.", this.handMirrorHighlighted);
        this.p1Pillar11.setWorldMapPoint(new WorldPoint(2965, 6200, 2));
        this.p1Pillar11.addIcon(23775);
        this.p1Pillar12 = new ObjectStep(this.getQuestHelper(), 35091, new WorldPoint(2581, 6186, 2), "Add a mirror to the pillar to the south. Rotate it to point the light down.", this.handMirrorHighlighted);
        this.p1Pillar12.setWorldMapPoint(new WorldPoint(2965, 6186, 2));
        this.p1Pillar12.addIcon(23775);
        this.p1Pillar13 = new ObjectStep(this.getQuestHelper(), 35268, new WorldPoint(2581, 6186, 1), "Add a mirror to the pillar to the south. Rotate it to point the light south.", this.handMirrorHighlighted);
        this.p1Pillar13.setWorldMapPoint(new WorldPoint(2773, 6186, 1));
        this.p1Pillar13.addIcon(23775);
        this.goF0ToF1 = new ObjectStep(this.getQuestHelper(), 35387, new WorldPoint(2581, 6203, 0), "", new Requirement[0]);
        this.goF1ToF0 = new ObjectStep(this.getQuestHelper(), 35389, new WorldPoint(2581, 6203, 1), "", new Requirement[0]);
        this.goF1ToF0.addDialogStep("Climb down.");
        this.goF1ToF0.setWorldMapPoint(new WorldPoint(2773, 6203, 1));
        this.goF2ToF1 = new ObjectStep(this.getQuestHelper(), 35388, new WorldPoint(2581, 6203, 2), "", new Requirement[0]);
        this.goF2ToF1.setWorldMapPoint(new WorldPoint(2965, 6203, 2));
        this.goF1ToF2 = new ObjectStep(this.getQuestHelper(), 35389, new WorldPoint(2581, 6203, 1), "", new Requirement[0]);
        this.goF1ToF2.addDialogStep("Climb up.");
        this.goF1ToF2.setWorldMapPoint(new WorldPoint(2773, 6203, 1));
    }

    protected void setupItemRequirements() {
        this.handMirrorHighlighted = new ItemRequirement("Hand mirror", 23775);
        this.handMirrorHighlighted.setHighlightInInventory(true);
        this.redCrystalHighlighted = new ItemRequirement("Red crystal", 23776);
        this.redCrystalHighlighted.setHighlightInInventory(true);
        this.fracturedCrystalHighlighted = new ItemRequirement("Fractured crystal", 23784);
        this.fracturedCrystalHighlighted.setHighlightInInventory(true);
        this.greenCrystalHighlighted = new ItemRequirement("Green crystal", 23778);
        this.greenCrystalHighlighted.setHighlightInInventory(true);
        this.cyanCrystalHighlighted = new ItemRequirement("Cyan crystal", 23779);
        this.cyanCrystalHighlighted.setHighlightInInventory(true);
    }

    protected void setupConditionalSteps() {
        this.goToF0 = new ConditionalStep(this.getQuestHelper(), (QuestStep)this.talkToAmlodd, "Go to the bottom floor of the library.", new Requirement[0]);
        this.goToF0.addStep(this.onF1, this.goF1ToF0);
        this.goToF0.addStep(this.onF2, this.goF2ToF1);
        this.goToF1 = new ConditionalStep(this.getQuestHelper(), (QuestStep)this.talkToAmlodd, "Go to the middle floor of the library.", new Requirement[0]);
        this.goToF1.addStep(this.onF2, this.goF2ToF1);
        this.goToF1.addStep(this.onF0, this.goF0ToF1);
        this.goToF2 = new ConditionalStep(this.getQuestHelper(), (QuestStep)this.talkToAmlodd, "Go to the top floor of the library.", new Requirement[0]);
        this.goToF2.addStep(this.onF1, this.goF1ToF2);
        this.goToF2.addStep(this.onF0, this.goF0ToF1);
    }

    protected void setupZones() {
        this.f0 = new Zone(new WorldPoint(2565, 6080, 0), new WorldPoint(2740, 6204, 0));
        this.f1 = new Zone(new WorldPoint(2565, 6080, 1), new WorldPoint(2740, 6204, 1));
        this.f2 = new Zone(new WorldPoint(2565, 6080, 2), new WorldPoint(2740, 6204, 2));
    }

    protected void setupConditions() {
        this.hasMirrorsAndCrystal = new Conditions(this.handMirrorHighlighted, this.redCrystalHighlighted, this.fracturedCrystalHighlighted);
        this.onF0 = new ZoneRequirement(this.f0);
        this.onF1 = new ZoneRequirement(this.f1);
        this.onF2 = new ZoneRequirement(this.f2);
        int WHITE = 1;
        int CYAN = 2;
        int MAGENTA = 4;
        this.notResetCadarn = new VarbitRequirement(8971, MAGENTA);
        this.r1 = new VarbitRequirement(8947, MAGENTA);
        this.r2 = new VarbitRequirement(8948, MAGENTA);
        this.r3 = new VarbitRequirement(8957, MAGENTA);
        this.r4 = new Conditions(new VarbitRequirement(8958, MAGENTA), new VarbitRequirement(8959, MAGENTA));
        this.r5 = new Conditions(new VarbitRequirement(8961, MAGENTA), this.r4);
        this.r6 = new Conditions(new VarbitRequirement(9011, WHITE), this.r4);
        this.r7 = new Conditions(new VarbitRequirement(8579, WHITE), this.r4);
        this.r8 = new Conditions(new VarbitRequirement(8873, WHITE), this.r4);
        this.r9 = new Conditions(new VarbitRequirement(8583, WHITE), this.r4);
        this.r10 = new Conditions(new VarbitRequirement(8605, CYAN), this.r4);
        this.r11 = new Conditions(new VarbitRequirement(8787, CYAN), this.r4);
        this.r12 = new Conditions(new VarbitRequirement(8604, CYAN), this.r4);
    }

    public List<QuestStep> getDisplaySteps() {
        return QuestUtil.toArrayList(this.resetPuzzle, this.collectMirrors, this.p1Pillar1, this.p1Pillar2, this.p1Pillar3, this.p1Pillar4, this.p1Pillar5, this.p1Pillar6, this.p1Pillar7, this.goToF0, this.p1Pillar8, this.p1Pillar9, this.goToF1, this.p1Pillar10, this.goToF2, this.p1Pillar11, this.p1Pillar12, this.goToF1, this.p1Pillar13);
    }
}

