/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.songoftheelves;

import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questhelpers.QuestUtil;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.item.ItemRequirements;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.List;
import net.runelite.api.coords.WorldPoint;

public class CadarnLightPuzzle
extends ConditionalStep {
    Zone f0;
    Zone f1;
    Zone f2;
    ItemRequirement handMirrorHighlighted;
    ItemRequirement redCrystalHighlighted;
    DetailedQuestStep p1Pillar1;
    DetailedQuestStep p1Pillar2;
    DetailedQuestStep p1Pillar3;
    DetailedQuestStep p1Pillar4;
    DetailedQuestStep p1Pillar5;
    DetailedQuestStep p1Pillar6;
    DetailedQuestStep p1Pillar7;
    DetailedQuestStep p1Pillar8;
    DetailedQuestStep collectMirrors;
    QuestStep goDownstairs;
    Requirement hasMirrorsAndCrystal;
    Requirement onF1;
    Requirement onF2;
    Requirement onF0;
    Requirement r1;
    Requirement r2;
    Requirement r3;
    Requirement r4;
    Requirement r5;
    Requirement r6;
    Requirement r7;

    public CadarnLightPuzzle(QuestHelper questHelper, ConditionalStep goToF0Steps, ConditionalStep goToF1Steps) {
        super(questHelper, (QuestStep)goToF1Steps, new Requirement[0]);
        this.setupItemRequirements();
        this.setupZones();
        this.setupConditions();
        this.setupSteps();
        this.goDownstairs = goToF0Steps.copy();
        this.collectMirrors.addSubSteps(goToF1Steps);
        this.addStep(new Conditions(this.onF0, this.r7), this.p1Pillar8);
        this.addStep(new Conditions(this.onF0, this.r6), this.p1Pillar7);
        this.addStep(new Conditions(this.onF0, this.r5), this.p1Pillar6);
        this.addStep(new Conditions(this.onF0, this.r4), this.p1Pillar5);
        this.addStep(new Conditions(this.onF0, this.r3), this.p1Pillar4);
        this.addStep(new Conditions(this.onF0, this.r2), this.p1Pillar3);
        this.addStep(new Conditions(this.r2), this.goDownstairs);
        this.addStep(new Conditions(this.onF1, this.r1), this.p1Pillar2);
        this.addStep(new Conditions(this.hasMirrorsAndCrystal, this.onF1), this.p1Pillar1);
        this.addStep(this.onF1, this.collectMirrors);
    }

    protected void setupSteps() {
        this.setupItemRequirements();
        this.setupZones();
        this.setupConditions();
        this.collectMirrors = new ObjectStep(this.getQuestHelper(), 35076, new WorldPoint(2623, 6118, 1), "Collect 7 mirrors and a red crystal from the dispenser in the central room.", new Requirement[0]);
        this.collectMirrors.setWorldMapPoint(new WorldPoint(2815, 6118, 1));
        this.collectMirrors.addDialogStep("Take everything.");
        this.p1Pillar1 = new ObjectStep(this.getQuestHelper(), 35287, new WorldPoint(2609, 6158, 1), "Add a mirror to a pillar to the north. Rotate it to point the light east.", this.handMirrorHighlighted);
        this.p1Pillar1.setWorldMapPoint(new WorldPoint(2801, 6158, 1));
        this.p1Pillar1.addIcon(23775);
        this.p1Pillar2 = new ObjectStep(this.getQuestHelper(), 35293, new WorldPoint(2623, 6158, 1), "Add a mirror to a pillar to the east. Rotate it to point the light down.", this.handMirrorHighlighted);
        this.p1Pillar2.setWorldMapPoint(new WorldPoint(2815, 6158, 1));
        this.p1Pillar2.addIcon(23775);
        this.p1Pillar3 = new ObjectStep(this.getQuestHelper(), 36705, new WorldPoint(2623, 6158, 0), "Add a mirror to the pillar near the stairs. Rotate it to point the light south.", this.handMirrorHighlighted);
        this.p1Pillar3.addIcon(23775);
        this.p1Pillar4 = new ObjectStep(this.getQuestHelper(), 35151, new WorldPoint(2623, 6130, 0), "Add a mirror to the pillar to the south. Rotate it to point the light west.", this.handMirrorHighlighted);
        this.p1Pillar4.addIcon(23775);
        this.p1Pillar5 = new ObjectStep(this.getQuestHelper(), 35145, new WorldPoint(2609, 6130, 0), "Add a mirror to the pillar to the west. Rotate it to point the light south.", this.handMirrorHighlighted);
        this.p1Pillar5.addIcon(23775);
        this.p1Pillar6 = new ObjectStep(this.getQuestHelper(), 35144, new WorldPoint(2609, 6116, 0), "Add the red crystal to the pillar to the south.", this.redCrystalHighlighted);
        this.p1Pillar6.addIcon(23776);
        this.p1Pillar7 = new ObjectStep(this.getQuestHelper(), 35143, new WorldPoint(2609, 6102, 0), "Add a mirror to the pillar to the south. Rotate it to point the light east.", this.handMirrorHighlighted);
        this.p1Pillar7.addIcon(23775);
        this.p1Pillar8 = new ObjectStep(this.getQuestHelper(), 35149, new WorldPoint(2623, 6102, 0), "Add a mirror to the pillar to the east. Rotate it to point the light south at the Seal of Cadarn.", this.handMirrorHighlighted);
        this.p1Pillar8.addIcon(23775);
    }

    protected void setupItemRequirements() {
        this.handMirrorHighlighted = new ItemRequirement("Hand mirror", 23775);
        this.handMirrorHighlighted.setHighlightInInventory(true);
        this.redCrystalHighlighted = new ItemRequirement("Red crystal", 23776);
        this.redCrystalHighlighted.setHighlightInInventory(true);
    }

    protected void setupZones() {
        this.f0 = new Zone(new WorldPoint(2565, 6080, 0), new WorldPoint(2740, 6204, 0));
        this.f1 = new Zone(new WorldPoint(2565, 6080, 1), new WorldPoint(2740, 6204, 1));
        this.f2 = new Zone(new WorldPoint(2565, 6080, 2), new WorldPoint(2740, 6204, 2));
    }

    protected void setupConditions() {
        this.hasMirrorsAndCrystal = new Conditions(new ItemRequirements(new ItemRequirement("Hand mirror", 23775, 6)), new ItemRequirements(new ItemRequirement("Red crystal", 23776)));
        this.onF0 = new ZoneRequirement(this.f0);
        this.onF1 = new ZoneRequirement(this.f1);
        this.onF2 = new ZoneRequirement(this.f2);
        int MAGENTA = 4;
        int BLUE = 3;
        this.r1 = new VarbitRequirement(8971, MAGENTA);
        this.r2 = new VarbitRequirement(8586, MAGENTA);
        this.r3 = new VarbitRequirement(8858, MAGENTA);
        this.r4 = new VarbitRequirement(8854, BLUE);
        this.r5 = new VarbitRequirement(8853, BLUE);
        this.r6 = new VarbitRequirement(8844, MAGENTA);
        this.r7 = new VarbitRequirement(8845, MAGENTA);
    }

    public List<QuestStep> getDisplaySteps() {
        return QuestUtil.toArrayList(this.collectMirrors, this.p1Pillar1, this.p1Pillar2, this.goDownstairs, this.p1Pillar3, this.p1Pillar4, this.p1Pillar5, this.p1Pillar6, this.p1Pillar7, this.p1Pillar8);
    }
}

