/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.songoftheelves;

import com.google.inject.Inject;
import com.questhelper.helpers.quests.songoftheelves.BaxtorianPillar;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.item.ItemRequirements;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.steps.DetailedOwnerStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import net.runelite.api.Client;
import net.runelite.api.GraphicsObject;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.GraphicsObjectCreated;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import org.apache.commons.lang3.StringUtils;

public class BaxtorianPuzzle
extends DetailedOwnerStep {
    @Inject
    protected EventBus eventBus;
    @Inject
    protected Client client;
    private HashMap<String, ItemRequirement> items;
    private ArrayList<BaxtorianPillar> pillars;
    private ArrayList<String> unknownItems;
    ItemRequirement natureRune;
    ItemRequirement flowersOrIrit;
    ItemRequirement blackKnifeOrDagger;
    ItemRequirement wineOfZamorakOrZamorakBrew;
    ItemRequirement cabbage;
    ItemRequirement adamantChainbody;
    ItemRequirement blackKnife;
    ItemRequirement blackDagger;
    ItemRequirement wineOfZamorak;
    ItemRequirement zamorakBrew;
    ItemRequirement flowers;
    ItemRequirement iritLeaf;
    boolean foundFinalItem;

    public BaxtorianPuzzle(QuestHelper questHelper) {
        super(questHelper, "Solve the pillar puzzle.", new Requirement[0]);
    }

    @Override
    public void startUp() {
        this.updateSteps();
    }

    @Override
    public void shutDown() {
        this.shutDownStep();
        this.currentStep = null;
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        this.updateSteps();
    }

    @Override
    protected void updateSteps() {
        for (BaxtorianPillar pillar : this.pillars) {
            if (pillar.getAnswerText() == null) {
                this.startUpStep(pillar.getUseStep());
                return;
            }
            if (pillar.getSolution() == null) {
                this.startUpStep(pillar.getInspectStep());
                return;
            }
            if (pillar.getSolution() == pillar.getPlacedItem()) continue;
            this.startUpStep(pillar.getUseStep());
            return;
        }
    }

    private void checkHint(String hintText) {
        if (hintText == null) {
            return;
        }
        for (BaxtorianPillar pillar : this.pillars) {
            if (pillar.getAnswerText() == null || !hintText.contains(pillar.getAnswerText())) continue;
            String id = hintText.replace(pillar.getAnswerText(), "");
            pillar.setSolution(this.items.get(id));
            this.unknownItems.remove(id);
            if (!this.foundFinalItem && this.unknownItems.size() == 1) {
                this.foundFinalItem = true;
                this.pillars.get(this.pillars.size() - 1).setSolution(this.items.get(this.unknownItems.get(0)));
            }
            return;
        }
    }

    @Subscribe
    public void onGraphicsObjectCreated(GraphicsObjectCreated event) {
        GraphicsObject go = event.getGraphicsObject();
        if (go.getId() == 86) {
            this.clientThread.invokeLater(() -> {
                Widget itemPlacedWidget = this.client.getWidget(12648450);
                if (itemPlacedWidget == null) {
                    return;
                }
                LocalPoint smokePoint = go.getLocation();
                WorldPoint worldSmokePoint = WorldPoint.fromLocal((Client)this.client, (LocalPoint)smokePoint);
                for (BaxtorianPillar pillar : this.pillars) {
                    if (!worldSmokePoint.equals((Object)pillar.getWp())) continue;
                    this.checkItemPlaced(itemPlacedWidget.getText(), pillar);
                    return;
                }
            });
        }
    }

    private void checkItemPlaced(String itemPlacedText, BaxtorianPillar pillar) {
        if (itemPlacedText == null) {
            return;
        }
        String textStart = "You place the ";
        String textEnd = " on the pillar.";
        String itemPlaced = StringUtils.substringBetween((String)itemPlacedText, (String)textStart, (String)textEnd);
        for (ItemRequirement item : this.items.values()) {
            if (!this.checkIfItemMatches(itemPlaced, item)) continue;
            pillar.setPlacedItem(item);
        }
    }

    private boolean checkIfItemMatches(String itemPlaced, ItemRequirement solutionItem) {
        if (solutionItem instanceof ItemRequirements) {
            ItemRequirements solutionItems = (ItemRequirements)solutionItem;
            for (ItemRequirement itemRequirement : solutionItems.getItemRequirements()) {
                if (!this.checkIfItemMatches(itemPlaced, itemRequirement)) continue;
                return true;
            }
        } else {
            return itemPlaced.contains(solutionItem.getName());
        }
        return false;
    }

    private void setupItemRequirements() {
        this.natureRune = new ItemRequirement("Nature rune", 561);
        this.natureRune.setHighlightInInventory(true);
        this.flowers = new ItemRequirements(LogicType.OR, "Flowers", new ItemRequirement("Assorted flowers", 2460), new ItemRequirement("Black flowers", 2476), new ItemRequirement("Blue flowers", 2464), new ItemRequirement("Exotic flowers", 3698), new ItemRequirement("Marigolds", 6010), new ItemRequirement("Mixed flowers", 2472), new ItemRequirement("Purple flowers", 2468), new ItemRequirement("Orange flowers", 2470), new ItemRequirement("Red flowers", 2462), new ItemRequirement("White flowers", 2474), new ItemRequirement("Yellow flowers", 2466));
        ItemRequirement grimyIritLeaf = new ItemRequirement("Grimy irit leaf", 209);
        ItemRequirement cleanIritLeaf = new ItemRequirement("Irit leaf", 259);
        this.iritLeaf = new ItemRequirements(LogicType.OR, "Irit leaf", cleanIritLeaf, grimyIritLeaf);
        this.iritLeaf.setDisplayMatchedItemName(true);
        this.iritLeaf.setTooltip("Grimy Irit Leaf is also valid.");
        this.flowersOrIrit = new ItemRequirements(LogicType.OR, "Irit leaf or a flower", this.iritLeaf, this.flowers);
        this.flowersOrIrit.setHighlightInInventory(true);
        this.adamantChainbody = new ItemRequirement("Adamant chainbody", 1111);
        this.adamantChainbody.setHighlightInInventory(true);
        this.wineOfZamorak = new ItemRequirement("Wine of zamorak", 245);
        ItemRequirement zamorakBrew1 = new ItemRequirement("Zamorak brew(1)", 193);
        ItemRequirement zamorakBrew2 = new ItemRequirement("Zamorak brew(2)", 191);
        ItemRequirement zamorakBrew3 = new ItemRequirement("Zamorak brew(3)", 189);
        ItemRequirement zamorakBrew4 = new ItemRequirement("Zamorak brew(4)", 2450);
        this.zamorakBrew = new ItemRequirements("Zamorak brew", zamorakBrew1, zamorakBrew2, zamorakBrew3, zamorakBrew4);
        this.zamorakBrew.setDisplayMatchedItemName(true);
        this.wineOfZamorakOrZamorakBrew = new ItemRequirements(LogicType.OR, "Wine of zamorak or Zamorak brew", this.wineOfZamorak, this.zamorakBrew);
        this.wineOfZamorakOrZamorakBrew.setHighlightInInventory(true);
        this.cabbage = new ItemRequirement("Cabbage", 1965);
        this.cabbage.setHighlightInInventory(true);
        ItemRequirement blackKnifeClean = new ItemRequirement("Black knife", 869);
        ItemRequirement blackKnifeP = new ItemRequirement("Black knife(p)", 874);
        ItemRequirement blackKnifePplus = new ItemRequirement("Black knife(p+)", 5658);
        ItemRequirement blackKnifePplusPlus = new ItemRequirement("Black knife(p++)", 5665);
        this.blackKnife = new ItemRequirements(LogicType.OR, "Black knife", blackKnifeClean, blackKnifeP, blackKnifePplus, blackKnifePplusPlus);
        this.blackKnife.setHighlightInInventory(true);
        ItemRequirement blackDaggerClean = new ItemRequirement("Black dagger", 1217);
        ItemRequirement blackDaggerP = new ItemRequirement("Black dagger(p)", 1233);
        ItemRequirement blackDaggerPplus = new ItemRequirement("Black dagger(p+)", 5682);
        ItemRequirement blackDaggerPplusPlus = new ItemRequirement("Black dagger(p++)", 5700);
        this.blackDagger = new ItemRequirements(LogicType.OR, "Black dagger", blackDaggerClean, blackDaggerP, blackDaggerPplus, blackDaggerPplusPlus);
        this.blackKnifeOrDagger = new ItemRequirements(LogicType.OR, "Black knife or black dagger", this.blackKnife, this.blackDagger);
        this.blackKnifeOrDagger.setHighlightInInventory(true);
    }

    @Override
    protected void setupSteps() {
        this.items = new HashMap();
        this.pillars = new ArrayList();
        this.unknownItems = new ArrayList();
        this.unknownItems.addAll(Arrays.asList("1st.", "2nd.", "3rd.", "4th.", "5th.", "6th."));
        String SOUTHWEST_ID = "south west";
        this.pillars.add(new BaxtorianPillar(this.getQuestHelper(), new WorldPoint(2600, 9909, 0), new WorldPoint(2600, 9909, 0), "I am the ", SOUTHWEST_ID));
        String WEST_ID = "west";
        this.pillars.add(new BaxtorianPillar(this.getQuestHelper(), new WorldPoint(2600, 9913, 0), new WorldPoint(2600, 9911, 0), "I am next to the ", WEST_ID));
        String NORTHWEST_ID = "north west";
        this.pillars.add(new BaxtorianPillar(this.getQuestHelper(), new WorldPoint(2607, 9913, 0), new WorldPoint(2600, 9913, 0), "I am opposite the ", NORTHWEST_ID));
        String EAST_ID = "east";
        this.pillars.add(new BaxtorianPillar(this.getQuestHelper(), new WorldPoint(2607, 9911, 0), new WorldPoint(2607, 9911, 0), "I am not next to the ", EAST_ID));
        String NORTHEAST_ID = "north east";
        this.pillars.add(new BaxtorianPillar(this.getQuestHelper(), new WorldPoint(2607, 9909, 0), new WorldPoint(2607, 9913, 0), "I am not the ", NORTHEAST_ID));
        String SOUTHEAST_ID = "south east";
        this.pillars.add(new BaxtorianPillar(this.getQuestHelper(), new WorldPoint(2607, 9909, 0), new WorldPoint(2607, 9909, 0), null, SOUTHEAST_ID));
        this.setupItemRequirements();
        this.items.put("1st.", this.natureRune);
        this.items.put("2nd.", this.flowersOrIrit);
        this.items.put("3rd.", this.blackKnifeOrDagger);
        this.items.put("4th.", this.wineOfZamorakOrZamorakBrew);
        this.items.put("5th.", this.adamantChainbody);
        this.items.put("6th.", this.cabbage);
    }

    @Override
    public Collection<QuestStep> getSteps() {
        ArrayList<QuestStep> steps = new ArrayList<QuestStep>();
        for (BaxtorianPillar pillar : this.pillars) {
            steps.add(pillar.getInspectStep());
            steps.add(pillar.getUseStep());
        }
        return steps;
    }

    @Override
    @Subscribe
    public void onWidgetLoaded(WidgetLoaded widgetLoaded) {
        Widget hintWidget;
        if (widgetLoaded.getGroupId() == 229 && (hintWidget = this.client.getWidget(229, 1)) != null) {
            this.clientThread.invokeLater(() -> this.checkHint(hintWidget.getText()));
        }
    }
}

