/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.songoftheelves;

import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ObjectStep;
import java.util.Collections;
import net.runelite.api.coords.WorldPoint;

public class BaxtorianPillar {
    private final WorldPoint wp;
    private final String answerText;
    private DetailedQuestStep inspectStep;
    private DetailedQuestStep useStep;
    private ItemRequirement placedItem;
    private ItemRequirement solution;

    public BaxtorianPillar(QuestHelper questHelper, WorldPoint inspectWp, WorldPoint wp, String answerText, String name) {
        this.wp = wp;
        this.answerText = answerText;
        this.inspectStep = new ObjectStep(questHelper, 2005, inspectWp, "Inspect the marked pillar.", new Requirement[0]);
        this.useStep = new ObjectStep(questHelper, 2005, wp, "Place the correct item on the " + name + " pillar.", new Requirement[0]);
    }

    public void setSolution(ItemRequirement solution) {
        this.solution = solution;
        this.useStep.setRequirements(Collections.singletonList(solution));
        this.useStep.addIcon(solution.getId());
    }

    public WorldPoint getWp() {
        return this.wp;
    }

    public String getAnswerText() {
        return this.answerText;
    }

    public DetailedQuestStep getInspectStep() {
        return this.inspectStep;
    }

    public void setInspectStep(DetailedQuestStep inspectStep) {
        this.inspectStep = inspectStep;
    }

    public DetailedQuestStep getUseStep() {
        return this.useStep;
    }

    public void setUseStep(DetailedQuestStep useStep) {
        this.useStep = useStep;
    }

    public ItemRequirement getPlacedItem() {
        return this.placedItem;
    }

    public void setPlacedItem(ItemRequirement placedItem) {
        this.placedItem = placedItem;
    }

    public ItemRequirement getSolution() {
        return this.solution;
    }
}

