/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.songoftheelves;

import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questhelpers.QuestUtil;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.List;
import net.runelite.api.coords.WorldPoint;

public class AmloddLightPuzzle
extends ConditionalStep {
    Zone f0;
    Zone f1;
    Zone f2;
    ItemRequirement handMirrorHighlighted;
    ItemRequirement redCrystalHighlighted;
    ItemRequirement fracturedCrystalHighlighted;
    ItemRequirement greenCrystalHighlighted;
    ItemRequirement cyanCrystalHighlighted;
    ItemRequirement yellowCrystalHighlighted;
    DetailedQuestStep resetPuzzle;
    DetailedQuestStep p1Pillar1;
    DetailedQuestStep p1Pillar2;
    DetailedQuestStep p1Pillar3;
    DetailedQuestStep p1Pillar4;
    DetailedQuestStep p1Pillar5;
    DetailedQuestStep p1Pillar6;
    DetailedQuestStep p1Pillar7;
    DetailedQuestStep p1Pillar8;
    DetailedQuestStep p1Pillar9;
    DetailedQuestStep p1Pillar10;
    DetailedQuestStep p1Pillar11;
    DetailedQuestStep p1Pillar12;
    DetailedQuestStep p1Pillar13;
    DetailedQuestStep p1Pillar14;
    DetailedQuestStep p1Pillar15;
    DetailedQuestStep p1Pillar16;
    DetailedQuestStep p1Pillar17;
    DetailedQuestStep p1Pillar18;
    DetailedQuestStep p1Pillar19;
    DetailedQuestStep p1Pillar20;
    DetailedQuestStep collectMirrors;
    DetailedQuestStep talkToAmlodd;
    DetailedQuestStep goF0ToF1NW;
    DetailedQuestStep goF1ToF0NW;
    DetailedQuestStep goF2ToF1NW;
    ConditionalStep goToF0NW;
    ConditionalStep goToF1NW;
    ConditionalStep goToF0Middle;
    Requirement hasMirrorsAndCrystal;
    Requirement onF1;
    Requirement onF2;
    Requirement onF0;
    Requirement notResetCrwys;
    Requirement r1;
    Requirement r2;
    Requirement r3;
    Requirement r4;
    Requirement r5;
    Requirement r6;
    Requirement r7;
    Requirement r8;
    Requirement r9;
    Requirement r10;
    Requirement r11;
    Requirement r12;
    Requirement r13;
    Requirement r14;
    Requirement r15;
    Requirement r16;
    Requirement r17;
    Requirement r18;
    Requirement r19;

    public AmloddLightPuzzle(QuestHelper questHelper, ConditionalStep goToF1Steps, ConditionalStep goToF0Steps) {
        super(questHelper, (QuestStep)goToF1Steps, new Requirement[0]);
        this.setupItemRequirements();
        this.setupZones();
        this.setupConditions();
        this.setupSteps();
        this.setupConditionalSteps();
        this.collectMirrors.addSubSteps(goToF1Steps);
        this.goToF0Middle = goToF0Steps;
        this.addStep(new Conditions(this.onF1, this.notResetCrwys), this.resetPuzzle);
        this.addStep(new Conditions(this.notResetCrwys), goToF1Steps);
        this.addStep(new Conditions(this.onF0, this.r19), this.p1Pillar20);
        this.addStep(new Conditions(this.onF0, this.r18), this.p1Pillar19);
        this.addStep(new Conditions(this.onF0, this.r17), this.p1Pillar18);
        this.addStep(new Conditions(this.onF0, this.r16), this.p1Pillar17);
        this.addStep(new Conditions(this.onF0, this.r15), this.p1Pillar16);
        this.addStep(new Conditions(this.onF0, this.r14), this.p1Pillar15);
        this.addStep(new Conditions(this.onF0, this.r13), this.p1Pillar14);
        this.addStep(new Conditions(this.onF0, this.r12), this.p1Pillar13);
        this.addStep(new Conditions(this.onF0, this.r11), this.p1Pillar12);
        this.addStep(new Conditions(this.onF0, this.r10), this.p1Pillar11);
        this.addStep(new Conditions(this.r10), this.goToF0Middle);
        this.addStep(new Conditions(this.onF1, this.r9), this.p1Pillar10);
        this.addStep(new Conditions(this.onF1, this.r8), this.p1Pillar9);
        this.addStep(new Conditions(this.r8), this.goToF1NW);
        this.addStep(new Conditions(this.onF0, this.r7), this.p1Pillar8);
        this.addStep(new Conditions(this.r7), this.goToF0NW);
        this.addStep(new Conditions(this.onF1, this.r6), this.p1Pillar7);
        this.addStep(new Conditions(this.onF1, this.r5), this.p1Pillar6);
        this.addStep(new Conditions(this.onF1, this.r4), this.p1Pillar5);
        this.addStep(new Conditions(this.onF1, this.r3), this.p1Pillar4);
        this.addStep(new Conditions(this.onF1, this.r2), this.p1Pillar3);
        this.addStep(new Conditions(this.onF1, this.r1), this.p1Pillar2);
        this.addStep(new Conditions(this.onF1, this.hasMirrorsAndCrystal), this.p1Pillar1);
        this.addStep(this.onF1, this.collectMirrors);
    }

    protected void setupItemRequirements() {
        this.handMirrorHighlighted = new ItemRequirement("Hand mirror", 23775);
        this.handMirrorHighlighted.setHighlightInInventory(true);
        this.redCrystalHighlighted = new ItemRequirement("Red crystal", 23776);
        this.redCrystalHighlighted.setHighlightInInventory(true);
        this.fracturedCrystalHighlighted = new ItemRequirement("Fractured crystal", 23784);
        this.fracturedCrystalHighlighted.setHighlightInInventory(true);
        this.greenCrystalHighlighted = new ItemRequirement("Green crystal", 23778);
        this.greenCrystalHighlighted.setHighlightInInventory(true);
        this.cyanCrystalHighlighted = new ItemRequirement("Cyan crystal", 23779);
        this.cyanCrystalHighlighted.setHighlightInInventory(true);
        this.yellowCrystalHighlighted = new ItemRequirement("Yellow crystal", 23777);
        this.yellowCrystalHighlighted.setHighlightInInventory(true);
    }

    protected void setupConditionalSteps() {
        this.goToF0NW = new ConditionalStep(this.getQuestHelper(), (QuestStep)this.talkToAmlodd, "Go to the bottom floor of the library.", new Requirement[0]);
        this.goToF0NW.addStep(this.onF1, this.goF1ToF0NW);
        this.goToF0NW.addStep(this.onF2, this.goF2ToF1NW);
        this.goToF1NW = new ConditionalStep(this.getQuestHelper(), (QuestStep)this.talkToAmlodd, "Go to the middle floor of the library.", new Requirement[0]);
        this.goToF1NW.addStep(this.onF2, this.goF2ToF1NW);
        this.goToF1NW.addStep(this.onF0, this.goF0ToF1NW);
    }

    protected void setupZones() {
        this.f0 = new Zone(new WorldPoint(2565, 6080, 0), new WorldPoint(2740, 6204, 0));
        this.f1 = new Zone(new WorldPoint(2565, 6080, 1), new WorldPoint(2740, 6204, 1));
        this.f2 = new Zone(new WorldPoint(2565, 6080, 2), new WorldPoint(2740, 6204, 2));
    }

    protected void setupSteps() {
        this.talkToAmlodd = new NpcStep(this.getQuestHelper(), 8898, new WorldPoint(2353, 3179, 0), "Talk to Lord Amlodd in Lletya.", new Requirement[0]);
        this.talkToAmlodd.addDialogStep("Yes.");
        this.collectMirrors = new ObjectStep(this.getQuestHelper(), 35076, new WorldPoint(2623, 6118, 1), "Collect all the items from the dispenser in the central room.", new Requirement[0]);
        this.collectMirrors.setWorldMapPoint(new WorldPoint(2815, 6118, 1));
        this.collectMirrors.addDialogStep("Take everything.");
        this.resetPuzzle = new ObjectStep(this.getQuestHelper(), 35076, new WorldPoint(2623, 6118, 1), "Pull the lever in the dispenser in the central room.", new Requirement[0]);
        this.resetPuzzle.setWorldMapPoint(new WorldPoint(2815, 6118, 1));
        this.resetPuzzle.addDialogSteps("Pull the lever.", "Pull it.");
        this.p1Pillar1 = new ObjectStep(this.getQuestHelper(), 35286, new WorldPoint(2609, 6144, 1), "Add a fractured crystal to the pillar to the north.", this.fracturedCrystalHighlighted);
        this.p1Pillar1.setWorldMapPoint(new WorldPoint(2801, 6144, 1));
        this.p1Pillar1.addIcon(23784);
        this.p1Pillar2 = new ObjectStep(this.getQuestHelper(), 35276, new WorldPoint(2595, 6144, 1), "Add a mirror to the pillar to the west. Rotate it to point the light north.", this.handMirrorHighlighted);
        this.p1Pillar2.setWorldMapPoint(new WorldPoint(2787, 6144, 1));
        this.p1Pillar2.addIcon(23775);
        this.p1Pillar3 = new ObjectStep(this.getQuestHelper(), 35277, new WorldPoint(2595, 6158, 1), "Add a red crystal to the pillar to the north.", this.redCrystalHighlighted);
        this.p1Pillar3.setWorldMapPoint(new WorldPoint(2787, 6158, 1));
        this.p1Pillar3.addIcon(23776);
        this.p1Pillar4 = new ObjectStep(this.getQuestHelper(), 35278, new WorldPoint(2595, 6172, 1), "Add a mirror to the pillar to the north. Rotate it to point the light east.", this.handMirrorHighlighted);
        this.p1Pillar4.setWorldMapPoint(new WorldPoint(2787, 6172, 1));
        this.p1Pillar4.addIcon(23775);
        this.p1Pillar5 = new ObjectStep(this.getQuestHelper(), 35288, new WorldPoint(2609, 6172, 1), "Add a mirror to the pillar to the east. Rotate it to point the light north.", this.handMirrorHighlighted);
        this.p1Pillar5.setWorldMapPoint(new WorldPoint(2801, 6172, 1));
        this.p1Pillar5.addIcon(23775);
        this.p1Pillar6 = new ObjectStep(this.getQuestHelper(), 35289, new WorldPoint(2609, 6186, 1), "Add a mirror to the pillar to the north. Rotate it to point the light west.", this.handMirrorHighlighted);
        this.p1Pillar6.setWorldMapPoint(new WorldPoint(2801, 6186, 1));
        this.p1Pillar6.addIcon(23775);
        this.p1Pillar7 = new ObjectStep(this.getQuestHelper(), 35279, new WorldPoint(2595, 6186, 1), "Add a mirror to the pillar to the west. Rotate it to point the light down.", this.handMirrorHighlighted);
        this.p1Pillar7.setWorldMapPoint(new WorldPoint(2787, 6186, 1));
        this.p1Pillar7.addIcon(23775);
        this.p1Pillar8 = new ObjectStep(this.getQuestHelper(), 36701, new WorldPoint(2595, 6186, 0), "Add a mirror to the pillar with light coming down into it. Rotate it to point the light south.", this.handMirrorHighlighted);
        this.p1Pillar8.addIcon(23775);
        this.p1Pillar9 = new ObjectStep(this.getQuestHelper(), 35287, new WorldPoint(2609, 6158, 1), "Add a mirror to a pillar to the north of where you placed the fractured crystal. Rotate it to point the light east.", this.handMirrorHighlighted);
        this.p1Pillar9.setWorldMapPoint(new WorldPoint(2801, 6158, 1));
        this.p1Pillar9.addIcon(23775);
        this.p1Pillar10 = new ObjectStep(this.getQuestHelper(), 35293, new WorldPoint(2623, 6158, 1), "Add a mirror to a pillar to the east. Rotate it to point the light down.", this.handMirrorHighlighted);
        this.p1Pillar10.setWorldMapPoint(new WorldPoint(2815, 6158, 1));
        this.p1Pillar10.addIcon(23775);
        this.p1Pillar11 = new ObjectStep(this.getQuestHelper(), 36705, new WorldPoint(2623, 6158, 0), "Add a mirror to the pillar near the stairs. Rotate it to point the light south.", this.handMirrorHighlighted);
        this.p1Pillar11.addIcon(23775);
        this.p1Pillar12 = new ObjectStep(this.getQuestHelper(), 35151, new WorldPoint(2623, 6130, 0), "Add a mirror to the pillar to the south. Rotate it to point the light west.", this.handMirrorHighlighted);
        this.p1Pillar12.addIcon(23775);
        this.p1Pillar13 = new ObjectStep(this.getQuestHelper(), 35145, new WorldPoint(2609, 6130, 0), "Add a mirror to the pillar to the west. Rotate it to point the light south.", this.handMirrorHighlighted);
        this.p1Pillar13.addIcon(23775);
        this.p1Pillar14 = new ObjectStep(this.getQuestHelper(), 35144, new WorldPoint(2609, 6116, 0), "Add a mirror to the pillar to the south. Rotate it to point the light west.", this.handMirrorHighlighted);
        this.p1Pillar14.addIcon(23775);
        this.p1Pillar15 = new ObjectStep(this.getQuestHelper(), 35138, new WorldPoint(2595, 6116, 0), "Add a mirror to the pillar to the west. Rotate it to point the light north.", this.handMirrorHighlighted);
        this.p1Pillar15.addIcon(23775);
        this.p1Pillar16 = new ObjectStep(this.getQuestHelper(), 35139, new WorldPoint(2595, 6130, 0), "Add a green crystal to the pillar to the north.", this.greenCrystalHighlighted);
        this.p1Pillar16.addIcon(23778);
        this.p1Pillar17 = new ObjectStep(this.getQuestHelper(), 35140, new WorldPoint(2595, 6144, 0), "Add a yellow crystal to the pillar to the north.", this.yellowCrystalHighlighted);
        this.p1Pillar17.addIcon(23777);
        this.p1Pillar18 = new ObjectStep(this.getQuestHelper(), 35141, new WorldPoint(2595, 6158, 0), "Add a mirror to the pillar to the north. Rotate it to point the light east.", this.handMirrorHighlighted);
        this.p1Pillar18.addIcon(23775);
        this.p1Pillar19 = new ObjectStep(this.getQuestHelper(), 35142, new WorldPoint(2595, 6172, 0), "Add a mirror to the pillar to the north. Rotate it to point the light east.", this.handMirrorHighlighted);
        this.p1Pillar19.addIcon(23775);
        this.p1Pillar20 = new ObjectStep(this.getQuestHelper(), 35148, new WorldPoint(2609, 6172, 0), "Add a mirror to the pillar to the east. Rotate it to point the light south.", this.handMirrorHighlighted);
        this.p1Pillar20.addIcon(23775);
        this.goF0ToF1NW = new ObjectStep(this.getQuestHelper(), 35387, new WorldPoint(2581, 6203, 0), "", new Requirement[0]);
        this.goF1ToF0NW = new ObjectStep(this.getQuestHelper(), 35389, new WorldPoint(2581, 6203, 1), "", new Requirement[0]);
        this.goF1ToF0NW.addDialogStep("Climb down.");
        this.goF1ToF0NW.setWorldMapPoint(new WorldPoint(2773, 6203, 1));
        this.goF2ToF1NW = new ObjectStep(this.getQuestHelper(), 35388, new WorldPoint(2581, 6203, 2), "", new Requirement[0]);
        this.goF2ToF1NW.setWorldMapPoint(new WorldPoint(2965, 6203, 2));
    }

    protected void setupConditions() {
        this.hasMirrorsAndCrystal = new Conditions(this.handMirrorHighlighted, this.redCrystalHighlighted, this.fracturedCrystalHighlighted, this.yellowCrystalHighlighted);
        this.onF0 = new ZoneRequirement(this.f0);
        this.onF1 = new ZoneRequirement(this.f1);
        this.onF2 = new ZoneRequirement(this.f2);
        int CYAN = 2;
        int BLUE = 3;
        int MAGENTA = 4;
        int RED = 5;
        int GREEN = 7;
        this.notResetCrwys = new VarbitRequirement(8958, MAGENTA);
        this.r1 = new Conditions(new VarbitRequirement(8947, MAGENTA), new VarbitRequirement(8969, MAGENTA));
        this.r2 = new Conditions(new VarbitRequirement(8948, MAGENTA), this.r1);
        this.r3 = new Conditions(new VarbitRequirement(8949, RED), this.r1);
        this.r4 = new Conditions(new VarbitRequirement(8950, RED), this.r1);
        this.r5 = new Conditions(new VarbitRequirement(8952, RED), this.r1);
        this.r6 = new Conditions(new VarbitRequirement(8954, RED), this.r1);
        this.r7 = new Conditions(new VarbitRequirement(8584, RED), this.r1);
        this.r8 = new Conditions(new VarbitRequirement(8867, RED), this.r1);
        this.r9 = new Conditions(new VarbitRequirement(8971, MAGENTA), this.r1);
        this.r10 = new Conditions(new VarbitRequirement(8586, MAGENTA), this.r1);
        this.r11 = new Conditions(new VarbitRequirement(8858, MAGENTA), this.r1);
        this.r12 = new Conditions(new VarbitRequirement(8854, BLUE), this.r1);
        this.r13 = new Conditions(new VarbitRequirement(8853, BLUE), this.r1);
        this.r14 = new Conditions(new VarbitRequirement(8843, BLUE), this.r1);
        this.r15 = new Conditions(new VarbitRequirement(8842, BLUE), this.r1);
        this.r16 = new Conditions(new VarbitRequirement(8841, CYAN), this.r1);
        this.r17 = new Conditions(new VarbitRequirement(8861, GREEN), this.r1);
        this.r18 = new Conditions(new VarbitRequirement(8862, GREEN), this.r1);
        this.r19 = new Conditions(new VarbitRequirement(8866, RED), this.r1);
    }

    public List<QuestStep> getDisplaySteps() {
        return QuestUtil.toArrayList(this.resetPuzzle, this.collectMirrors, this.p1Pillar1, this.p1Pillar2, this.p1Pillar3, this.p1Pillar4, this.p1Pillar5, this.p1Pillar6, this.p1Pillar7, this.goToF0NW, this.goToF0NW, this.p1Pillar8, this.goToF1NW, this.p1Pillar9, this.p1Pillar10, this.goToF0Middle, this.p1Pillar11, this.p1Pillar12, this.p1Pillar13, this.p1Pillar14, this.p1Pillar15, this.p1Pillar16, this.p1Pillar17, this.p1Pillar18, this.p1Pillar19, this.p1Pillar20);
    }
}

