/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.sleepinggiants;

import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.FreeInventorySlotRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.util.Operation;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.widget.WidgetPresenceRequirement;
import com.questhelper.requirements.widget.WidgetSpriteRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import com.questhelper.steps.WidgetDetails;
import com.questhelper.steps.WidgetStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@QuestDescriptor(quest=QuestHelperQuest.SLEEPING_GIANTS)
public class SleepingGiants
extends BasicQuestHelper {
    private static final Logger log = LoggerFactory.getLogger(SleepingGiants.class);
    ItemRequirement oakLogs;
    ItemRequirement wool;
    ItemRequirement nails;
    ItemRequirement hammer;
    ItemRequirement chisel;
    ItemRequirement iceGloves;
    ItemRequirement alKharidTeleport;
    ItemRequirement bucket;
    ItemRequirement bucketOfWater;
    FreeInventorySlotRequirement freeInventorySpace;
    ItemRequirement oneOakLog;
    ItemRequirement twoOakLogs;
    ItemRequirement fiveNails;
    ItemRequirement preform;
    QuestStep strikeHillGiant;
    QuestStep speakToKovac;
    QuestStep fixPolishingStone;
    QuestStep fixGrindstone;
    QuestStep fixHammer;
    QuestStep speakToKovacAfterRepairs;
    QuestStep searchCrate;
    QuestStep fillCrucible;
    QuestStep speakToKovacAboutMould;
    QuestStep pourMetal;
    QuestStep coolDownSword;
    QuestStep speakToKovacContinue;
    QuestStep interactWithMould;
    QuestStep selectForteTab;
    QuestStep selectForte;
    QuestStep selectBladesTab;
    QuestStep selectBlade;
    QuestStep selectTipsTab;
    QuestStep selectTip;
    QuestStep setMould;
    QuestStep talkToKovakAfterMould;
    QuestStep getPreform;
    QuestStep dunkPreform;
    QuestStep hitPreformWhileRed;
    QuestStep coolPreformToGrindstone;
    QuestStep dunkPreformToGrindstone;
    QuestStep grindstonePreform;
    QuestStep coolPreformToPolish;
    QuestStep heatPreformToPolish;
    QuestStep polishPreform;
    QuestStep handInPreform;
    QuestStep goToDesertPlateau;
    QuestStep takeHammer;
    QuestStep enterFoundry;
    QuestStep enterFoundryToMakeWeapon;
    QuestStep takeBucket;
    QuestStep fillBucketWaterfall;
    ZoneRequirement onDesertPlateau;
    ZoneRequirement inGiantsFoundry;
    VarbitRequirement grindstoneFixed;
    VarbitRequirement polishingStoneFixed;
    VarbitRequirement hammerFixed;
    VarbitRequirement commissionReceived;
    VarbitRequirement crateSearched;
    VarbitRequirement crucibleFilled;
    VarbitRequirement talkedToKovacAboutMould;
    VarbitRequirement shouldSetMould;
    VarbitRequirement mouldSet;
    VarbitRequirement talkedToKovacAboutPouringMetal;
    VarbitRequirement metalPoured;
    VarbitRequirement preformObtained;
    VarbitRequirement swordMade;
    VarbitRequirement preformHandedIn;
    VarbitRequirement storedPreform;
    VarbitRequirement metalHeated;
    VarbitRequirement metalHammered;
    VarbitRequirement metalTooCoolToGrindstone;
    VarbitRequirement metalTooHotToGrindstone;
    VarbitRequirement metalGrinded;
    VarbitRequirement metalTooHotForPolishing;
    VarbitRequirement metalTooCoolForPolishing;
    Requirement selectingMould;
    Requirement noForteSelected;
    Requirement noBladeSelected;
    Requirement noTipSelected;
    Requirement forteTabOpen;
    Requirement bladeTabOpen;
    Requirement tipTabOpen;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.setupZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        ConditionalStep startQuest = new ConditionalStep((QuestHelper)this, this.strikeHillGiant, new Requirement[0]);
        startQuest.addStep(new Conditions(LogicType.NOR, this.onDesertPlateau), this.goToDesertPlateau);
        startQuest.addStep(new Conditions(LogicType.NOR, this.hammer), this.takeHammer);
        steps.put(0, startQuest);
        ConditionalStep speakToKovacOnDesertPlateau = new ConditionalStep((QuestHelper)this, this.speakToKovac, new Requirement[0]);
        speakToKovacOnDesertPlateau.addStep(new Conditions(LogicType.NOR, this.onDesertPlateau), this.goToDesertPlateau);
        startQuest.addStep(new Conditions(LogicType.NOR, this.hammer), this.takeHammer);
        steps.put(5, speakToKovacOnDesertPlateau);
        ConditionalStep fixMachinery = new ConditionalStep((QuestHelper)this, this.speakToKovacAfterRepairs, new Requirement[0]);
        fixMachinery.addStep(new Conditions(LogicType.NOR, this.inGiantsFoundry), this.enterFoundry);
        fixMachinery.addStep(new Conditions(LogicType.NOR, this.polishingStoneFixed), this.fixPolishingStone);
        fixMachinery.addStep(new Conditions(LogicType.NOR, this.grindstoneFixed), this.fixGrindstone);
        fixMachinery.addStep(new Conditions(LogicType.NOR, this.hammerFixed), this.fixHammer);
        steps.put(10, fixMachinery);
        steps.put(15, fixMachinery);
        ConditionalStep speakToKovacContinueAfterRepairs = new ConditionalStep((QuestHelper)this, this.speakToKovacAfterRepairs, new Requirement[0]);
        speakToKovacContinueAfterRepairs.addStep(new Conditions(LogicType.NOR, this.inGiantsFoundry), this.enterFoundry);
        steps.put(20, speakToKovacContinueAfterRepairs);
        ConditionalStep speakToKovacForCommission = new ConditionalStep((QuestHelper)this, this.handInPreform, new Requirement[0]);
        speakToKovacForCommission.addStep(new Conditions(LogicType.NOR, this.inGiantsFoundry), this.enterFoundryToMakeWeapon);
        speakToKovacForCommission.addStep(new Conditions(LogicType.NOR, this.commissionReceived), this.speakToKovacContinue);
        speakToKovacForCommission.addStep(new Conditions(LogicType.NOR, this.crateSearched), this.searchCrate);
        speakToKovacForCommission.addStep(new Conditions(LogicType.NOR, this.crucibleFilled), this.fillCrucible);
        speakToKovacForCommission.addStep(new Conditions(LogicType.NOR, this.talkedToKovacAboutMould), this.speakToKovacAboutMould);
        speakToKovacForCommission.addStep(new Conditions(this.selectingMould, this.noForteSelected, this.forteTabOpen), this.selectForte);
        speakToKovacForCommission.addStep(new Conditions(this.selectingMould, this.noForteSelected), this.selectForteTab);
        speakToKovacForCommission.addStep(new Conditions(this.selectingMould, this.noBladeSelected, this.bladeTabOpen), this.selectBlade);
        speakToKovacForCommission.addStep(new Conditions(this.selectingMould, this.noBladeSelected), this.selectBladesTab);
        speakToKovacForCommission.addStep(new Conditions(this.selectingMould, this.noTipSelected, this.tipTabOpen), this.selectTip);
        speakToKovacForCommission.addStep(new Conditions(this.selectingMould, this.noTipSelected), this.selectTipsTab);
        speakToKovacForCommission.addStep(new Conditions(this.selectingMould), this.setMould);
        speakToKovacForCommission.addStep(new Conditions(LogicType.NOR, this.mouldSet), this.interactWithMould);
        speakToKovacForCommission.addStep(new Conditions(LogicType.NOR, this.talkedToKovacAboutPouringMetal), this.talkToKovakAfterMould);
        speakToKovacForCommission.addStep(new Conditions(LogicType.NOR, this.metalPoured), this.pourMetal);
        speakToKovacForCommission.addStep(new Conditions(new Conditions(LogicType.NOR, this.preformObtained), new Conditions(LogicType.OR, this.iceGloves, this.bucketOfWater)), this.coolDownSword);
        speakToKovacForCommission.addStep(new Conditions(new Conditions(LogicType.NOR, this.preformObtained), this.bucket), this.fillBucketWaterfall);
        speakToKovacForCommission.addStep(new Conditions(new Conditions(LogicType.NOR, this.preformObtained), new Conditions(LogicType.NOR, this.bucket)), this.takeBucket);
        ConditionalStep swordCreation = new ConditionalStep((QuestHelper)this, this.dunkPreform, new Requirement[0]);
        swordCreation.addStep(this.storedPreform, this.getPreform);
        swordCreation.addStep(this.swordMade, this.handInPreform);
        swordCreation.addStep(new Conditions(this.metalGrinded, this.metalTooCoolForPolishing), this.heatPreformToPolish);
        swordCreation.addStep(new Conditions(this.metalGrinded, this.metalTooHotForPolishing), this.coolPreformToPolish);
        swordCreation.addStep(this.metalGrinded, this.polishPreform);
        swordCreation.addStep(new Conditions(this.metalHammered, this.metalTooCoolToGrindstone), this.dunkPreformToGrindstone);
        swordCreation.addStep(new Conditions(this.metalHammered, this.metalTooHotToGrindstone), this.coolPreformToGrindstone);
        swordCreation.addStep(this.metalHammered, this.grindstonePreform);
        swordCreation.addStep(this.metalHeated, this.hitPreformWhileRed);
        speakToKovacForCommission.addStep(new Conditions(LogicType.NOR, this.preformHandedIn), swordCreation);
        steps.put(25, speakToKovacForCommission);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.oakLogs = new ItemRequirement("Oak Logs", 1521);
        this.oakLogs.setQuantity(3);
        this.wool = new ItemRequirement("Wool", 1737);
        this.nails = new ItemRequirement("Nails", 4819);
        this.nails.addAlternates(4820, 1539, 4821, 4822, 4823, 4824);
        this.nails.setQuantity(10);
        this.hammer = new ItemRequirement("Hammer", 2347);
        this.hammer.addAlternates(25644);
        this.hammer.canBeObtainedDuringQuest();
        this.hammer.setTooltip("Imcando hammer also works");
        this.chisel = new ItemRequirement("Chisel", 1755);
        this.iceGloves = new ItemRequirement("Ice Gloves", 1580);
        this.iceGloves.setTooltip("Allows you to skip filling and using a bucket of water.");
        this.bucket = new ItemRequirement("Bucket", 1925);
        this.bucket.canBeObtainedDuringQuest();
        this.bucket.setHighlightInInventory(true);
        this.bucketOfWater = new ItemRequirement("Bucket of Water", 1929);
        this.bucketOfWater.canBeObtainedDuringQuest();
        this.freeInventorySpace = new FreeInventorySlotRequirement(20);
        this.alKharidTeleport = new ItemRequirement("Al Kharid Teleport", ItemCollections.RING_OF_DUELINGS);
        this.alKharidTeleport.addAlternates(ItemCollections.AMULET_OF_GLORIES);
        this.alKharidTeleport.setTooltip("Ring of Dueling or Amulet of Glory; Can be used to quickly reach the Giants' Foundry.");
        this.twoOakLogs = new ItemRequirement("Oak Logs", 1521);
        this.twoOakLogs.setQuantity(2);
        this.fiveNails = new ItemRequirement("Nails", 4819);
        this.fiveNails.addAlternates(4820, 1539, 4821, 4822, 4823, 4824);
        this.fiveNails.setQuantity(5);
        this.oneOakLog = new ItemRequirement("Oak Logs", 1521);
        this.preform = new ItemRequirement("Preform", 27010).equipped();
    }

    public void setupZones() {
        Zone desertPlateau = new Zone(new WorldPoint(3375, 3169, 0), new WorldPoint(3349, 3143, 0));
        this.onDesertPlateau = new ZoneRequirement(desertPlateau);
        Zone giantsFoundry = new Zone(new WorldPoint(3357, 11480, 0), new WorldPoint(3380, 11510, 0));
        this.inGiantsFoundry = new ZoneRequirement(giantsFoundry);
    }

    public void setupConditions() {
        this.grindstoneFixed = new VarbitRequirement(13905, 2, Operation.EQUAL);
        this.polishingStoneFixed = new VarbitRequirement(13906, 2, Operation.EQUAL);
        this.hammerFixed = new VarbitRequirement(13904, 2, Operation.EQUAL);
        this.commissionReceived = new VarbitRequirement(13903, 10, Operation.GREATER_EQUAL);
        this.crateSearched = new VarbitRequirement(13903, 15, Operation.GREATER_EQUAL);
        this.crucibleFilled = new VarbitRequirement(13903, 25, Operation.GREATER_EQUAL);
        this.talkedToKovacAboutMould = new VarbitRequirement(13903, 30, Operation.GREATER_EQUAL);
        this.shouldSetMould = new VarbitRequirement(13903, 30, Operation.GREATER_EQUAL);
        this.mouldSet = new VarbitRequirement(13903, 35, Operation.GREATER_EQUAL);
        this.talkedToKovacAboutPouringMetal = new VarbitRequirement(13903, 40, Operation.GREATER_EQUAL);
        this.metalPoured = new VarbitRequirement(13903, 45, Operation.GREATER_EQUAL);
        this.preformObtained = new VarbitRequirement(13903, 50, Operation.GREATER_EQUAL);
        this.selectingMould = new WidgetPresenceRequirement(718, 2);
        this.noForteSelected = new VarbitRequirement(13910, 0);
        this.noBladeSelected = new VarbitRequirement(13911, 0);
        this.noTipSelected = new VarbitRequirement(13912, 0);
        this.forteTabOpen = new WidgetSpriteRequirement(718, 12, 1, 297);
        this.bladeTabOpen = new WidgetSpriteRequirement(718, 12, 10, 297);
        this.tipTabOpen = new WidgetSpriteRequirement(718, 12, 19, 297);
        this.storedPreform = new VarbitRequirement(13947, 1, Operation.GREATER_EQUAL);
        this.metalHeated = new VarbitRequirement(13948, 720, Operation.GREATER_EQUAL);
        this.metalHammered = new VarbitRequirement(13949, 333, Operation.GREATER_EQUAL);
        this.metalTooCoolToGrindstone = new VarbitRequirement(13948, 340, Operation.LESS_EQUAL);
        this.metalTooHotToGrindstone = new VarbitRequirement(13948, 620, Operation.GREATER_EQUAL);
        this.metalGrinded = new VarbitRequirement(13949, 666, Operation.GREATER_EQUAL);
        this.metalTooHotForPolishing = new VarbitRequirement(13948, 333, Operation.GREATER_EQUAL);
        this.metalTooCoolForPolishing = new VarbitRequirement(13948, 30, Operation.LESS_EQUAL);
        this.swordMade = new VarbitRequirement(13949, 1000);
        this.preformHandedIn = new VarbitRequirement(13903, 55, Operation.GREATER_EQUAL);
    }

    public void setupSteps() {
        this.goToDesertPlateau = new DetailedQuestStep((QuestHelper)this, new WorldPoint(3362, 3148, 0), "Go to the Desert Plateau east of Al Kharid to start the quest.", Arrays.asList(this.oakLogs, this.wool, this.nails, this.chisel), Arrays.asList(this.iceGloves));
        ((DetailedQuestStep)this.goToDesertPlateau).setLinePoints(Arrays.asList(new WorldPoint(3293, 3180, 0), new WorldPoint(3306, 3180, 0), new WorldPoint(3313, 3171, 0), new WorldPoint(3320, 3171, 0), new WorldPoint(3333, 3175, 0), new WorldPoint(3339, 3175, 0), new WorldPoint(3343, 3173, 0), new WorldPoint(3353, 3173, 0), new WorldPoint(3364, 3184, 0), new WorldPoint(3376, 3184, 0), new WorldPoint(3381, 3178, 0), new WorldPoint(3381, 3175, 0), new WorldPoint(3375, 3170, 0)));
        this.takeHammer = new DetailedQuestStep((QuestHelper)this, new WorldPoint(3350, 3162, 0), "Take a hammer from the crate north of the Giants' Foundry.", new Requirement[0]);
        this.takeHammer.addIcon(2347);
        this.strikeHillGiant = new NpcStep((QuestHelper)this, 11467, new WorldPoint(3361, 3147, 0), "Attempt to Strike the Hill Giant at the entrance of the cave to start the quest.", new Requirement[0]);
        this.strikeHillGiant.addDialogStep("Yes.");
        this.speakToKovac = new NpcStep((QuestHelper)this, 11468, new WorldPoint(3361, 3147, 0), "Speak to Kovac.", new Requirement[0]);
        this.enterFoundry = new ObjectStep((QuestHelper)this, 44635, new WorldPoint(3361, 3150, 0), "Enter the Giants' Foundry.", new Requirement[0]);
        this.enterFoundryToMakeWeapon = new ObjectStep((QuestHelper)this, 44635, new WorldPoint(3361, 3150, 0), "Enter the Giants' Foundry again.", new Requirement[0]);
        this.fixPolishingStone = new ObjectStep((QuestHelper)this, 44775, new WorldPoint(3363, 11485, 0), "Fix the Broken polishing wheel.", this.twoOakLogs, this.fiveNails, this.hammer);
        this.fixPolishingStone.addDialogStep("Yes.");
        this.fixGrindstone = new ObjectStep((QuestHelper)this, 44774, new WorldPoint(3362, 11492, 0), "Fix the Broken grindstone.", this.chisel);
        this.fixGrindstone.addDialogStep("Yes.");
        this.fixHammer = new ObjectStep((QuestHelper)this, 44773, new WorldPoint(3364, 11497, 0), "Fix the Broken trip hammer.", this.oneOakLog, this.fiveNails, this.hammer);
        this.fixHammer.addDialogStep("Yes.");
        this.speakToKovacAfterRepairs = new NpcStep((QuestHelper)this, 11468, "Speak to Kovac to continue.", new Requirement[0]);
        this.speakToKovacContinue = new NpcStep((QuestHelper)this, 11470, "Speak to Kovac for a commission.", new Requirement[0]);
        this.searchCrate = new ObjectStep((QuestHelper)this, 44779, new WorldPoint(3370, 11483, 0), "Take some bars & weapons from the Crate.", this.freeInventorySpace);
        this.searchCrate.addDialogStep("Yes.");
        this.fillCrucible = new ObjectStep((QuestHelper)this, 44776, "Fill the Crucible with items & bars until it is full.", new Requirement[0]);
        this.fillCrucible.addSubSteps(this.enterFoundryToMakeWeapon);
        this.speakToKovacAboutMould = new NpcStep((QuestHelper)this, 11470, "Speak to Kovac about the mould.", new Requirement[0]);
        this.interactWithMould = new ObjectStep((QuestHelper)this, 44777, "Select the mould for the forte, blade and tip.", new Requirement[0]);
        this.selectForteTab = new WidgetStep((QuestHelper)this, "Select the Forte tab.", new WidgetDetails(718, 12, 1));
        this.selectForte = new WidgetStep((QuestHelper)this, "Select the Forte that matches your commission best.", 718, 9);
        this.selectBladesTab = new WidgetStep((QuestHelper)this, "Select the Blades tab.", new WidgetDetails(718, 12, 9));
        this.selectBlade = new WidgetStep((QuestHelper)this, "Select the Blade that matches your commission best.", 718, 9);
        this.selectTipsTab = new WidgetStep((QuestHelper)this, "Select the Tips tab.", new WidgetDetails(718, 12, 18));
        this.selectTip = new WidgetStep((QuestHelper)this, "Select the Tip that matches your commission best.", 718, 9);
        this.setMould = new WidgetStep((QuestHelper)this, "Set the Mould.", 718, 6);
        this.interactWithMould.addSubSteps(this.selectForte, this.selectForteTab, this.selectBladesTab, this.selectBlade, this.selectTipsTab, this.selectTip);
        this.talkToKovakAfterMould = new NpcStep((QuestHelper)this, 11470, "Speak to Kovac about pouring the metal.", new Requirement[0]);
        this.pourMetal = new ObjectStep((QuestHelper)this, 44776, "Pour the full Crucible into the mould.", new Requirement[0]);
        this.coolDownSword = new ObjectStep((QuestHelper)this, 44777, "Pick up the sword from the mould with a bucket of water or ice gloves equipped.", this.iceGloves.equipped().showConditioned(this.iceGloves), this.bucketOfWater.showConditioned(this.bucketOfWater).highlighted());
        this.coolDownSword.addIcon(1929);
        this.fillBucketWaterfall = new ObjectStep((QuestHelper)this, 44632, "Fill the bucket with water by using it on the Waterfall.", this.bucketOfWater);
        this.takeBucket = new ObjectStep((QuestHelper)this, 33309, "Take a Bucket from the Pile of Buckets", new Requirement[0]);
        this.dunkPreform = new ObjectStep((QuestHelper)this, 44631, new WorldPoint(3372, 11497, 0), "Dunk the preform in the lava pool until it's at max heat.", new Requirement[0]);
        this.hitPreformWhileRed = new ObjectStep((QuestHelper)this, 44619, new WorldPoint(3364, 11497, 0), "Use the trip hammer while the heat bar is in the red, and re-heat it in the lava whenever it's close to yellow.", new Requirement[0]);
        this.hitPreformWhileRed.addSubSteps(this.dunkPreform);
        this.coolPreformToGrindstone = new ObjectStep((QuestHelper)this, 44632, "Cool the preform to the lower range of the yellow heat section on the waterfall.", new Requirement[0]);
        this.dunkPreformToGrindstone = new ObjectStep((QuestHelper)this, 44631, new WorldPoint(3372, 11497, 0), "Dunk the preform in the lava pool until it's at the bottom of the yellow heat section.", new Requirement[0]);
        this.grindstonePreform = new ObjectStep((QuestHelper)this, 44620, new WorldPoint(3362, 11492, 0), "Grindstone the preform whilst in the yellow heat section.", new Requirement[0]);
        this.grindstonePreform.addSubSteps(this.coolPreformToGrindstone, this.dunkPreformToGrindstone);
        this.coolPreformToPolish = new ObjectStep((QuestHelper)this, 44632, "Cool the preform to the top of the range of the green heat section on the waterfall.", new Requirement[0]);
        this.heatPreformToPolish = new ObjectStep((QuestHelper)this, 44631, new WorldPoint(3372, 11497, 0), "Dunk the preform in the lava pool until it's at the top of the green heat section.", new Requirement[0]);
        this.polishPreform = new ObjectStep((QuestHelper)this, 44621, new WorldPoint(3363, 11485, 0), "Use the polishing wheel whilst in the green heat range, heating it in the lava when needed.", new Requirement[0]);
        this.polishPreform.addSubSteps(this.coolPreformToPolish, this.heatPreformToPolish);
        this.getPreform = new ObjectStep((QuestHelper)this, 44778, new WorldPoint(3369, 11501, 0), "Get your preform from the preform storage in the north of the room.", new Requirement[0]);
        this.handInPreform = new NpcStep((QuestHelper)this, 11470, "Give the finished sword to Kovac.", new Requirement[0]);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.oakLogs, this.wool, this.nails, this.hammer, this.chisel);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.iceGloves, this.alKharidTeleport);
    }

    @Override
    public List<Requirement> getGeneralRecommended() {
        return Arrays.asList(this.freeInventorySpace);
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Collections.singletonList(new ExperienceReward(Skill.SMITHING, 6000));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Collections.singletonList(new UnlockReward("Access to the Giants' Foundry"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting out", Arrays.asList(this.goToDesertPlateau, this.strikeHillGiant, this.speakToKovac, this.enterFoundry, this.fixPolishingStone, this.fixGrindstone, this.fixHammer, this.speakToKovacAfterRepairs), Arrays.asList(this.oakLogs, this.wool, this.nails, this.hammer, this.chisel), Collections.singletonList(this.freeInventorySpace)));
        allSteps.add(new PanelDetails("Creating the sword", Arrays.asList(this.speakToKovacContinue, this.searchCrate, this.fillCrucible, this.speakToKovacAboutMould, this.setMould, this.interactWithMould, this.talkToKovakAfterMould, this.pourMetal, this.coolDownSword, this.hitPreformWhileRed, this.grindstonePreform, this.polishPreform, this.handInPreform), Arrays.asList(this.iceGloves, this.bucket)));
        return allSteps;
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        return Collections.singletonList(new SkillRequirement(Skill.SMITHING, 15));
    }
}

