/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.sinsofthefather;

import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.steps.DetailedOwnerStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameTick;
import net.runelite.api.widgets.Widget;
import net.runelite.client.eventbus.Subscribe;

public class ValveStep
extends DetailedOwnerStep {
    DetailedQuestStep readNote;
    DetailedQuestStep setNorthValve;
    DetailedQuestStep setSouthValve;
    DetailedQuestStep setNorthValveNoHighlight;
    DetailedQuestStep setSouthValveNoHighlight;
    DetailedQuestStep cutTree;
    private int valveTotalValue;
    private int northTurns;
    private int southTurns;
    private final int GALLONS_NORTH = 7;
    private final int GALLONS_SOUTH = 4;
    private Zone northValveArea;
    private Zone southValveArea;
    Requirement atNorthValve;
    Requirement atSouthValve;
    ItemRequirement scentedTop;
    ItemRequirement scentedLegs;
    ItemRequirement scentedShoes;
    ItemRequirement oldNote;
    private boolean foundSum = false;
    private boolean solving = false;
    private boolean solved = false;
    private boolean northDone = false;
    private boolean southDone = false;

    public ValveStep(QuestHelper questHelper) {
        super(questHelper, "Turn the valves to solve the water puzzle.", new Requirement[0]);
    }

    @Override
    protected void updateSteps() {
        if (!this.foundSum) {
            this.startUpStep(this.readNote);
        } else if (!this.southDone) {
            if (this.atSouthValve.check(this.client)) {
                this.startUpStep(this.setSouthValve);
            } else {
                this.startUpStep(this.setSouthValveNoHighlight);
            }
        } else if (!this.northDone) {
            if (this.atNorthValve.check(this.client)) {
                this.startUpStep(this.setNorthValve);
            } else {
                this.startUpStep(this.setNorthValveNoHighlight);
            }
        } else {
            this.startUpStep(this.cutTree);
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        Widget widgetNote = this.client.getWidget(625, 7);
        if (!this.foundSum && widgetNote != null) {
            Matcher foundValveValue = Pattern.compile("[0-9]+").matcher(widgetNote.getText());
            boolean foundAnswer = foundValveValue.find();
            if (foundAnswer && !this.solving) {
                this.foundSum = true;
                this.solving = true;
                this.valveTotalValue = Integer.parseInt(foundValveValue.group(0));
                this.getValveValues();
                this.updateSteps();
            }
        } else if (this.foundSum) {
            Widget widgetNumberOptions = this.client.getWidget(187, 3);
            Widget widgetValveChoice = this.client.getWidget(229, 1);
            if (this.atSouthValve.check(this.client)) {
                if (widgetNumberOptions != null) {
                    this.southDone = this.checkValve(widgetNumberOptions, this.southTurns);
                } else if (widgetValveChoice != null) {
                    if (widgetValveChoice.getText().contains(String.valueOf(this.southTurns))) {
                        this.southDone = true;
                    } else if (widgetValveChoice.getText().contains("You set the valve")) {
                        this.southDone = false;
                    }
                }
            } else if (this.atNorthValve.check(this.client)) {
                if (widgetNumberOptions != null) {
                    this.northDone = this.checkValve(widgetNumberOptions, this.northTurns);
                } else if (widgetValveChoice != null) {
                    if (widgetValveChoice.getText().contains(String.valueOf(this.northTurns))) {
                        this.northDone = true;
                    } else if (widgetValveChoice.getText().contains("You set the valve")) {
                        this.northDone = false;
                    }
                }
            }
            this.updateSteps();
        }
    }

    private boolean checkValve(Widget choices, int turns) {
        boolean isSelected = false;
        for (Widget option : choices.getChildren()) {
            if (!option.getText().equals(turns + " (current)")) continue;
            isSelected = true;
        }
        return isSelected;
    }

    private void getValveValues() {
        int maxNorthTurns = this.valveTotalValue / 7;
        this.iterateValueCombos(maxNorthTurns);
    }

    private void iterateValueCombos(int currentNorthTurns) {
        if (currentNorthTurns == 0) {
            return;
        }
        int northSum = currentNorthTurns * 7;
        int remainderNorth = this.valveTotalValue - northSum;
        if (currentNorthTurns <= 5 && remainderNorth % 4 == 0) {
            this.solved = true;
            this.northTurns = currentNorthTurns;
            this.southTurns = remainderNorth / 4;
            this.setNorthValve.setText("Set the north valve to " + this.northTurns + ".");
            this.setNorthValveNoHighlight.setText("Set the north valve to " + this.northTurns + ".");
            this.setNorthValve.addWidgetChoice(String.valueOf(this.northTurns), 187, 3);
            this.setNorthValve.addWidgetChoice(this.northTurns + " (current)", 187, 3);
            this.setSouthValve.setText("Set the south valve to " + this.southTurns + ".");
            this.setSouthValveNoHighlight.setText("Set the south valve to " + this.southTurns + ".");
            this.setSouthValve.addWidgetChoice(String.valueOf(this.southTurns), 187, 3);
            this.setSouthValve.addWidgetChoice(this.southTurns + " (current)", 187, 3);
        } else {
            int newNorthTurns = currentNorthTurns - 1;
            this.iterateValueCombos(newNorthTurns);
        }
    }

    protected void setupRequirements() {
        this.scentedTop = new ItemRequirement("Vyre noble top", 24676, 1, true);
        this.scentedTop.setTooltip("You can get a replacement from a chest in Old Man Ral's basement.");
        this.scentedLegs = new ItemRequirement("Vyre noble legs", 24678, 1, true);
        this.scentedLegs.setTooltip("You can get a replacement from a chest in Old Man Ral's basement.");
        this.scentedShoes = new ItemRequirement("Vyre noble shoes", 24680, 1, true);
        this.scentedShoes.setTooltip("You can get a replacement from a chest in Old Man Ral's basement.");
        this.oldNote = new ItemRequirement("Old note", 24682);
        this.oldNote.setHighlightInInventory(true);
    }

    protected void setupZones() {
        this.northValveArea = new Zone(new WorldPoint(3619, 3362, 0), new WorldPoint(3624, 3365, 0));
        this.southValveArea = new Zone(new WorldPoint(3618, 3358, 0), new WorldPoint(3624, 3361, 0));
    }

    protected void setupConditions() {
        this.atNorthValve = new ZoneRequirement(this.northValveArea);
        this.atSouthValve = new ZoneRequirement(this.southValveArea);
    }

    @Override
    protected void setupSteps() {
        this.setupRequirements();
        this.setupZones();
        this.setupConditions();
        this.readNote = new DetailedQuestStep(this.getQuestHelper(), "Read the Old Note to find out the amount of water the Blisterwood Tree needs.", this.oldNote, this.scentedTop, this.scentedLegs, this.scentedShoes);
        this.setNorthValve = new ObjectStep(this.getQuestHelper(), 37997, new WorldPoint(3621, 3364, 0), "Turn the northern valve to the highlighted value.", new Requirement[0]);
        this.setSouthValve = new ObjectStep(this.getQuestHelper(), 37998, new WorldPoint(3621, 3359, 0), "Turn the southern valve to the highlighted value.", new Requirement[0]);
        this.setNorthValveNoHighlight = new ObjectStep(this.getQuestHelper(), 37997, new WorldPoint(3621, 3364, 0), "Turn the northern valve to the highlighted value.", new Requirement[0]);
        this.setSouthValveNoHighlight = new ObjectStep(this.getQuestHelper(), 37998, new WorldPoint(3621, 3359, 0), "Turn the southern valve to the highlighted value.", new Requirement[0]);
        this.cutTree = new ObjectStep(this.getQuestHelper(), 37989, new WorldPoint(3635, 3362, 0), "Gather 8 logs from the Blisterwood tree.", this.scentedTop, this.scentedLegs, this.scentedShoes);
    }

    @Override
    public Collection<QuestStep> getSteps() {
        return Arrays.asList(this.readNote, this.setNorthValve, this.setSouthValve, this.setNorthValveNoHighlight, this.setSouthValveNoHighlight, this.cutTree);
    }
}

