/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.sinsofthefather;

import com.questhelper.QuestHelperPlugin;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.requirements.Requirement;
import com.questhelper.steps.DetailedQuestStep;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import lombok.NonNull;
import net.runelite.api.Client;
import net.runelite.api.events.GameTick;
import net.runelite.api.widgets.Widget;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.PanelComponent;

public class DoorPuzzleStep
extends DetailedQuestStep {
    @Inject
    Client client;
    private final int UNKNOWN_VALUE = 0;
    private final int EMPTY = 1;
    private final int FILLED = 2;
    private final int SIZE = 5;
    private PuzzleLine[] result = null;
    private boolean solving = false;

    public DoorPuzzleStep(BasicQuestHelper questHelper) {
        super((QuestHelper)questHelper, "Solve the puzzle by marking the highlighted squares.", new Requirement[0]);
    }

    private PuzzleLine[] solve() {
        int[] rowSums = new int[5];
        int[] colSums = new int[5];
        try {
            for (int i = 0; i < 5; ++i) {
                colSums[i] = Integer.parseInt(this.client.getWidget(665, 19 + i).getText());
                rowSums[i] = Integer.parseInt(this.client.getWidget(665, 26 + i).getText());
            }
        }
        catch (NumberFormatException nfe) {
            System.out.println("NumberFormatException: " + nfe.getMessage());
        }
        PuzzleState solved = this.newSolveState(rowSums, colSums);
        return this.solveGrid(solved);
    }

    private PuzzleLine[] solveGrid(PuzzleState puzzleState) {
        LinkedList<PuzzleState> puzzleStates = new LinkedList<PuzzleState>();
        puzzleStates.add(puzzleState);
        int MAX_ITERATIONS = 20;
        for (int iterations = 0; iterations < MAX_ITERATIONS; ++iterations) {
            PuzzleState solution = this.checkSolutionOverlaps((PuzzleState)puzzleStates.remove());
            if (solution == null && puzzleStates.isEmpty()) {
                return null;
            }
            if (solution != null && solution.numberOfGray == 0) {
                return solution.grid;
            }
            if (solution == null) continue;
            puzzleStates.add(this.setFirstUnknownTo(solution, 2));
            puzzleStates.add(this.setFirstUnknownTo(solution, 1));
        }
        return null;
    }

    private PuzzleState setFirstUnknownTo(PuzzleState puzzleState, int state) {
        int x = -1;
        int y = -1;
        PuzzleState newPuzzleState = this.cloneState(puzzleState);
        boolean found = false;
        for (int r = 0; r < 5; ++r) {
            for (int c = 0; c < 5; ++c) {
                if (found || newPuzzleState.grid[r].cells[c] != 0) continue;
                x = r;
                y = c;
                found = true;
            }
        }
        newPuzzleState.grid[x].cells[y] = state;
        --newPuzzleState.numberOfGray;
        newPuzzleState.rowSolutions[x] = this.removeIncorrectSolutions(newPuzzleState.rowSolutions[x], y, state);
        newPuzzleState.columnSolutions[y] = this.removeIncorrectSolutions(newPuzzleState.columnSolutions[y], x, state);
        return newPuzzleState;
    }

    private PuzzleLine[] cloneGrid(PuzzleLine[] oldPuzzle) {
        PuzzleLine[] newGrid = this.generateNewGrid();
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 5; ++j) {
                newGrid[i].cells[j] = oldPuzzle[i].cells[j];
            }
        }
        return newGrid;
    }

    private PuzzleLine[][] cloneSolutions(PuzzleLine[][] oldSolution) {
        PuzzleLine[][] newSolution = new PuzzleLine[5][];
        for (int i = 0; i < 5; ++i) {
            newSolution[i] = new PuzzleLine[oldSolution[i].length];
            for (int j = 0; j < oldSolution[i].length; ++j) {
                PuzzleLine newLine = new PuzzleLine(5);
                for (int k = 0; k < 5; ++k) {
                    newLine.cells[k] = oldSolution[i][j].cells[k];
                }
                newSolution[i][j] = newLine;
            }
        }
        return newSolution;
    }

    private PuzzleState cloneState(PuzzleState oldState) {
        return new PuzzleState(this.cloneSolutions(oldState.rowSolutions), this.cloneSolutions(oldState.columnSolutions), this.cloneGrid(oldState.grid), oldState.numberOfGray);
    }

    private PuzzleLine deduceColorsFromSols(PuzzleLine[] sols) {
        int numSolutions = sols.length;
        if (numSolutions == 0) {
            return null;
        }
        if (numSolutions == 1) {
            return sols[0];
        }
        PuzzleLine c = new PuzzleLine(5);
        for (int i = 0; i < 5; ++i) {
            int acc = 0;
            for (PuzzleLine sol : sols) {
                if (sol.cells[i] != 2) continue;
                ++acc;
            }
            c.cells[i] = acc == 0 ? 1 : (acc == numSolutions ? 2 : 0);
        }
        return c;
    }

    private PuzzleState checkSolutionOverlaps(PuzzleState oldPuzzleState) {
        boolean hasFoundASolution = true;
        while (hasFoundASolution && oldPuzzleState.numberOfGray > 0) {
            PuzzleLine sol;
            hasFoundASolution = false;
            for (int r = 0; r < 5; ++r) {
                sol = this.deduceColorsFromSols(oldPuzzleState.rowSolutions[r]);
                if (sol == null) {
                    return null;
                }
                for (int c = 0; c < 5; ++c) {
                    if (sol.cells[c] == 0 || oldPuzzleState.grid[r].cells[c] != 0) continue;
                    hasFoundASolution = true;
                    --oldPuzzleState.numberOfGray;
                    oldPuzzleState.grid[r].cells[c] = sol.cells[c];
                    oldPuzzleState.columnSolutions[c] = this.removeIncorrectSolutions(oldPuzzleState.columnSolutions[c], r, sol.cells[c]);
                }
            }
            for (int c = 0; c < 5; ++c) {
                sol = this.deduceColorsFromSols(oldPuzzleState.columnSolutions[c]);
                if (sol == null) {
                    return null;
                }
                for (int r = 0; r < 5; ++r) {
                    if (sol.cells[r] == 0 || oldPuzzleState.grid[r].cells[c] != 0) continue;
                    hasFoundASolution = true;
                    --oldPuzzleState.numberOfGray;
                    oldPuzzleState.grid[r].cells[c] = sol.cells[r];
                    oldPuzzleState.rowSolutions[r] = this.removeIncorrectSolutions(oldPuzzleState.rowSolutions[r], c, sol.cells[r]);
                }
            }
        }
        return oldPuzzleState;
    }

    private PuzzleLine[] removeIncorrectSolutions(PuzzleLine[] oldSolutions, int k, int c) {
        ArrayList<PuzzleLine> newSolutions = new ArrayList<PuzzleLine>();
        for (PuzzleLine solution : oldSolutions) {
            if (solution.cells[k] != c) continue;
            newSolutions.add(solution);
        }
        return newSolutions.toArray(new PuzzleLine[0]);
    }

    private PuzzleState newSolveState(int[] rowSums, int[] columnSums) {
        return new PuzzleState(this.createAllSolutions(rowSums), this.createAllSolutions(columnSums), this.generateNewGrid(), 25);
    }

    @Override
    @Subscribe
    public void onGameTick(GameTick event) {
        Widget xAxis = this.client.getWidget(665, 25);
        Widget yAxis = this.client.getWidget(665, 18);
        if (xAxis != null && yAxis != null && !this.solving) {
            this.solving = true;
            this.result = this.solve();
        }
    }

    @Override
    public void makeWidgetOverlayHint(Graphics2D graphics, QuestHelperPlugin plugin) {
        Widget panels = this.client.getWidget(665, 32);
        if (this.result != null && panels != null) {
            for (int i = 0; i < this.result.length; ++i) {
                for (int j = 0; j < this.result[i].cells.length; ++j) {
                    if (this.result[i].cells[j] != 2) continue;
                    Widget panel = panels.getChild(i * 5 + j);
                    graphics.setColor(new Color(this.questHelper.getConfig().targetOverlayColor().getRed(), this.questHelper.getConfig().targetOverlayColor().getGreen(), this.questHelper.getConfig().targetOverlayColor().getBlue(), 65));
                    graphics.fill(panel.getBounds());
                    graphics.setColor(this.questHelper.getConfig().targetOverlayColor());
                    graphics.draw(panel.getBounds());
                }
            }
        }
    }

    @Override
    public void makeWorldOverlayHint(Graphics2D graphics, QuestHelperPlugin plugin) {
    }

    @Override
    public void makeWorldArrowOverlayHint(Graphics2D graphics, QuestHelperPlugin plugin) {
    }

    @Override
    public void makeOverlayHint(PanelComponent panelComponent, QuestHelperPlugin plugin, @NonNull List<String> additionalText, @NonNull List<Requirement> requirement) {
        if (additionalText == null) {
            throw new NullPointerException("additionalText is marked @NonNull but is null");
        }
        if (requirement == null) {
            throw new NullPointerException("requirement is marked @NonNull but is null");
        }
        super.makeOverlayHint(panelComponent, plugin, additionalText, requirement);
        Widget panels = this.client.getWidget(665, 32);
        if (this.result == null && panels != null) {
            String text = "Unable to calculate an answer for this puzzle. Good luck!";
            Color color = Color.RED;
            panelComponent.getChildren().add(LineComponent.builder().left(text).leftColor(color).build());
        }
    }

    private PuzzleLine[][] createAllSolutions(int[] goalValues) {
        HashMap<Integer, PuzzleLine[]> allSolutions = this.constructSolutions();
        PuzzleLine[][] solutionsForGoals = new PuzzleLine[5][5];
        for (int i = 0; i < 5; ++i) {
            solutionsForGoals[i] = allSolutions.get(goalValues[i]);
        }
        return solutionsForGoals;
    }

    private PuzzleLine[] generateNewGrid() {
        PuzzleLine[] g = new PuzzleLine[5];
        for (int i = 0; i < 5; ++i) {
            g[i] = new PuzzleLine(5);
        }
        return g;
    }

    private HashMap<Integer, PuzzleLine[]> constructSolutions() {
        HashMap<Integer, PuzzleLine[]> allSolutions = new HashMap<Integer, PuzzleLine[]>();
        allSolutions.put(0, this.getSolutions(new PuzzleLine(1, 1, 1, 1, 1)));
        allSolutions.put(1, this.getSolutions(new PuzzleLine(2, 1, 1, 1, 1)));
        allSolutions.put(2, this.getSolutions(new PuzzleLine(1, 2, 1, 1, 1)));
        allSolutions.put(3, this.getSolutions(new PuzzleLine(2, 2, 1, 1, 1), new PuzzleLine(1, 1, 2, 1, 1)));
        allSolutions.put(4, this.getSolutions(new PuzzleLine(2, 1, 2, 1, 1), new PuzzleLine(1, 1, 1, 2, 1)));
        allSolutions.put(5, this.getSolutions(new PuzzleLine(1, 2, 2, 1, 1), new PuzzleLine(2, 1, 1, 2, 1), new PuzzleLine(1, 1, 1, 1, 2)));
        allSolutions.put(6, this.getSolutions(new PuzzleLine(2, 2, 2, 1, 1), new PuzzleLine(1, 2, 1, 2, 1), new PuzzleLine(2, 1, 1, 1, 2)));
        allSolutions.put(7, this.getSolutions(new PuzzleLine(2, 2, 1, 2, 1), new PuzzleLine(1, 1, 2, 2, 1), new PuzzleLine(1, 2, 1, 1, 2)));
        allSolutions.put(8, this.getSolutions(new PuzzleLine(2, 1, 2, 2, 1), new PuzzleLine(2, 2, 1, 1, 2), new PuzzleLine(1, 1, 2, 1, 2)));
        allSolutions.put(9, this.getSolutions(new PuzzleLine(1, 2, 2, 2, 1), new PuzzleLine(2, 1, 2, 1, 2), new PuzzleLine(1, 1, 1, 2, 2)));
        allSolutions.put(10, this.getSolutions(new PuzzleLine(2, 2, 2, 2, 1), new PuzzleLine(1, 2, 2, 1, 2), new PuzzleLine(2, 1, 1, 2, 2)));
        allSolutions.put(11, this.getSolutions(new PuzzleLine(2, 2, 2, 1, 2), new PuzzleLine(1, 2, 1, 2, 2)));
        allSolutions.put(12, this.getSolutions(new PuzzleLine(2, 2, 1, 2, 2), new PuzzleLine(1, 1, 2, 2, 2)));
        allSolutions.put(13, this.getSolutions(new PuzzleLine(2, 1, 2, 2, 2)));
        allSolutions.put(14, this.getSolutions(new PuzzleLine(1, 2, 2, 2, 2)));
        allSolutions.put(15, this.getSolutions(new PuzzleLine(2, 2, 2, 2, 2)));
        return allSolutions;
    }

    private PuzzleLine[] getSolutions(PuzzleLine ... solution) {
        return solution;
    }

    static class PuzzleState {
        PuzzleLine[][] rowSolutions;
        PuzzleLine[][] columnSolutions;
        PuzzleLine[] grid;
        int numberOfGray;

        PuzzleState(PuzzleLine[][] row, PuzzleLine[][] column, PuzzleLine[] grid, int numberOfGray) {
            this.rowSolutions = row;
            this.columnSolutions = column;
            this.grid = grid;
            this.numberOfGray = numberOfGray;
        }
    }

    static class PuzzleLine {
        public int[] cells;

        PuzzleLine(int ... cells) {
            this.cells = cells;
        }

        PuzzleLine(int size) {
            this.cells = new int[size];
        }
    }
}

