/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.shilovillage;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.conditional.ObjectCondition;
import com.questhelper.requirements.item.ItemOnTileRequirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.npc.DialogRequirement;
import com.questhelper.requirements.npc.NpcInteractingRequirement;
import com.questhelper.requirements.player.FreeInventorySlotRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.util.Operation;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.var.VarplayerRequirement;
import com.questhelper.requirements.widget.WidgetTextRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ItemStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.SHILO_VILLAGE)
public class ShiloVillage
extends BasicQuestHelper {
    ItemRequirement spade;
    ItemRequirement torchOrCandle;
    ItemRequirement rope;
    ItemRequirement bronzeWire;
    ItemRequirement chisel;
    ItemRequirement bones3;
    ItemRequirement combatGear;
    ItemRequirement food;
    ItemRequirement staminas;
    ItemRequirement antipoison;
    ItemRequirement prayerPotions;
    ItemRequirement quickTeleport;
    ItemRequirement papyrus;
    ItemRequirement charcoal;
    ItemRequirement crumbleUndead;
    ItemRequirement belt;
    ItemRequirement stonePlaque;
    ItemRequirement tatteredScroll;
    ItemRequirement crumpledScroll;
    ItemRequirement zadimusCorpse;
    ItemRequirement boneShard;
    ItemRequirement beads;
    ItemRequirement pommel;
    ItemRequirement beadsOfTheDead;
    ItemRequirement boneKey;
    ItemRequirement rashCorpse;
    Requirement emptySlot3;
    Requirement moundNearby;
    Requirement inCavern1;
    Requirement inCavern2;
    Requirement inCavern3;
    Requirement inCavern4;
    Requirement shownStone;
    Requirement shownCorpse;
    Requirement hasReadTattered;
    Requirement hasReadCrumpled;
    Requirement revealedDoor;
    Requirement searchedDoor;
    Requirement doorOpened;
    Requirement nazNearby;
    Requirement corpseNearby;
    QuestStep talkToMosol;
    QuestStep useBeltOnTrufitus;
    QuestStep useSpadeOnGround;
    QuestStep useTorchOnFissure;
    QuestStep useRopeOnFissure;
    QuestStep lookAtMound;
    QuestStep searchFissure;
    QuestStep useChiselOnStone;
    QuestStep enterDeeperCave;
    QuestStep searchForTatteredScroll;
    QuestStep searchForCrumpledScroll;
    QuestStep searchForCorpse;
    QuestStep useCorpseOnTrufitus;
    QuestStep useStonePlaqueOnTrufitus;
    QuestStep readTattered;
    QuestStep readCrumpled;
    QuestStep buryCorpse;
    QuestStep searchRocksOnCairn;
    QuestStep searchDolmen;
    QuestStep useChiselOnPommel;
    QuestStep useWireOnBeads;
    QuestStep searchPalms;
    QuestStep searchDoors;
    QuestStep makeKey;
    QuestStep useKeyOnDoor;
    QuestStep enterDoor;
    QuestStep useBonesOnDoor;
    QuestStep searchDolmenForFight;
    QuestStep killNazastarool;
    QuestStep pickupCorpse;
    QuestStep enterCairnAgain;
    QuestStep useCorpseOnDolmen;
    Zone cavern1;
    Zone cavern2;
    Zone cavern3;
    Zone cavern4;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        ConditionalStep goStartQuest = new ConditionalStep((QuestHelper)this, this.talkToMosol, new Requirement[0]);
        goStartQuest.addStep(this.belt, this.useBeltOnTrufitus);
        steps.put(0, goStartQuest);
        steps.put(1, this.useSpadeOnGround);
        steps.put(2, this.useSpadeOnGround);
        steps.put(3, this.useSpadeOnGround);
        ConditionalStep lightUpFissure = new ConditionalStep((QuestHelper)this, this.useTorchOnFissure, new Requirement[0]);
        lightUpFissure.addStep(this.moundNearby, this.lookAtMound);
        steps.put(4, lightUpFissure);
        ConditionalStep goUseRope = new ConditionalStep((QuestHelper)this, this.useRopeOnFissure, new Requirement[0]);
        goUseRope.addStep(this.moundNearby, this.lookAtMound);
        steps.put(5, goUseRope);
        ConditionalStep goGetItems = new ConditionalStep((QuestHelper)this, this.searchFissure, new Requirement[0]);
        goGetItems.addStep(new Conditions(this.beadsOfTheDead, this.boneKey), this.useKeyOnDoor);
        goGetItems.addStep(new Conditions(this.beadsOfTheDead, this.searchedDoor), this.makeKey);
        goGetItems.addStep(new Conditions(this.beadsOfTheDead, this.revealedDoor), this.searchDoors);
        goGetItems.addStep(new Conditions(this.beadsOfTheDead), this.searchPalms);
        goGetItems.addStep(new Conditions(this.beads), this.useWireOnBeads);
        goGetItems.addStep(new Conditions(this.pommel), this.useChiselOnPommel);
        goGetItems.addStep(new Conditions(this.inCavern3), this.searchDolmen);
        goGetItems.addStep(new Conditions(this.stonePlaque, this.hasReadTattered, this.hasReadCrumpled, this.boneShard), this.searchRocksOnCairn);
        goGetItems.addStep(new Conditions(this.stonePlaque, this.hasReadTattered, this.crumpledScroll, this.boneShard), this.readCrumpled);
        goGetItems.addStep(new Conditions(this.stonePlaque, this.tatteredScroll, this.crumpledScroll, this.boneShard), this.readTattered);
        goGetItems.addStep(new Conditions(this.stonePlaque, this.tatteredScroll, this.crumpledScroll, this.zadimusCorpse), this.buryCorpse);
        goGetItems.addStep(new Conditions(this.inCavern2, this.stonePlaque, this.tatteredScroll, this.crumpledScroll), this.searchForCorpse);
        goGetItems.addStep(new Conditions(this.inCavern2, this.stonePlaque, this.tatteredScroll), this.searchForCrumpledScroll);
        goGetItems.addStep(new Conditions(this.inCavern2, this.stonePlaque), this.searchForTatteredScroll);
        goGetItems.addStep(new Conditions(this.inCavern1, this.stonePlaque), this.enterDeeperCave);
        goGetItems.addStep(this.inCavern1, this.useChiselOnStone);
        goGetItems.addStep(this.moundNearby, this.lookAtMound);
        steps.put(6, goGetItems);
        steps.put(7, goGetItems);
        steps.put(8, goGetItems);
        steps.put(9, goGetItems);
        ConditionalStep goToDolem = new ConditionalStep((QuestHelper)this, this.enterDoor, new Requirement[0]);
        goToDolem.addStep(this.inCavern4, this.useBonesOnDoor);
        steps.put(10, goToDolem);
        steps.put(11, goToDolem);
        ConditionalStep goDoFight = new ConditionalStep((QuestHelper)this, this.enterDoor, new Requirement[0]);
        goDoFight.addStep(new Conditions(this.rashCorpse, this.inCavern3), this.useCorpseOnDolmen);
        goDoFight.addStep(this.rashCorpse, this.enterCairnAgain);
        goDoFight.addStep(this.corpseNearby, this.pickupCorpse);
        goDoFight.addStep(this.nazNearby, this.killNazastarool);
        goDoFight.addStep(this.inCavern4, this.searchDolmenForFight);
        steps.put(12, goDoFight);
        steps.put(13, goDoFight);
        steps.put(14, goDoFight);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.spade = new ItemRequirement("Spade", 952).isNotConsumed();
        this.torchOrCandle = new ItemRequirement("Lit torch or candle", 594);
        this.torchOrCandle.addAlternates(33);
        this.torchOrCandle.setTooltip("You will NOT get this item back");
        this.rope = new ItemRequirement("Rope", 954);
        this.bronzeWire = new ItemRequirement("Bronze wire", 1794);
        this.chisel = new ItemRequirement("Chisel", 1755).isNotConsumed();
        this.bones3 = new ItemRequirement("Bones", 526, 3);
        this.combatGear = new ItemRequirement("Combat gear", -1, -1).isNotConsumed();
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.food = new ItemRequirement("Food", ItemCollections.GOOD_EATING_FOOD, -1);
        this.staminas = new ItemRequirement("Stamina potions", ItemCollections.STAMINA_POTIONS, -1);
        this.antipoison = new ItemRequirement("Antipoisons", ItemCollections.ANTIPOISONS, -1);
        this.prayerPotions = new ItemRequirement("Prayer potions", ItemCollections.PRAYER_POTIONS, -1);
        this.quickTeleport = new ItemRequirement("A quick teleport for escaping", -1, -1);
        this.papyrus = new ItemRequirement("Papyrus", 970);
        this.charcoal = new ItemRequirement("Charcoal", 973);
        this.crumbleUndead = new ItemRequirement("Crumble undead spell for final boss", -1, -1);
        this.emptySlot3 = new FreeInventorySlotRequirement(3);
        this.belt = new ItemRequirement("Wampum belt", 625);
        this.stonePlaque = new ItemRequirement("Stone-plaque", 606);
        this.tatteredScroll = new ItemRequirement("Tattered scroll", 607);
        this.crumpledScroll = new ItemRequirement("Crumpled scroll", 608);
        this.zadimusCorpse = new ItemRequirement("Zadimus corpse", 610);
        this.zadimusCorpse.addAlternates(604, 605);
        this.boneShard = new ItemRequirement("Bone shard", 604);
        this.boneShard.addAlternates(605);
        this.boneKey = new ItemRequirement("Bone key", 605);
        this.pommel = new ItemRequirement("Sword pommel", 623);
        this.beads = new ItemRequirement("Bone beads", 618);
        this.beadsOfTheDead = new ItemRequirement("Beads of the dead", 616);
        this.rashCorpse = new ItemRequirement("Rashiliya corpse", 609);
    }

    public void loadZones() {
        this.cavern1 = new Zone(new WorldPoint(2870, 9330, 0), new WorldPoint(2950, 9407, 0));
        this.cavern2 = new Zone(new WorldPoint(2878, 9282, 0), new WorldPoint(2942, 9333, 0));
        this.cavern3 = new Zone(new WorldPoint(2751, 9353, 0), new WorldPoint(2770, 9397, 0));
        this.cavern4 = new Zone(new WorldPoint(2833, 9463, 0), new WorldPoint(2943, 9533, 0));
    }

    public void setupConditions() {
        this.moundNearby = new ObjectCondition(2217, new WorldPoint(2922, 3000, 0));
        this.inCavern1 = new ZoneRequirement(this.cavern1);
        this.inCavern2 = new ZoneRequirement(this.cavern2);
        this.inCavern3 = new ZoneRequirement(this.cavern3);
        this.inCavern4 = new ZoneRequirement(this.cavern4);
        this.shownCorpse = new Conditions(true, LogicType.OR, new DialogRequirement("The ground in the centre of the village"), this.boneShard);
        this.shownStone = new Conditions(true, LogicType.OR, new DialogRequirement("If you have found anything else that you need help with, please just let me know."), new WidgetTextRequirement(119, 3, true, "<str>Trufitus identified the plaque"));
        this.hasReadTattered = new Conditions(true, LogicType.OR, new WidgetTextRequirement(220, 3, "Bervirius, son of King Danthalas"), new VarplayerRequirement(116, 9, Operation.GREATER_EQUAL));
        this.hasReadCrumpled = new Conditions(true, LogicType.OR, new WidgetTextRequirement(222, 3, "Rashiliyia's rage went unchecked."), this.beadsOfTheDead);
        this.revealedDoor = new VarbitRequirement(8180, 1, Operation.GREATER_EQUAL);
        this.doorOpened = new VarbitRequirement(8180, 2, Operation.GREATER_EQUAL);
        this.searchedDoor = new Conditions(true, LogicType.OR, new WidgetTextRequirement(229, 1, "Examining the door,"));
        this.nazNearby = new NpcInteractingRequirement(5353, 5354, 5355);
        this.corpseNearby = new ItemOnTileRequirement(609);
    }

    public void setupSteps() {
        this.talkToMosol = new NpcStep((QuestHelper)this, 5340, new WorldPoint(2884, 2951, 0), "Talk to Mosol Rei east of Shilo Village in south Karamja.", new Requirement[0]);
        this.talkToMosol.addDialogSteps("Why do I need to run?", "Rashiliyia? Who is she?", "I'll go to see the Shaman.", "Yes, I'm sure and I'll take the Wampum belt to Trufitus.");
        this.talkToMosol.addDialogStep(1, "What can we do?");
        this.useBeltOnTrufitus = new NpcStep((QuestHelper)this, 4625, new WorldPoint(2809, 3085, 0), "Use the belt on to Trufitus.", this.belt.highlighted());
        this.useBeltOnTrufitus.addIcon(625);
        this.useBeltOnTrufitus.addDialogSteps("Mosol Rei said something about a legend?", "Why was it called Ah Za Rhoon?", "Tell me more.", "I am going to search for Ah Za Rhoon!", "Yes, I will seriously look for Ah Za Rhoon and I'd appreciate your help.");
        this.useSpadeOnGround = new ObjectStep((QuestHelper)this, 2217, new WorldPoint(2922, 3000, 0), "Use a spade on the ground in south east Karamja.", this.spade.highlighted());
        this.useSpadeOnGround.addIcon(952);
        this.lookAtMound = new ObjectStep((QuestHelper)this, 2217, new WorldPoint(2922, 3000, 0), "Look at the mound of earth in south east Karamja.", new Requirement[0]);
        this.useTorchOnFissure = new ObjectStep((QuestHelper)this, 2218, new WorldPoint(2922, 3000, 0), "Use a lit torch or candle on the fissure.", this.torchOrCandle.highlighted());
        this.useTorchOnFissure.addDialogStep("Yes");
        this.useTorchOnFissure.addIcon(33);
        this.useTorchOnFissure.addSubSteps(this.lookAtMound);
        this.useRopeOnFissure = new ObjectStep((QuestHelper)this, 2218, new WorldPoint(2922, 3000, 0), "Use a rope on the fissure.", this.rope.highlighted());
        this.useRopeOnFissure.addIcon(954);
        this.searchFissure = new ObjectStep((QuestHelper)this, 2219, new WorldPoint(2922, 3000, 0), "Right-click search the fissure.", new Requirement[0]);
        this.searchFissure.addDialogStep("Yes, I'll give it a go!");
        this.useChiselOnStone = new ObjectStep((QuestHelper)this, 2221, new WorldPoint(2901, 9379, 0), "Use a chisel on the strange looking stone to the south.", this.chisel.highlighted());
        this.useChiselOnStone.addIcon(1755);
        this.enterDeeperCave = new ObjectStep((QuestHelper)this, 2220, new WorldPoint(2888, 9373, 0), "Search the cave in to go deeper in the caverns.", new Requirement[0]);
        this.enterDeeperCave.addDialogStep("Yes, I'll wriggle through.");
        this.searchForTatteredScroll = new ObjectStep((QuestHelper)this, 2222, new WorldPoint(2885, 9318, 0), "Search the loose rocks to the north for a tattered scroll.", new Requirement[0]);
        this.searchForTatteredScroll.addDialogStep("Yes, I'll carefully move the rocks to see what's behind them.");
        this.searchForCrumpledScroll = new ObjectStep((QuestHelper)this, 2223, new WorldPoint(2939, 9285, 0), "Search the old sacks to the east for a crumpled scroll.", new Requirement[0]);
        this.searchForCorpse = new ObjectStep((QuestHelper)this, 2224, new WorldPoint(2935, 9326, 0), "Right-click search the gallows in the north east corner for a corpse.", new Requirement[0]);
        this.searchForCorpse.addDialogStep("Yes, I may find something else on the corpse.");
        this.useCorpseOnTrufitus = new NpcStep((QuestHelper)this, 4625, new WorldPoint(2809, 3085, 0), "Use Zadimus's corpse on Trufitus.", this.zadimusCorpse.highlighted());
        this.useCorpseOnTrufitus.addDialogStep("Is there any sacred ground around here?");
        this.useCorpseOnTrufitus.addIcon(610);
        this.useStonePlaqueOnTrufitus = new NpcStep((QuestHelper)this, 4625, new WorldPoint(2809, 3085, 0), "Use the stone-plaque on Trufitus.", this.stonePlaque.highlighted());
        this.useStonePlaqueOnTrufitus.addIcon(606);
        this.readTattered = new DetailedQuestStep((QuestHelper)this, "Read the tattered scroll.", this.tatteredScroll.highlighted());
        this.readTattered.addDialogSteps("Yes please.");
        this.readCrumpled = new DetailedQuestStep((QuestHelper)this, "Read the crumpled scroll.", this.crumpledScroll.highlighted());
        this.readCrumpled.addDialogSteps("Yes please.");
        this.buryCorpse = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2795, 3089, 0), "Bury Zadimus's corpse in the middle of Tai Bwo Wannai.", this.zadimusCorpse.highlighted());
        this.buryCorpse.addIcon(610);
        this.searchRocksOnCairn = new ObjectStep((QuestHelper)this, 2234, new WorldPoint(2762, 2990, 0), "Right-click search the rocks on Cairn Isle.", new Requirement[0]);
        this.searchRocksOnCairn.addDialogSteps("Yes please, I can think of nothing nicer!");
        this.searchDolmen = new ObjectStep((QuestHelper)this, 2235, new WorldPoint(2767, 9365, 0), "Right-click search the dolmen to the south.", new Requirement[0]);
        this.useChiselOnPommel = new DetailedQuestStep((QuestHelper)this, "Use a chisel on the pommel.", this.chisel.highlighted(), this.pommel.highlighted());
        this.useWireOnBeads = new DetailedQuestStep((QuestHelper)this, "Use bronze wire on the beads.", this.bronzeWire.highlighted(), this.beads.highlighted());
        this.searchPalms = new ObjectStep((QuestHelper)this, 2237, new WorldPoint(2916, 3093, 0), "Search the palm trees in the north east of Karamja.", this.beadsOfTheDead.equipped(), this.boneShard, this.chisel, this.bones3, this.combatGear);
        this.searchDoors = new ObjectStep((QuestHelper)this, 34673, new WorldPoint(2916, 3091, 0), "Right-click search the doors behind the palm trees.", new Requirement[0]);
        this.makeKey = new DetailedQuestStep((QuestHelper)this, "Use a chisel on the bone shard.", this.chisel.highlighted(), this.boneShard.highlighted());
        this.useKeyOnDoor = new ObjectStep((QuestHelper)this, 34673, new WorldPoint(2916, 3091, 0), "Use the bone key on the doors behind the palm trees.", this.boneKey.highlighted());
        this.useKeyOnDoor.addIcon(605);
        this.enterDoor = new ObjectStep((QuestHelper)this, 34673, new WorldPoint(2916, 3091, 0), "Enter the doors behind the palm trees.", this.beadsOfTheDead.equipped(), this.bones3, this.combatGear);
        this.useBonesOnDoor = new ObjectStep((QuestHelper)this, 2246, new WorldPoint(2892, 9480, 0), "Equip the beads of the dead, then make your way through the gate, down the rocks, then to the south west corner. Use bones on the door there.", this.beadsOfTheDead.equipped(), this.bones3.highlighted());
        this.useBonesOnDoor.addIcon(526);
        this.searchDolmenForFight = new ObjectStep((QuestHelper)this, 2258, new WorldPoint(2893, 9488, 0), "Search the dolmen, ready to fight.", new Requirement[0]);
        this.killNazastarool = new NpcStep((QuestHelper)this, 5353, new WorldPoint(2892, 9488, 0), "Defeat Nazastarool's 3 forms. You can safe spot them over the dolmen, and the Crumble Undead spell is very strong against them.", new Requirement[0]);
        ((NpcStep)this.killNazastarool).addAlternateNpcs(5354, 5355);
        ((NpcStep)this.killNazastarool).addSafeSpots(new WorldPoint(2894, 9486, 0), new WorldPoint(2891, 9486, 0));
        this.pickupCorpse = new ItemStep((QuestHelper)this, "Pickup Rashiliyia's corpse.", this.rashCorpse);
        this.enterCairnAgain = new ObjectStep((QuestHelper)this, 2234, new WorldPoint(2762, 2990, 0), "Right-click search the rocks on Cairn Isle to enter the caverns again.", this.rashCorpse);
        this.enterCairnAgain.addDialogSteps("Yes please, I can think of nothing nicer!");
        this.useCorpseOnDolmen = new ObjectStep((QuestHelper)this, 2235, new WorldPoint(2767, 9365, 0), "Use Rashiliyia's corpse on the dolmen to the south.", this.rashCorpse.highlighted());
        this.useCorpseOnDolmen.addIcon(609);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.spade, this.torchOrCandle, this.rope, this.bronzeWire, this.chisel, this.bones3);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.combatGear, this.food, this.staminas, this.antipoison, this.prayerPotions, this.quickTeleport, this.papyrus, this.charcoal, this.crumbleUndead);
    }

    @Override
    public List<String> getCombatRequirements() {
        return Collections.singletonList("Nazastarool 3 times (levels 68, 91, 93) (safespottable)");
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new QuestRequirement(QuestHelperQuest.JUNGLE_POTION, QuestState.FINISHED));
        req.add(new SkillRequirement(Skill.CRAFTING, 20));
        req.add(new SkillRequirement(Skill.AGILITY, 32));
        return req;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(2);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Collections.singletonList(new ExperienceReward(Skill.CRAFTING, 3875));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("Access to Shilo Village"), new UnlockReward("Ability to mine gem rocks in Shilo Village"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Exploring", Arrays.asList(this.talkToMosol, this.useBeltOnTrufitus, this.useSpadeOnGround, this.useTorchOnFissure, this.useRopeOnFissure, this.searchFissure, this.useChiselOnStone, this.enterDeeperCave, this.searchForTatteredScroll, this.searchForCrumpledScroll, this.searchForCorpse, this.buryCorpse, this.readTattered, this.readCrumpled), this.spade, this.torchOrCandle, this.rope, this.chisel));
        allSteps.add(new PanelDetails("Free Raiysha", Arrays.asList(this.searchRocksOnCairn, this.searchDolmen, this.useChiselOnPommel, this.useWireOnBeads, this.searchPalms, this.searchDoors, this.makeKey, this.useKeyOnDoor, this.enterDoor, this.useBonesOnDoor, this.searchDolmenForFight, this.killNazastarool, this.pickupCorpse, this.enterCairnAgain, this.useCorpseOnDolmen), this.chisel, this.bronzeWire, this.bones3));
        return allSteps;
    }
}

