/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.shieldofarrav;

import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.conditional.ObjectCondition;
import com.questhelper.requirements.item.ItemOnTileRequirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.SHIELD_OF_ARRAV_PHOENIX_GANG)
public class ShieldOfArravPhoenixGang
extends BasicQuestHelper {
    ItemRequirement book;
    ItemRequirement intelReport;
    ItemRequirement twentyCoins;
    ItemRequirement shieldHalf;
    ItemRequirement certificateHalf;
    ItemRequirement blackArmCertificateHalf;
    ItemRequirement certificate;
    Requirement inPhoenixEntry;
    Requirement intelReportNearby;
    Requirement inPhoenixBase;
    Requirement chestOpen;
    QuestStep startQuest;
    QuestStep searchBookcase;
    QuestStep talkToReldoAgain;
    QuestStep talkToBaraek;
    QuestStep goDownToPhoenixGang;
    QuestStep talkToStraven;
    QuestStep goUpFromPhoenixGang;
    QuestStep killJonny;
    QuestStep pickupIntelReport;
    QuestStep returnDownLadder;
    QuestStep talkToStravenAgain;
    QuestStep getShieldHalf;
    QuestStep getShieldHalf1;
    QuestStep tradeCertificateHalf;
    QuestStep combineCertificate;
    QuestStep talkToHaig;
    QuestStep talkToRoald;
    QuestStep leaveAfterGettingShieldHalf;
    Zone phoenixEntry;
    Zone phoenixBase;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.startQuest);
        steps.put(1, this.searchBookcase);
        steps.put(2, this.talkToReldoAgain);
        steps.put(3, this.talkToBaraek);
        ConditionalStep getPhoenixTask = new ConditionalStep((QuestHelper)this, this.goDownToPhoenixGang, new Requirement[0]);
        getPhoenixTask.addStep(this.inPhoenixEntry, this.talkToStraven);
        steps.put(4, getPhoenixTask);
        ConditionalStep goToKillJonny = new ConditionalStep((QuestHelper)this, this.killJonny, new Requirement[0]);
        goToKillJonny.addStep(new Conditions(this.intelReport, this.inPhoenixEntry), this.talkToStravenAgain);
        goToKillJonny.addStep(this.intelReport.alsoCheckBank(this.questBank), this.returnDownLadder);
        goToKillJonny.addStep(this.intelReportNearby, this.pickupIntelReport);
        goToKillJonny.addStep(this.inPhoenixEntry, this.goUpFromPhoenixGang);
        steps.put(8, goToKillJonny);
        ConditionalStep completeQuest = new ConditionalStep((QuestHelper)this, this.returnDownLadder, new Requirement[0]);
        completeQuest.addStep(this.certificate.alsoCheckBank(this.questBank), this.talkToRoald);
        completeQuest.addStep(new Conditions(this.certificateHalf.alsoCheckBank(this.questBank), this.blackArmCertificateHalf.alsoCheckBank(this.questBank)), this.combineCertificate);
        completeQuest.addStep(this.certificateHalf.alsoCheckBank(this.questBank), this.tradeCertificateHalf);
        completeQuest.addStep(new Conditions(this.inPhoenixBase, this.shieldHalf.alsoCheckBank(this.questBank)), this.leaveAfterGettingShieldHalf);
        completeQuest.addStep(this.shieldHalf.alsoCheckBank(this.questBank), this.talkToHaig);
        completeQuest.addStep(new Conditions(this.inPhoenixBase, this.chestOpen), this.getShieldHalf1);
        completeQuest.addStep(this.inPhoenixBase, this.getShieldHalf);
        steps.put(9, completeQuest);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.book = new ItemRequirement("Book", 757);
        this.intelReport = new ItemRequirement("Intel report", 761);
        this.twentyCoins = new ItemRequirement("Coins", ItemCollections.COINS, 20);
        this.shieldHalf = new ItemRequirement("Broken shield", 763);
        this.inPhoenixBase = new ZoneRequirement(this.phoenixBase);
        this.chestOpen = new ObjectCondition(2404);
        this.certificateHalf = new ItemRequirement("Half certificate", 11173);
        this.blackArmCertificateHalf = new ItemRequirement("Half certificate", 11174);
        this.certificate = new ItemRequirement("Certificate", 769);
    }

    public void loadZones() {
        this.phoenixEntry = new Zone(new WorldPoint(3239, 9780, 0), new WorldPoint(3249, 9786, 0));
        this.phoenixBase = new Zone(new WorldPoint(3232, 9761, 0), new WorldPoint(3254, 9785, 0));
    }

    public void setupConditions() {
        this.inPhoenixEntry = new ZoneRequirement(this.phoenixEntry);
        this.intelReportNearby = new ItemOnTileRequirement(this.intelReport);
    }

    public void setupSteps() {
        this.startQuest = new NpcStep((QuestHelper)this, 4243, new WorldPoint(3210, 3494, 0), "Talk to Reldo in the Varrock Castle library.", new Requirement[0]);
        this.startQuest.addDialogSteps("I'm in search of a quest.", "Yes.");
        this.searchBookcase = new ObjectStep((QuestHelper)this, 2402, new WorldPoint(3212, 3493, 0), "Search the marked bookcase for a book, then read it.", this.book.highlighted());
        this.talkToReldoAgain = new NpcStep((QuestHelper)this, 4243, new WorldPoint(3210, 3494, 0), "Talk to Reldo again.", new Requirement[0]);
        this.talkToBaraek = new NpcStep((QuestHelper)this, 2881, new WorldPoint(3218, 3435, 0), "Talk to Baraek in the Varrock Square.", this.twentyCoins);
        this.talkToBaraek.addDialogStep("Can you tell me where I can find the Phoenix Gang?");
        this.talkToBaraek.addDialogStep("Okay. Have 20 gold coins.");
        this.goDownToPhoenixGang = new ObjectStep((QuestHelper)this, 11803, new WorldPoint(3244, 3383, 0), "Head into the Phoenix Gang's base in south Varrock.", new Requirement[0]);
        this.talkToStraven = new NpcStep((QuestHelper)this, 5212, new WorldPoint(3247, 9781, 0), "Talk to Staven.", new Requirement[0]);
        this.talkToStraven.addDialogStep("I know who you are!");
        this.talkToStraven.addDialogStep("I'd like to offer you my services.");
        this.goUpFromPhoenixGang = new ObjectStep((QuestHelper)this, 2405, new WorldPoint(3244, 9783, 0), "Go back up to the surface.", new Requirement[0]);
        this.killJonny = new NpcStep((QuestHelper)this, 5213, new WorldPoint(3222, 3395, 0), "Kill Jonny the Beard in the Blue Moon Inn in Varrock.", new Requirement[0]);
        this.pickupIntelReport = new DetailedQuestStep((QuestHelper)this, "Pick up the Intel Report.", this.intelReport);
        this.returnDownLadder = new ObjectStep((QuestHelper)this, 11803, new WorldPoint(3244, 3383, 0), "Return to the Phoenix Gang's base.", new Requirement[0]);
        this.talkToStravenAgain = new NpcStep((QuestHelper)this, 5212, new WorldPoint(3247, 9781, 0), "Talk to Staven again.", new Requirement[0]);
        this.getShieldHalf = new ObjectStep((QuestHelper)this, 2403, new WorldPoint(3235, 9761, 0), "Search the chest in the Phoenix base for half of the Shield of Arrav.", new Requirement[0]);
        this.getShieldHalf1 = new ObjectStep((QuestHelper)this, 2404, new WorldPoint(3235, 9761, 0), "Search the chest in the Phoenix base for half of the Shield of Arrav.", new Requirement[0]);
        this.getShieldHalf.addSubSteps(this.getShieldHalf1);
        this.leaveAfterGettingShieldHalf = new ObjectStep((QuestHelper)this, 2405, new WorldPoint(3244, 9783, 0), "Go back up to the surface.", new Requirement[0]);
        this.talkToHaig = new NpcStep((QuestHelper)this, 5214, new WorldPoint(3255, 3449, 0), "Trade your weapon store key to your partner. If you can't trade, use the key on them to drop it at their feet. AFTERWARDS, talk to Curator Haig in the Varrock Museum.", this.shieldHalf);
        this.talkToHaig.addSubSteps(this.leaveAfterGettingShieldHalf);
        this.talkToRoald = new NpcStep((QuestHelper)this, 5215, new WorldPoint(3222, 3473, 0), "Talk to King Roald in Varrock Castle to finish the quest.", this.certificate);
        this.tradeCertificateHalf = new DetailedQuestStep((QuestHelper)this, "Trade one of your certificate halves for the other half with another player.  If you cannot trade, use the certificate on them to drop it at their feet. They can do the same for you.", new Requirement[0]);
        this.combineCertificate = new DetailedQuestStep((QuestHelper)this, "Use the two certificate halves together to create the certificate.", this.certificateHalf, this.blackArmCertificateHalf);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.twentyCoins);
        return reqs;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Collections.singletonList(new ItemReward("Coins", 995, 600));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Locating the Phoenix Gang", Arrays.asList(this.startQuest, this.searchBookcase, this.talkToReldoAgain, this.talkToBaraek, this.goDownToPhoenixGang, this.talkToStraven), new Requirement[0]));
        allSteps.add(new PanelDetails("Joining the gang", Arrays.asList(this.goUpFromPhoenixGang, this.killJonny, this.pickupIntelReport, this.returnDownLadder, this.talkToStravenAgain), new Requirement[0]));
        allSteps.add(new PanelDetails("Returning the shield", Arrays.asList(this.getShieldHalf, this.talkToHaig, this.tradeCertificateHalf, this.combineCertificate, this.talkToRoald), new Requirement[0]));
        return allSteps;
    }

    @Override
    public List<String> getCombatRequirements() {
        return Collections.singletonList("Jonny the beard (level 2)");
    }

    @Override
    public List<String> getNotes() {
        return Arrays.asList("You can also do this quest by joining the Black Arm Gang, which instead requires you to kill the weaponsmaster (level 23), or have another player kill them for you.", "Once you're accepted into one of the gangs, you CANNOT change gang.", "This quest requires you to swap items with another player who's in the other gang, so it's recommended to either find a friend to help you, or you can use the friend's chat 'OSRS SOA' and find someone to help there.");
    }

    @Override
    public boolean isCompleted() {
        boolean partComplete = super.isCompleted();
        return partComplete || QuestHelperQuest.SHIELD_OF_ARRAV_BLACK_ARM_GANG.getVar(this.client) >= 3;
    }
}

