/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.shieldofarrav;

import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.conditional.NpcCondition;
import com.questhelper.requirements.conditional.ObjectCondition;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.SHIELD_OF_ARRAV_BLACK_ARM_GANG)
public class ShieldOfArravBlackArmGang
extends BasicQuestHelper {
    ItemRequirement storeRoomKey;
    ItemRequirement twoPhoenixCrossbow;
    ItemRequirement shieldHalf;
    ItemRequirement certificateHalf;
    ItemRequirement phoenixCertificateHalf;
    ItemRequirement certificate;
    Requirement inStoreRoom;
    Requirement weaponMasterAlive;
    Requirement isUpstairsInBase;
    Requirement cupboardOpen;
    QuestStep talkToCharlie;
    QuestStep getWeaponStoreKey;
    QuestStep talkToKatrine;
    QuestStep goUpToWeaponStore;
    QuestStep killWeaponsMaster;
    QuestStep pickupTwoCrossbows;
    QuestStep goDownFromWeaponStore;
    QuestStep returnToKatrine;
    QuestStep goUpstairsInBase;
    QuestStep getShieldFromCupboard;
    QuestStep getShieldFromCupboard1;
    QuestStep goDownstairsInBase;
    QuestStep talkToHaig;
    QuestStep tradeCertificateHalf;
    QuestStep combineCertificate;
    QuestStep talkToRoald;
    Zone storeRoom;
    Zone upstairsInBase;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToCharlie);
        steps.put(1, this.talkToKatrine);
        ConditionalStep gettingTheCrossbows = new ConditionalStep((QuestHelper)this, this.getWeaponStoreKey, new Requirement[0]);
        gettingTheCrossbows.addStep(new Conditions(this.twoPhoenixCrossbow, this.inStoreRoom), this.goDownFromWeaponStore);
        gettingTheCrossbows.addStep(this.twoPhoenixCrossbow, this.returnToKatrine);
        gettingTheCrossbows.addStep(new Conditions(this.weaponMasterAlive, this.inStoreRoom), this.killWeaponsMaster);
        gettingTheCrossbows.addStep(this.inStoreRoom, this.pickupTwoCrossbows);
        gettingTheCrossbows.addStep(this.storeRoomKey.alsoCheckBank(this.questBank), this.goUpToWeaponStore);
        steps.put(2, gettingTheCrossbows);
        ConditionalStep completeQuest = new ConditionalStep((QuestHelper)this, this.goUpstairsInBase, new Requirement[0]);
        completeQuest.addStep(this.certificate.alsoCheckBank(this.questBank), this.talkToRoald);
        completeQuest.addStep(new Conditions(this.certificateHalf.alsoCheckBank(this.questBank), this.phoenixCertificateHalf.alsoCheckBank(this.questBank)), this.combineCertificate);
        completeQuest.addStep(this.certificateHalf.alsoCheckBank(this.questBank), this.tradeCertificateHalf);
        completeQuest.addStep(new Conditions(this.shieldHalf.alsoCheckBank(this.questBank), this.isUpstairsInBase), this.goDownstairsInBase);
        completeQuest.addStep(this.shieldHalf.alsoCheckBank(this.questBank), this.talkToHaig);
        completeQuest.addStep(new Conditions(this.isUpstairsInBase, this.cupboardOpen), this.getShieldFromCupboard1);
        completeQuest.addStep(this.isUpstairsInBase, this.getShieldFromCupboard);
        steps.put(3, completeQuest);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.storeRoomKey = new ItemRequirement("Weapon store key", 759);
        this.twoPhoenixCrossbow = new ItemRequirement("Phoenix crossbow", 767, 2);
        this.shieldHalf = new ItemRequirement("Broken shield", 765);
        this.certificateHalf = new ItemRequirement("Half certificate", 11174);
        this.phoenixCertificateHalf = new ItemRequirement("Half certificate", 11173);
        this.certificate = new ItemRequirement("Certificate", 769);
    }

    public void loadZones() {
        this.storeRoom = new Zone(new WorldPoint(3242, 3380, 1), new WorldPoint(3252, 3386, 1));
        this.upstairsInBase = new Zone(new WorldPoint(3182, 3382, 1), new WorldPoint(3201, 3398, 1));
    }

    public void setupConditions() {
        this.inStoreRoom = new ZoneRequirement(this.storeRoom);
        this.weaponMasterAlive = new NpcCondition(5211);
        this.isUpstairsInBase = new ZoneRequirement(this.upstairsInBase);
        this.cupboardOpen = new ObjectCondition(2401);
    }

    public void setupSteps() {
        this.talkToCharlie = new NpcStep((QuestHelper)this, 5209, new WorldPoint(3208, 3392, 0), "To start the quest as the Black Arm Gang, talk to Charlie the Tramp in south Varrock to start.", new Requirement[0]);
        this.talkToCharlie.addDialogStep("Is there anything down this alleyway?");
        this.talkToCharlie.addDialogStep("Do you think they would let me join?");
        this.talkToKatrine = new NpcStep((QuestHelper)this, 5210, new WorldPoint(3185, 3385, 0), "Talk to Katrine down the alley to the west.", new Requirement[0]);
        this.talkToKatrine.addDialogStep("I've heard you're the Black Arm Gang.");
        this.talkToKatrine.addDialogStep("I'd rather not reveal my sources.");
        this.talkToKatrine.addDialogStep("I want to become a member of your gang.");
        this.talkToKatrine.addDialogStep("Well, you can give me a try can't you?");
        this.talkToKatrine.addDialogStep("Ok, no problem.");
        this.getWeaponStoreKey = new DetailedQuestStep((QuestHelper)this, "Get the weapon storeroom key from another player.  If you cannot trade, have them use the key on you to drop it at your feet.", new Requirement[0]);
        this.goUpToWeaponStore = new ObjectStep((QuestHelper)this, 11794, new WorldPoint(3252, 3384, 0), "Go up the ladder in south east Varrock to the Phoenix Weapon Storeroom.", this.storeRoomKey);
        this.killWeaponsMaster = new NpcStep((QuestHelper)this, 5211, new WorldPoint(3247, 3384, 1), "Kill the Weaponsmaster, or have someone else kill him.", new Requirement[0]);
        this.pickupTwoCrossbows = new DetailedQuestStep((QuestHelper)this, "Pick up TWO phoenix crossbows", this.twoPhoenixCrossbow);
        this.goDownFromWeaponStore = new ObjectStep((QuestHelper)this, 11802, new WorldPoint(3252, 3384, 1), "Go back down from the storeroom.", this.twoPhoenixCrossbow);
        this.returnToKatrine = new NpcStep((QuestHelper)this, 5210, new WorldPoint(3185, 3385, 0), "Return to Katrine with the crossbows.", this.twoPhoenixCrossbow);
        this.returnToKatrine.addSubSteps(this.goDownFromWeaponStore);
        this.goUpstairsInBase = new ObjectStep((QuestHelper)this, 11796, new WorldPoint(3189, 3390, 0), "Go up the stairs in the Black Arm Gang base.", new Requirement[0]);
        this.getShieldFromCupboard = new ObjectStep((QuestHelper)this, 2400, new WorldPoint(3189, 3386, 1), "Search the cupboard for half of the Shield of Arrav.", new Requirement[0]);
        this.getShieldFromCupboard1 = new ObjectStep((QuestHelper)this, 2401, new WorldPoint(3189, 3386, 1), "Search the cupboard for half of the Shield of Arrav.", new Requirement[0]);
        this.getShieldFromCupboard.addSubSteps(this.getShieldFromCupboard1);
        this.goDownstairsInBase = new ObjectStep((QuestHelper)this, 11799, new WorldPoint(3189, 3391, 1), "Go back downstairs.", new Requirement[0]);
        this.tradeCertificateHalf = new DetailedQuestStep((QuestHelper)this, "Trade one of your certificate halves for the other half with another player. If you cannot trade, use the certificate on them to drop it at their feet. They can do the same for you.", new Requirement[0]);
        this.combineCertificate = new DetailedQuestStep((QuestHelper)this, "Use the two certificate halves together to create the certificate.", this.certificateHalf, this.phoenixCertificateHalf);
        this.talkToHaig = new NpcStep((QuestHelper)this, 5214, new WorldPoint(3255, 3449, 0), "Talk to Curator Haig in the Varrock Museum.", this.shieldHalf);
        this.talkToHaig.addSubSteps(this.goDownstairsInBase);
        this.talkToRoald = new NpcStep((QuestHelper)this, 4163, new WorldPoint(3222, 3473, 0), "Talk to King Roald in Varrock Castle to finish the quest.", this.certificate);
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Collections.singletonList(new ItemReward("Coins", 995, 600));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Start quest", Arrays.asList(this.talkToCharlie, this.talkToKatrine), new Requirement[0]));
        allSteps.add(new PanelDetails("Get the phoenix crossbows", Arrays.asList(this.getWeaponStoreKey, this.goUpToWeaponStore, this.killWeaponsMaster, this.pickupTwoCrossbows, this.returnToKatrine), new Requirement[0]));
        allSteps.add(new PanelDetails("Return the shield", Arrays.asList(this.goUpstairsInBase, this.getShieldFromCupboard, this.talkToHaig, this.tradeCertificateHalf, this.combineCertificate, this.talkToRoald), new Requirement[0]));
        return allSteps;
    }

    @Override
    public List<String> getCombatRequirements() {
        return Collections.singletonList("Weaponsmaster (level 23), or a friend to kill him for you");
    }

    @Override
    public List<String> getNotes() {
        return Arrays.asList("You can also do this quest by joining the Phoenix Gang, which instead requires you to kill Jonny the beard (level 2).", "Once you're accepted into one of the gangs, you CANNOT change gang.", "This quest requires you to swap items with another player who's in the other gang, so it's recommended to either find a friend to help you, or you can use the friend's chat 'OSRS SOA' and find someone to help there.");
    }

    @Override
    public boolean isCompleted() {
        boolean partComplete = super.isCompleted();
        return partComplete || QuestHelperQuest.SHIELD_OF_ARRAV_PHOENIX_GANG.getVar(this.client) >= 6;
    }
}

