/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.sheepherder;

import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemOnTileRequirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ItemStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import com.questhelper.tools.QuestTile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.SHEEP_HERDER)
public class SheepHerder
extends BasicQuestHelper {
    ItemRequirement coins;
    ItemRequirement energyRestore;
    ItemRequirement plagueJacket;
    ItemRequirement plagueTrousers;
    ItemRequirement cattleprod;
    ItemRequirement sheepFeed;
    ItemRequirement bones1;
    ItemRequirement bones2;
    ItemRequirement bones3;
    ItemRequirement bones4;
    Requirement inEnclosure;
    Requirement sheep1InEnclosure;
    Requirement sheep2InEnclosure;
    Requirement sheep3InEnclosure;
    Requirement sheep4InEnclosure;
    Requirement sheep1HasBones;
    Requirement sheep2HasBones;
    Requirement sheep3HasBones;
    Requirement sheep4HasBones;
    Requirement sheep1Burned;
    Requirement sheep2Burned;
    Requirement sheep3Burned;
    Requirement sheep4Burned;
    Requirement allSheepBonesObtained;
    Requirement allSheepBurned;
    Requirement bonesNearby;
    DetailedQuestStep talkToHalgrive;
    DetailedQuestStep talkToOrbon;
    DetailedQuestStep enterEnclosure;
    DetailedQuestStep pickupCattleprod;
    DetailedQuestStep prodSheep1;
    DetailedQuestStep prodSheep2;
    DetailedQuestStep prodSheep3;
    DetailedQuestStep prodSheep4;
    DetailedQuestStep feedSheep;
    DetailedQuestStep pickupBones;
    DetailedQuestStep useBonesOnIncinerator;
    DetailedQuestStep talkToHalgriveToFinish;
    Zone enclosure;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.setupRequirements();
        this.setupZones();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToHalgrive);
        steps.put(1, this.talkToOrbon);
        ConditionalStep goBurnSheep = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterEnclosure, new Requirement[0]);
        goBurnSheep.addStep(new Conditions(this.allSheepBurned), this.talkToHalgriveToFinish);
        goBurnSheep.addStep(new Conditions(this.allSheepBonesObtained), this.useBonesOnIncinerator);
        goBurnSheep.addStep(new Conditions(this.bonesNearby), this.pickupBones);
        goBurnSheep.addStep(new Conditions(this.sheep1InEnclosure, this.sheep2InEnclosure, this.sheep3InEnclosure, this.sheep4InEnclosure), this.feedSheep);
        goBurnSheep.addStep(new Conditions(this.cattleprod, this.sheep1InEnclosure, this.sheep2InEnclosure, this.sheep3InEnclosure), this.prodSheep4);
        goBurnSheep.addStep(new Conditions(this.cattleprod, this.sheep1InEnclosure, this.sheep2InEnclosure), this.prodSheep3);
        goBurnSheep.addStep(new Conditions(this.cattleprod, this.sheep1InEnclosure), this.prodSheep2);
        goBurnSheep.addStep(this.cattleprod, this.prodSheep1);
        goBurnSheep.addStep(this.inEnclosure, this.pickupCattleprod);
        steps.put(2, goBurnSheep);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.coins = new ItemRequirement("Coins", ItemCollections.COINS);
        this.energyRestore = new ItemRequirement("Energy restoring items", ItemCollections.RUN_RESTORE_ITEMS);
        this.plagueJacket = new ItemRequirement("Plague jacket", 284);
        this.plagueJacket.setTooltip("You can buy another from Doctor Orbon for 100 coins");
        this.plagueTrousers = new ItemRequirement("Plague trousers", 285);
        this.plagueTrousers.setTooltip("You can buy another from Doctor Orbon for 100 coins");
        this.cattleprod = new ItemRequirement("Cattle prod", 278);
        this.sheepFeed = new ItemRequirement("Sheep feed", 279);
        this.sheepFeed.setTooltip("You can get more from Halgrive");
        this.bones1 = new ItemRequirement("Sheep bones 1", 280);
        this.bones2 = new ItemRequirement("Sheep bones 2", 281);
        this.bones3 = new ItemRequirement("Sheep bones 3", 282);
        this.bones4 = new ItemRequirement("Sheep bones 4", 283);
    }

    private void setupZones() {
        this.enclosure = new Zone(new WorldPoint(2595, 3351, 0), new WorldPoint(2609, 3364, 0));
    }

    private void setupConditions() {
        this.inEnclosure = new ZoneRequirement(this.enclosure);
        this.sheep1Burned = new VarbitRequirement(2233, 6);
        this.sheep1HasBones = new Conditions(LogicType.OR, this.bones3, this.sheep1Burned);
        this.sheep1InEnclosure = new Conditions(LogicType.OR, new VarbitRequirement(2233, 1), this.sheep1HasBones);
        this.sheep2Burned = new VarbitRequirement(2234, 6);
        this.sheep2HasBones = new Conditions(LogicType.OR, this.bones4, this.sheep2Burned);
        this.sheep2InEnclosure = new Conditions(LogicType.OR, new VarbitRequirement(2234, 1), this.sheep2HasBones);
        this.sheep3Burned = new VarbitRequirement(2232, 6);
        this.sheep3HasBones = new Conditions(LogicType.OR, this.bones2, this.sheep3Burned);
        this.sheep3InEnclosure = new Conditions(LogicType.OR, new VarbitRequirement(2232, 1), this.sheep3HasBones);
        this.sheep4Burned = new VarbitRequirement(2231, 6);
        this.sheep4HasBones = new Conditions(LogicType.OR, this.bones1, this.sheep4Burned);
        this.sheep4InEnclosure = new Conditions(LogicType.OR, new VarbitRequirement(2231, 1), this.sheep4HasBones);
        this.allSheepBonesObtained = new Conditions(this.sheep1HasBones, this.sheep2HasBones, this.sheep3HasBones, this.sheep4HasBones);
        this.allSheepBurned = new Conditions(this.sheep1Burned, this.sheep2Burned, this.sheep3Burned, this.sheep4Burned);
        this.bonesNearby = new Conditions(LogicType.OR, new ItemOnTileRequirement(this.bones1), new ItemOnTileRequirement(this.bones2), new ItemOnTileRequirement(this.bones3), new ItemOnTileRequirement(this.bones4));
    }

    public void setupSteps() {
        this.talkToHalgrive = new NpcStep((QuestHelper)this, 8765, new WorldPoint(2615, 3298, 0), "Talk to Councillor Halgrive outside the East Ardougne church.", new Requirement[0]);
        this.talkToHalgrive.addDialogSteps("What's wrong?", "I can do that for you.");
        this.talkToOrbon = new NpcStep((QuestHelper)this, 3984, new WorldPoint(2616, 3306, 0), "Talk to Doctor Orbon in the East Ardougne Church.", this.coins.quantity(100));
        this.talkToOrbon.addDialogStep("Okay, I'll take it.");
        this.enterEnclosure = new ObjectStep((QuestHelper)this, 166, new WorldPoint(2594, 3362, 0), "Enter the enclosure north of Ardougne.", this.plagueJacket.equipped(), this.plagueTrousers.equipped());
        this.pickupCattleprod = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2604, 3357, 0), "Pickup the nearby cattleprod.", this.cattleprod);
        this.prodSheep1 = new NpcStep((QuestHelper)this, 3988, new WorldPoint(2562, 3389, 0), "Prod one of the blue sheep north west of the enclosure to the enclosure gate.", true, this.cattleprod.equipped(), this.plagueJacket.equipped(), this.plagueTrousers.equipped());
        this.prodSheep1.addTileMarker(new QuestTile(new WorldPoint(2594, 3362, 0)));
        this.prodSheep2 = new NpcStep((QuestHelper)this, 3989, new WorldPoint(2610, 3389, 0), "Prod one of the yellow sheep north of the enclosure to the enclosure gate.", true, this.cattleprod.equipped(), this.plagueJacket.equipped(), this.plagueTrousers.equipped());
        this.prodSheep2.addTileMarker(new QuestTile(new WorldPoint(2594, 3362, 0)));
        this.prodSheep3 = new NpcStep((QuestHelper)this, 3987, new WorldPoint(2621, 3367, 0), "Prod one of the green sheep east of the enclosure to the enclosure gate.", true, this.cattleprod.equipped(), this.plagueJacket.equipped(), this.plagueTrousers.equipped());
        this.prodSheep3.addTileMarker(new QuestTile(new WorldPoint(2594, 3362, 0)));
        this.prodSheep4 = new NpcStep((QuestHelper)this, 3986, new WorldPoint(2609, 3347, 0), "Prod one of the red sheep south east of the enclosure to the enclosure gate.", true, this.cattleprod.equipped(), this.plagueJacket.equipped(), this.plagueTrousers.equipped());
        this.prodSheep4.addTileMarker(new QuestTile(new WorldPoint(2594, 3362, 0)));
        this.pickupBones = new ItemStep((QuestHelper)this, "Pickup the bones.", this.bones1.hideConditioned(this.sheep4HasBones), this.bones2.hideConditioned(this.sheep3HasBones), this.bones3.hideConditioned(this.sheep1HasBones), this.bones4.hideConditioned(this.sheep2HasBones));
        this.feedSheep = new NpcStep((QuestHelper)this, 3988, new WorldPoint(2597, 3361, 0), "Feed the sheep the sheep feed.", true, this.sheepFeed.highlighted());
        this.feedSheep.addIcon(279);
        ((NpcStep)this.feedSheep).setMaxRoamRange(3);
        ((NpcStep)this.feedSheep).addAlternateNpcs(3987, 3986, 3989);
        this.useBonesOnIncinerator = new ObjectStep((QuestHelper)this, 165, new WorldPoint(2607, 3361, 0), "Pickup the bones and incinerate them.", this.bones1.highlighted().hideConditioned(this.sheep4Burned), this.bones2.highlighted().hideConditioned(this.sheep3Burned), this.bones3.highlighted().hideConditioned(this.sheep1Burned), this.bones4.highlighted().hideConditioned(this.sheep2Burned));
        this.useBonesOnIncinerator.addIcon(280);
        this.talkToHalgriveToFinish = new NpcStep((QuestHelper)this, 8765, new WorldPoint(2615, 3298, 0), "Return to Councillor Halgrive.", new Requirement[0]);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Collections.singletonList(this.coins.quantity(100));
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Collections.singletonList(this.energyRestore);
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(4);
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Collections.singletonList(new ItemReward("Coins", 995, 3100));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting out", Arrays.asList(this.talkToHalgrive, this.talkToOrbon), this.coins.quantity(100)));
        allSteps.add(new PanelDetails("Killing sheep", Arrays.asList(this.enterEnclosure, this.pickupCattleprod, this.prodSheep1, this.prodSheep2, this.prodSheep3, this.prodSheep4, this.feedSheep, this.pickupBones, this.useBonesOnIncinerator, this.talkToHalgriveToFinish), this.plagueJacket, this.plagueTrousers));
        return allSteps;
    }
}

