/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.shadowofthestorm;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.helpers.quests.shadowofthestorm.IncantationStep;
import com.questhelper.helpers.quests.shadowofthestorm.SearchKilns;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemOnTileRequirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.Operation;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedOwnerStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ItemStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.SHADOW_OF_THE_STORM)
public class ShadowOfTheStorm
extends BasicQuestHelper {
    ItemRequirement darkItems;
    ItemRequirement silverlight;
    ItemRequirement strangeImplement;
    ItemRequirement blackMushroomInk;
    ItemRequirement pestle;
    ItemRequirement vial;
    ItemRequirement silverBar;
    ItemRequirement silverlightHighlighted;
    ItemRequirement blackMushroomHighlighted;
    ItemRequirement silverlightDyedEquipped;
    ItemRequirement sigilMould;
    ItemRequirement silverlightDyed;
    ItemRequirement strangeImplementHighlighted;
    ItemRequirement sigil;
    ItemRequirement book;
    ItemRequirement bookHighlighted;
    ItemRequirement sigilHighlighted;
    ItemRequirement sigil2;
    ItemRequirement combatGear;
    ItemRequirement coinsForCarpet;
    Requirement inRuin;
    Requirement inThroneRoom;
    Requirement talkedToGolem;
    Requirement talkedToMatthew;
    Requirement inCircleSpot;
    Requirement sigilNearby;
    Requirement evilDaveMoved;
    Requirement baddenMoved;
    Requirement reenMoved;
    Requirement golemMoved;
    Requirement golemRejected;
    Requirement golemReprogrammed;
    Requirement inSecondCircleSpot;
    DetailedQuestStep talkToReen;
    DetailedQuestStep talkToBadden;
    DetailedQuestStep pickMushroom;
    DetailedQuestStep dyeSilverlight;
    DetailedQuestStep goIntoRuin;
    DetailedQuestStep pickUpStrangeImplement;
    DetailedQuestStep talkToEvilDave;
    DetailedQuestStep enterPortal;
    DetailedQuestStep talkToDenath;
    DetailedQuestStep talkToJennifer;
    DetailedQuestStep talkToMatthew;
    DetailedQuestStep smeltSigil;
    DetailedQuestStep talkToGolem;
    DetailedQuestStep readBook;
    DetailedQuestStep enterRuinAfterBook;
    DetailedQuestStep enterPortalAfterBook;
    DetailedQuestStep talkToMatthewAfterBook;
    DetailedQuestStep standInCircle;
    DetailedQuestStep pickUpSigil;
    DetailedQuestStep leavePortal;
    DetailedQuestStep tellDaveToReturn;
    DetailedQuestStep pickUpImplementAfterRitual;
    DetailedQuestStep goUpToBadden;
    DetailedQuestStep talkToBaddenAfterRitual;
    DetailedQuestStep talkToReenAfterRitual;
    DetailedQuestStep talkToTheGolemAfterRitual;
    DetailedQuestStep useImplementOnGolem;
    DetailedQuestStep pickUpSigil2;
    DetailedQuestStep talkToGolemAfterReprogramming;
    DetailedQuestStep enterRuinAfterRecruiting;
    DetailedQuestStep enterPortalAfterRecruiting;
    DetailedQuestStep talkToMatthewToStartFight;
    DetailedQuestStep killDemon;
    DetailedQuestStep standInCircleAgain;
    DetailedQuestStep enterRuinNoDark;
    DetailedQuestStep enterRuinForRitual;
    DetailedQuestStep enterPortalForRitual;
    DetailedQuestStep enterRuinForDave;
    DetailedQuestStep enterPortalForFight;
    DetailedQuestStep enterRuinForFight;
    DetailedQuestStep unequipDarklight;
    DetailedOwnerStep searchKiln;
    IncantationStep readIncantation;
    IncantationStep incantRitual;
    Zone ruin;
    Zone throneRoom;
    Zone circleSpot;
    Zone secondCircleSpot;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        this.setupZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        steps.put(0, this.talkToReen);
        steps.put(10, this.talkToBadden);
        ConditionalStep infiltrateCult = new ConditionalStep((QuestHelper)this, (QuestStep)this.pickMushroom, new Requirement[0]);
        infiltrateCult.addStep(new Conditions(this.silverlightDyed, this.strangeImplement, this.inRuin), this.talkToEvilDave);
        infiltrateCult.addStep(new Conditions(this.silverlightDyed, this.inRuin), this.pickUpStrangeImplement);
        infiltrateCult.addStep(this.silverlightDyed, this.goIntoRuin);
        infiltrateCult.addStep(this.blackMushroomHighlighted, this.dyeSilverlight);
        steps.put(20, infiltrateCult);
        ConditionalStep goTalkToDenath = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterRuinNoDark, new Requirement[0]);
        goTalkToDenath.addStep(this.inThroneRoom, this.talkToDenath);
        goTalkToDenath.addStep(this.inRuin, this.enterPortal);
        steps.put(30, goTalkToDenath);
        ConditionalStep completeSubTasks = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterRuinNoDark, new Requirement[0]);
        completeSubTasks.addStep(new Conditions(this.book, this.sigil, this.inThroneRoom), this.talkToMatthewAfterBook);
        completeSubTasks.addStep(new Conditions(this.book, this.sigil, this.inRuin), this.enterPortalAfterBook);
        completeSubTasks.addStep(new Conditions(this.book, this.sigil), this.enterRuinAfterBook);
        completeSubTasks.addStep(new Conditions(this.talkedToGolem, this.sigil), this.searchKiln);
        completeSubTasks.addStep(new Conditions(this.talkedToMatthew, this.sigil), this.talkToGolem);
        completeSubTasks.addStep(new Conditions(this.talkedToMatthew, this.sigilMould), this.smeltSigil);
        completeSubTasks.addStep(new Conditions(this.inThroneRoom, this.sigilMould), this.talkToMatthew);
        completeSubTasks.addStep(this.inThroneRoom, this.talkToJennifer);
        completeSubTasks.addStep(this.inRuin, this.enterPortal);
        steps.put(40, completeSubTasks);
        steps.put(50, completeSubTasks);
        steps.put(60, completeSubTasks);
        ConditionalStep startRitual = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterRuinForRitual, new Requirement[0]);
        startRitual.addStep(this.inThroneRoom, this.talkToMatthewAfterBook);
        startRitual.addStep(this.inRuin, this.enterPortalForRitual);
        steps.put(70, startRitual);
        ConditionalStep performRitual = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterRuinForRitual, new Requirement[0]);
        performRitual.addStep(this.inCircleSpot, this.readIncantation);
        performRitual.addStep(this.inThroneRoom, this.standInCircle);
        performRitual.addStep(this.inRuin, this.enterPortalForRitual);
        steps.put(80, performRitual);
        ConditionalStep prepareForSecondRitual = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterRuinForDave, new Requirement[0]);
        prepareForSecondRitual.addStep(this.sigilNearby, this.pickUpSigil);
        prepareForSecondRitual.addStep(new Conditions(this.evilDaveMoved, this.baddenMoved, this.reenMoved, this.golemMoved, this.inThroneRoom), this.talkToMatthewToStartFight);
        prepareForSecondRitual.addStep(new Conditions(this.evilDaveMoved, this.baddenMoved, this.reenMoved, this.golemMoved, this.inRuin), this.enterPortalAfterRecruiting);
        prepareForSecondRitual.addStep(new Conditions(this.evilDaveMoved, this.baddenMoved, this.reenMoved, this.golemMoved), this.enterRuinAfterRecruiting);
        prepareForSecondRitual.addStep(new Conditions(this.evilDaveMoved, this.baddenMoved, this.reenMoved, this.golemReprogrammed), this.talkToGolemAfterReprogramming);
        prepareForSecondRitual.addStep(new Conditions(this.evilDaveMoved, this.baddenMoved, this.reenMoved, this.golemRejected), this.useImplementOnGolem);
        prepareForSecondRitual.addStep(new Conditions(this.evilDaveMoved, this.baddenMoved, this.reenMoved), this.talkToTheGolemAfterRitual);
        prepareForSecondRitual.addStep(new Conditions(this.evilDaveMoved, this.baddenMoved), this.talkToReenAfterRitual);
        prepareForSecondRitual.addStep(new Conditions(this.strangeImplement, this.evilDaveMoved, this.inRuin), this.goUpToBadden);
        prepareForSecondRitual.addStep(new Conditions(this.evilDaveMoved, this.inRuin), this.pickUpImplementAfterRitual);
        prepareForSecondRitual.addStep(new Conditions(this.evilDaveMoved), this.talkToBaddenAfterRitual);
        prepareForSecondRitual.addStep(this.inRuin, this.tellDaveToReturn);
        prepareForSecondRitual.addStep(this.inThroneRoom, this.leavePortal);
        steps.put(90, prepareForSecondRitual);
        steps.put(100, prepareForSecondRitual);
        ConditionalStep summonAgrith = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterRuinAfterRecruiting, new Requirement[0]);
        summonAgrith.addStep(this.inSecondCircleSpot, this.incantRitual);
        summonAgrith.addStep(this.inThroneRoom, this.standInCircleAgain);
        summonAgrith.addStep(this.inRuin, this.enterPortalAfterRecruiting);
        steps.put(110, summonAgrith);
        ConditionalStep defeatAgrith = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterRuinForFight, new Requirement[0]);
        defeatAgrith.addStep(this.inThroneRoom, this.killDemon);
        defeatAgrith.addStep(this.inRuin, this.enterPortalForFight);
        steps.put(120, defeatAgrith);
        steps.put(124, this.unequipDarklight);
        return steps;
    }

    private void setupZones() {
        this.ruin = new Zone(new WorldPoint(2706, 4881, 0), new WorldPoint(2738, 4918, 0));
        this.throneRoom = new Zone(new WorldPoint(2709, 4879, 2), new WorldPoint(2731, 4919, 2));
        this.circleSpot = new Zone(new WorldPoint(2718, 4902, 2), new WorldPoint(2718, 4902, 2));
        this.secondCircleSpot = new Zone(new WorldPoint(2720, 4903, 2), new WorldPoint(2720, 4903, 2));
    }

    @Override
    public void setupRequirements() {
        this.darkItems = new ItemRequirement("pieces of black clothing", 6750, 3, true).isNotConsumed().doNotAggregate();
        this.darkItems.addAlternates(6752, 1107, 1125, 1077, 1165, 1151, 7457, 426, 428, 4099, 4103, 4101, 6106, 6111, 6110, 6109, 6107, 6108, 548, 546, 12896, 12895, 12893, 12892, 12894, 1017, 1019, 11862, 11847, 12524, 20266, 20026, 2503, 2497, 2491, 581);
        this.silverlight = new ItemRequirement("Silverlight", 2402).isNotConsumed();
        this.silverlight.setTooltip("You can get another from Father Reen in Al Kharid if you've lost it");
        this.silverlight.addAlternates(6745);
        this.strangeImplement = new ItemRequirement("Strange implement", 4619);
        this.strangeImplement.setTooltip("You can find another in the underground of Uzer");
        this.strangeImplementHighlighted = new ItemRequirement("Strange implement", 4619);
        this.strangeImplementHighlighted.setHighlightInInventory(true);
        this.strangeImplementHighlighted.setTooltip("You can find another in the underground of Uzer");
        this.blackMushroomInk = new ItemRequirement("Black mushroom ink", 4622);
        this.pestle = new ItemRequirement("Pestle and mortar", 233).isNotConsumed();
        this.vial = new ItemRequirement("Vial", 229);
        this.silverBar = new ItemRequirement("Silver bar", 2355);
        this.blackMushroomHighlighted = new ItemRequirement("Black mushroom", 4620);
        this.blackMushroomHighlighted.setHighlightInInventory(true);
        this.silverlightHighlighted = new ItemRequirement("Silverlight", 2402);
        this.silverlightHighlighted.setHighlightInInventory(true);
        this.silverlightDyed = new ItemRequirement("Silverlight (dyed)", 6745);
        this.silverlightDyedEquipped = new ItemRequirement("Silverlight (dyed)", 6745, 1, true);
        this.sigilMould = new ItemRequirement("Demonic sigil mould", 6747);
        this.combatGear = new ItemRequirement("Combat gear + potions", -1, -1).isNotConsumed();
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.coinsForCarpet = new ItemRequirement("Coins or more for carpet rides", ItemCollections.COINS, 400);
        this.sigil = new ItemRequirement("Demonic sigil", 6748);
        this.sigil.setTooltip("You can make another if needed with the demonic sigil mould");
        this.sigil2 = new ItemRequirement("Demonic sigil", 6748, 2);
        this.sigil2.setTooltip("You can make another if needed with the demonic sigil mould (which you can get from Jennifer)");
        this.sigilHighlighted = new ItemRequirement("Demonic sigil", 6748);
        this.sigilHighlighted.setHighlightInInventory(true);
        this.book = new ItemRequirement("Demonic tome", 6749);
        this.bookHighlighted = new ItemRequirement("Demonic tome", 6749);
        this.bookHighlighted.setHighlightInInventory(true);
    }

    private void setupConditions() {
        this.inRuin = new ZoneRequirement(this.ruin);
        this.inThroneRoom = new ZoneRequirement(this.throneRoom);
        this.inCircleSpot = new ZoneRequirement(this.circleSpot);
        this.inSecondCircleSpot = new ZoneRequirement(this.secondCircleSpot);
        this.talkedToMatthew = new VarbitRequirement(1372, 50, Operation.GREATER_EQUAL);
        this.talkedToGolem = new VarbitRequirement(1372, 60, Operation.GREATER_EQUAL);
        this.sigilNearby = new ItemOnTileRequirement(this.sigil);
        this.evilDaveMoved = new VarbitRequirement(1380, 2, Operation.GREATER_EQUAL);
        this.baddenMoved = new VarbitRequirement(1381, 2, Operation.GREATER_EQUAL);
        this.reenMoved = new VarbitRequirement(1382, 2, Operation.GREATER_EQUAL);
        this.golemRejected = new VarbitRequirement(1379, 1, Operation.GREATER_EQUAL);
        this.golemReprogrammed = new VarbitRequirement(1379, 2, Operation.GREATER_EQUAL);
        this.golemMoved = new VarbitRequirement(1379, 3, Operation.GREATER_EQUAL);
    }

    private void setupSteps() {
        this.talkToReen = new NpcStep((QuestHelper)this, 893, new WorldPoint(3270, 3159, 0), "Talk to Father Reen outside Al Kharid bank.", new Requirement[0]);
        this.talkToReen.addDialogStep("That's me!");
        this.talkToBadden = new NpcStep((QuestHelper)this, 895, new WorldPoint(3490, 3090, 0), "Talk to Father Badden in Uzer.", this.silverlight, this.darkItems);
        this.talkToBadden.addDialogSteps("Reen sent me.", "So what do you want me to do?", "How can I do that?");
        this.pickMushroom = new ObjectStep((QuestHelper)this, 6311, new WorldPoint(3495, 3088, 0), "Pick up some black mushrooms.", new Requirement[0]);
        this.dyeSilverlight = new DetailedQuestStep((QuestHelper)this, "Use the black mushrooms on Silverlight.", this.silverlightHighlighted, this.blackMushroomHighlighted);
        this.goIntoRuin = new ObjectStep((QuestHelper)this, 6373, new WorldPoint(3493, 3090, 0), "Enter the Uzer ruins.", this.silverlightDyedEquipped, this.darkItems);
        this.pickUpStrangeImplement = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2713, 4913, 0), "Pick up the strange implement in the north west corner of the ruin.", this.strangeImplement);
        this.talkToEvilDave = new NpcStep((QuestHelper)this, 902, new WorldPoint(2721, 4911, 0), "Talk to Evil Dave with the dyed Silverlight and 3 dark clothing items equipped.", this.silverlightDyedEquipped, this.darkItems);
        this.talkToEvilDave.addDialogSteps("I want to join your group.", "I'm evil!");
        this.enterPortal = new ObjectStep((QuestHelper)this, 6310, new WorldPoint(2722, 4913, 0), "Enter the portal.", new Requirement[0]);
        this.enterRuinNoDark = new ObjectStep((QuestHelper)this, 6373, new WorldPoint(3493, 3090, 0), "Enter the Uzer ruins.", new Requirement[0]);
        this.talkToDenath = new NpcStep((QuestHelper)this, 897, new WorldPoint(2720, 4912, 2), "Talk to Denath next to the throne.", new Requirement[0]);
        this.talkToDenath.addDialogStep("What do I have to do?");
        this.talkToDenath.addSubSteps(this.enterRuinNoDark, this.enterPortal);
        this.talkToJennifer = new NpcStep((QuestHelper)this, 905, new WorldPoint(2723, 4901, 2), "Talk to Jennifer.", new Requirement[0]);
        this.talkToJennifer.addDialogStep("Do you have the demonic sigil mould?");
        this.talkToMatthew = new NpcStep((QuestHelper)this, 903, new WorldPoint(2727, 4897, 2), "Talk to Matthew.", new Requirement[0]);
        this.talkToMatthew.addDialogStep("Do you know what happened to Josef?");
        this.smeltSigil = new DetailedQuestStep((QuestHelper)this, "Travel to any furnace with the sigil mould and silver bar and smelt a sigil.", this.silverBar, this.sigilMould);
        this.talkToGolem = new NpcStep((QuestHelper)this, 5136, new WorldPoint(3485, 3088, 0), "Talk to the Golem in Uzer.", this.silverlightDyed, this.sigil, this.combatGear);
        this.talkToGolem.addDialogStep("Did you see anything happen last night?");
        this.searchKiln = new SearchKilns(this);
        this.readBook = new DetailedQuestStep((QuestHelper)this, "Read the book.", this.bookHighlighted);
        this.enterRuinAfterBook = new ObjectStep((QuestHelper)this, 6373, new WorldPoint(3493, 3090, 0), "Enter the Uzer ruins.", this.silverlightDyed, this.book, this.sigil);
        this.enterPortalAfterBook = new ObjectStep((QuestHelper)this, 6310, new WorldPoint(2722, 4913, 0), "Enter the portal.", this.book, this.sigil);
        this.talkToMatthewAfterBook = new NpcStep((QuestHelper)this, 903, new WorldPoint(2727, 4897, 2), "Bring the book to Matthew in the Demon Throne Room. Afterwards Denath should start the ritual. If he doesn't, leave and re-enter the throne room and talk to Matthew again.", this.book);
        this.talkToMatthewAfterBook.addSubSteps(this.enterRuinAfterBook, this.enterPortalAfterBook);
        this.enterRuinForRitual = new ObjectStep((QuestHelper)this, 6373, new WorldPoint(3493, 3090, 0), "Enter the Uzer ruins.", this.sigil, this.silverlightDyed, this.combatGear);
        this.enterPortalForRitual = new ObjectStep((QuestHelper)this, 6310, new WorldPoint(2722, 4913, 0), "Enter the portal.", new Requirement[0]);
        this.standInCircle = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2718, 4902, 2), "Stand in the correct spot in the circle.", this.sigil);
        this.readIncantation = new IncantationStep((QuestHelper)this, true);
        this.pickUpSigil = new ItemStep((QuestHelper)this, "Pick up the sigil.", this.sigil);
        this.leavePortal = new ObjectStep((QuestHelper)this, 10251, new WorldPoint(2720, 4883, 2), "Leave the throne room.", new Requirement[0]);
        this.enterRuinForDave = new ObjectStep((QuestHelper)this, 6373, new WorldPoint(3493, 3090, 0), "Talk to Evil Dave in the Uzer ruins.", new Requirement[0]);
        this.tellDaveToReturn = new NpcStep((QuestHelper)this, 902, new WorldPoint(2721, 4900, 0), "Talk to Evil Dave.", new Requirement[0]);
        this.tellDaveToReturn.addDialogStep("You've got to get back to the throne room!");
        this.tellDaveToReturn.addSubSteps(this.enterRuinForDave);
        this.pickUpImplementAfterRitual = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2713, 4913, 0), "Pick up the strange implement in the north west corner of the ruin.", this.strangeImplement);
        this.pickUpSigil2 = new ItemStep((QuestHelper)this, "Pick up the sigil Tanya dropped.", this.sigil);
        this.goUpToBadden = new ObjectStep((QuestHelper)this, 6372, new WorldPoint(2722, 4885, 0), "Leave the ruins.", new Requirement[0]);
        this.talkToBaddenAfterRitual = new NpcStep((QuestHelper)this, 895, new WorldPoint(3490, 3090, 0), "Talk to Father Badden in Uzer.", this.sigil2);
        this.talkToBaddenAfterRitual.addSubSteps(this.goUpToBadden);
        this.talkToReenAfterRitual = new NpcStep((QuestHelper)this, 893, new WorldPoint(3490, 3090, 0), "Talk to Father Reen in Uzer.", this.sigil2);
        this.talkToReenAfterRitual.addDialogStep("Oh, don't be so simple-minded!");
        this.talkToTheGolemAfterRitual = new NpcStep((QuestHelper)this, 5136, new WorldPoint(3485, 3088, 0), "Talk to the Golem in Uzer.", this.strangeImplement);
        this.useImplementOnGolem = new NpcStep((QuestHelper)this, 5136, new WorldPoint(3485, 3088, 0), "Use the strange implement on the Golem in Uzer.", this.strangeImplementHighlighted);
        this.useImplementOnGolem.addIcon(4619);
        this.talkToGolemAfterReprogramming = new NpcStep((QuestHelper)this, 5136, new WorldPoint(3485, 3088, 0), "Talk to the Golem again.", this.sigil2);
        this.enterRuinAfterRecruiting = new ObjectStep((QuestHelper)this, 6373, new WorldPoint(3493, 3090, 0), "Enter the Uzer ruins.", this.silverlightDyed, this.sigil, this.combatGear);
        this.enterPortalAfterRecruiting = new ObjectStep((QuestHelper)this, 6310, new WorldPoint(2722, 4913, 0), "Enter the portal.", this.silverlightDyed, this.sigil, this.combatGear);
        this.talkToMatthewToStartFight = new NpcStep((QuestHelper)this, 903, new WorldPoint(2727, 4897, 2), "Talk to Matthew in the throne room.", this.silverlightDyed, this.sigil, this.combatGear);
        this.talkToMatthewToStartFight.addSubSteps(this.enterRuinAfterRecruiting, this.enterPortalAfterRecruiting);
        this.talkToMatthewToStartFight.addDialogStep("Yes.");
        this.standInCircleAgain = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2720, 4903, 2), "Stand in the correct spot in the circle.", this.sigil);
        this.incantRitual = new IncantationStep((QuestHelper)this, false);
        this.enterRuinForFight = new ObjectStep((QuestHelper)this, 6373, new WorldPoint(3493, 3090, 0), "Enter the Uzer ruins to finish fighting Agrith-Naar.", this.silverlightDyed, this.combatGear);
        this.enterPortalForFight = new ObjectStep((QuestHelper)this, 6310, new WorldPoint(2722, 4913, 0), "Enter the portal to finish fighting Agrith-Naar.", this.silverlightDyed, this.combatGear);
        this.killDemon = new NpcStep((QuestHelper)this, 911, "Kill Agrith-Naar. You can hurt him with any weapon, BUT YOU MUST DEAL THE FINAL BLOW WITH SILVERLIGHT.", this.silverlightDyedEquipped, this.combatGear);
        this.killDemon.addSubSteps(this.enterRuinForFight, this.enterPortalForFight);
        this.unequipDarklight = new DetailedQuestStep((QuestHelper)this, "Unequip Darklight to complete the quest!", new Requirement[0]);
    }

    @Override
    public List<String> getNotes() {
        return Arrays.asList("You will need 3 black items for a part of the quest. Potential items would be:", "- Desert shirt/robe dyed with black mushroom ink", "- Black armour", "- Priest gown top/bottom", "- Black wizard hat", "- Dark mystic", "- Ghostly robes", "- Shade robes", "- Black dragonhide", "- Black cape", "- One of the various black holiday event items");
    }

    @Override
    public List<String> getCombatRequirements() {
        return Collections.singletonList("Agrith-Naar (level 100)");
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.silverlight, this.darkItems, this.silverBar);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.combatGear, this.coinsForCarpet);
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new QuestRequirement(QuestHelperQuest.THE_GOLEM, QuestState.FINISHED));
        req.add(new QuestRequirement(QuestHelperQuest.DEMON_SLAYER, QuestState.FINISHED));
        req.add(new SkillRequirement(Skill.CRAFTING, 30, true));
        return req;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Arrays.asList(new ItemReward("10,000 Experience Lamp (Any combat skill except Prayer)", 4447, 1), new ItemReward("Darklight", 6746, 1));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting off", Collections.singletonList(this.talkToReen), new Requirement[0]));
        allSteps.add(new PanelDetails("Infiltrate the cult", Arrays.asList(this.talkToBadden, this.pickMushroom, this.dyeSilverlight, this.goIntoRuin, this.pickUpStrangeImplement, this.talkToEvilDave, this.talkToJennifer, this.talkToMatthew), this.silverlight, this.darkItems));
        allSteps.add(new PanelDetails("Uncovering the truth", Arrays.asList(this.smeltSigil, this.talkToGolem, this.searchKiln, this.readBook, this.talkToMatthewAfterBook, this.standInCircle, this.readIncantation), this.silverBar, this.silverlightDyed, this.combatGear));
        allSteps.add(new PanelDetails("Defeating Agrith-Naar", Arrays.asList(this.pickUpSigil, this.leavePortal, this.pickUpSigil2, this.tellDaveToReturn, this.talkToBaddenAfterRitual, this.talkToReenAfterRitual, this.talkToTheGolemAfterRitual, this.useImplementOnGolem, this.talkToGolemAfterReprogramming, this.talkToMatthewToStartFight, this.standInCircleAgain, this.incantRitual, this.killDemon, this.unequipDarklight), this.silverlightDyed, this.combatGear));
        return allSteps;
    }
}

