/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.shadowofthestorm;

import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.steps.DetailedQuestStep;
import java.util.Collections;
import java.util.HashMap;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.client.eventbus.Subscribe;
import org.apache.commons.lang3.ArrayUtils;

public class IncantationStep
extends DetailedQuestStep {
    private final HashMap<Integer, String> words = new HashMap<Integer, String>(){
        {
            this.put(0, "Caldar");
            this.put(1, "Nahudu");
            this.put(2, "Agrith-Naar");
            this.put(3, "Camerinthum");
            this.put(4, "Tarren");
        }
    };
    private final boolean reverse;
    private String[] incantationOrder;
    private int incantationPosition = 0;

    public IncantationStep(QuestHelper questHelper, boolean reverse) {
        super(questHelper, "Click the demonic sigil and read the incantation.", new Requirement[0]);
        ItemRequirement sigilHighlighted = new ItemRequirement("Demonic sigil", 6748);
        sigilHighlighted.setHighlightInInventory(true);
        this.addItemRequirements(Collections.singletonList(sigilHighlighted));
        this.reverse = reverse;
    }

    @Override
    public void startUp() {
        super.startUp();
        this.updateHints();
    }

    @Override
    public void onWidgetLoaded(WidgetLoaded event) {
        int groupId = event.getGroupId();
        if (groupId == 219) {
            this.clientThread.invokeLater(this::updateChoiceIfRequired);
        }
        super.onWidgetLoaded(event);
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        Widget widget = event.getWidget();
        if (widget == null) {
            return;
        }
        if (widget.getId() != 0x950000) {
            return;
        }
        if (event.getMenuOption().equals("Chant")) {
            this.incantationPosition = 0;
        }
    }

    private void updateChoiceIfRequired() {
        if (!this.shouldUpdateChoice()) {
            return;
        }
        this.choices.resetChoices();
        this.addDialogStep(this.incantationOrder[this.incantationPosition]);
        ++this.incantationPosition;
    }

    private boolean shouldUpdateChoice() {
        Widget widget = this.client.getWidget(219, 1);
        if (widget == null) {
            return false;
        }
        Widget[] children = widget.getChildren();
        if (children == null || children.length < 3) {
            return false;
        }
        Widget childWidget = widget.getChild(2);
        return childWidget != null && "Nahudu".equals(childWidget.getText());
    }

    protected void updateHints() {
        if (this.incantationOrder != null || this.client.getVarbitValue(1374) == 0 && this.client.getVarbitValue(1375) == 0) {
            return;
        }
        this.incantationOrder = new String[]{this.words.get(this.client.getVarbitValue(1373)), this.words.get(this.client.getVarbitValue(1374)), this.words.get(this.client.getVarbitValue(1375)), this.words.get(this.client.getVarbitValue(1376)), this.words.get(this.client.getVarbitValue(1377))};
        if (this.reverse) {
            ArrayUtils.reverse((Object[])this.incantationOrder);
        }
        String incantString = "Say the following in order: " + String.join((CharSequence)", ", this.incantationOrder);
        this.setText("Click the demonic sigil and read the incantation.");
        this.addText(incantString);
    }
}

