/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.shadesofmortton;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.conditional.ObjectCondition;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.FreeInventorySlotRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.Operation;
import com.questhelper.requirements.var.VarplayerRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.SHADES_OF_MORTTON)
public class ShadesOfMortton
extends BasicQuestHelper {
    ItemRequirement combatGear;
    ItemRequirement tarrominUnf2;
    ItemRequirement tarrominUnfHighlighted;
    ItemRequirement tinderbox;
    ItemRequirement ashes2;
    ItemRequirement ashesHighlighted;
    ItemRequirement coins5000;
    ItemRequirement hammerOrFlam;
    ItemRequirement log;
    ItemRequirement pyreLog;
    ItemRequirement serum207Highlighted;
    ItemRequirement serum208;
    ItemRequirement sacredOilHighlighted;
    ItemRequirement oliveOil;
    ItemRequirement timber5;
    ItemRequirement swampPaste25;
    ItemRequirement lime5;
    ItemRequirement diary;
    ItemRequirement loar5;
    ItemRequirement loar;
    ItemRequirement serum207;
    ItemRequirement oliveOilHighlighted;
    ItemRequirement logHighlighted;
    ItemRequirement morttonTele;
    ItemRequirement food;
    ItemRequirement flamHammer;
    ItemRequirement flamtaerBracelet;
    Requirement inventorySpace11;
    Requirement razmirePartlyCured;
    Requirement ulsquirePartlyCured;
    Requirement repairedTemple;
    Requirement litFire;
    Requirement has20Sanctity;
    Requirement curedRazmire;
    Requirement curedUlsquire;
    QuestStep searchShelf;
    QuestStep readDiary;
    QuestStep addAshes;
    QuestStep use207OnRazmire;
    QuestStep talkToRazmire;
    QuestStep kill5Shades;
    QuestStep kill4Shades;
    QuestStep kill3Shades;
    QuestStep kill2Shades;
    QuestStep kill1Shades;
    QuestStep use207OnRazmireAgain;
    QuestStep talkToRazmireAgain;
    QuestStep buyTimberLimeAndSwamp;
    QuestStep use207OnUlsquire;
    QuestStep talkToUlsquire;
    QuestStep talkToUlsquireAgain;
    QuestStep repairTemple;
    QuestStep lightAltar;
    QuestStep useOilOnFlame;
    QuestStep use207OnFlame;
    QuestStep useOilOnLog;
    QuestStep burnCorpse;
    QuestStep repairTo20Sanctity;
    QuestStep use208OnRazmire;
    QuestStep use208OnUlsquire;
    QuestStep talkToUlsquireToFinish;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        ConditionalStep goReadDiary = new ConditionalStep((QuestHelper)this, this.searchShelf, new Requirement[0]);
        goReadDiary.addStep(this.diary.alsoCheckBank(this.questBank), this.readDiary);
        steps.put(0, goReadDiary);
        steps.put(5, this.addAshes);
        ConditionalStep goTalkToRazmire = new ConditionalStep((QuestHelper)this, this.use207OnRazmire, new Requirement[0]);
        goTalkToRazmire.addStep(this.razmirePartlyCured, this.talkToRazmire);
        steps.put(10, goTalkToRazmire);
        steps.put(15, this.kill5Shades);
        steps.put(20, this.kill4Shades);
        steps.put(25, this.kill3Shades);
        steps.put(30, this.kill2Shades);
        steps.put(35, this.kill1Shades);
        ConditionalStep goTalkToRazmireAgain = new ConditionalStep((QuestHelper)this, this.use207OnRazmireAgain, new Requirement[0]);
        goTalkToRazmireAgain.addStep(this.razmirePartlyCured, this.talkToRazmireAgain);
        steps.put(40, goTalkToRazmireAgain);
        ConditionalStep goTalkToUlsquire = new ConditionalStep((QuestHelper)this, this.use207OnUlsquire, new Requirement[0]);
        goTalkToUlsquire.addStep(this.ulsquirePartlyCured, this.talkToUlsquire);
        steps.put(45, goTalkToUlsquire);
        ConditionalStep goTalkToUlsquireAgain = new ConditionalStep((QuestHelper)this, this.use207OnUlsquire, new Requirement[0]);
        goTalkToUlsquireAgain.addStep(this.ulsquirePartlyCured, this.talkToUlsquireAgain);
        steps.put(47, goTalkToUlsquireAgain);
        ConditionalStep makeSacredOil = new ConditionalStep((QuestHelper)this, this.repairTemple, new Requirement[0]);
        makeSacredOil.addStep(new Conditions(this.litFire, this.has20Sanctity, this.sacredOilHighlighted), this.use207OnFlame);
        makeSacredOil.addStep(new Conditions(this.litFire, this.has20Sanctity), this.useOilOnFlame);
        makeSacredOil.addStep(this.litFire, this.repairTo20Sanctity);
        makeSacredOil.addStep(this.repairedTemple, this.lightAltar);
        steps.put(50, makeSacredOil);
        steps.put(55, makeSacredOil);
        steps.put(60, makeSacredOil);
        ConditionalStep saveRemains = new ConditionalStep((QuestHelper)this, this.repairTemple, new Requirement[0]);
        saveRemains.addStep(new Conditions(this.serum208.alsoCheckBank(this.questBank), this.sacredOilHighlighted), this.useOilOnLog);
        saveRemains.addStep(new Conditions(this.litFire, this.has20Sanctity, this.sacredOilHighlighted), this.use207OnFlame);
        saveRemains.addStep(new Conditions(this.litFire, this.has20Sanctity), this.useOilOnFlame);
        saveRemains.addStep(this.litFire, this.repairTo20Sanctity);
        saveRemains.addStep(this.repairedTemple, this.lightAltar);
        steps.put(65, saveRemains);
        steps.put(70, this.burnCorpse);
        steps.put(75, this.burnCorpse);
        ConditionalStep goCureProperly = new ConditionalStep((QuestHelper)this, this.use208OnRazmire, new Requirement[0]);
        goCureProperly.addStep(new Conditions(this.curedRazmire, this.curedUlsquire), this.talkToUlsquireToFinish);
        goCureProperly.addStep(this.curedRazmire, this.use208OnUlsquire);
        steps.put(80, goCureProperly);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.combatGear = new ItemRequirement("Combat gear", -1, -1).isNotConsumed();
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.tarrominUnf2 = new ItemRequirement("Tarromin potion (unf)", 95, 2);
        this.tarrominUnfHighlighted = new ItemRequirement("Tarromin potion (unf)", 95);
        this.tarrominUnfHighlighted.setHighlightInInventory(true);
        this.tinderbox = new ItemRequirement("Tinderbox", 590).isNotConsumed();
        this.ashes2 = new ItemRequirement("Ashes", 592, 2);
        this.ashesHighlighted = new ItemRequirement("Ashes", 592);
        this.ashesHighlighted.setHighlightInInventory(true);
        this.coins5000 = new ItemRequirement("Coins for building materials, or 18000 if you want to buy a Flamtaer hammer", ItemCollections.COINS, 5000);
        this.hammerOrFlam = new ItemRequirement("Hammer or Flamtaer Hammer", ItemCollections.HAMMER).isNotConsumed();
        this.hammerOrFlam.addAlternates(3678);
        this.flamHammer = new ItemRequirement("Flamtaer hammer", 3678).isNotConsumed();
        this.flamHammer.setTooltip("This speeds up the repair section of the quest considerably");
        this.morttonTele = new ItemRequirement("A Mort'ton teleport or Barrows teleport tablet", 12406);
        this.morttonTele.addAlternates(19629);
        this.food = new ItemRequirement("Food", ItemCollections.GOOD_EATING_FOOD, -1);
        this.flamtaerBracelet = new ItemRequirement("Flamtaer bracelet", 21180);
        this.flamtaerBracelet.setTooltip("This speeds up the repair section of the quest considerably");
        this.log = new ItemRequirement("A log whose pyre version you can burn", 1511);
        this.log.addAlternates(1521, 1517, 1519, 1515, 1513, 19669);
        this.logHighlighted = new ItemRequirement("A log whose pyre version you can burn", 1511);
        this.logHighlighted.addAlternates(1521, 1517, 1519, 1515, 1513, 19669);
        this.logHighlighted.setHighlightInInventory(true);
        this.pyreLog = new ItemRequirement("A pyre log you can burn", 3438);
        this.pyreLog.addAlternates(3440, 3444, 3442, 3446, 3448, 19672);
        this.pyreLog.setHighlightInInventory(true);
        this.serum207Highlighted = new ItemRequirement("Serum 207", 3414);
        this.serum207Highlighted.setTooltip("You can make more with a tarromin potion (unf) and some ashes");
        this.serum207Highlighted.setHighlightInInventory(true);
        this.serum207Highlighted.addAlternates(3412, 3410, 3408);
        this.serum207 = new ItemRequirement("Serum 207", 3414);
        this.serum207.setTooltip("You can make more with a tarromin potion (unf) and some ashes");
        this.serum207.addAlternates(3412, 3410, 3408);
        this.serum208 = new ItemRequirement("Serum 208", 3419);
        this.serum208.setHighlightInInventory(true);
        this.serum208.addAlternates(3418, 3417, 3416);
        this.sacredOilHighlighted = new ItemRequirement("Sacred oil", 3436);
        this.sacredOilHighlighted.setHighlightInInventory(true);
        this.sacredOilHighlighted.addAlternates(3434, 3432, 3430);
        this.oliveOil = new ItemRequirement("Olive oil", 3422);
        this.oliveOil.addAlternates(3426, 3424, 3422);
        this.oliveOilHighlighted = new ItemRequirement("Olive oil", 3422);
        this.oliveOilHighlighted.addAlternates(3426, 3424, 3422);
        this.oliveOilHighlighted.setHighlightInInventory(true);
        this.swampPaste25 = new ItemRequirement("Swamp paste", 1941, 25);
        this.timber5 = new ItemRequirement("Timber beam", 8837, 5);
        this.lime5 = new ItemRequirement("Limestone brick", 3420, 5);
        this.diary = new ItemRequirement("Diary", 3395);
        this.diary.setHighlightInInventory(true);
        this.loar = new ItemRequirement("Loar remains", 3396);
        this.loar.setHighlightInInventory(true);
        this.loar5 = new ItemRequirement("Loar remains", 3396, 5);
        this.inventorySpace11 = new FreeInventorySlotRequirement(11);
    }

    public void setupConditions() {
        this.has20Sanctity = new VarplayerRequirement(341, 20);
        this.razmirePartlyCured = new VarplayerRequirement(340, true, 3);
        this.curedRazmire = new VarplayerRequirement(340, true, 6);
        this.ulsquirePartlyCured = new VarplayerRequirement(340, true, 1);
        this.curedUlsquire = new VarplayerRequirement(340, true, 5);
        this.repairedTemple = new VarplayerRequirement(343, 100);
        this.has20Sanctity = new VarplayerRequirement(345, 20, Operation.GREATER_EQUAL);
        this.litFire = new ObjectCondition(4090, new WorldPoint(3506, 3316, 0));
    }

    public void setupSteps() {
        this.searchShelf = new ObjectStep((QuestHelper)this, 4062, new WorldPoint(3481, 3279, 0), "Search the shelf in the south building of Mort'ton.", new Requirement[0]);
        this.readDiary = new DetailedQuestStep((QuestHelper)this, "Read the diary.", this.diary);
        this.addAshes = new DetailedQuestStep((QuestHelper)this, "Add ashes to a tarromin potion (unf).", this.tarrominUnfHighlighted, this.ashesHighlighted);
        this.use207OnRazmire = new NpcStep((QuestHelper)this, 1289, new WorldPoint(3488, 3296, 0), "Use the serum 207 on Razmire in the north of Mort'ton.", this.serum207Highlighted);
        ((NpcStep)this.use207OnRazmire).addAlternateNpcs(1290);
        this.use207OnRazmire.addIcon(3408);
        this.talkToRazmire = new NpcStep((QuestHelper)this, 1289, new WorldPoint(3488, 3296, 0), "Talk to Razmire in the north of Mort'ton.", this.serum207Highlighted);
        this.talkToRazmire.addDialogSteps("What are all these shadowy creatures?", "Yes, I'll dispatch those dark and evil creatures.");
        ((NpcStep)this.talkToRazmire).addAlternateNpcs(1290);
        this.kill5Shades = new NpcStep((QuestHelper)this, 1276, new WorldPoint(3488, 3287, 0), "Kill 5 Loar Shades and pick up their remains.", true, this.loar5);
        ((NpcStep)this.kill5Shades).addAlternateNpcs(1277);
        this.kill4Shades = new NpcStep((QuestHelper)this, 1276, new WorldPoint(3488, 3287, 0), "Kill 4 Loar Shades and pick up their remains.", true, this.loar5);
        ((NpcStep)this.kill4Shades).addAlternateNpcs(1277);
        this.kill3Shades = new NpcStep((QuestHelper)this, 1276, new WorldPoint(3488, 3287, 0), "Kill 3 Loar Shades and pick up their remains.", true, this.loar5);
        ((NpcStep)this.kill3Shades).addAlternateNpcs(1277);
        this.kill2Shades = new NpcStep((QuestHelper)this, 1276, new WorldPoint(3488, 3287, 0), "Kill 2 Loar Shades and pick up their remains.", true, this.loar5);
        ((NpcStep)this.kill2Shades).addAlternateNpcs(1277);
        this.kill1Shades = new NpcStep((QuestHelper)this, 1276, new WorldPoint(3488, 3287, 0), "Kill 1 Loar Shades and pick up their remains.", true, this.loar5);
        ((NpcStep)this.kill1Shades).addAlternateNpcs(1277);
        this.kill5Shades.addSubSteps(this.kill1Shades, this.kill2Shades, this.kill3Shades, this.kill4Shades);
        this.use207OnRazmireAgain = new NpcStep((QuestHelper)this, 1289, new WorldPoint(3488, 3296, 0), "Use the serum 207 on Razmire in the north of Mort'ton.", this.serum207Highlighted, this.loar5);
        ((NpcStep)this.use207OnRazmireAgain).addAlternateNpcs(1290);
        this.use207OnRazmireAgain.addIcon(3408);
        this.talkToRazmireAgain = new NpcStep((QuestHelper)this, 1289, new WorldPoint(3488, 3296, 0), "Talk to Razmire in the north of Mort'ton.", this.serum207Highlighted, this.loar5);
        ((NpcStep)this.talkToRazmireAgain).addAlternateNpcs(1290);
        this.buyTimberLimeAndSwamp = new NpcStep((QuestHelper)this, 1289, new WorldPoint(3488, 3296, 0), "Buy 5 timber beams, 5 limestone bricks, and 25 swamp paste from Razmire's builders' store.", this.timber5, this.lime5, this.swampPaste25);
        this.buyTimberLimeAndSwamp.addDialogSteps("Can you open a store for me?", "Can I see the building store please?");
        ((NpcStep)this.buyTimberLimeAndSwamp).addAlternateNpcs(1290);
        this.use207OnUlsquire = new NpcStep((QuestHelper)this, 1287, new WorldPoint(3496, 3289, 0), "Buy some olive oil from Razmire's general store, and 5 timber beams, 5 limestone bricks, and 25 swamp paste from their builders' store. Afterwards, use some serum 207 on Ulsquire.", this.serum207Highlighted);
        this.use207OnUlsquire.addIcon(3408);
        ((NpcStep)this.use207OnUlsquire).addAlternateNpcs(1288);
        this.use207OnUlsquire.addDialogSteps("Can you open a store for me?", "Can I see the general store please?");
        this.talkToUlsquire = new NpcStep((QuestHelper)this, 1287, new WorldPoint(3496, 3289, 0), "Talk to Ulsquire in the east of Mort'ton.", new Requirement[0]);
        ((NpcStep)this.talkToUlsquire).addAlternateNpcs(1288);
        this.talkToUlsquireAgain = new NpcStep((QuestHelper)this, 1287, new WorldPoint(3496, 3289, 0), "Talk to Ulsquire again.", new Requirement[0]);
        this.talkToUlsquireAgain.addDialogSteps("What can you tell me about that temple?");
        ((NpcStep)this.talkToUlsquireAgain).addAlternateNpcs(1288);
        this.repairTemple = new DetailedQuestStep((QuestHelper)this, new WorldPoint(3506, 3316, 0), "Repair the temple north east of Mort'ton. Do this on World 377 to make it faster and easier.", this.oliveOil, this.serum207, this.hammerOrFlam, this.lime5, this.timber5, this.swampPaste25);
        this.repairTo20Sanctity = new DetailedQuestStep((QuestHelper)this, new WorldPoint(3506, 3316, 0), "Keep repairing the temple until 20 sanctity.", this.oliveOil, this.serum207, this.hammerOrFlam, this.lime5, this.timber5, this.swampPaste25);
        this.lightAltar = new ObjectStep((QuestHelper)this, 4091, new WorldPoint(3506, 3316, 0), "Light the fire altar", this.tinderbox);
        this.useOilOnFlame = new ObjectStep((QuestHelper)this, 4090, new WorldPoint(3506, 3316, 0), "Use the olive oil on the temple's fire.", this.oliveOilHighlighted);
        this.useOilOnFlame.addIcon(3422);
        this.use207OnFlame = new ObjectStep((QuestHelper)this, 4090, new WorldPoint(3506, 3316, 0), "Use a serum 207 (with 2 or more doses) on the temple's fire.", this.serum207Highlighted);
        this.use207OnFlame.addIcon(3408);
        this.useOilOnLog = new DetailedQuestStep((QuestHelper)this, "Use the sacred oil on a log.", this.logHighlighted, this.sacredOilHighlighted);
        this.burnCorpse = new ObjectStep((QuestHelper)this, 4093, new WorldPoint(3507, 3277, 0), "Use the pyre log in a funeral pyre, then a loar remain. Finally, burn it.", this.pyreLog, this.loar);
        this.use208OnRazmire = new NpcStep((QuestHelper)this, 1289, new WorldPoint(3488, 3296, 0), "Use the serum 208 on Razmire in the north of Mort'ton.", this.serum208);
        this.use208OnRazmire.addIcon(3416);
        ((NpcStep)this.use207OnRazmire).addAlternateNpcs(1290);
        this.use208OnUlsquire = new NpcStep((QuestHelper)this, 1287, new WorldPoint(3496, 3289, 0), "Use some serum 208 on Ulsquire in the east of Mort'ton.", this.serum208);
        this.use208OnUlsquire.addIcon(3416);
        ((NpcStep)this.talkToUlsquire).addAlternateNpcs(1288);
        this.talkToUlsquireToFinish = new NpcStep((QuestHelper)this, 1287, new WorldPoint(3496, 3289, 0), "Talk to Ulsquire to finish the quest.", new Requirement[0]);
        ((NpcStep)this.talkToUlsquireToFinish).addAlternateNpcs(1288);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.tarrominUnf2, this.tinderbox, this.log, this.ashes2, this.coins5000, this.hammerOrFlam);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.combatGear, this.morttonTele, this.food, this.flamHammer, this.flamtaerBracelet);
    }

    @Override
    public List<Requirement> getGeneralRecommended() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(this.inventorySpace11);
        return req;
    }

    @Override
    public List<String> getNotes() {
        return Arrays.asList("Whilst in Mort Myre, the Ghasts will occasionally rot the food in your inventory and steal charges from your Druid Pouch.", "It's strongly recommended to bring a Flamtaer hammer and Flamtaer bracelets, as they speed up the temple repair section massively.");
    }

    @Override
    public List<String> getCombatRequirements() {
        return Collections.singletonList("5 Loar Shades (level 40)");
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new QuestRequirement(QuestHelperQuest.PRIEST_IN_PERIL, QuestState.FINISHED));
        req.add(new SkillRequirement(Skill.CRAFTING, 20));
        req.add(new SkillRequirement(Skill.HERBLORE, 15, true));
        req.add(new SkillRequirement(Skill.FIREMAKING, 5));
        return req;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(3);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Arrays.asList(new ExperienceReward(Skill.CRAFTING, 2000), new ExperienceReward(Skill.HERBLORE, 2000));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Collections.singletonList(new UnlockReward("Ability to play the Shades of Mort'ton Minigame"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Investigating the town", Arrays.asList(this.searchShelf, this.readDiary, this.addAshes), this.tarrominUnf2, this.ashes2, this.tinderbox, this.log, this.coins5000, this.hammerOrFlam));
        allSteps.add(new PanelDetails("Helping Razmire", Arrays.asList(this.use207OnRazmire, this.talkToRazmire, this.kill5Shades, this.use207OnRazmireAgain, this.talkToRazmireAgain), this.serum207Highlighted, this.tinderbox, this.log, this.coins5000, this.hammerOrFlam));
        allSteps.add(new PanelDetails("Helping Ulsquire", Arrays.asList(this.use207OnUlsquire, this.talkToUlsquire, this.talkToUlsquireAgain, this.repairTemple, this.lightAltar, this.repairTo20Sanctity, this.useOilOnFlame, this.use207OnFlame, this.useOilOnLog, this.burnCorpse, this.use208OnRazmire, this.use208OnUlsquire, this.talkToUlsquireToFinish), this.serum207Highlighted, this.tinderbox, this.log, this.coins5000, this.hammerOrFlam));
        return allSteps;
    }
}

