/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.secretsofthenorth;

import com.questhelper.QuestHelperPlugin;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.steps.QuestStep;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.util.HashMap;
import java.util.Map;
import net.runelite.api.events.VarClientIntChanged;
import net.runelite.api.widgets.Widget;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.ui.FontManager;

public class SolveChestCode
extends QuestStep {
    private final int ARROW_ONE_DOWN = 3;
    private final int ARROW_ONE_UP = 4;
    private final int ARROW_TWO_DOWN = 10;
    private final int ARROW_TWO_UP = 11;
    private final int ARROW_THREE_DOWN = 17;
    private final int ARROW_THREE_UP = 18;
    private final int ARROW_FOUR_DOWN = 24;
    private final int ARROW_FOUR_UP = 25;
    private final int COMPLETE = 5;
    private final HashMap<Integer, Integer> highlightButtons = new HashMap();
    private final HashMap<Integer, Integer> distance = new HashMap();

    public SolveChestCode(QuestHelper questHelper) {
        super(questHelper, "Open the north chest using the code \"7402\".");
        this.highlightButtons.put(1, 3);
        this.highlightButtons.put(2, 10);
        this.highlightButtons.put(3, 17);
        this.highlightButtons.put(4, 24);
        this.distance.put(1, 0);
        this.distance.put(2, 0);
        this.distance.put(3, 0);
        this.distance.put(4, 0);
    }

    @Subscribe
    public void onVarClientIntChanged(VarClientIntChanged varClientIntChanged) {
        this.updateSolvedPositionState();
    }

    private void updateSolvedPositionState() {
        int SLOT_ONE = 1113;
        int SLOT_TWO = 1114;
        int SLOT_THREE = 1115;
        int SLOT_FOUR = 1116;
        int ENTRY_ONE = 7;
        int ENTRY_TWO = 4;
        boolean ENTRY_THREE = false;
        int ENTRY_FOUR = 2;
        this.highlightButtons.replace(1, this.matchStateToSolution(1113, 7, 3, 4));
        this.highlightButtons.replace(2, this.matchStateToSolution(1114, 4, 10, 11));
        this.highlightButtons.replace(3, this.matchStateToSolution(1115, 0, 17, 18));
        this.highlightButtons.replace(4, this.matchStateToSolution(1116, 2, 24, 25));
        this.distance.replace(1, this.matchStateToDistance(1113, 7));
        this.distance.replace(2, this.matchStateToDistance(1114, 4));
        this.distance.replace(3, this.matchStateToDistance(1115, 0));
        this.distance.replace(4, this.matchStateToDistance(1116, 2));
        if (this.highlightButtons.get(1) + this.highlightButtons.get(2) + this.highlightButtons.get(3) + this.highlightButtons.get(4) == 0) {
            this.highlightButtons.put(5, 5);
        } else {
            this.highlightButtons.put(5, 0);
        }
    }

    private int matchStateToSolution(int slot, int target, int arrowRightId, int arrowLeftId) {
        int id;
        int currentValue = this.client.getVarcIntValue(slot);
        int n = id = Math.floorMod(currentValue - target, 10) < Math.floorMod(target - currentValue, 10) ? arrowRightId : arrowLeftId;
        if (currentValue != target) {
            return id;
        }
        return 0;
    }

    private int matchStateToDistance(int slot, int target) {
        int currentValue = this.client.getVarcIntValue(slot);
        return Math.min(Math.floorMod(currentValue - target, 10), Math.floorMod(target - currentValue, 10));
    }

    @Override
    public void makeWidgetOverlayHint(Graphics2D graphics, QuestHelperPlugin plugin) {
        super.makeWidgetOverlayHint(graphics, plugin);
        for (Map.Entry<Integer, Integer> entry : this.highlightButtons.entrySet()) {
            Widget widget;
            if (entry.getValue() == 0) continue;
            if (entry.getKey() == 5) {
                widget = this.client.getWidget(809, 5);
                if (widget == null) continue;
                graphics.setColor(new Color(this.questHelper.getConfig().targetOverlayColor().getRed(), this.questHelper.getConfig().targetOverlayColor().getGreen(), this.questHelper.getConfig().targetOverlayColor().getBlue(), 65));
                graphics.fill(widget.getBounds());
                graphics.setColor(this.questHelper.getConfig().targetOverlayColor());
                graphics.draw(widget.getBounds());
                continue;
            }
            widget = this.client.getWidget(809, 4);
            if (widget == null) continue;
            Widget arrow = widget.getChild(entry.getValue().intValue());
            if (arrow == null) break;
            graphics.setColor(new Color(this.questHelper.getConfig().targetOverlayColor().getRed(), this.questHelper.getConfig().targetOverlayColor().getGreen(), this.questHelper.getConfig().targetOverlayColor().getBlue(), 65));
            graphics.fill(arrow.getBounds());
            graphics.setColor(this.questHelper.getConfig().targetOverlayColor());
            graphics.draw(arrow.getBounds());
            if (this.distance.get(entry.getKey()) == null) continue;
            int widgetX = arrow.getCanvasLocation().getX() + arrow.getWidth() / 2 - 30;
            int widgetY = arrow.getCanvasLocation().getY() + arrow.getHeight() / 2 + 4;
            Font font = FontManager.getRunescapeFont().deriveFont(1, 16.0f);
            graphics.setFont(font);
            graphics.drawString(Integer.toString(this.distance.get(entry.getKey())), widgetX, widgetY);
        }
    }
}

