/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.seaslug;

import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.SEA_SLUG)
public class SeaSlug
extends BasicQuestHelper {
    ItemRequirement swampPaste;
    ItemRequirement glass;
    ItemRequirement dampSticks;
    ItemRequirement torch;
    ItemRequirement litTorch;
    ItemRequirement drySticks;
    Requirement onPlatformGroundFloor;
    Requirement onPlatformFirstFloor;
    Requirement onPlatform;
    Requirement onIsland;
    QuestStep talkToCaroline;
    QuestStep talkToHolgart;
    QuestStep talkToHolgartWithSwampPaste;
    QuestStep travelWithHolgart;
    QuestStep pickupGlass;
    QuestStep pickupDampSticks;
    QuestStep climbLadder;
    QuestStep talkToKennith;
    QuestStep goDownLadder;
    QuestStep goToIsland;
    QuestStep goToIslandFromMainland;
    QuestStep talkToKent;
    QuestStep returnFromIsland;
    QuestStep talkToBaileyForTorch;
    QuestStep useGlassOnDampSticks;
    QuestStep rubSticks;
    QuestStep goBackUpLadder;
    QuestStep talkToKennithAgain;
    QuestStep kickWall;
    QuestStep talkToKennithAfterKicking;
    QuestStep activateCrane;
    QuestStep goDownLadderAgain;
    QuestStep returnWithHolgart;
    QuestStep finishQuest;
    QuestStep travelWithHolgartFreeingKennith;
    Zone platformFirstFloor;
    Zone platformGroundFloor;
    Zone island;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToCaroline);
        steps.put(1, this.talkToHolgart);
        steps.put(2, this.talkToHolgartWithSwampPaste);
        ConditionalStep investigateThePlatform = new ConditionalStep((QuestHelper)this, this.travelWithHolgart, new Requirement[0]);
        investigateThePlatform.addStep(this.onPlatformFirstFloor, this.talkToKennith);
        investigateThePlatform.addStep(this.onPlatformGroundFloor, this.climbLadder);
        steps.put(3, investigateThePlatform);
        ConditionalStep goFindKent = new ConditionalStep((QuestHelper)this, this.travelWithHolgart, new Requirement[0]);
        goFindKent.addStep(this.onPlatformGroundFloor, this.goToIsland);
        goFindKent.addStep(this.onPlatformFirstFloor, this.goDownLadder);
        steps.put(4, goFindKent);
        ConditionalStep talkWithKent = new ConditionalStep((QuestHelper)this, this.goToIslandFromMainland, new Requirement[0]);
        talkWithKent.addStep(this.onIsland, this.talkToKent);
        steps.put(5, talkWithKent);
        ConditionalStep goToFirstFloor = new ConditionalStep((QuestHelper)this, this.travelWithHolgartFreeingKennith, new Requirement[0]);
        goToFirstFloor.addStep(new Conditions(this.litTorch), this.goBackUpLadder);
        goToFirstFloor.addStep(new Conditions(this.torch, this.drySticks), this.rubSticks);
        goToFirstFloor.addStep(new Conditions(this.torch, this.glass, this.dampSticks), this.useGlassOnDampSticks);
        goToFirstFloor.addStep(new Conditions(this.torch, this.glass), this.pickupDampSticks);
        goToFirstFloor.addStep(new Conditions(this.torch), this.pickupGlass);
        goToFirstFloor.addStep(this.onPlatform, this.talkToBaileyForTorch);
        ConditionalStep lightTheTorch = new ConditionalStep((QuestHelper)this, (QuestStep)goToFirstFloor, new Requirement[0]);
        lightTheTorch.addStep(this.onIsland, this.returnFromIsland);
        steps.put(6, lightTheTorch);
        ConditionalStep freeKennith = new ConditionalStep((QuestHelper)this, (QuestStep)goToFirstFloor, new Requirement[0]);
        freeKennith.addStep(this.onPlatformFirstFloor, this.talkToKennithAgain);
        steps.put(7, freeKennith);
        ConditionalStep breakWall = new ConditionalStep((QuestHelper)this, (QuestStep)goToFirstFloor, new Requirement[0]);
        breakWall.addStep(this.onPlatformFirstFloor, this.kickWall);
        steps.put(8, breakWall);
        ConditionalStep tellKennethYouBrokeWall = new ConditionalStep((QuestHelper)this, (QuestStep)goToFirstFloor, new Requirement[0]);
        tellKennethYouBrokeWall.addStep(this.onPlatformFirstFloor, this.talkToKennithAfterKicking);
        steps.put(9, tellKennethYouBrokeWall);
        ConditionalStep turnTheCrane = new ConditionalStep((QuestHelper)this, (QuestStep)goToFirstFloor, new Requirement[0]);
        turnTheCrane.addStep(this.onPlatformFirstFloor, this.activateCrane);
        steps.put(10, turnTheCrane);
        ConditionalStep finishUp = new ConditionalStep((QuestHelper)this, this.finishQuest, new Requirement[0]);
        finishUp.addStep(this.onPlatformGroundFloor, this.returnWithHolgart);
        finishUp.addStep(this.onPlatformFirstFloor, this.goDownLadderAgain);
        steps.put(11, finishUp);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.swampPaste = new ItemRequirement("Swamp paste", 1941);
        this.dampSticks = new ItemRequirement("Damp sticks", 1467);
        this.dampSticks.setHighlightInInventory(true);
        this.drySticks = new ItemRequirement("Dry sticks", 1468);
        this.drySticks.setHighlightInInventory(true);
        this.torch = new ItemRequirement("Unlit torch", 596);
        this.litTorch = new ItemRequirement("Lit torch", 594);
        this.glass = new ItemRequirement("Broken glass", 1469);
        this.glass.setHighlightInInventory(true);
    }

    public void loadZones() {
        this.platformGroundFloor = new Zone(new WorldPoint(2760, 3271, 0), new WorldPoint(2795, 3293, 0));
        this.platformFirstFloor = new Zone(new WorldPoint(2760, 3271, 1), new WorldPoint(2795, 3293, 1));
        this.island = new Zone(new WorldPoint(2787, 3312, 0), new WorldPoint(2802, 3327, 0));
    }

    public void setupConditions() {
        this.onPlatformFirstFloor = new ZoneRequirement(this.platformFirstFloor);
        this.onPlatformGroundFloor = new ZoneRequirement(this.platformGroundFloor);
        this.onPlatform = new ZoneRequirement(this.platformFirstFloor, this.platformGroundFloor);
        this.onIsland = new ZoneRequirement(this.island);
    }

    public void setupSteps() {
        this.talkToCaroline = new NpcStep((QuestHelper)this, 5067, new WorldPoint(2717, 3303, 0), "Talk to Caroline just north of Witchaven, east of East Ardougne.", new Requirement[0]);
        this.talkToCaroline.addDialogStep("I suppose so, how do I get there?");
        this.talkToHolgart = new NpcStep((QuestHelper)this, 7324, new WorldPoint(2717, 3303, 0), "Talk to Holgart nearby and give him some swamp paste.", this.swampPaste);
        this.talkToHolgartWithSwampPaste = new NpcStep((QuestHelper)this, 7324, new WorldPoint(2717, 3303, 0), "Give Holgart some swamp paste.", this.swampPaste);
        this.talkToHolgart.addSubSteps(this.talkToHolgartWithSwampPaste);
        this.travelWithHolgart = new NpcStep((QuestHelper)this, 7789, new WorldPoint(2717, 3303, 0), "Travel with Holgart to the fishing platform.", new Requirement[0]);
        this.travelWithHolgart.addDialogStep("Will you take me there?");
        this.climbLadder = new ObjectStep((QuestHelper)this, 18324, new WorldPoint(2784, 3286, 0), "Climb the ladder in the north east corner of the platform.", new Requirement[0]);
        this.talkToKennith = new NpcStep((QuestHelper)this, 5063, new WorldPoint(2765, 3289, 1), "Talk to Kennith from inside the cabin on the west side of the first floor.", new Requirement[0]);
        this.goDownLadder = new ObjectStep((QuestHelper)this, 18325, new WorldPoint(2784, 3286, 1), "Go back down the ladder.", new Requirement[0]);
        this.goToIsland = new NpcStep((QuestHelper)this, 5070, new WorldPoint(2781, 3274, 0), "Travel with Holgart to a nearby island.", new Requirement[0]);
        this.goToIslandFromMainland = new NpcStep((QuestHelper)this, 7789, new WorldPoint(2717, 3303, 0), "Travel with Holgart north of Witchaven to find Kent.", new Requirement[0]);
        this.goToIsland.addSubSteps(this.goToIsland);
        this.talkToKent = new NpcStep((QuestHelper)this, 5074, new WorldPoint(2794, 3322, 0), "Talk to Kent on the island.", new Requirement[0]);
        this.returnFromIsland = new NpcStep((QuestHelper)this, 5072, new WorldPoint(2801, 3320, 0), "Return to the platform with Holgart.", new Requirement[0]);
        this.travelWithHolgartFreeingKennith = new NpcStep((QuestHelper)this, 5069, new WorldPoint(2717, 3303, 0), "Travel with Holgart to the fishing platform.", new Requirement[0]);
        this.returnFromIsland.addSubSteps(this.travelWithHolgartFreeingKennith);
        this.talkToBaileyForTorch = new NpcStep((QuestHelper)this, 5066, new WorldPoint(2764, 3275, 0), "Talk to Bailey for an unlit torch.", new Requirement[0]);
        this.pickupGlass = new DetailedQuestStep((QuestHelper)this, "Pick up the broken glass in the room.", this.glass);
        this.pickupDampSticks = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2784, 3289, 0), "Pick up the damp sticks in the north east corner of the platform.", this.dampSticks);
        this.useGlassOnDampSticks = new DetailedQuestStep((QuestHelper)this, "Use the broken glass on damp sticks to dry them.", this.glass, this.dampSticks);
        this.rubSticks = new DetailedQuestStep((QuestHelper)this, "Rub the dry sticks to light the unlit torch.", new Requirement[0]);
        this.goBackUpLadder = new ObjectStep((QuestHelper)this, 18324, new WorldPoint(2784, 3286, 0), "Go up the ladder in the north east corner of the platform.", new Requirement[0]);
        this.talkToKennithAgain = new NpcStep((QuestHelper)this, 5063, new WorldPoint(2765, 3289, 1), "Talk to Kennith to the west.", new Requirement[0]);
        this.kickWall = new ObjectStep((QuestHelper)this, 18251, new WorldPoint(2768, 3289, 1), "Kick in the badly repaired wall east of Kennith.", new Requirement[0]);
        this.talkToKennithAfterKicking = new NpcStep((QuestHelper)this, 5063, new WorldPoint(2765, 3289, 1), "Talk to Kennith again.", new Requirement[0]);
        this.activateCrane = new ObjectStep((QuestHelper)this, 18327, new WorldPoint(2772, 3289, 1), "Rotate the crane east of Kennith's cabin.", new Requirement[0]);
        this.goDownLadderAgain = new ObjectStep((QuestHelper)this, 18325, new WorldPoint(2784, 3286, 1), "Go back down the ladder.", new Requirement[0]);
        this.returnWithHolgart = new NpcStep((QuestHelper)this, 5070, new WorldPoint(2781, 3274, 0), "Travel with Holgart back to the mainland.", new Requirement[0]);
        this.finishQuest = new NpcStep((QuestHelper)this, 5067, new WorldPoint(2717, 3303, 0), "Talk to Caroline to complete the quest.", new Requirement[0]);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.swampPaste);
        return reqs;
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        return Collections.singletonList(new SkillRequirement(Skill.FIREMAKING, 30, true));
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Collections.singletonList(new ExperienceReward(Skill.FISHING, 7125));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Collections.singletonList(new UnlockReward("Access to the Fishing Platform"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting off", Collections.singletonList(this.talkToCaroline), this.swampPaste));
        allSteps.add(new PanelDetails("Investigation", Arrays.asList(this.talkToHolgart, this.travelWithHolgart, this.climbLadder, this.talkToKennith, this.goDownLadder, this.goToIsland), new Requirement[0]));
        allSteps.add(new PanelDetails("Talking with Kent", Arrays.asList(this.talkToKent, this.returnFromIsland), new Requirement[0]));
        allSteps.add(new PanelDetails("Saving Kennith", Arrays.asList(this.talkToBaileyForTorch, this.pickupGlass, this.pickupDampSticks, this.useGlassOnDampSticks, this.rubSticks, this.goBackUpLadder, this.talkToKennithAgain, this.kickWall, this.talkToKennithAfterKicking, this.activateCrane, this.goDownLadderAgain, this.returnWithHolgart, this.finishQuest), new Requirement[0]));
        return allSteps;
    }

    @Override
    public List<String> getNotes() {
        return Collections.singletonList("You can complete an Ardougne Medium Diary task by fishing from the fishing platform using a fishing rod or small fishing net (these can be bought from the fishing shop near quest start in Witchaven).");
    }
}

