/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.scorpioncatcher;

import com.questhelper.collections.ItemCollections;
import com.questhelper.collections.KeyringCollection;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemOnTileRequirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.item.KeyringRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.ItemStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.SCORPION_CATCHER)
public class ScorpionCatcher
extends BasicQuestHelper {
    ItemRequirement dustyKey;
    ItemRequirement jailKey;
    ItemRequirement scorpionCageMissingTaverley;
    ItemRequirement scorpionCageMissingMonastery;
    ItemRequirement scorpionCageEmptyOrTaverley;
    ItemRequirement scorpionCageTaverleyAndMonastery;
    ItemRequirement scorpionCageFull;
    ItemRequirement food;
    ItemRequirement antiDragonShield;
    ItemRequirement antiPoison;
    ItemRequirement teleRunesFalador;
    ItemRequirement gamesNecklace;
    ItemRequirement gloryOrCombatBracelet;
    ItemRequirement camelotTeleport;
    QuestRequirement fairyRingAccess;
    Zone sorcerersTower3;
    Zone sorcerersTower2;
    Zone sorcerersTower1;
    Zone taverleyDungeon;
    Zone deepTaverleyDungeon1;
    Zone deepTaverleyDungeon2;
    Zone deepTaverleyDungeon3;
    Zone deepTaverleyDungeon4;
    Zone jailCell;
    Zone taverleyScorpionRoom;
    Zone upstairsMonastery;
    Zone barbarianOutpost;
    Requirement has70Agility;
    Requirement has80Agility;
    Requirement inTaverleyDungeon;
    Requirement inDeepTaverleyDungeon;
    Requirement inJailCell;
    Requirement inSorcerersTower1;
    Requirement inSorcerersTower2;
    Requirement inSorcerersTower3;
    Requirement inTaverleyScorpionRoom;
    Requirement inUpstairsMonastery;
    Requirement inBarbarianOutpost;
    Requirement jailKeyNearby;
    QuestStep speakToThormac;
    QuestStep speakToSeer1;
    QuestStep enterTaverleyDungeon;
    QuestStep goThroughPipe;
    QuestStep goOverStrangeFloor;
    QuestStep killJailerForKey;
    QuestStep getDustyFromAdventurer;
    QuestStep enterDeeperTaverley;
    QuestStep pickUpJailKey;
    QuestStep searchOldWall;
    QuestStep catchTaverleyScorpion;
    QuestStep sorcerersTowerLadder0;
    QuestStep sorcerersTowerLadder1;
    QuestStep sorcerersTowerLadder2;
    QuestStep enterMonastery;
    QuestStep catchMonasteryScorpion;
    QuestStep catchOutpostScorpion;
    QuestStep enterOutpost;
    QuestStep returnToThormac;
    ConditionalStep finishQuest;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.setupRequirements();
        this.setupZones();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        ConditionalStep goToTopOfTower = new ConditionalStep((QuestHelper)this, this.sorcerersTowerLadder0, new Requirement[0]);
        goToTopOfTower.addStep(this.inSorcerersTower1, this.sorcerersTowerLadder1);
        goToTopOfTower.addStep(this.inSorcerersTower2, this.sorcerersTowerLadder2);
        ConditionalStep beginQuest = new ConditionalStep((QuestHelper)this, (QuestStep)goToTopOfTower, new Requirement[0]);
        beginQuest.addStep(this.inSorcerersTower3, this.speakToThormac);
        this.finishQuest = new ConditionalStep((QuestHelper)this, (QuestStep)goToTopOfTower, "Return to Thormac to finish the quest.", this.scorpionCageFull);
        this.finishQuest.addStep(this.inSorcerersTower3, this.returnToThormac);
        ConditionalStep goGetTaverleyScorpion = new ConditionalStep((QuestHelper)this, this.enterTaverleyDungeon, new Requirement[0]);
        goGetTaverleyScorpion.addStep(new Conditions(this.inTaverleyScorpionRoom), this.catchTaverleyScorpion);
        goGetTaverleyScorpion.addStep(new Conditions(this.inDeepTaverleyDungeon), this.searchOldWall);
        goGetTaverleyScorpion.addStep(new Conditions(this.inTaverleyDungeon, this.has80Agility), this.goOverStrangeFloor);
        goGetTaverleyScorpion.addStep(new Conditions(this.inTaverleyDungeon, this.has70Agility), this.goThroughPipe);
        goGetTaverleyScorpion.addStep(new Conditions(this.inTaverleyDungeon, this.dustyKey), this.enterDeeperTaverley);
        goGetTaverleyScorpion.addStep(new Conditions(this.inTaverleyDungeon, new Conditions(LogicType.OR, this.inJailCell, this.jailKey)), this.getDustyFromAdventurer);
        goGetTaverleyScorpion.addStep(new Conditions(this.inTaverleyDungeon, this.jailKeyNearby), this.pickUpJailKey);
        goGetTaverleyScorpion.addStep(new Conditions(this.inTaverleyDungeon), this.killJailerForKey);
        ConditionalStep scorpions = new ConditionalStep((QuestHelper)this, (QuestStep)this.finishQuest, new Requirement[0]);
        scorpions.addStep(this.scorpionCageMissingTaverley.alsoCheckBank(this.questBank), goGetTaverleyScorpion);
        scorpions.addStep(new Conditions(this.scorpionCageMissingMonastery, this.inUpstairsMonastery), this.catchMonasteryScorpion);
        scorpions.addStep(this.scorpionCageMissingMonastery.alsoCheckBank(this.questBank), this.enterMonastery);
        scorpions.addStep(new Conditions(this.scorpionCageTaverleyAndMonastery, this.inBarbarianOutpost), this.catchOutpostScorpion);
        scorpions.addStep(this.scorpionCageTaverleyAndMonastery.alsoCheckBank(this.questBank), this.enterOutpost);
        steps.put(0, beginQuest);
        steps.put(1, this.speakToSeer1);
        steps.put(2, scorpions);
        steps.put(3, scorpions);
        return steps;
    }

    private void setupZones() {
        this.sorcerersTower3 = new Zone(new WorldPoint(2699, 3408, 3), new WorldPoint(2705, 3402, 3));
        this.sorcerersTower2 = new Zone(new WorldPoint(2699, 3408, 2), new WorldPoint(2705, 3402, 2));
        this.sorcerersTower1 = new Zone(new WorldPoint(2699, 3408, 1), new WorldPoint(2705, 3402, 1));
        this.taverleyDungeon = new Zone(new WorldPoint(2816, 9668, 0), new WorldPoint(2973, 9855, 0));
        this.deepTaverleyDungeon1 = new Zone(new WorldPoint(2816, 9856, 0), new WorldPoint(2880, 9760, 0));
        this.deepTaverleyDungeon2 = new Zone(new WorldPoint(2880, 9760, 0), new WorldPoint(2907, 9793, 0));
        this.deepTaverleyDungeon3 = new Zone(new WorldPoint(2889, 9793, 0), new WorldPoint(2923, 9815, 0));
        this.deepTaverleyDungeon4 = new Zone(new WorldPoint(2907, 9772, 0), new WorldPoint(2928, 9793, 0));
        this.jailCell = new Zone(new WorldPoint(2928, 9683, 0), new WorldPoint(2934, 9689, 0));
        this.taverleyScorpionRoom = new Zone(new WorldPoint(2874, 9798, 0), new WorldPoint(2880, 9793, 0));
        this.upstairsMonastery = new Zone(new WorldPoint(3043, 3499, 1), new WorldPoint(3060, 3481, 1));
        this.barbarianOutpost = new Zone(new WorldPoint(2546, 3573, 0), new WorldPoint(2555, 3560, 0));
    }

    @Override
    public void setupRequirements() {
        this.dustyKey = new KeyringRequirement("Dusty Key", this.configManager, KeyringCollection.DUSTY_KEY).isNotConsumed();
        this.dustyKey.setTooltip("Not needed if you have level 70 Agility, can be obtained during the quest");
        this.jailKey = new ItemRequirement("Jail Key", 1591);
        this.scorpionCageMissingTaverley = new ItemRequirement("Scorpion Cage", 456);
        this.scorpionCageMissingTaverley.addAlternates(460, 461, 462);
        this.scorpionCageMissingTaverley.setTooltip("You can get another from Thormac");
        this.scorpionCageMissingMonastery = new ItemRequirement("Scorpion Cage", 457);
        this.scorpionCageMissingMonastery.addAlternates(458);
        this.scorpionCageEmptyOrTaverley = new ItemRequirement("Scorpion Cage", 456);
        this.scorpionCageEmptyOrTaverley.addAlternates(457);
        this.scorpionCageTaverleyAndMonastery = new ItemRequirement("Scorpion Cage", 459);
        this.scorpionCageFull = new ItemRequirement("Scorpion Cage", 463);
        this.antiDragonShield = new ItemRequirement("Anti-dragon shield or DFS", ItemCollections.ANTIFIRE_SHIELDS).isNotConsumed();
        this.antiPoison = new ItemRequirement("Antipoison", ItemCollections.ANTIPOISONS);
        this.food = new ItemRequirement("Food", ItemCollections.GOOD_EATING_FOOD, -1);
        this.teleRunesFalador = new ItemRequirement("Teleport to Falador", 8009, -1);
        this.camelotTeleport = new ItemRequirement("Teleport to Camelot", 8010, -1);
        this.gamesNecklace = new ItemRequirement("Games Necklace", ItemCollections.GAMES_NECKLACES);
        this.gloryOrCombatBracelet = new ItemRequirement("A charged glory or a combat bracelet", ItemCollections.AMULET_OF_GLORIES);
        this.gloryOrCombatBracelet.addAlternates(ItemCollections.COMBAT_BRACELETS);
        this.fairyRingAccess = new QuestRequirement(QuestHelperQuest.FAIRYTALE_II__CURE_A_QUEEN, QuestState.IN_PROGRESS, "Fairy ring access");
        this.fairyRingAccess.setTooltip(QuestHelperQuest.FAIRYTALE_II__CURE_A_QUEEN.getName() + " is required to at least be started in order to use fairy rings");
    }

    private void setupConditions() {
        this.has70Agility = new SkillRequirement(Skill.AGILITY, 70, true);
        this.has80Agility = new SkillRequirement(Skill.AGILITY, 80, true);
        this.inSorcerersTower1 = new ZoneRequirement(this.sorcerersTower1);
        this.inSorcerersTower2 = new ZoneRequirement(this.sorcerersTower2);
        this.inSorcerersTower3 = new ZoneRequirement(this.sorcerersTower3);
        this.inTaverleyDungeon = new ZoneRequirement(this.taverleyDungeon);
        this.inDeepTaverleyDungeon = new ZoneRequirement(this.deepTaverleyDungeon1, this.deepTaverleyDungeon2, this.deepTaverleyDungeon3, this.deepTaverleyDungeon4);
        this.inJailCell = new ZoneRequirement(this.jailCell);
        this.jailKeyNearby = new ItemOnTileRequirement(this.jailKey);
        this.inTaverleyScorpionRoom = new ZoneRequirement(this.taverleyScorpionRoom);
        this.inUpstairsMonastery = new ZoneRequirement(this.upstairsMonastery);
        this.inBarbarianOutpost = new ZoneRequirement(this.barbarianOutpost);
    }

    private void setupSteps() {
        this.speakToThormac = new NpcStep((QuestHelper)this, 5232, new WorldPoint(2702, 3405, 3), "Speak to Thormac on the top floor of the Sorcerer's Tower south of Seer's Village.", new Requirement[0]);
        this.speakToThormac.addDialogStep("What do you need assistance with?");
        this.speakToThormac.addDialogStep("So how would I go about catching them then?");
        this.speakToThormac.addDialogStep("Ok, I will do it then");
        this.sorcerersTowerLadder0 = new ObjectStep((QuestHelper)this, 16683, new WorldPoint(2701, 3408, 0), "Climb to the top of the Sorcerer's Tower south of Seers' Village.", new Requirement[0]);
        this.sorcerersTowerLadder1 = new ObjectStep((QuestHelper)this, 16683, new WorldPoint(2704, 3403, 1), "Climb to the top of the Sorcerer's Tower south of Seers' Village.", new Requirement[0]);
        this.sorcerersTowerLadder2 = new ObjectStep((QuestHelper)this, 16683, new WorldPoint(2699, 3405, 2), "Climb to the top of the Sorcerer's Tower south of Seers' Village.", new Requirement[0]);
        this.speakToThormac.addSubSteps(this.sorcerersTowerLadder0, this.sorcerersTowerLadder1, this.sorcerersTowerLadder2);
        this.speakToSeer1 = new NpcStep((QuestHelper)this, 5231, new WorldPoint(2710, 3484, 0), "Speak to a seer in Seer's Village.", new Requirement[0]);
        this.speakToSeer1.addDialogStep("I need to locate some scorpions.");
        this.speakToSeer1.addDialogStep("Your friend Thormac sent me to speak to you.");
        this.enterTaverleyDungeon = this.client.getRealSkillLevel(Skill.AGILITY) >= 70 ? new ObjectStep((QuestHelper)this, 16680, new WorldPoint(2884, 3397, 0), "Go to Taverley Dungeon. As you're 70 Agility, you don't need a dusty key.", this.scorpionCageMissingTaverley) : new ObjectStep((QuestHelper)this, 16680, new WorldPoint(2884, 3397, 0), "Go to Taverley Dungeon. Bring a dusty key if you have one, otherwise you can get one in the dungeon.", this.scorpionCageMissingTaverley, this.dustyKey);
        this.goOverStrangeFloor = new ObjectStep((QuestHelper)this, 16510, new WorldPoint(2879, 9813, 0), "Go over the strange floor.", new Requirement[0]);
        this.goThroughPipe = new ObjectStep((QuestHelper)this, 16509, new WorldPoint(2888, 9799, 0), "Squeeze through the obstacle pipe.", new Requirement[0]);
        this.killJailerForKey = new NpcStep((QuestHelper)this, 300, new WorldPoint(2930, 9692, 0), "Travel through Taverley Dungeon until you reach the Black Knights' Base. Kill the Jailer in the east side of the base for a jail key.", new Requirement[0]);
        this.pickUpJailKey = new ItemStep((QuestHelper)this, "Pick up the jail key.", this.jailKey);
        this.getDustyFromAdventurer = new NpcStep((QuestHelper)this, 4925, new WorldPoint(2930, 9685, 0), "Use the jail key on the south door and talk to Velrak for a dusty key.", this.jailKey);
        this.getDustyFromAdventurer.addDialogStep("So... do you know anywhere good to explore?");
        this.getDustyFromAdventurer.addDialogStep("Yes please!");
        this.enterDeeperTaverley = new ObjectStep((QuestHelper)this, 2623, new WorldPoint(2924, 9803, 0), "Enter the gate to the deeper Taverley dungeon.", this.dustyKey);
        this.enterTaverleyDungeon.addSubSteps(this.goThroughPipe, this.goOverStrangeFloor, this.killJailerForKey, this.getDustyFromAdventurer, this.enterDeeperTaverley);
        this.searchOldWall = new ObjectStep((QuestHelper)this, 2117, new WorldPoint(2875, 9799, 0), "Search the Old wall.", new Requirement[0]);
        this.catchTaverleyScorpion = new NpcStep((QuestHelper)this, 5228, "Use the scorpion cage on the scorpion.", this.scorpionCageMissingTaverley);
        this.catchTaverleyScorpion.addIcon(456);
        this.enterMonastery = new ObjectStep((QuestHelper)this, 2641, new WorldPoint(3057, 3483, 0), "Enter the Edgeville Monastery.", new Requirement[0]);
        this.catchMonasteryScorpion = new NpcStep((QuestHelper)this, 5230, "Use the scorpion cage on the scorpion.", this.scorpionCageMissingMonastery);
        this.catchMonasteryScorpion.addIcon(456);
        this.enterOutpost = new ObjectStep((QuestHelper)this, 2115, new WorldPoint(2545, 3570, 0), "Enter the Barbarian Outpost.", new Requirement[0]);
        this.catchOutpostScorpion = new NpcStep((QuestHelper)this, 5229, new WorldPoint(2553, 3570, 0), "Use the scorpion cage on the scorpion.", this.scorpionCageTaverleyAndMonastery);
        this.catchOutpostScorpion.addIcon(456);
        this.returnToThormac = new NpcStep((QuestHelper)this, 5232, "", this.scorpionCageFull);
    }

    public ArrayList<ItemRequirement> getItemRequirements() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        if (this.client.getRealSkillLevel(Skill.AGILITY) < 70) {
            reqs.add(this.dustyKey);
        }
        return reqs.isEmpty() ? null : reqs;
    }

    public ArrayList<ItemRequirement> getItemRecommended() {
        return new ArrayList<ItemRequirement>(Arrays.asList(this.antiDragonShield, this.antiPoison, this.food, this.teleRunesFalador, this.camelotTeleport, this.gamesNecklace, this.gloryOrCombatBracelet));
    }

    public ArrayList<String> getCombatRequirements() {
        return new ArrayList<String>(Collections.singletonList("The ability to run past level 172 black demons and level 64 poison spiders"));
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Collections.singletonList(new ExperienceReward(Skill.STRENGTH, 6625));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Collections.singletonList(new UnlockReward("Ability to have Thormac turn a Battlestaff into a Mystic Staff for 40,000 Coins."));
    }

    public ArrayList<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Talk to Thormac", new ArrayList<QuestStep>(Collections.singletonList(this.speakToThormac)), new Requirement[0]));
        allSteps.add(new PanelDetails("The first scorpion", new ArrayList<QuestStep>(Arrays.asList(this.speakToSeer1, this.enterTaverleyDungeon, this.searchOldWall, this.catchTaverleyScorpion)), new Requirement[0]));
        allSteps.add(new PanelDetails("The second scorpion", new ArrayList<QuestStep>(Arrays.asList(this.enterMonastery, this.catchMonasteryScorpion)), new Requirement[0]));
        allSteps.add(new PanelDetails("The third scorpion", new ArrayList<QuestStep>(Arrays.asList(this.enterOutpost, this.catchOutpostScorpion)), new Requirement[0]));
        allSteps.add(new PanelDetails("Finishing up", new ArrayList<QuestStep>(Collections.singletonList(this.finishQuest)), new Requirement[0]));
        return allSteps;
    }

    public ArrayList<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> reqs = new ArrayList<Requirement>();
        reqs.add(new QuestRequirement(QuestHelperQuest.ALFRED_GRIMHANDS_BARCRAWL, QuestState.FINISHED));
        reqs.add(new SkillRequirement(Skill.PRAYER, 31));
        return reqs;
    }
}

