/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.runemysteries;

import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.RUNE_MYSTERIES)
public class RuneMysteries
extends BasicQuestHelper {
    ItemRequirement airTalisman;
    ItemRequirement researchPackage;
    ItemRequirement notes;
    ItemRequirement varrockTeleport;
    ItemRequirement wizardTeleport;
    Requirement inUpstairsLumbridge;
    Requirement inWizardBasement;
    QuestStep goUpToHoracio;
    QuestStep talkToHoracio;
    QuestStep goDownToSedridor;
    QuestStep talkToSedridor;
    QuestStep finishTalkingToSedridor;
    QuestStep talkToAubury;
    QuestStep talkToAudburyAgain;
    QuestStep goDownToSedridor2;
    QuestStep talkToSedridor2;
    Zone wizardBasement;
    Zone upstairsLumbridge;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.setupRequirements();
        this.setupZones();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        ConditionalStep goTalkToHoracio = new ConditionalStep((QuestHelper)this, this.goUpToHoracio, new Requirement[0]);
        goTalkToHoracio.addStep(this.inUpstairsLumbridge, this.talkToHoracio);
        steps.put(0, goTalkToHoracio);
        ConditionalStep goTalkToSedridor = new ConditionalStep((QuestHelper)this, this.goDownToSedridor, new Requirement[0]);
        goTalkToSedridor.addStep(this.inWizardBasement, this.talkToSedridor);
        steps.put(1, goTalkToSedridor);
        steps.put(2, this.finishTalkingToSedridor);
        steps.put(3, this.talkToAubury);
        steps.put(4, this.talkToAudburyAgain);
        ConditionalStep goTalkToSedridor2 = new ConditionalStep((QuestHelper)this, this.goDownToSedridor2, new Requirement[0]);
        goTalkToSedridor2.addStep(this.inWizardBasement, this.talkToSedridor2);
        steps.put(5, goTalkToSedridor2);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.airTalisman = new ItemRequirement("Air talisman", 1438).isNotConsumed();
        this.airTalisman.setTooltip("You can get another from Duke Horacio if you lost it");
        this.researchPackage = new ItemRequirement("Research package", 290);
        this.researchPackage.setTooltip("You can get another from Sedridor if you lost it");
        this.notes = new ItemRequirement("Research notes", 291);
        this.notes.setTooltip("You can get another from Aubury if you lost them");
        this.varrockTeleport = new ItemRequirement("Varrock teleport", 8007);
        this.wizardTeleport = new ItemRequirement("A teleport to the Wizard's Tower", ItemCollections.NECKLACE_OF_PASSAGES);
    }

    public void setupConditions() {
        this.inUpstairsLumbridge = new ZoneRequirement(this.upstairsLumbridge);
        this.inWizardBasement = new ZoneRequirement(this.wizardBasement);
    }

    public void setupZones() {
        this.upstairsLumbridge = new Zone(new WorldPoint(3203, 3206, 1), new WorldPoint(3218, 3231, 1));
        this.wizardBasement = new Zone(new WorldPoint(3094, 9553, 0), new WorldPoint(3125, 9582, 0));
    }

    public void setupSteps() {
        this.goUpToHoracio = new ObjectStep((QuestHelper)this, 16671, new WorldPoint(3205, 3208, 0), "Talk to Duke Horacio on the first floor of Lumbridge castle.", new Requirement[0]);
        this.talkToHoracio = new NpcStep((QuestHelper)this, 815, new WorldPoint(3210, 3220, 1), "Talk to Duke Horacio on the first floor of Lumbridge castle.", new Requirement[0]);
        this.talkToHoracio.addDialogStep("Have you any quests for me?");
        this.talkToHoracio.addDialogStep("Sure, no problem.");
        this.talkToHoracio.addSubSteps(this.goUpToHoracio);
        this.goDownToSedridor = new ObjectStep((QuestHelper)this, 2147, new WorldPoint(3104, 3162, 0), "Bring the Air Talisman to Sedridor in the Wizard Tower's basement.", this.airTalisman);
        this.goDownToSedridor.addDialogStep("Have you any quests for me?");
        this.talkToSedridor = new NpcStep((QuestHelper)this, 11432, new WorldPoint(3104, 9571, 0), "Bring the Air Talisman to Sedridor in the Wizard Tower's basement.", this.airTalisman);
        this.talkToSedridor.addDialogStep("I'm looking for the head wizard.");
        this.talkToSedridor.addDialogStep("Ok, here you are.");
        this.finishTalkingToSedridor = new NpcStep((QuestHelper)this, 11432, new WorldPoint(3104, 9571, 0), "Accept taking the package for Sedridor.", new Requirement[0]);
        this.finishTalkingToSedridor.addDialogStep("Yes, certainly.");
        this.talkToSedridor.addSubSteps(this.goDownToSedridor, this.finishTalkingToSedridor);
        this.talkToAubury = new NpcStep((QuestHelper)this, 10681, new WorldPoint(3253, 3401, 0), "Bring the Research Package to Aubury in south east Varrock.", this.researchPackage);
        this.talkToAubury.addDialogStep("I've been sent here with a package for you.");
        this.talkToAudburyAgain = new NpcStep((QuestHelper)this, 10681, new WorldPoint(3253, 3401, 0), "Talk to Aubury again in south east Varrock.", new Requirement[0]);
        this.goDownToSedridor2 = new ObjectStep((QuestHelper)this, 2147, new WorldPoint(3104, 3162, 0), "Bring the research notes to Sedridor in the Wizard Tower's basement.", this.notes);
        this.talkToSedridor2 = new NpcStep((QuestHelper)this, 11432, new WorldPoint(3104, 9571, 0), "Bring the notes to Sedridor in the Wizard Tower's basement.", this.notes);
        this.talkToSedridor2.addSubSteps(this.goDownToSedridor2);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.varrockTeleport);
        reqs.add(this.wizardTeleport);
        return reqs;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Collections.singletonList(new ItemReward("Air Talisman", 1438, 1));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("Ability to use the Runecrafting Skill."), new UnlockReward("Ability to mine Rune and Pure Essence."));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Discover Runecrafting", Arrays.asList(this.talkToHoracio, this.talkToSedridor, this.talkToAubury, this.talkToAudburyAgain, this.talkToSedridor2), new Requirement[0]));
        return allSteps;
    }
}

