/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.rumdeal;

import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedOwnerStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameTick;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.FishingSpot;

public class SlugSteps
extends DetailedOwnerStep {
    DetailedQuestStep addSluglings;
    DetailedQuestStep talkToPete;
    DetailedQuestStep goDownFromTop;
    DetailedQuestStep fish5Slugs;
    DetailedQuestStep goDownToSluglings;
    DetailedQuestStep goUpFromSluglings;
    DetailedQuestStep goUpToDropSluglings;
    DetailedQuestStep goUpF1ToPressure;
    DetailedQuestStep goUpToF2ToPressure;
    DetailedQuestStep pressure;
    ConditionalStep getSluglings;
    ConditionalStep pressureSluglings;
    ConditionalStep pullPressureLever;
    Zone islandF0;
    Zone islandF1;
    Zone islandF2;
    Requirement onIslandF0;
    Requirement onIslandF1;
    Requirement onIslandF2;
    ItemRequirement sluglings;
    ItemRequirement sluglingsHighlight;
    ItemRequirement netBowl;

    public SlugSteps(QuestHelper questHelper) {
        super(questHelper, new Requirement[0]);
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        this.updateSteps();
    }

    @Override
    protected void updateSteps() {
        int numHandedIn = this.client.getVarbitValue(1354);
        this.sluglings.setQuantity(5 - numHandedIn);
        if (numHandedIn >= 5) {
            this.startUpStep(this.pullPressureLever);
        } else if (this.sluglings.check(this.client)) {
            this.startUpStep(this.pressureSluglings);
        } else {
            this.startUpStep(this.getSluglings);
        }
    }

    @Override
    protected void setupSteps() {
        this.sluglings = new ItemRequirement("Sluglings or Karamthulu", 6715, 5);
        this.sluglingsHighlight = new ItemRequirement("Sluglings or Karamthulu", 6715, 5);
        this.netBowl = new ItemRequirement("Fishbowl and net", 6673);
        this.netBowl.setTooltip("You can get another from Captain Braindeath, or make it with a fishbowl and large net");
        this.sluglingsHighlight.setHighlightInInventory(true);
        this.sluglingsHighlight.addAlternates(6716, 6717);
        this.sluglings.addAlternates(6716, 6717);
        this.islandF0 = new Zone(new WorldPoint(2110, 5054, 0), new WorldPoint(2178, 5185, 0));
        this.islandF1 = new Zone(new WorldPoint(2110, 5054, 1), new WorldPoint(2178, 5185, 1));
        this.islandF2 = new Zone(new WorldPoint(2110, 5054, 2), new WorldPoint(2178, 5185, 2));
        this.onIslandF0 = new ZoneRequirement(this.islandF0);
        this.onIslandF1 = new ZoneRequirement(this.islandF1);
        this.onIslandF2 = new ZoneRequirement(this.islandF2);
        this.talkToPete = new NpcStep(this.getQuestHelper(), 601, new WorldPoint(3680, 3537, 0), "Talk to Pirate Pete north east of the Ectofuntus.", new Requirement[0]);
        this.talkToPete.addDialogSteps("Okay!");
        this.addSluglings = new ObjectStep(this.getQuestHelper(), 10171, new WorldPoint(2142, 5102, 2), "Add the sea creatures to the pressure barrel on the top floor.", this.sluglings.highlighted());
        this.addSluglings.addIcon(6715);
        this.goDownFromTop = new ObjectStep(this.getQuestHelper(), 10168, new WorldPoint(2163, 5092, 2), "Go down the ladder and fish for sea creatures.", new Requirement[0]);
        this.fish5Slugs = new NpcStep(this.getQuestHelper(), FishingSpot.QUEST_RUM_DEAL.getIds(), "Fish 5 sluglings or karamthulu from around the coast of the island.", this.netBowl);
        this.goDownToSluglings = new ObjectStep(this.getQuestHelper(), 10137, new WorldPoint(2150, 5088, 1), "Go fish 5 sluglings.", this.netBowl);
        this.goUpFromSluglings = new ObjectStep(this.getQuestHelper(), 10136, new WorldPoint(2150, 5088, 0), "Add the sea creatures to the pressure barrel on the top floor.", this.sluglings);
        this.fish5Slugs.addSubSteps(this.goDownFromTop, this.goDownToSluglings, this.talkToPete);
        this.goUpToDropSluglings = new ObjectStep(this.getQuestHelper(), 10167, new WorldPoint(2163, 5092, 1), "Add the sea creatures to the pressure barrel on the top floor.", this.sluglings);
        this.goUpFromSluglings = new ObjectStep(this.getQuestHelper(), 10136, new WorldPoint(2150, 5088, 0), "Go to the top floor to pull the pressure lever.", this.sluglings);
        this.goUpF1ToPressure = new ObjectStep(this.getQuestHelper(), 10136, new WorldPoint(2150, 5088, 0), "Go to the top floor to pull the pressure lever.", new Requirement[0]);
        this.goUpToF2ToPressure = new ObjectStep(this.getQuestHelper(), 10167, new WorldPoint(2163, 5092, 1), "Go to the top floor to pull the pressure lever.", new Requirement[0]);
        this.pressure = new ObjectStep(this.getQuestHelper(), 10164, new WorldPoint(2141, 5103, 2), "Pull the pressure lever.", new Requirement[0]);
        this.pressure.addSubSteps(this.goUpToF2ToPressure, this.goUpF1ToPressure);
        this.getSluglings = new ConditionalStep(this.getQuestHelper(), (QuestStep)this.talkToPete, new Requirement[0]);
        this.getSluglings.addStep(this.onIslandF0, this.fish5Slugs);
        this.getSluglings.addStep(this.onIslandF1, this.goDownToSluglings);
        this.getSluglings.addStep(this.onIslandF2, this.goDownToSluglings);
        this.pressureSluglings = new ConditionalStep(this.getQuestHelper(), (QuestStep)this.talkToPete, new Requirement[0]);
        this.pressureSluglings.addStep(this.onIslandF2, this.addSluglings);
        this.pressureSluglings.addStep(this.onIslandF1, this.goUpToDropSluglings);
        this.pressureSluglings.addStep(this.onIslandF0, this.goUpFromSluglings);
        this.pullPressureLever = new ConditionalStep(this.getQuestHelper(), (QuestStep)this.talkToPete, new Requirement[0]);
        this.pullPressureLever.addStep(this.onIslandF2, this.pressure);
        this.pullPressureLever.addStep(this.onIslandF1, this.goUpToF2ToPressure);
        this.pullPressureLever.addStep(this.onIslandF0, this.goUpF1ToPressure);
    }

    @Override
    public Collection<QuestStep> getSteps() {
        return Arrays.asList(this.talkToPete, this.goDownToSluglings, this.fish5Slugs, this.goUpFromSluglings, this.goUpToDropSluglings, this.addSluglings, this.getSluglings, this.pressureSluglings, this.goUpF1ToPressure, this.goUpToF2ToPressure, this.pressure, this.pullPressureLever);
    }

    public List<QuestStep> getDisplaySteps() {
        return Arrays.asList(this.fish5Slugs, this.addSluglings, this.pressure);
    }
}

