/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.rumdeal;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.helpers.quests.rumdeal.SlugSteps;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questhelpers.QuestUtil;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.conditional.NpcCondition;
import com.questhelper.requirements.item.ItemOnTileRequirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.FreeInventorySlotRequirement;
import com.questhelper.requirements.player.PrayerPointRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ItemStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.RUM_DEAL)
public class RumDeal
extends BasicQuestHelper {
    ItemRequirement combatGear;
    ItemRequirement dibber;
    ItemRequirement rake;
    ItemRequirement slayerGloves;
    ItemRequirement blindweedSeed;
    ItemRequirement rakeHighlight;
    ItemRequirement blindweedSeedHighlight;
    ItemRequirement blindweed;
    ItemRequirement blindweedHighlight;
    ItemRequirement bucket;
    ItemRequirement bucketHighlight;
    ItemRequirement stagnantWater;
    ItemRequirement stagnantWaterHighlight;
    ItemRequirement netBowl;
    ItemRequirement sluglings5;
    ItemRequirement holyWrench;
    ItemRequirement wrench;
    ItemRequirement spiderCarcass;
    ItemRequirement spiderCarcassHighlight;
    ItemRequirement swill;
    Requirement prayerPoints47;
    Requirement onIsland;
    Requirement onIslandF1;
    Requirement onIslandF2;
    Requirement onIslandF0;
    Requirement rakedPatch;
    Requirement plantedPatch;
    Requirement grownPatch;
    Requirement onNorthIsland;
    Requirement added5Sluglings;
    Requirement inSpiderRoom;
    Requirement evilSpiritNearby;
    Requirement carcassNearby;
    DetailedQuestStep talkToPete;
    DetailedQuestStep talkToBraindeath;
    DetailedQuestStep goDownstairs;
    DetailedQuestStep rakePatch;
    DetailedQuestStep plantSeed;
    DetailedQuestStep waitForGrowth;
    DetailedQuestStep pickPlant;
    DetailedQuestStep goUpStairsWithPlant;
    DetailedQuestStep talkToBraindeathWithPlant;
    DetailedQuestStep talkToPeteWithPlant;
    DetailedQuestStep climbUpToDropPlant;
    DetailedQuestStep dropPlant;
    DetailedQuestStep goDownFromDropPlant;
    DetailedQuestStep talkToBraindeathAfterPlant;
    DetailedQuestStep goDownForWater;
    DetailedQuestStep openGate;
    DetailedQuestStep useBucketOnWater;
    DetailedQuestStep goUpWithWater;
    DetailedQuestStep goUpToDropWater;
    DetailedQuestStep dropWater;
    DetailedQuestStep goDownFromTopAfterDropWater;
    DetailedQuestStep talkToBraindeathAfterWater;
    DetailedQuestStep goDownFromTop;
    DetailedQuestStep goUpFromBottom;
    DetailedQuestStep goDownAfterSlugs;
    DetailedQuestStep talkToBraindeathAfterSlugs;
    DetailedQuestStep talkToDavey;
    DetailedQuestStep useWrenchOnControl;
    DetailedQuestStep killSpirit;
    DetailedQuestStep goUpFromSpiders;
    DetailedQuestStep talkToBraindeathAfterSpirit;
    DetailedQuestStep goDownToSpiders;
    DetailedQuestStep killSpider;
    DetailedQuestStep goUpFromSpidersWithCorpse;
    DetailedQuestStep goUpToDropSpider;
    DetailedQuestStep dropSpider;
    DetailedQuestStep goDownAfterSpider;
    DetailedQuestStep talkToBraindeathAfterSpider;
    DetailedQuestStep useBucketOnTap;
    DetailedQuestStep goDownToDonnie;
    DetailedQuestStep talkToDonnie;
    DetailedQuestStep goUpToBraindeathToFinish;
    DetailedQuestStep talkToBraindeathToFinish;
    DetailedQuestStep pickUpCarcass;
    SlugSteps getSlugs;
    Zone island;
    Zone islandF0;
    Zone islandF1;
    Zone islandF2;
    Zone northIsland;
    Zone spiderRoom;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToPete);
        steps.put(1, this.talkToPete);
        ConditionalStep startOff = new ConditionalStep((QuestHelper)this, (QuestStep)this.talkToPete, new Requirement[0]);
        startOff.addStep(this.onIsland, this.talkToBraindeath);
        steps.put(2, startOff);
        ConditionalStep growBlindweed = new ConditionalStep((QuestHelper)this, (QuestStep)this.talkToPete, new Requirement[0]);
        growBlindweed.addStep(this.grownPatch, this.pickPlant);
        growBlindweed.addStep(this.plantedPatch, this.waitForGrowth);
        growBlindweed.addStep(this.inSpiderRoom, this.goUpFromSpiders);
        growBlindweed.addStep(new Conditions(this.onIslandF0, this.rakedPatch), this.plantSeed);
        growBlindweed.addStep(this.onIslandF2, this.goDownFromTop);
        growBlindweed.addStep(this.onIslandF0, this.rakePatch);
        growBlindweed.addStep(this.onIslandF1, this.goDownstairs);
        steps.put(3, growBlindweed);
        steps.put(4, growBlindweed);
        ConditionalStep bringPlant = new ConditionalStep((QuestHelper)this, (QuestStep)this.talkToPeteWithPlant, new Requirement[0]);
        bringPlant.addStep(this.inSpiderRoom, this.goUpFromSpiders);
        bringPlant.addStep(new Conditions(this.onIslandF1), this.talkToBraindeathWithPlant);
        bringPlant.addStep(new Conditions(this.onIslandF0), this.goUpStairsWithPlant);
        bringPlant.addStep(this.onIslandF2, this.goDownFromTop);
        steps.put(5, bringPlant);
        ConditionalStep addPlant = new ConditionalStep((QuestHelper)this, (QuestStep)this.talkToPeteWithPlant, new Requirement[0]);
        addPlant.addStep(this.inSpiderRoom, this.goUpFromSpiders);
        addPlant.addStep(this.onIslandF1, this.climbUpToDropPlant);
        addPlant.addStep(this.onIslandF0, this.goUpFromBottom);
        addPlant.addStep(this.onIslandF2, this.dropPlant);
        steps.put(6, addPlant);
        ConditionalStep talkAfterPlant = new ConditionalStep((QuestHelper)this, (QuestStep)this.talkToPete, new Requirement[0]);
        talkAfterPlant.addStep(this.inSpiderRoom, this.goUpFromSpiders);
        talkAfterPlant.addStep(this.onIslandF1, this.talkToBraindeathAfterPlant);
        talkAfterPlant.addStep(this.onIslandF0, this.goUpFromBottom);
        talkAfterPlant.addStep(this.onIslandF2, this.goDownFromDropPlant);
        steps.put(7, talkAfterPlant);
        ConditionalStep getWater = new ConditionalStep((QuestHelper)this, (QuestStep)this.talkToPete, new Requirement[0]);
        getWater.addStep(this.inSpiderRoom, this.goUpFromSpiders);
        getWater.addStep(new Conditions(this.onIslandF2, this.stagnantWater), this.dropWater);
        getWater.addStep(new Conditions(this.onIslandF1, this.stagnantWater), this.goUpToDropWater);
        getWater.addStep(new Conditions(this.onIslandF0, this.stagnantWater), this.goUpWithWater);
        getWater.addStep(this.onNorthIsland, this.useBucketOnWater);
        getWater.addStep(this.onIslandF0, this.openGate);
        getWater.addStep(this.onIslandF1, this.goDownForWater);
        getWater.addStep(this.onIslandF2, this.goDownFromTop);
        steps.put(8, getWater);
        ConditionalStep putWater = new ConditionalStep((QuestHelper)this, (QuestStep)this.talkToPete, new Requirement[0]);
        putWater.addStep(this.inSpiderRoom, this.goUpFromSpiders);
        putWater.addStep(this.onIslandF2, this.dropWater);
        putWater.addStep(this.onIslandF1, this.goUpToDropWater);
        putWater.addStep(this.onIslandF0, this.goUpWithWater);
        steps.put(9, putWater);
        ConditionalStep startSlug = new ConditionalStep((QuestHelper)this, (QuestStep)this.talkToPete, new Requirement[0]);
        startSlug.addStep(this.inSpiderRoom, this.goUpFromSpiders);
        startSlug.addStep(this.onIslandF2, this.goDownFromTopAfterDropWater);
        startSlug.addStep(this.onIslandF1, this.talkToBraindeathAfterWater);
        startSlug.addStep(this.onIslandF0, this.goUpFromBottom);
        steps.put(10, startSlug);
        ConditionalStep getSlugsSteps = new ConditionalStep((QuestHelper)this, (QuestStep)this.getSlugs, new Requirement[0]);
        getSlugsSteps.addStep(this.inSpiderRoom, this.goUpFromSpiders);
        steps.put(11, getSlugsSteps);
        ConditionalStep startSpirit = new ConditionalStep((QuestHelper)this, (QuestStep)this.talkToPete, new Requirement[0]);
        startSpirit.addStep(this.inSpiderRoom, this.goUpFromSpiders);
        startSpirit.addStep(this.onIslandF1, this.talkToBraindeathAfterSlugs);
        startSpirit.addStep(this.onIslandF2, this.goDownAfterSlugs);
        startSpirit.addStep(this.onIslandF0, this.goUpFromBottom);
        steps.put(12, startSpirit);
        ConditionalStep killSpiritSteps = new ConditionalStep((QuestHelper)this, (QuestStep)this.talkToPete, new Requirement[0]);
        killSpiritSteps.addStep(this.inSpiderRoom, this.goUpFromSpiders);
        killSpiritSteps.addStep(new Conditions(this.onIslandF1, this.holyWrench, this.evilSpiritNearby), this.killSpirit);
        killSpiritSteps.addStep(new Conditions(this.onIslandF1, this.holyWrench), this.useWrenchOnControl);
        killSpiritSteps.addStep(this.onIslandF1, this.talkToDavey);
        killSpiritSteps.addStep(this.onIslandF2, this.goDownFromTop);
        killSpiritSteps.addStep(this.onIslandF0, this.goUpFromBottom);
        steps.put(13, killSpiritSteps);
        ConditionalStep spiderStepsStart = new ConditionalStep((QuestHelper)this, (QuestStep)this.talkToPete, new Requirement[0]);
        spiderStepsStart.addStep(this.inSpiderRoom, this.goUpFromSpiders);
        spiderStepsStart.addStep(this.onIslandF1, this.talkToBraindeathAfterSpirit);
        spiderStepsStart.addStep(this.onIslandF2, this.goDownFromTop);
        spiderStepsStart.addStep(this.onIslandF0, this.goUpFromBottom);
        steps.put(14, spiderStepsStart);
        ConditionalStep spiderSteps = new ConditionalStep((QuestHelper)this, (QuestStep)this.talkToPete, new Requirement[0]);
        spiderSteps.addStep(new Conditions(this.onIslandF2, this.spiderCarcass), this.dropSpider);
        spiderSteps.addStep(new Conditions(this.onIslandF1, this.spiderCarcass), this.goUpToDropSpider);
        spiderSteps.addStep(new Conditions(this.inSpiderRoom, this.spiderCarcass), this.goUpFromSpidersWithCorpse);
        spiderSteps.addStep(this.carcassNearby, this.pickUpCarcass);
        spiderSteps.addStep(this.inSpiderRoom, this.killSpider);
        spiderSteps.addStep(this.onIslandF1, this.goDownToSpiders);
        spiderSteps.addStep(this.onIslandF2, this.goDownFromTop);
        spiderSteps.addStep(this.onIslandF0, this.goUpFromBottom);
        steps.put(15, spiderSteps);
        ConditionalStep makeBrewForDonnieStart = new ConditionalStep((QuestHelper)this, (QuestStep)this.talkToPete, new Requirement[0]);
        makeBrewForDonnieStart.addStep(this.inSpiderRoom, this.goUpFromSpiders);
        makeBrewForDonnieStart.addStep(this.onIslandF1, this.talkToBraindeathAfterSpider);
        makeBrewForDonnieStart.addStep(this.onIslandF2, this.goDownAfterSpider);
        makeBrewForDonnieStart.addStep(this.onIslandF0, this.goUpFromBottom);
        steps.put(16, makeBrewForDonnieStart);
        ConditionalStep giveBrewToDonnie = new ConditionalStep((QuestHelper)this, (QuestStep)this.talkToPete, new Requirement[0]);
        giveBrewToDonnie.addStep(new Conditions(this.onIslandF0, this.swill), this.talkToDonnie);
        giveBrewToDonnie.addStep(new Conditions(this.onIslandF1, this.swill), this.goDownToDonnie);
        giveBrewToDonnie.addStep(this.inSpiderRoom, this.goUpFromSpiders);
        giveBrewToDonnie.addStep(this.onIslandF1, this.useBucketOnTap);
        giveBrewToDonnie.addStep(this.onIslandF2, this.goDownAfterSpider);
        giveBrewToDonnie.addStep(this.onIslandF0, this.goUpFromBottom);
        steps.put(17, giveBrewToDonnie);
        ConditionalStep finishQuest = new ConditionalStep((QuestHelper)this, (QuestStep)this.talkToPete, new Requirement[0]);
        finishQuest.addStep(this.inSpiderRoom, this.goUpFromSpiders);
        finishQuest.addStep(this.onIslandF1, this.talkToBraindeathToFinish);
        finishQuest.addStep(this.onIslandF2, this.goDownFromTop);
        finishQuest.addStep(this.onIslandF0, this.goUpToBraindeathToFinish);
        steps.put(18, finishQuest);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.combatGear = new ItemRequirement("Combat gear", -1, -1).isNotConsumed();
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.slayerGloves = new ItemRequirement("Slayer gloves", 6708).isNotConsumed();
        this.slayerGloves.addAlternates(6720);
        this.blindweedSeed = new ItemRequirement("Blindweed seed", 6710);
        this.blindweedSeedHighlight = new ItemRequirement("Blindweed seed", 6710);
        this.blindweedSeedHighlight.setHighlightInInventory(true);
        this.rake = new ItemRequirement("Rake", 5341).isNotConsumed();
        this.rakeHighlight = new ItemRequirement("Rake", 5341).isNotConsumed();
        this.rakeHighlight.setHighlightInInventory(true);
        this.dibber = new ItemRequirement("Seed dibber", 5343).isNotConsumed();
        this.blindweed = new ItemRequirement("Blindweed", 6711);
        this.blindweed.setTooltip("You can get another from Captain Braindeath");
        this.blindweedHighlight = new ItemRequirement(true, "Blindweed", 6711);
        this.blindweedHighlight.setTooltip("You can get another from Captain Braindeath");
        this.bucket = new ItemRequirement("Bucket", 1925);
        this.bucketHighlight = new ItemRequirement("Bucket", 1925);
        this.bucketHighlight.setHighlightInInventory(true);
        this.stagnantWater = new ItemRequirement("Bucket of water", 6712);
        this.stagnantWater.setTooltip("You can get more from Captain Braindeath");
        this.stagnantWaterHighlight = new ItemRequirement("Bucket of water", 6712);
        this.stagnantWaterHighlight.setTooltip("You can get more from Captain Braindeath");
        this.stagnantWaterHighlight.setHighlightInInventory(true);
        this.netBowl = new ItemRequirement("Fishbowl and net", 6673);
        this.netBowl.setTooltip("You can get another from Captain Braindeath, or make it with a fishbowl and large net");
        this.sluglings5 = new ItemRequirement("Sluglings", 6715, 5);
        this.holyWrench = new ItemRequirement("Holy wrench", 6714);
        this.holyWrench.setHighlightInInventory(true);
        this.wrench = new ItemRequirement("Wrench", 6713);
        this.wrench.setTooltip("You can get another from Captain Braindeath");
        this.spiderCarcass = new ItemRequirement("Fever spider body", 6718);
        this.spiderCarcassHighlight = new ItemRequirement("Fever spider body", 6718);
        this.spiderCarcassHighlight.setHighlightInInventory(true);
        this.swill = new ItemRequirement("Unsanitary swill", 6719);
        this.prayerPoints47 = new PrayerPointRequirement(47);
    }

    public void loadZones() {
        this.island = new Zone(new WorldPoint(2110, 5054, 0), new WorldPoint(2178, 5185, 2));
        this.islandF0 = new Zone(new WorldPoint(2110, 5054, 0), new WorldPoint(2178, 5185, 0));
        this.islandF1 = new Zone(new WorldPoint(2110, 5054, 1), new WorldPoint(2178, 5185, 1));
        this.islandF2 = new Zone(new WorldPoint(2110, 5054, 2), new WorldPoint(2178, 5185, 2));
        this.northIsland = new Zone(new WorldPoint(2110, 5099, 2), new WorldPoint(2178, 5185, 0));
        this.spiderRoom = new Zone(new WorldPoint(2138, 5091, 0), new WorldPoint(2164, 5106, 0));
    }

    public void setupConditions() {
        this.onIsland = new ZoneRequirement(this.island);
        this.onIslandF0 = new ZoneRequirement(this.islandF0);
        this.onIslandF1 = new ZoneRequirement(this.islandF1);
        this.onIslandF2 = new ZoneRequirement(this.islandF2);
        this.onNorthIsland = new ZoneRequirement(this.northIsland);
        this.inSpiderRoom = new ZoneRequirement(this.spiderRoom);
        this.rakedPatch = new VarbitRequirement(1366, 3);
        this.plantedPatch = new VarbitRequirement(1366, 4);
        this.grownPatch = new VarbitRequirement(1366, 5);
        this.added5Sluglings = new VarbitRequirement(1354, 5);
        this.evilSpiritNearby = new NpcCondition(625);
        this.carcassNearby = new ItemOnTileRequirement(this.spiderCarcass);
    }

    public void setupSteps() {
        this.talkToPete = new NpcStep((QuestHelper)this, 601, new WorldPoint(3680, 3537, 0), "Talk to Pirate Pete north east of the Ectofuntus.", new Requirement[0]);
        this.talkToPete.addDialogSteps("Yes.", "Yes!", "Of course, I fear no demon!", "Nonsense! Keep the money!", "I've decided to help you for free.", "Okay!");
        this.talkToBraindeath = new NpcStep((QuestHelper)this, 603, new WorldPoint(2145, 5108, 1), "Talk to Captain Braindeath.", new Requirement[0]);
        this.goDownFromTop = new ObjectStep((QuestHelper)this, 10168, new WorldPoint(2163, 5092, 2), "Go down the ladder.", new Requirement[0]);
        this.goUpFromBottom = new ObjectStep((QuestHelper)this, 10136, new WorldPoint(2150, 5088, 0), "Go up to the first floor.", new Requirement[0]);
        this.goDownstairs = new ObjectStep((QuestHelper)this, 10137, new WorldPoint(2150, 5088, 1), "Go down to the island's farming patch to plant the blindweed seed.", this.blindweedSeed, this.rake, this.dibber);
        this.rakePatch = new ObjectStep((QuestHelper)this, 10096, new WorldPoint(2163, 5070, 0), "Rake the blindweed patch.", this.rakeHighlight);
        this.rakePatch.addIcon(5341);
        this.plantSeed = new ObjectStep((QuestHelper)this, 10096, new WorldPoint(2163, 5070, 0), "Plant the seed in the blindweed patch.", this.blindweedSeedHighlight, this.dibber);
        this.plantSeed.addIcon(6710);
        this.waitForGrowth = new DetailedQuestStep((QuestHelper)this, "Wait 5 minutes for the blindweed to grow.", new Requirement[0]);
        this.pickPlant = new ObjectStep((QuestHelper)this, 10096, new WorldPoint(2163, 5070, 0), "Pick the blindweed on Braindeath Island.", new Requirement[0]);
        this.goUpStairsWithPlant = new ObjectStep((QuestHelper)this, 10136, new WorldPoint(2150, 5088, 0), "Take the blindweed back to Captain Braindeath.", this.blindweed);
        this.talkToBraindeathWithPlant = new NpcStep((QuestHelper)this, 603, new WorldPoint(2145, 5108, 1), "Talk to Captain Braindeath.", this.blindweed);
        this.talkToPeteWithPlant = new NpcStep((QuestHelper)this, 601, new WorldPoint(3680, 3537, 0), "Talk to Pirate Pete north east of the Ectofuntus.", this.blindweed);
        this.goUpStairsWithPlant.addSubSteps(this.talkToPeteWithPlant, this.talkToBraindeathWithPlant);
        this.climbUpToDropPlant = new ObjectStep((QuestHelper)this, 10167, new WorldPoint(2163, 5092, 1), "Go to the top floor and put the blindweed into the hopper.", this.blindweed);
        this.dropPlant = new ObjectStep((QuestHelper)this, 10170, new WorldPoint(2142, 5102, 2), "Go to the top floor and put the blindweed into the hopper.", this.blindweedHighlight);
        this.dropPlant.addSubSteps(this.climbUpToDropPlant);
        this.dropPlant.addIcon(6711);
        this.goDownFromDropPlant = new ObjectStep((QuestHelper)this, 10168, new WorldPoint(2163, 5092, 2), "Return to Captain Braindeath.", new Requirement[0]);
        this.talkToBraindeathAfterPlant = new NpcStep((QuestHelper)this, 603, new WorldPoint(2145, 5108, 1), "Talk to Captain Braindeath.", new Requirement[0]);
        this.talkToBraindeathAfterPlant.addSubSteps(this.goDownFromDropPlant);
        this.goDownForWater = new ObjectStep((QuestHelper)this, 10137, new WorldPoint(2138, 5088, 1), "Go to the north part of the island and get some stagnant water.", this.bucket);
        this.openGate = new ObjectStep((QuestHelper)this, 10172, new WorldPoint(2120, 5098, 0), "Go to the north part of the island and get some stagnant water.", this.bucket);
        this.useBucketOnWater = new ObjectStep((QuestHelper)this, 10105, new WorldPoint(2135, 5161, 0), "Go to the north part of the island and get some stagnant water.", this.bucketHighlight);
        this.useBucketOnWater.addSubSteps(this.goDownForWater, this.openGate);
        this.useBucketOnWater.addIcon(1925);
        this.goUpWithWater = new ObjectStep((QuestHelper)this, 10136, new WorldPoint(2150, 5088, 0), "Take the water back to the hopper on the top floor.", this.stagnantWater);
        this.goUpToDropWater = new ObjectStep((QuestHelper)this, 10167, new WorldPoint(2163, 5092, 1), "Take the water back to the hopper on the top floor.", this.stagnantWater);
        this.goUpToDropWater.addDialogStep("What exactly do you want me to do?");
        this.dropWater = new ObjectStep((QuestHelper)this, 10170, new WorldPoint(2142, 5102, 2), "Take the water back to the hopper on the top floor.", this.stagnantWaterHighlight);
        this.dropWater.addSubSteps(this.goUpWithWater, this.goUpToDropWater);
        this.dropWater.addIcon(6712);
        this.goDownFromTopAfterDropWater = new ObjectStep((QuestHelper)this, 10168, new WorldPoint(2163, 5092, 2), "Return to Captain Braindeath.", new Requirement[0]);
        this.talkToBraindeathAfterWater = new NpcStep((QuestHelper)this, 603, new WorldPoint(2145, 5108, 1), "Talk to Captain Braindeath.", new Requirement[0]);
        this.talkToBraindeathAfterWater.addSubSteps(this.goDownFromTopAfterDropWater);
        this.getSlugs = new SlugSteps(this);
        this.goDownAfterSlugs = new ObjectStep((QuestHelper)this, 10168, new WorldPoint(2163, 5092, 2), "Return to Captain Braindeath.", new Requirement[0]);
        this.talkToBraindeathAfterSlugs = new NpcStep((QuestHelper)this, 603, new WorldPoint(2145, 5108, 1), "Talk to Captain Braindeath.", new Requirement[0]);
        this.talkToBraindeathAfterSlugs.addSubSteps(this.goDownAfterSlugs);
        this.talkToDavey = new NpcStep((QuestHelper)this, 605, new WorldPoint(2132, 5100, 1), "Talk to Davey south west of Captain Braindeath.", this.wrench, this.prayerPoints47);
        this.useWrenchOnControl = new ObjectStep((QuestHelper)this, 10104, new WorldPoint(2144, 5101, 1), "Use the holy wrench on the brewing control. Be prepared to fight an evil spirit.", this.holyWrench);
        this.useWrenchOnControl.addIcon(6714);
        this.killSpirit = new NpcStep((QuestHelper)this, 625, "Kill the Evil Spirit.", this.prayerPoints47);
        this.goUpFromSpiders = new ObjectStep((QuestHelper)this, 10167, new WorldPoint(2139, 5105, 0), "Go up the ladder.", new Requirement[0]);
        this.talkToBraindeathAfterSpirit = new NpcStep((QuestHelper)this, 603, new WorldPoint(2145, 5108, 1), "Talk to Captain Braindeath.", new Requirement[0]);
        this.goDownToSpiders = new ObjectStep((QuestHelper)this, 10168, new WorldPoint(2139, 5105, 1), "Go into the brewery's basement and kill a fever spider. If you're not wearing slayer gloves they'll afflict you with disease.", this.slayerGloves);
        this.killSpider = new NpcStep((QuestHelper)this, 626, "Go into the brewery's basement and kill a fever spider. If you're not wearing slayer gloves they'll afflict you with disease.", true, this.slayerGloves.equipped());
        this.killSpider.addSubSteps(this.goDownToSpiders);
        this.pickUpCarcass = new ItemStep((QuestHelper)this, "Pick up the fever spider body.", this.spiderCarcass);
        this.goUpFromSpidersWithCorpse = new ObjectStep((QuestHelper)this, 10167, new WorldPoint(2139, 5105, 0), "Add the spider body to the hopper on the top floor.", this.spiderCarcass);
        this.goUpToDropSpider = new ObjectStep((QuestHelper)this, 10167, new WorldPoint(2163, 5092, 1), "Add the spider body to the hopper on the top floor.", this.spiderCarcass);
        this.dropSpider = new ObjectStep((QuestHelper)this, 10170, new WorldPoint(2142, 5102, 2), "Add the spider body to the hopper on the top floor.", this.spiderCarcassHighlight);
        this.dropSpider.addIcon(6718);
        this.dropSpider.addSubSteps(this.goUpFromSpidersWithCorpse, this.goUpToDropSpider);
        this.goDownAfterSpider = new ObjectStep((QuestHelper)this, 10168, new WorldPoint(2163, 5092, 2), "Return to Captain Braindeath.", new Requirement[0]);
        this.talkToBraindeathAfterSpider = new NpcStep((QuestHelper)this, 603, new WorldPoint(2145, 5108, 1), "Talk to Captain Braindeath.", new Requirement[0]);
        this.talkToBraindeathAfterSpider.addSubSteps(this.goDownAfterSpider);
        this.useBucketOnTap = new ObjectStep((QuestHelper)this, 10148, new WorldPoint(2142, 5093, 1), "Fill a bucket from the output tap in the south west of the brewery.", this.bucket);
        this.goDownToDonnie = new ObjectStep((QuestHelper)this, 10137, new WorldPoint(2150, 5088, 1), "Bring the unsanitary swill to Captain Donnie south of the Brewery.", this.swill);
        this.talkToDonnie = new NpcStep((QuestHelper)this, 606, new WorldPoint(2152, 5078, 0), "Bring the unsanitary swill to Captain Donnie south of the Brewery.", this.swill);
        this.talkToDonnie.addSubSteps(this.goDownToDonnie);
        this.goUpToBraindeathToFinish = new ObjectStep((QuestHelper)this, 10136, new WorldPoint(2150, 5088, 0), "Return to Captain Braindeath to finish.", new Requirement[0]);
        this.talkToBraindeathToFinish = new NpcStep((QuestHelper)this, 603, new WorldPoint(2145, 5108, 1), "Talk to Captain Braindeath to finish.", new Requirement[0]);
        this.talkToBraindeathToFinish.addSubSteps(this.goUpToBraindeathToFinish);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.combatGear, this.dibber, this.rake, this.slayerGloves);
    }

    @Override
    public List<String> getCombatRequirements() {
        return Arrays.asList("Evil spirit (level 150)", "Fever spider (level 49)");
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(2);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Arrays.asList(new ExperienceReward(Skill.FISHING, 7000), new ExperienceReward(Skill.PRAYER, 7000), new ExperienceReward(Skill.FARMING, 7000));
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Collections.singletonList(new ItemReward("A Holy Wrench", 6714, 1));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting off", Arrays.asList(this.talkToPete, this.talkToBraindeath), this.rake, this.dibber, this.slayerGloves, this.combatGear));
        allSteps.add(new PanelDetails("Get blindweed", Arrays.asList(this.goDownstairs, this.rakePatch, this.plantSeed, this.waitForGrowth, this.pickPlant, this.goUpStairsWithPlant, this.dropPlant), this.rake, this.dibber));
        allSteps.add(new PanelDetails("Get stagnant water", Arrays.asList(this.talkToBraindeathAfterPlant, this.useBucketOnWater, this.dropWater), new Requirement[0]));
        List<QuestStep> sluglingSteps = QuestUtil.toArrayList(this.talkToBraindeathAfterWater);
        sluglingSteps.addAll(this.getSlugs.getDisplaySteps());
        allSteps.add(new PanelDetails("Get sluglings", sluglingSteps, new Requirement[0]));
        allSteps.add(new PanelDetails("Kill evil spirit", Arrays.asList(this.talkToBraindeathAfterSlugs, this.talkToDavey, this.useWrenchOnControl, this.killSpirit), this.combatGear));
        allSteps.add(new PanelDetails("Get spider carcass", Arrays.asList(this.talkToBraindeathAfterSpirit, this.killSpider, this.pickUpCarcass, this.dropSpider), this.combatGear, this.slayerGloves));
        allSteps.add(new PanelDetails("Giving swill to Donnie", Arrays.asList(this.talkToBraindeathAfterSpider, this.useBucketOnTap, this.talkToDonnie, this.talkToBraindeathToFinish), new Requirement[0]));
        return allSteps;
    }

    @Override
    public List<Requirement> getGeneralRecommended() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new FreeInventorySlotRequirement(6));
        return req;
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new QuestRequirement(QuestHelperQuest.ZOGRE_FLESH_EATERS, QuestState.FINISHED));
        req.add(new QuestRequirement(QuestHelperQuest.PRIEST_IN_PERIL, QuestState.FINISHED));
        req.add(new SkillRequirement(Skill.CRAFTING, 42, true));
        req.add(new SkillRequirement(Skill.FISHING, 50, true));
        req.add(new SkillRequirement(Skill.FARMING, 40, true));
        req.add(new SkillRequirement(Skill.PRAYER, 47, true));
        req.add(new SkillRequirement(Skill.SLAYER, 42));
        req.add(new PrayerPointRequirement(47));
        return req;
    }
}

