/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.rovingelves;

import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemOnTileRequirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ItemStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.ROVING_ELVES)
public class RovingElves
extends BasicQuestHelper {
    ItemRequirement glarialsPebble;
    ItemRequirement pebbleHint;
    ItemRequirement keyHint;
    ItemRequirement key;
    ItemRequirement spade;
    ItemRequirement rope;
    ItemRequirement seed;
    ItemRequirement blessedSeed;
    ItemRequirement highlightRope;
    ItemRequirement blessedSeedHighlight;
    ItemRequirement prayerPotions;
    ItemRequirement food;
    ItemRequirement elvenForestTeleport;
    ItemRequirement baxTeleport;
    ItemRequirement superCombatPotion;
    ItemRequirement antipoison;
    Requirement inGlarialsTomb;
    Requirement onDeadTreeIsland;
    Requirement onLedge;
    Requirement onHudonIsland;
    Requirement inFalls;
    Requirement seedNearby;
    Requirement inThroneRoom;
    DetailedQuestStep talkToIslwyn;
    DetailedQuestStep talkToEluned;
    DetailedQuestStep enterGlarialsTombstone;
    DetailedQuestStep killGuardian;
    DetailedQuestStep pickUpSeed;
    DetailedQuestStep returnSeedToEluned;
    DetailedQuestStep boardRaft;
    DetailedQuestStep useRopeOnRock;
    DetailedQuestStep useRopeOnTree;
    DetailedQuestStep enterFalls;
    DetailedQuestStep searchFallsCrate;
    DetailedQuestStep useKeyOnFallsDoor;
    DetailedQuestStep plantSeed;
    DetailedQuestStep returnToIslwyn;
    Zone glarialTomb;
    Zone deadTreeIsland;
    Zone ledge;
    Zone hudonIsland;
    Zone falls;
    Zone throneRoom;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToIslwyn);
        steps.put(1, this.talkToIslwyn);
        steps.put(2, this.talkToEluned);
        ConditionalStep getTheSeed = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterGlarialsTombstone, new Requirement[0]);
        getTheSeed.addStep(this.seed.alsoCheckBank(this.questBank), this.returnSeedToEluned);
        getTheSeed.addStep(this.seedNearby, this.pickUpSeed);
        getTheSeed.addStep(this.inGlarialsTomb, this.killGuardian);
        steps.put(3, getTheSeed);
        ConditionalStep plantingTheSeed = new ConditionalStep((QuestHelper)this, (QuestStep)this.boardRaft, new Requirement[0]);
        plantingTheSeed.addStep(this.inThroneRoom, this.plantSeed);
        plantingTheSeed.addStep(new Conditions(this.inFalls, this.key), this.useKeyOnFallsDoor);
        plantingTheSeed.addStep(this.inFalls, this.searchFallsCrate);
        plantingTheSeed.addStep(this.onLedge, this.enterFalls);
        plantingTheSeed.addStep(this.onDeadTreeIsland, this.useRopeOnTree);
        plantingTheSeed.addStep(this.onHudonIsland, this.useRopeOnRock);
        steps.put(4, plantingTheSeed);
        steps.put(5, this.returnToIslwyn);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.seed = new ItemRequirement("Consecration seed", 4205);
        this.seed.addAlternates(4206);
        this.blessedSeed = new ItemRequirement("Consecration seed", 4206);
        this.blessedSeed.setTooltip("You can get another from Eluned");
        this.blessedSeedHighlight = new ItemRequirement("Consecration seed", 4206);
        this.blessedSeedHighlight.setTooltip("You can get another from Eluned");
        this.blessedSeedHighlight.setHighlightInInventory(true);
        this.glarialsPebble = new ItemRequirement("Glarial's pebble", 294).isNotConsumed();
        this.glarialsPebble.setTooltip("You can get another from Golrie under Tree Gnome Village");
        this.key = new ItemRequirement("Key", 298).isNotConsumed();
        this.key.setTooltip("You can get another from inside Baxtorian Falls");
        this.keyHint = new ItemRequirement("Key (obtainable in quest)", 293).isNotConsumed();
        this.pebbleHint = new ItemRequirement("Glarial's pebble (obtainable in quest)", 294).isNotConsumed();
        this.spade = new ItemRequirement("Spade", 952).isNotConsumed();
        this.rope = new ItemRequirement("Rope", 954).isNotConsumed();
        this.highlightRope = this.rope.highlighted();
        this.prayerPotions = new ItemRequirement("A few prayer potions", 2434);
        this.baxTeleport = new ItemRequirement("Teleport to Baxtorian Falls. Skills necklace (Fishing Guild [1]), Games necklace (Barbarian Outpost [2])", ItemCollections.SKILLS_NECKLACES);
        this.baxTeleport.addAlternates(ItemCollections.GAMES_NECKLACES);
        this.elvenForestTeleport = new ItemRequirement("Teleport near to Elven Forest. Iorwerth camp teleport, Charter Ship to Port Tyras", 12410);
        this.food = new ItemRequirement("Food", ItemCollections.GOOD_EATING_FOOD, -1);
        this.superCombatPotion = new ItemRequirement("Super combat potion", ItemCollections.SUPER_COMBAT_POTIONS);
        this.antipoison = new ItemRequirement("Antipoison potion", ItemCollections.ANTIPOISONS);
    }

    public void setupConditions() {
        this.onDeadTreeIsland = new ZoneRequirement(this.deadTreeIsland);
        this.onHudonIsland = new ZoneRequirement(this.hudonIsland);
        this.onLedge = new ZoneRequirement(this.ledge);
        this.inFalls = new ZoneRequirement(this.falls);
        this.inGlarialsTomb = new ZoneRequirement(this.glarialTomb);
        this.inThroneRoom = new ZoneRequirement(this.throneRoom);
        this.seedNearby = new ItemOnTileRequirement(this.seed);
    }

    public void loadZones() {
        this.glarialTomb = new Zone(new WorldPoint(2524, 9801, 0), new WorldPoint(2557, 9849, 0));
        this.hudonIsland = new Zone(new WorldPoint(2510, 3476, 0), new WorldPoint(2515, 3482, 0));
        this.deadTreeIsland = new Zone(new WorldPoint(2512, 3465, 0), new WorldPoint(2513, 3475, 0));
        this.ledge = new Zone(new WorldPoint(2510, 3462, 0), new WorldPoint(2513, 3464, 0));
        this.falls = new Zone(new WorldPoint(2556, 9861, 0), new WorldPoint(2595, 9920, 0));
        this.throneRoom = new Zone(new WorldPoint(2599, 9901, 0), new WorldPoint(2608, 9916, 0));
    }

    public void setupSteps() {
        this.talkToIslwyn = new NpcStep((QuestHelper)this, 7780, new WorldPoint(2207, 3159, 0), "Talk to Islwyn in Isafdar. If he's not at the marked location, try hopping worlds to find him here.", this.antipoison);
        this.talkToIslwyn.addTeleport(this.elvenForestTeleport);
        this.talkToIslwyn.addDialogStep("Yes.");
        this.talkToEluned = new NpcStep((QuestHelper)this, 8766, new WorldPoint(2207, 3159, 0), "Talk to Eluned.", new Requirement[0]);
        this.enterGlarialsTombstone = new ObjectStep((QuestHelper)this, 1992, new WorldPoint(2559, 3445, 0), "Bank everything besides the pebble, some potions, and some food. After, go use Glarial's pebble to Glarial's Tombstone east of Baxtorian Falls. Be prepared to fight a level 84 Moss Guardian bare-handed.", Collections.singletonList(this.glarialsPebble.highlighted()), Arrays.asList(this.food, this.prayerPotions, this.superCombatPotion, this.elvenForestTeleport));
        this.enterGlarialsTombstone.addIcon(294);
        this.enterGlarialsTombstone.addTeleport(this.baxTeleport);
        this.killGuardian = new NpcStep((QuestHelper)this, 891, new WorldPoint(2515, 9844, 0), "Kill the Moss Guardian for a Consecration seed.", new Requirement[0]);
        this.pickUpSeed = new ItemStep((QuestHelper)this, "Pick up the consecration seed.", this.seed);
        this.returnSeedToEluned = new NpcStep((QuestHelper)this, 8766, new WorldPoint(2207, 3159, 0), "Return the seed to Eluned.", Collections.singletonList(this.seed), Collections.singletonList(this.antipoison));
        this.returnSeedToEluned.addTeleport(this.elvenForestTeleport);
        this.boardRaft = new ObjectStep((QuestHelper)this, 1987, new WorldPoint(2509, 3494, 0), "Board the log raft on the top of Baxtorian Falls.", this.blessedSeed, this.rope, this.spade);
        this.boardRaft.addTeleport(this.baxTeleport);
        this.useRopeOnRock = new ObjectStep((QuestHelper)this, 1996, new WorldPoint(2512, 3468, 0), "Use a rope on the rock to the south.", this.highlightRope);
        this.useRopeOnRock.addIcon(954);
        this.useRopeOnTree = new ObjectStep((QuestHelper)this, 2020, new WorldPoint(2512, 3465, 0), "Use a rope on the dead tree.", this.highlightRope);
        this.useRopeOnTree.addIcon(954);
        this.enterFalls = new ObjectStep((QuestHelper)this, 2010, new WorldPoint(2511, 3464, 0), "Enter the falls.", new Requirement[0]);
        this.searchFallsCrate = new ObjectStep((QuestHelper)this, 1999, new WorldPoint(2589, 9888, 0), "Search the crate in the east room for a key.", new Requirement[0]);
        this.useKeyOnFallsDoor = new ObjectStep((QuestHelper)this, 2002, new WorldPoint(2566, 9901, 0), "Go through the doors from the west room.", this.key);
        this.plantSeed = new DetailedQuestStep((QuestHelper)this, "Plant the consecrated seed anywhere in the room.", this.blessedSeedHighlight, this.spade);
        this.returnToIslwyn = new NpcStep((QuestHelper)this, 7780, new WorldPoint(2207, 3159, 0), "Return to Islwyn in Isafdar to finish the quest.", new Requirement[0]);
        this.returnToIslwyn.addTeleport(this.elvenForestTeleport);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.spade, this.rope, this.pebbleHint, this.keyHint);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.antipoison, this.prayerPotions, this.food, this.superCombatPotion, this.baxTeleport.quantity(2), this.elvenForestTeleport.quantity(3));
    }

    @Override
    public List<String> getCombatRequirements() {
        return Collections.singletonList("Moss Guardian (level 84) without runes, weapons, or armour");
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new QuestRequirement(QuestHelperQuest.REGICIDE, QuestState.FINISHED));
        req.add(new QuestRequirement(QuestHelperQuest.WATERFALL_QUEST, QuestState.FINISHED));
        req.add(new SkillRequirement(Skill.AGILITY, 56, true));
        return req;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Collections.singletonList(new ExperienceReward(Skill.STRENGTH, 10000));
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Arrays.asList(new ItemReward("A used Crystal Shield", 23991, 1), new ItemReward("or Crystal Bow", 23983, 1));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting off", Arrays.asList(this.talkToIslwyn, this.talkToEluned), null, Arrays.asList(this.antipoison, this.elvenForestTeleport, this.baxTeleport)));
        allSteps.add(new PanelDetails("Get the seed", Arrays.asList(this.enterGlarialsTombstone, this.killGuardian, this.pickUpSeed, this.returnSeedToEluned), Collections.singletonList(this.glarialsPebble), Arrays.asList(this.food, this.prayerPotions, this.baxTeleport, this.elvenForestTeleport, this.antipoison)));
        allSteps.add(new PanelDetails("Plant the seed", Arrays.asList(this.boardRaft, this.useRopeOnRock, this.useRopeOnTree, this.enterFalls, this.searchFallsCrate, this.useKeyOnFallsDoor, this.plantSeed, this.returnToIslwyn), Arrays.asList(this.spade, this.rope, this.blessedSeed), Arrays.asList(this.baxTeleport, this.elvenForestTeleport, this.antipoison)));
        return allSteps;
    }
}

