/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.romeoandjuliet;

import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.ROMEO__JULIET)
public class RomeoAndJuliet
extends BasicQuestHelper {
    ItemRequirement cadavaBerry;
    ItemRequirement letter;
    ItemRequirement potion;
    Requirement inJulietRoom;
    QuestStep talkToRomeo;
    QuestStep goUpToJuliet;
    QuestStep talkToJuliet;
    QuestStep giveLetterToRomeo;
    QuestStep talkToLawrence;
    QuestStep talkToApothecary;
    QuestStep goUpToJuliet2;
    QuestStep givePotionToJuliet;
    QuestStep finishQuest;
    Zone julietRoom;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.setupRequirements();
        this.setupZones();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToRomeo);
        ConditionalStep tellJulietAboutRomeo = new ConditionalStep((QuestHelper)this, this.goUpToJuliet, new Requirement[0]);
        tellJulietAboutRomeo.addStep(this.inJulietRoom, this.talkToJuliet);
        steps.put(10, tellJulietAboutRomeo);
        steps.put(20, this.giveLetterToRomeo);
        steps.put(30, this.talkToLawrence);
        steps.put(40, this.talkToApothecary);
        ConditionalStep bringPotionToJuliet = new ConditionalStep((QuestHelper)this, this.talkToApothecary, new Requirement[0]);
        bringPotionToJuliet.addStep(new Conditions(this.potion, this.inJulietRoom), this.givePotionToJuliet);
        bringPotionToJuliet.addStep(this.potion, this.goUpToJuliet2);
        steps.put(50, bringPotionToJuliet);
        steps.put(60, this.finishQuest);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.cadavaBerry = new ItemRequirement("Cadava berries", 753);
        this.cadavaBerry.setTooltip("You can pick some from bushes south east of Varrock");
        this.letter = new ItemRequirement("Message", 755);
        this.letter.setTooltip("You can get another from Juliet");
        this.potion = new ItemRequirement("Cadava potion", 756);
    }

    public void setupConditions() {
        this.inJulietRoom = new ZoneRequirement(this.julietRoom);
    }

    public void setupZones() {
        this.julietRoom = new Zone(new WorldPoint(3147, 3425, 1), new WorldPoint(3166, 3443, 1));
    }

    public void setupSteps() {
        this.talkToRomeo = new NpcStep((QuestHelper)this, 5037, new WorldPoint(3211, 3422, 0), "Talk to Romeo in Varrock Square.", new Requirement[0]);
        this.talkToRomeo.addDialogStep("Yes, I have seen her actually!");
        this.talkToRomeo.addDialogStep("Yes, ok, I'll let her know.");
        this.goUpToJuliet = new ObjectStep((QuestHelper)this, 11797, new WorldPoint(3157, 3436, 0), "Talk to Juliet in the house west of Varrock.", new Requirement[0]);
        this.goUpToJuliet.addDialogStep("Ok, thanks.");
        this.talkToJuliet = new NpcStep((QuestHelper)this, 5035, new WorldPoint(3158, 3427, 1), "Talk to Juliet in the house west of Varrock.", new Requirement[0]);
        this.talkToJuliet.addSubSteps(this.goUpToJuliet);
        this.giveLetterToRomeo = new NpcStep((QuestHelper)this, 5037, new WorldPoint(3211, 3422, 0), "Bring the letter to Romeo in Varrock Square.", this.letter);
        this.talkToLawrence = new NpcStep((QuestHelper)this, 5038, new WorldPoint(3254, 3483, 0), "Talk to Father Lawrence in north east Varrock.", new Requirement[0]);
        this.talkToLawrence.addDialogStep("Ok, thanks.");
        this.talkToApothecary = new NpcStep((QuestHelper)this, 5036, new WorldPoint(3195, 3405, 0), "Bring the Apothecary cadava berries in south west Varrock.", this.cadavaBerry);
        this.talkToApothecary.addDialogStep("Talk about something else.");
        this.talkToApothecary.addDialogStep("Talk about Romeo & Juliet.");
        this.goUpToJuliet2 = new ObjectStep((QuestHelper)this, 11797, new WorldPoint(3157, 3436, 0), "Bring the potion to Juliet in the house west of Varrock.", this.potion);
        this.givePotionToJuliet = new NpcStep((QuestHelper)this, 5035, new WorldPoint(3158, 3427, 1), "Bring the potion to Juliet in the house west of Varrock.", this.potion);
        this.givePotionToJuliet.addSubSteps(this.goUpToJuliet2);
        this.finishQuest = new NpcStep((QuestHelper)this, 5037, new WorldPoint(3211, 3422, 0), "Talk to Romeo in Varrock Square to finish the quest.", new Requirement[0]);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.cadavaBerry);
        return reqs;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(5);
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Helping Romeo", Arrays.asList(this.talkToRomeo, this.talkToJuliet, this.giveLetterToRomeo), new Requirement[0]));
        allSteps.add(new PanelDetails("Hatching a plan", Arrays.asList(this.talkToLawrence, this.talkToApothecary), this.cadavaBerry));
        allSteps.add(new PanelDetails("Enact the plan", Arrays.asList(this.givePotionToJuliet, this.finishQuest), new Requirement[0]));
        return allSteps;
    }
}

