/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.recruitmentdrive;

import com.questhelper.helpers.quests.recruitmentdrive.DoorPuzzle;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.widget.WidgetTextRequirement;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.List;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.eventbus.Subscribe;

public class SirRenItchoodStep
extends ConditionalStep {
    private String answer = null;
    private String[] answers = new String[]{"NULL", "TIME", "FISH", "RAIN", "BITE", "MEAT", "LAST"};
    private final int VARBIT_FINISHED_ROOM = 663;
    private final int VARBIT_ANSWER = 666;
    private Requirement answerWidgetOpen;
    private DoorPuzzle enterDoorcode;
    private QuestStep talkToRen;
    private QuestStep openAnswerWidget;
    private QuestStep leaveRoom;
    private VarbitRequirement finishedRoomCondition;

    public SirRenItchoodStep(QuestHelper questHelper, QuestStep step, Requirement ... requirements) {
        super(questHelper, step, requirements);
        this.talkToRen = step;
        this.addRenSteps();
    }

    @Override
    public void startUp() {
        super.startUp();
        int answerID = this.client.getVarbitValue(666);
        if (answerID == 0) {
            return;
        }
        String answer = this.answers[answerID];
        this.enterDoorcode.updateWord(answer);
    }

    @Override
    @Subscribe
    public void onVarbitChanged(VarbitChanged varbitChanged) {
        super.onVarbitChanged(varbitChanged);
        int answerID = this.client.getVarbitValue(666);
        if (answerID == 0) {
            return;
        }
        String answer = this.answers[answerID];
        this.enterDoorcode.updateWord(answer);
    }

    private void addRenSteps() {
        this.finishedRoomCondition = new VarbitRequirement(663, 1);
        this.openAnswerWidget = new ObjectStep(this.questHelper, 7323, "Open the door to be prompted to enter a code.", new Requirement[0]);
        this.answerWidgetOpen = new WidgetTextRequirement(285, 55, "Combination Lock Door");
        this.enterDoorcode = new DoorPuzzle(this.questHelper, "NONE");
        this.leaveRoom = new ObjectStep(this.questHelper, 7323, "Leave through the door to enter the portal and continue.", new Requirement[0]);
        this.addStep(this.finishedRoomCondition, this.leaveRoom);
        this.addStep(new Conditions(this.answerWidgetOpen), this.enterDoorcode);
        this.addStep(null, this.openAnswerWidget);
    }

    public List<QuestStep> getPanelSteps() {
        ArrayList<QuestStep> steps = new ArrayList<QuestStep>();
        steps.add(this.talkToRen);
        steps.add(this.openAnswerWidget);
        steps.add(this.enterDoorcode);
        steps.add(this.leaveRoom);
        return steps;
    }
}

