/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.recruitmentdrive;

import com.questhelper.helpers.quests.recruitmentdrive.LadyTableStep;
import com.questhelper.helpers.quests.recruitmentdrive.MsCheevesSetup;
import com.questhelper.helpers.quests.recruitmentdrive.MsHynnAnswerDialogQuizStep;
import com.questhelper.helpers.quests.recruitmentdrive.SirRenItchoodStep;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.conditional.NpcCondition;
import com.questhelper.requirements.item.NoItemRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.ItemSlots;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.util.Operation;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.RECRUITMENT_DRIVE)
public class RecruitmentDrive
extends BasicQuestHelper {
    private NoItemRequirement noItemRequirement;
    private ZoneRequirement isFirstFloorCastle;
    private ZoneRequirement isSecondFloorCastle;
    private ZoneRequirement isInSirTinleysRoom;
    private ZoneRequirement isInMsHynnRoom;
    private ZoneRequirement isInSirKuamsRoom;
    private ZoneRequirement isInSirSpishyusRoom;
    private ZoneRequirement isInSirRenItchood;
    private ZoneRequirement isInladyTableRoom;
    private ConditionalStep conditionalTalkToSirAmikVarze;
    private QuestStep talkToSirTiffy;
    QuestStep doNothingStep;
    QuestStep talkToSirTinley;
    QuestStep leaveSirTinleyRoom;
    QuestStep talkToSirKuam;
    QuestStep killSirLeye;
    QuestStep leaveSirKuamRoom;
    QuestStep moveChickenOnRightToLeft;
    QuestStep moveFoxOnRightToLeft;
    QuestStep moveChickenOnLeftToRight;
    QuestStep moveGrainOnRightToLeft;
    QuestStep moveChickenOnRightToLeftAgain;
    QuestStep finishedSpishyusRoom;
    SirRenItchoodStep sirRenStep;
    LadyTableStep ladyTableStep;
    private QuestStep talkToMsHynnTerprett;
    private MsHynnAnswerDialogQuizStep msHynnDialogQuiz;
    private MsCheevesSetup msCheevesSetup;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.setupRequirements();
        this.SetupZones();
        return this.getSteps();
    }

    private Map<Integer, QuestStep> getSteps() {
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.TalkToSirAmikVarze());
        steps.put(1, this.TalkToSirTiffyInFaladorPark());
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.noItemRequirement = new NoItemRequirement("No items or equipment carried", ItemSlots.ANY_EQUIPPED_AND_INVENTORY);
    }

    public void SetupZones() {
        Zone firstFloorZone = new Zone(new WorldPoint(2954, 3335, 1), new WorldPoint(2966, 3343, 1));
        Zone secondFloorZone = new Zone(new WorldPoint(2955, 3334, 2), new WorldPoint(2964, 3342, 2));
        Zone sirTinleyRoomZone = new Zone(new WorldPoint(2471, 4954, 0), new WorldPoint(2481, 4960, 0));
        Zone msHynnRoomZone = new Zone(new WorldPoint(2446, 4934, 0), new WorldPoint(2457, 4946, 0));
        Zone sirKuamRoomZone = new Zone(new WorldPoint(2453, 4958, 0), new WorldPoint(2466, 4970, 0));
        Zone sirSphishyusZone = new Zone(new WorldPoint(2469, 4968, 0), new WorldPoint(2492, 4980, 0));
        Zone sirRenItchoodZone = new Zone(new WorldPoint(2438, 4952, 0), new WorldPoint(2448, 4962, 0));
        Zone ladyTableZone = new Zone(new WorldPoint(2445, 4974, 0), new WorldPoint(2461, 4987, 0));
        this.isFirstFloorCastle = new ZoneRequirement(firstFloorZone);
        this.isSecondFloorCastle = new ZoneRequirement(secondFloorZone);
        this.isInSirTinleysRoom = new ZoneRequirement(sirTinleyRoomZone);
        this.isInMsHynnRoom = new ZoneRequirement(msHynnRoomZone);
        this.isInSirKuamsRoom = new ZoneRequirement(sirKuamRoomZone);
        this.isInSirSpishyusRoom = new ZoneRequirement(sirSphishyusZone);
        this.isInSirRenItchood = new ZoneRequirement(sirRenItchoodZone);
        this.isInladyTableRoom = new ZoneRequirement(ladyTableZone);
    }

    private QuestStep TalkToSirTiffyInFaladorPark() {
        WorldPoint firstFloorStairsPosition = new WorldPoint(2955, 3338, 1);
        WorldPoint secondFloorStairsPosition = new WorldPoint(2960, 3339, 2);
        ObjectStep climbDownSecondFloorStaircase = new ObjectStep((QuestHelper)this, 24074, secondFloorStairsPosition, "Climb down the stairs from the second floor.", new Requirement[0]);
        ObjectStep climbDownfirstFloorStaircase = new ObjectStep((QuestHelper)this, 24074, firstFloorStairsPosition, "Climb down the stairs from the first floor.", new Requirement[0]);
        this.talkToSirTiffy = new NpcStep((QuestHelper)this, 4687, "Talk to Sir Tiffy Cashien in Falador Park.", this.noItemRequirement);
        ConditionalStep conditionalTalkToSirTiffy = new ConditionalStep((QuestHelper)this, this.talkToSirTiffy, new Requirement[0]);
        conditionalTalkToSirTiffy.addStep(this.isSecondFloorCastle, climbDownSecondFloorStaircase);
        conditionalTalkToSirTiffy.addStep(this.isFirstFloorCastle, climbDownfirstFloorStaircase);
        this.talkToSirTiffy.addDialogStep("Yes, let's go!");
        this.talkToSirTiffy.addSubSteps(climbDownfirstFloorStaircase, climbDownSecondFloorStaircase);
        this.getMsCheeves();
        conditionalTalkToSirTiffy.addStep(this.isInSirTinleysRoom, this.getSirTinley());
        conditionalTalkToSirTiffy.addStep(this.isInMsHynnRoom, this.getMsHynnTerprett());
        conditionalTalkToSirTiffy.addStep(this.isInSirRenItchood, this.getSirRenItchood());
        conditionalTalkToSirTiffy.addStep(this.isInladyTableRoom, this.getLadyTableStep());
        conditionalTalkToSirTiffy.addStep(this.isInSirSpishyusRoom, this.getSirSpishyus());
        conditionalTalkToSirTiffy.addStep(this.isInSirKuamsRoom, this.getSirKuam());
        conditionalTalkToSirTiffy.addStep(this.msCheevesSetup.getIsInMsCheeversRoom(), this.msCheevesSetup.getConditionalStep());
        return conditionalTalkToSirTiffy;
    }

    private LadyTableStep getLadyTableStep() {
        this.ladyTableStep = new LadyTableStep((QuestHelper)this, new Requirement[0]);
        return this.ladyTableStep;
    }

    private QuestStep getSirKuam() {
        VarbitRequirement finishedRoom = new VarbitRequirement(661, 1);
        this.talkToSirKuam = new NpcStep((QuestHelper)this, 4681, "Talk to Sir Kuam Ferentse to have him spawn Sir Leye.", new Requirement[0]);
        this.killSirLeye = new NpcStep((QuestHelper)this, 4682, "Defeat Sir Leye to win this challenge. You must use the steel warhammer or your barehands to deal the final hit on him.", true, new Requirement[0]);
        this.leaveSirKuamRoom = new ObjectStep((QuestHelper)this, 7317, "Leave through the portal to continue.", new Requirement[0]);
        NpcCondition npcCondition = new NpcCondition(4682);
        ConditionalStep sirKuamConditional = new ConditionalStep((QuestHelper)this, this.talkToSirKuam, new Requirement[0]);
        sirKuamConditional.addStep(finishedRoom, this.leaveSirKuamRoom);
        sirKuamConditional.addStep(npcCondition, this.killSirLeye);
        return sirKuamConditional;
    }

    private void getMsCheeves() {
        this.msCheevesSetup = new MsCheevesSetup(this);
    }

    private QuestStep getSirSpishyus() {
        WorldPoint chickenOnLeftPoint = new WorldPoint(2473, 4970, 0);
        WorldPoint chickenOnRightPoint = new WorldPoint(2487, 4974, 0);
        WorldPoint foxOnRightPoint = new WorldPoint(2485, 4974, 0);
        WorldPoint grainOnRightPoint = new WorldPoint(2486, 4974, 0);
        VarbitRequirement foxOnRightSide = new VarbitRequirement(680, 0);
        VarbitRequirement foxOnLeftSide = new VarbitRequirement(681, 1);
        VarbitRequirement foxNotOnRightSide = new VarbitRequirement(680, 1);
        VarbitRequirement foxNotOnLeftSide = new VarbitRequirement(681, 0);
        VarbitRequirement chickenOnRightSide = new VarbitRequirement(682, 0);
        VarbitRequirement chickenOnLeftSide = new VarbitRequirement(683, 1);
        VarbitRequirement chickenNotOnRightSide = new VarbitRequirement(682, 1);
        VarbitRequirement chickenNotOnLeftSide = new VarbitRequirement(683, 0);
        VarbitRequirement grainOnRightSide = new VarbitRequirement(684, 0);
        VarbitRequirement grainOnLeftSide = new VarbitRequirement(685, 1);
        VarbitRequirement grainNotOnRightSide = new VarbitRequirement(684, 1);
        VarbitRequirement grainNotOnLeftSide = new VarbitRequirement(685, 0);
        VarbitRequirement finishedSpishyus = new VarbitRequirement(659, 1);
        Conditions foxPickedUp = new Conditions(LogicType.AND, foxNotOnLeftSide, foxNotOnRightSide);
        Conditions chickenPickedUp = new Conditions(LogicType.AND, chickenNotOnRightSide, chickenNotOnLeftSide);
        Conditions grainPickedUp = new Conditions(LogicType.AND, grainNotOnLeftSide, grainNotOnRightSide);
        int chickenOnRightId = 7279;
        this.moveChickenOnRightToLeft = new ObjectStep((QuestHelper)this, chickenOnRightId, chickenOnRightPoint, this.getSpishyusPickupText("Chicken", true), new Requirement[0]);
        this.finishedSpishyusRoom = new ObjectStep((QuestHelper)this, 7274, "Leave through the portal to continue.", new Requirement[0]);
        int foxOnRightId = 7275;
        this.moveFoxOnRightToLeft = new ObjectStep((QuestHelper)this, foxOnRightId, foxOnRightPoint, this.getSpishyusPickupText("Fox", true), new Requirement[0]);
        DetailedQuestStep moveChickenToLeft = new DetailedQuestStep((QuestHelper)this, this.getSpishyusMoveText("Chicken", false), new Requirement[0]);
        this.moveChickenOnRightToLeft.addSubSteps(moveChickenToLeft);
        DetailedQuestStep moveFoxToLeft = new DetailedQuestStep((QuestHelper)this, this.getSpishyusMoveText("Fox", false), new Requirement[0]);
        this.moveFoxOnRightToLeft.addSubSteps(moveFoxToLeft);
        int chickenOnLeftId = 7280;
        this.moveChickenOnLeftToRight = new ObjectStep((QuestHelper)this, chickenOnLeftId, chickenOnLeftPoint, this.getSpishyusPickupText("Chicken", false), new Requirement[0]);
        DetailedQuestStep moveChickenToRight = new DetailedQuestStep((QuestHelper)this, this.getSpishyusMoveText("Chicken", true), new Requirement[0]);
        this.moveChickenOnLeftToRight.addSubSteps(moveChickenToRight);
        int grainOnRightId = 7282;
        this.moveGrainOnRightToLeft = new ObjectStep((QuestHelper)this, grainOnRightId, grainOnRightPoint, this.getSpishyusPickupText("Grain", true), new Requirement[0]);
        DetailedQuestStep moveGrainToLeft = new DetailedQuestStep((QuestHelper)this, this.getSpishyusMoveText("Grain", false), new Requirement[0]);
        this.moveGrainOnRightToLeft.addSubSteps(moveGrainToLeft);
        this.moveChickenOnRightToLeftAgain = new ObjectStep((QuestHelper)this, chickenOnRightId, chickenOnRightPoint, this.getSpishyusPickupText("Chicken", true), new Requirement[0]);
        DetailedQuestStep moveChickenToLeftAgain = new DetailedQuestStep((QuestHelper)this, this.getSpishyusMoveText("Chicken", false), new Requirement[0]);
        this.moveChickenOnRightToLeftAgain.addSubSteps(moveChickenToLeftAgain);
        ConditionalStep sirSpishyus = new ConditionalStep((QuestHelper)this, this.moveChickenOnRightToLeft, new Requirement[0]);
        sirSpishyus.addStep(finishedSpishyus, this.finishedSpishyusRoom);
        sirSpishyus.addStep(new Conditions(chickenOnRightSide, foxOnRightSide, grainOnRightSide), this.moveChickenOnRightToLeft);
        sirSpishyus.addStep(new Conditions(chickenPickedUp, foxOnRightSide, grainOnRightSide), moveChickenToLeft);
        sirSpishyus.addStep(new Conditions(chickenOnLeftSide, foxOnRightSide, grainOnRightSide), this.moveFoxOnRightToLeft);
        sirSpishyus.addStep(new Conditions(chickenOnLeftSide, foxPickedUp, grainOnRightSide), moveFoxToLeft);
        sirSpishyus.addStep(new Conditions(chickenOnLeftSide, foxOnLeftSide, grainOnRightSide), this.moveChickenOnLeftToRight);
        sirSpishyus.addStep(new Conditions(chickenPickedUp, foxOnLeftSide, grainOnRightSide), moveChickenToRight);
        sirSpishyus.addStep(new Conditions(chickenOnRightSide, foxOnLeftSide, grainOnRightSide), this.moveGrainOnRightToLeft);
        sirSpishyus.addStep(new Conditions(chickenOnRightSide, foxOnLeftSide, grainPickedUp), moveGrainToLeft);
        sirSpishyus.addStep(new Conditions(chickenOnRightSide, foxOnLeftSide, grainOnLeftSide), this.moveChickenOnRightToLeftAgain);
        sirSpishyus.addStep(new Conditions(chickenPickedUp, foxOnLeftSide, grainOnLeftSide), moveChickenToLeftAgain);
        return sirSpishyus;
    }

    private String getSpishyusPickupText(String itemName, boolean moveRightToLeft) {
        String firstSide = moveRightToLeft ? "east" : "west";
        String secondSide = moveRightToLeft ? "west" : "east";
        return "Pickup the " + itemName + " on the " + firstSide + " and move it to the " + secondSide + " side by crossing the bridge";
    }

    private String getSpishyusMoveText(String itemName, boolean rightSide) {
        String dropSide = rightSide ? "east" : "west";
        return "Cross the bridge to the " + dropSide + " and drop the " + itemName + " from your equipped items.";
    }

    private QuestStep getSirRenItchood() {
        NpcStep talkToSirRenItchood = new NpcStep((QuestHelper)this, 4684, "Talk to Sir Ren Itchood to recieve the clue.", new Requirement[0]);
        talkToSirRenItchood.addDialogSteps("Can I have the clue for the door?");
        this.sirRenStep = new SirRenItchoodStep((QuestHelper)this, (QuestStep)talkToSirRenItchood, new Requirement[0]);
        return this.sirRenStep;
    }

    private QuestStep getSirTinley() {
        this.talkToSirTinley = new NpcStep((QuestHelper)this, 4683, "Talk to Sir Tinley. \n Once you have pressed continue do not do anything or you will fail.", new Requirement[0]);
        this.doNothingStep = new DetailedQuestStep((QuestHelper)this, "Press Continue and do nothing. Sir Tinley will eventually talk to you and let you pass.", new Requirement[0]);
        this.leaveSirTinleyRoom = new ObjectStep((QuestHelper)this, 7320, "Leave through the portal to continue.", new Requirement[0]);
        VarbitRequirement waitForCondition = new VarbitRequirement(667, 1, Operation.GREATER_EQUAL);
        VarbitRequirement finishedRoom = new VarbitRequirement(662, 1);
        ConditionalStep sirTinleyStep = new ConditionalStep((QuestHelper)this, this.talkToSirTinley, new Requirement[0]);
        sirTinleyStep.addStep(finishedRoom, this.leaveSirTinleyRoom);
        sirTinleyStep.addStep(waitForCondition, this.doNothingStep);
        return sirTinleyStep;
    }

    private QuestStep getMsHynnTerprett() {
        this.talkToMsHynnTerprett = new NpcStep((QuestHelper)this, 4686, "Talk to Ms Hynn Terprett and answer the riddle.", new Requirement[0]);
        this.msHynnDialogQuiz = new MsHynnAnswerDialogQuizStep((QuestHelper)this, this.talkToMsHynnTerprett, new Requirement[0]);
        return this.msHynnDialogQuiz;
    }

    private QuestStep TalkToSirAmikVarze() {
        WorldPoint bottomStairsPosition = new WorldPoint(2955, 3339, 0);
        WorldPoint secondStairsPosition = new WorldPoint(2961, 3339, 1);
        ObjectStep climbBottomSteps = new ObjectStep((QuestHelper)this, 24072, bottomStairsPosition, "Climb up the stairs to the first floor on the Falador Castle.", new Requirement[0]);
        ObjectStep climbSecondSteps = new ObjectStep((QuestHelper)this, 24072, secondStairsPosition, "Climb up the stairs to talk to Sir Amik Vaze.", new Requirement[0]);
        NpcStep talkToSirAmikVarze = new NpcStep((QuestHelper)this, 4771, "", new Requirement[0]);
        talkToSirAmikVarze.addDialogStep("Yes please");
        this.conditionalTalkToSirAmikVarze = new ConditionalStep((QuestHelper)this, (QuestStep)climbBottomSteps, "Talk to Sir Amik Varze.", new Requirement[0]);
        this.conditionalTalkToSirAmikVarze.addStep(this.isFirstFloorCastle, climbSecondSteps);
        this.conditionalTalkToSirAmikVarze.addStep(this.isSecondFloorCastle, talkToSirAmikVarze);
        this.conditionalTalkToSirAmikVarze.addSubSteps(climbSecondSteps, climbBottomSteps, talkToSirAmikVarze);
        return this.conditionalTalkToSirAmikVarze;
    }

    @Override
    public List<String> getCombatRequirements() {
        return Collections.singletonList("Sir Leye (level 20) with no items");
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> reqs = new ArrayList<Requirement>();
        reqs.add(new QuestRequirement(QuestHelperQuest.BLACK_KNIGHTS_FORTRESS, QuestState.FINISHED));
        reqs.add(new QuestRequirement(QuestHelperQuest.DRUIDIC_RITUAL, QuestState.FINISHED));
        return reqs;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Arrays.asList(new ExperienceReward(Skill.PRAYER, 1000), new ExperienceReward(Skill.AGILITY, 1000), new ExperienceReward(Skill.HERBLORE, 1000));
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Arrays.asList(new ItemReward("Initiate Helm", 5574, 1), new ItemReward("Coins", 995, 3000));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("Ability to respawn in Falador"), new UnlockReward("Access to Initiate Armor"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> steps = new ArrayList<PanelDetails>();
        PanelDetails startingPanel = new PanelDetails("Starting out", new ArrayList<QuestStep>(Collections.singletonList(this.conditionalTalkToSirAmikVarze)), new Requirement[0]);
        PanelDetails testing = new PanelDetails("Start the testing", Collections.singletonList(this.talkToSirTiffy), this.noItemRequirement);
        PanelDetails sirTinleysRoom = new PanelDetails("Sir Tinley", Arrays.asList(this.talkToSirTinley, this.doNothingStep, this.leaveSirTinleyRoom), new Requirement[0]);
        ArrayList<QuestStep> hynnSteps = new ArrayList<QuestStep>();
        hynnSteps.add(this.talkToMsHynnTerprett);
        hynnSteps.addAll(this.msHynnDialogQuiz.getPanelSteps());
        PanelDetails msHynnsRoom = new PanelDetails("Ms Hynn Terprett", hynnSteps, new Requirement[0]);
        PanelDetails sirKuamRoom = new PanelDetails("Sir Kuam", Arrays.asList(this.talkToSirKuam, this.killSirLeye, this.leaveSirKuamRoom), new Requirement[0]);
        PanelDetails sirSpishyusRoom = new PanelDetails("Sir Spishyus", Arrays.asList(this.moveChickenOnRightToLeft, this.moveFoxOnRightToLeft, this.moveChickenOnLeftToRight, this.moveGrainOnRightToLeft, this.moveChickenOnRightToLeftAgain), new Requirement[0]);
        PanelDetails sirRensRoom = new PanelDetails("Sir Ren Itchood", this.sirRenStep.getPanelSteps(), new Requirement[0]);
        PanelDetails missCheeversRoom = new PanelDetails("Mis Cheevers", this.msCheevesSetup.GetPanelSteps(), new Requirement[0]);
        PanelDetails ladyTable = new PanelDetails("Lady Table", this.ladyTableStep.getPanelSteps(), new Requirement[0]);
        steps.add(startingPanel);
        steps.add(testing);
        steps.add(sirKuamRoom);
        steps.add(sirSpishyusRoom);
        steps.add(msHynnsRoom);
        steps.add(sirTinleysRoom);
        steps.add(sirRensRoom);
        steps.add(missCheeversRoom);
        steps.add(ladyTable);
        return steps;
    }
}

