/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.recruitmentdrive;

import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.item.ItemRequirements;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ItemStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.List;
import net.runelite.api.coords.WorldPoint;

public class MsCheevesSetup {
    private QuestHelper questHelper;
    private ZoneRequirement isInMsCheeversRoom;
    private ConditionalStep conditionalStep;
    private ObjectStep getMagnetStep;
    private ObjectStep getTwoVials;
    private ObjectStep getCupricSulfate;
    private ObjectStep getGypsum;
    private ObjectStep getSodiumChloride;
    private ObjectStep getWire;
    private ObjectStep getTin;
    private ObjectStep getShears;
    private ObjectStep getChisel;
    private ObjectStep getNitrousOxide;
    private ObjectStep getTinOrePowder;
    private ObjectStep getCupricOrePowder;
    private ObjectStep getThreeVials;
    private ObjectStep getKnife;
    private ObjectStep leaveRoom;
    private ItemStep getMetalSpade;
    private Requirement hasMagnet;
    private Requirement hasAceticAcid;
    private Requirement hasOneVialOfLiquid;
    private Requirement hasCupricSulfate;
    private Requirement hasGypsum;
    private Requirement hasSodiumChloride;
    private Requirement hasWire;
    private Requirement hasTin;
    private Requirement hasShears;
    private Requirement hasChisel;
    private Requirement hasNitrousOxide;
    private Requirement hasTinOrePowder;
    private Requirement hasCupricOrePowder;
    private Requirement hasKnife;
    private Requirement hasMetalSpade;
    private Requirement hasMetalSpadeHead;
    private Requirement hasAshes;
    private Requirement hasBronzeKey;
    private VarbitRequirement finishedRoom;
    private QuestStep useSpadeOnBunsenBurner;
    private QuestStep useSpadeHeadOnDoor;
    private QuestStep useCupricSulfateOnDoor;
    private QuestStep useVialOfLiquidOnDoor;
    private QuestStep openDoor;
    private VarbitRequirement hasRetrievedThreeVials;
    private VarbitRequirement hasSpadeHeadOnDoor;
    private VarbitRequirement hasCupricSulfateOnDoor;
    private VarbitRequirement hasVialOfLiquidOnDoor;
    private VarbitRequirement hasFirstDoorOpen;
    private ItemRequirement metalSpade;
    private ItemRequirement metalSpadeHead;
    private ItemRequirement ashes;
    private ItemRequirement cupricSulfate;
    private ItemRequirement vialOfLiquid;
    private QuestStep useVialOfLiquidOnCakeTin;
    private QuestStep useGypsumOnTin;
    private QuestStep useTinOnKey;
    private QuestStep useCupricOrePowderOnTin;
    private QuestStep useTinOrePowderOnTin;
    private QuestStep useTinOnBunsenBurner;
    private QuestStep useEquipmentOnTin;
    private ItemRequirement tin;
    private ItemRequirement gypsumTin;
    private ItemRequirement gypsum;
    private ItemRequirement tinKeyPrint;
    private ItemRequirement cupricOrePowder;
    private ItemRequirement tinOrePowder;
    private ItemRequirement tinWithCupricOre;
    private ItemRequirement tinWithTinOre;
    private ItemRequirement tinWithAllOre;
    private ItemRequirement bronzeKey;
    private ItemRequirement knife;
    private ItemRequirement chisel;
    private ItemRequirement bronzeWire;
    private VarbitRequirement hasLiquidInTin;
    ItemRequirement hasGypsumTin;
    ItemRequirement hasTinKeyPrint;
    ItemRequirement hasTinCupricOre;
    ItemRequirement hasTinWithTinOre;
    ItemRequirement hasTinWithAllOre;
    private final int VARBIT_NITROUS_OXIDE = 5581;
    private final int VARBIT_VIAL_OF_LIQUID = 671;
    private final int VARBIT_ACETIC_ACIDE = 672;
    private final int VARBIT_CUPRIC_SULFATE = 673;
    private final int VARBIT_GYPSUM = 674;
    private final int VARBIT_SODIUM_CHLORIDE = 675;
    private final int VARBIT_NITROUS_OXIDE_RETRIEVED = 676;
    private final int VARBIT_TIN_ORE_POWDER = 677;
    private final int VARBIT_CUPRIC_ORE_POWDER = 678;
    private final int VARBIT_THREE_VIALS = 679;
    private final int VARBIT_SPADEHEAD_ON_DOOR = 686;
    private final int VARBIT_USE_CUPRIC_SULFATE_ON_DOOR = 687;
    private final int VARBIT_VIAL_OF_LIQUID_ON_DOOR = 686;
    private final int VARBIT_FIRST_DOOR_OPEN = 686;
    private final int VARBIT_LIQUID_IN_TIN = 689;
    private final int VARBIT_COMPLETE_ROOM = 664;

    public MsCheevesSetup(QuestHelper questHelper) {
        this.questHelper = questHelper;
        this.setupRequirements();
        this.setupZoneCondition();
        this.setupConditions();
        this.setupSteps();
        this.addSteps();
    }

    private void setupSteps() {
        this.getMagnetStep = new ObjectStep(this.questHelper, 7327, "Get the magnet from the old bookshelf.", new Requirement[0]);
        this.getTwoVials = new ObjectStep(this.questHelper, 7333, "Get two vials from the shelves", new Requirement[0]);
        this.getTwoVials.addDialogStep("Take both vials.");
        this.getCupricSulfate = new ObjectStep(this.questHelper, 7334, "Get Cupric Sulfate from the shelves.", new Requirement[0]);
        this.getCupricSulfate.addDialogStep("YES");
        this.getGypsum = new ObjectStep(this.questHelper, 7335, "Get Gypsum from the shelves.", new Requirement[0]);
        this.getGypsum.addDialogStep("YES");
        this.getSodiumChloride = new ObjectStep(this.questHelper, 7336, "Get Sodium Chloride from the shelves.", new Requirement[0]);
        this.getSodiumChloride.addDialogStep("YES");
        this.getWire = new ObjectStep(this.questHelper, 7349, new WorldPoint(2475, 4943, 0), "Get Wire from the crate.", new Requirement[0]);
        this.getTin = new ObjectStep(this.questHelper, 7347, new WorldPoint(2476, 4943, 0), "Get Tin from the crate.", new Requirement[0]);
        this.getShears = new ObjectStep(this.questHelper, 7350, "Get Shears from the chest.", new Requirement[0]);
        this.getShears.addAlternateObjects(7351);
        this.getChisel = new ObjectStep(this.questHelper, 7348, new WorldPoint(2476, 4937, 0), "Get a Chisel from the crate.", new Requirement[0]);
        this.getNitrousOxide = new ObjectStep(this.questHelper, 7337, "Get Nitrous Oxide from the Shelves.", new Requirement[0]);
        this.getNitrousOxide.addDialogStep("YES");
        this.getTinOrePowder = new ObjectStep(this.questHelper, 7338, "Get Tin Ore Powder from the Shelves.", new Requirement[0]);
        this.getTinOrePowder.addDialogStep("YES");
        this.getCupricOrePowder = new ObjectStep(this.questHelper, 7339, "Get Curpic Ore Powder from the Shelves.", new Requirement[0]);
        this.getCupricOrePowder.addDialogStep("YES");
        this.getThreeVials = new ObjectStep(this.questHelper, 7340, "Get Three Vials Of Liquid from the Shelves.", new Requirement[0]);
        this.getThreeVials.addDialogStep("Take all three vials");
        this.getKnife = new ObjectStep(this.questHelper, 7329, "Get a Knife from the old bookshelf.", new Requirement[0]);
        this.getMetalSpade = new ItemStep(this.questHelper, "Get the metal spade off the table", this.metalSpade);
        this.useSpadeOnBunsenBurner = new ObjectStep(this.questHelper, 7332, "Use the spade in your inventory on the bunsen burner", this.metalSpade);
        this.useSpadeOnBunsenBurner.addIcon(5586);
        this.useSpadeHeadOnDoor = new ObjectStep(this.questHelper, 7342, "Use the spade in your inventory on the door.", this.metalSpadeHead);
        this.useSpadeHeadOnDoor.addIcon(5587);
        this.useCupricSulfateOnDoor = new ObjectStep(this.questHelper, 7342, "Use Cupric Sulfate in your inventory on the door.", this.cupricSulfate);
        this.useCupricSulfateOnDoor.addIcon(5577);
        this.useVialOfLiquidOnDoor = new ObjectStep(this.questHelper, 7342, "Use vial of liquid in your inventory on the door.", this.vialOfLiquid);
        this.useVialOfLiquidOnDoor.addIcon(5582);
        this.openDoor = new ObjectStep(this.questHelper, 7342, "Open the door.", new Requirement[0]);
        this.useVialOfLiquidOnCakeTin = new DetailedQuestStep(this.questHelper, "Use a vial of liquid on the tin in your inventory.", this.tin, this.vialOfLiquid);
        this.useGypsumOnTin = new DetailedQuestStep(this.questHelper, "Use a vial of Gypsum on the tin in your inventory.", this.gypsum, this.tin);
        this.useTinOnKey = new ObjectStep(this.questHelper, 7346, "Use tin full with Gypsum on the key on the ground.", this.gypsumTin);
        this.useTinOnKey.addIcon(5593);
        this.useCupricOrePowderOnTin = new DetailedQuestStep(this.questHelper, "Use Tin on the cupric ore powder in your inventory.", this.tinKeyPrint, this.cupricOrePowder);
        this.useTinOrePowderOnTin = new DetailedQuestStep(this.questHelper, "Use Tin on the tin ore powder in your inventory.", this.tinWithCupricOre, this.tinOrePowder);
        this.useTinOnBunsenBurner = new ObjectStep(this.questHelper, 7332, "Use your tin with the bunsen burner to create a bronze key.", this.tinWithTinOre);
        this.useTinOnBunsenBurner.addIcon(5597);
        this.useEquipmentOnTin = new DetailedQuestStep(this.questHelper, "Use your chisel,knife or bronze wires on your tin in your inventory.", this.tinWithAllOre, this.chisel, this.knife, this.bronzeWire);
        this.leaveRoom = new ObjectStep(this.questHelper, 7326, new WorldPoint(2478, 4940, 0), "Leave the room by the second door to enter the portal", new Requirement[0]);
    }

    private void addSteps() {
        this.conditionalStep = new ConditionalStep(this.questHelper, (QuestStep)this.getMagnetStep, new Requirement[0]);
        this.conditionalStep.addStep(new Conditions(this.hasFirstDoorOpen, this.hasBronzeKey, this.finishedRoom), this.leaveRoom);
        this.setupSecondDoorKeyStep();
        this.destroyFirstDoorSteps();
        this.retrieveItemSteps();
    }

    public List<QuestStep> GetPanelSteps() {
        ArrayList<QuestStep> steps = new ArrayList<QuestStep>();
        steps.add(this.getMagnetStep);
        steps.add(this.getTwoVials);
        steps.add(this.getCupricSulfate);
        steps.add(this.getGypsum);
        steps.add(this.getSodiumChloride);
        steps.add(this.getWire);
        steps.add(this.getTin);
        steps.add(this.getShears);
        steps.add(this.getChisel);
        steps.add(this.getNitrousOxide);
        steps.add(this.getTinOrePowder);
        steps.add(this.getCupricOrePowder);
        steps.add(this.getThreeVials);
        steps.add(this.getKnife);
        steps.add(this.getMetalSpade);
        steps.add(this.useSpadeOnBunsenBurner);
        steps.add(this.useSpadeHeadOnDoor);
        steps.add(this.useCupricSulfateOnDoor);
        steps.add(this.useVialOfLiquidOnDoor);
        steps.add(this.openDoor);
        steps.add(this.useVialOfLiquidOnCakeTin);
        steps.add(this.useGypsumOnTin);
        steps.add(this.useTinOnKey);
        steps.add(this.useCupricOrePowderOnTin);
        steps.add(this.useTinOrePowderOnTin);
        steps.add(this.useTinOnBunsenBurner);
        steps.add(this.useEquipmentOnTin);
        steps.add(this.leaveRoom);
        return steps;
    }

    private void setupSecondDoorKeyStep() {
        this.conditionalStep.addStep(new Conditions(this.hasFirstDoorOpen, this.hasTinWithAllOre), this.useEquipmentOnTin);
        this.conditionalStep.addStep(new Conditions(this.hasFirstDoorOpen, this.hasTinWithTinOre), this.useTinOnBunsenBurner);
        this.conditionalStep.addStep(new Conditions(this.hasFirstDoorOpen, this.hasTinCupricOre), this.useTinOrePowderOnTin);
        this.conditionalStep.addStep(new Conditions(this.hasFirstDoorOpen, this.hasTinKeyPrint), this.useCupricOrePowderOnTin);
        this.conditionalStep.addStep(new Conditions(this.hasFirstDoorOpen, this.hasGypsumTin), this.useTinOnKey);
        this.conditionalStep.addStep(new Conditions(this.hasFirstDoorOpen, this.hasLiquidInTin), this.useGypsumOnTin);
        this.conditionalStep.addStep(new Conditions(this.hasFirstDoorOpen), this.useVialOfLiquidOnCakeTin);
    }

    private void destroyFirstDoorSteps() {
        this.conditionalStep.addStep(new Conditions(this.hasMagnet, this.hasAceticAcid, this.hasOneVialOfLiquid, this.hasGypsum, this.hasSodiumChloride, this.hasWire, this.hasTin, this.hasShears, this.hasNitrousOxide, this.hasNitrousOxide, this.hasTinOrePowder, this.hasCupricOrePowder, this.hasRetrievedThreeVials, this.hasKnife, this.hasAshes, this.hasVialOfLiquidOnDoor), this.openDoor);
        this.conditionalStep.addStep(new Conditions(this.hasMagnet, this.hasAceticAcid, this.hasOneVialOfLiquid, this.hasGypsum, this.hasSodiumChloride, this.hasWire, this.hasTin, this.hasShears, this.hasNitrousOxide, this.hasNitrousOxide, this.hasTinOrePowder, this.hasCupricOrePowder, this.hasRetrievedThreeVials, this.hasKnife, this.hasAshes, this.hasCupricSulfateOnDoor), this.useVialOfLiquidOnDoor);
        this.conditionalStep.addStep(new Conditions(this.hasMagnet, this.hasAceticAcid, this.hasOneVialOfLiquid, this.hasCupricSulfate, this.hasGypsum, this.hasSodiumChloride, this.hasWire, this.hasTin, this.hasShears, this.hasNitrousOxide, this.hasNitrousOxide, this.hasTinOrePowder, this.hasCupricOrePowder, this.hasRetrievedThreeVials, this.hasKnife, this.hasAshes, this.hasSpadeHeadOnDoor), this.useCupricSulfateOnDoor);
        this.conditionalStep.addStep(new Conditions(this.hasMagnet, this.hasAceticAcid, this.hasOneVialOfLiquid, this.hasCupricSulfate, this.hasGypsum, this.hasSodiumChloride, this.hasWire, this.hasTin, this.hasShears, this.hasNitrousOxide, this.hasNitrousOxide, this.hasTinOrePowder, this.hasCupricOrePowder, this.hasRetrievedThreeVials, this.hasKnife, this.hasMetalSpadeHead, this.hasAshes), this.useSpadeHeadOnDoor);
        this.conditionalStep.addStep(new Conditions(this.hasMagnet, this.hasAceticAcid, this.hasOneVialOfLiquid, this.hasCupricSulfate, this.hasGypsum, this.hasSodiumChloride, this.hasWire, this.hasTin, this.hasShears, this.hasNitrousOxide, this.hasNitrousOxide, this.hasTinOrePowder, this.hasCupricOrePowder, this.hasRetrievedThreeVials, this.hasKnife, this.hasMetalSpade), this.useSpadeOnBunsenBurner);
    }

    private void retrieveItemSteps() {
        this.conditionalStep.addStep(new Conditions(this.hasMagnet, this.hasAceticAcid, this.hasOneVialOfLiquid, this.hasCupricSulfate, this.hasGypsum, this.hasSodiumChloride, this.hasWire, this.hasTin, this.hasShears, this.hasNitrousOxide, this.hasNitrousOxide, this.hasTinOrePowder, this.hasCupricOrePowder, this.hasRetrievedThreeVials, this.hasKnife), this.getMetalSpade);
        this.conditionalStep.addStep(new Conditions(this.hasMagnet, this.hasAceticAcid, this.hasOneVialOfLiquid, this.hasCupricSulfate, this.hasGypsum, this.hasSodiumChloride, this.hasWire, this.hasTin, this.hasShears, this.hasNitrousOxide, this.hasNitrousOxide, this.hasTinOrePowder, this.hasCupricOrePowder, this.hasRetrievedThreeVials), this.getKnife);
        this.conditionalStep.addStep(new Conditions(this.hasMagnet, this.hasAceticAcid, this.hasOneVialOfLiquid, this.hasCupricSulfate, this.hasGypsum, this.hasSodiumChloride, this.hasWire, this.hasTin, this.hasShears, this.hasNitrousOxide, this.hasNitrousOxide, this.hasTinOrePowder, this.hasCupricOrePowder), this.getThreeVials);
        this.conditionalStep.addStep(new Conditions(this.hasMagnet, this.hasAceticAcid, this.hasOneVialOfLiquid, this.hasCupricSulfate, this.hasGypsum, this.hasSodiumChloride, this.hasWire, this.hasTin, this.hasShears, this.hasNitrousOxide, this.hasNitrousOxide, this.hasTinOrePowder), this.getCupricOrePowder);
        this.conditionalStep.addStep(new Conditions(this.hasMagnet, this.hasAceticAcid, this.hasOneVialOfLiquid, this.hasCupricSulfate, this.hasGypsum, this.hasSodiumChloride, this.hasWire, this.hasTin, this.hasShears, this.hasNitrousOxide, this.hasNitrousOxide), this.getTinOrePowder);
        this.conditionalStep.addStep(new Conditions(this.hasMagnet, this.hasAceticAcid, this.hasOneVialOfLiquid, this.hasCupricSulfate, this.hasGypsum, this.hasSodiumChloride, this.hasWire, this.hasTin, this.hasShears, this.hasChisel), this.getNitrousOxide);
        this.conditionalStep.addStep(new Conditions(this.hasMagnet, this.hasAceticAcid, this.hasOneVialOfLiquid, this.hasCupricSulfate, this.hasGypsum, this.hasSodiumChloride, this.hasWire, this.hasTin, this.hasShears), this.getChisel);
        this.conditionalStep.addStep(new Conditions(this.hasMagnet, this.hasAceticAcid, this.hasOneVialOfLiquid, this.hasCupricSulfate, this.hasGypsum, this.hasSodiumChloride, this.hasWire, this.hasTin), this.getShears);
        this.conditionalStep.addStep(new Conditions(this.hasMagnet, this.hasAceticAcid, this.hasOneVialOfLiquid, this.hasCupricSulfate, this.hasGypsum, this.hasSodiumChloride, this.hasWire), this.getTin);
        this.conditionalStep.addStep(new Conditions(this.hasMagnet, this.hasAceticAcid, this.hasOneVialOfLiquid, this.hasCupricSulfate, this.hasGypsum, this.hasSodiumChloride), this.getWire);
        this.conditionalStep.addStep(new Conditions(this.hasMagnet, this.hasAceticAcid, this.hasOneVialOfLiquid, this.hasCupricSulfate, this.hasGypsum), this.getSodiumChloride);
        this.conditionalStep.addStep(new Conditions(this.hasMagnet, this.hasAceticAcid, this.hasOneVialOfLiquid, this.hasCupricSulfate), this.getGypsum);
        this.conditionalStep.addStep(new Conditions(this.hasMagnet, this.hasAceticAcid, this.hasOneVialOfLiquid), this.getCupricSulfate);
        this.conditionalStep.addStep(this.hasMagnet, this.getTwoVials);
    }

    private void setupZoneCondition() {
        Zone missCheevesZone = new Zone(new WorldPoint(2466, 4936, 0), new WorldPoint(2480, 4947, 0));
        this.isInMsCheeversRoom = new ZoneRequirement(missCheevesZone);
    }

    public void setupRequirements() {
        this.metalSpade = new ItemRequirement("Metal Spade", 5586);
        this.metalSpade.setTooltip("If you are missing this item pick another up off the table.");
        this.metalSpade.setHighlightInInventory(true);
        this.metalSpadeHead = new ItemRequirement("Metal Spade", 5587);
        this.metalSpadeHead.setHighlightInInventory(true);
        this.metalSpadeHead.setTooltip("If you are missing this item pick up a metal spade off the table and use it on the bunsen burner.");
        this.ashes = new ItemRequirement("Ashes", 592);
        this.ashes.setHighlightInInventory(true);
        this.ashes.setTooltip("If you are missing this item pick up a metal spade off the table and use it on the bunsen burner.");
        this.cupricSulfate = new ItemRequirement("Cupric Sulfate", 5577);
        this.cupricSulfate.setHighlightInInventory(true);
        this.cupricSulfate.setTooltip("Take from the shelves on the north side");
        this.vialOfLiquid = new ItemRequirement("Vial of Liquid", 5582);
        this.vialOfLiquid.setHighlightInInventory(true);
        this.vialOfLiquid.setTooltip("Take from the shelf on the north side or the south side.");
        this.tin = new ItemRequirement("Tin", 5592);
        this.tin.setHighlightInInventory(true);
        this.gypsumTin = new ItemRequirement("Tin", 5593);
        this.gypsumTin.setHighlightInInventory(true);
        this.gypsum = new ItemRequirement("Gypsum", 5579);
        this.gypsum.setHighlightInInventory(true);
        this.tinKeyPrint = new ItemRequirement("Tin", 5594);
        this.tinKeyPrint.setHighlightInInventory(true);
        this.tinWithCupricOre = new ItemRequirement("Tin", 5596);
        this.tinWithCupricOre.setHighlightInInventory(true);
        this.cupricOrePowder = new ItemRequirement("Cupric Ore Powder", 5584);
        this.cupricOrePowder.setHighlightInInventory(true);
        this.tinOrePowder = new ItemRequirement("Tin Ore Powder", 5583);
        this.tinOrePowder.setHighlightInInventory(true);
        this.tinWithTinOre = new ItemRequirement("Tin", 5597);
        this.tinWithTinOre.setHighlightInInventory(true);
        this.tinWithAllOre = new ItemRequirement("Tin", 5598);
        this.tinWithAllOre.setHighlightInInventory(true);
        this.chisel = new ItemRequirement("Chisel", 5601);
        this.chisel.setHighlightInInventory(true);
        this.bronzeWire = new ItemRequirement("Bronze Wire", 5602);
        this.bronzeWire.setHighlightInInventory(true);
        this.knife = new ItemRequirement("Knife", 5605);
        this.knife.setHighlightInInventory(true);
        this.bronzeKey = new ItemRequirement("Bronze Key", 5585);
    }

    private void setupConditions() {
        this.hasMagnet = new ItemRequirements(new ItemRequirement("Magnet", 5604));
        this.hasAceticAcid = new ItemRequirements(new ItemRequirement("Acetic Acid", 5578));
        this.hasOneVialOfLiquid = this.vialOfLiquid;
        this.hasCupricSulfate = this.cupricSulfate;
        this.hasGypsum = this.gypsum;
        this.hasSodiumChloride = new ItemRequirements(new ItemRequirement("Sodium Chloride", 5580));
        this.hasTin = this.tin;
        this.hasWire = this.bronzeWire;
        this.hasShears = new ItemRequirements(new ItemRequirement("Shears", 5603));
        this.hasChisel = this.chisel;
        this.hasNitrousOxide = new ItemRequirements(new ItemRequirement("Nitrous Oxide", 5581));
        this.hasTinOrePowder = this.tinOrePowder;
        this.hasCupricOrePowder = this.cupricOrePowder;
        this.hasKnife = this.knife;
        this.hasMetalSpade = this.metalSpade;
        this.hasMetalSpadeHead = this.metalSpadeHead;
        this.hasAshes = this.ashes;
        this.hasGypsumTin = this.gypsumTin;
        this.hasTinKeyPrint = this.tinKeyPrint;
        this.hasTinCupricOre = this.tinWithCupricOre;
        this.hasTinWithTinOre = this.tinWithTinOre;
        this.hasTinWithAllOre = this.tinWithAllOre;
        this.hasBronzeKey = this.bronzeKey;
        this.hasRetrievedThreeVials = new VarbitRequirement(679, 3);
        this.hasSpadeHeadOnDoor = new VarbitRequirement(686, 1);
        this.hasCupricSulfateOnDoor = new VarbitRequirement(687, 1);
        this.hasVialOfLiquidOnDoor = new VarbitRequirement(686, 2);
        this.hasFirstDoorOpen = new VarbitRequirement(686, 3);
        this.finishedRoom = new VarbitRequirement(664, 1);
        this.hasLiquidInTin = new VarbitRequirement(689, 1);
    }

    public ZoneRequirement getIsInMsCheeversRoom() {
        return this.isInMsCheeversRoom;
    }

    public ConditionalStep getConditionalStep() {
        return this.conditionalStep;
    }
}

