/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.recruitmentdrive;

import com.google.inject.Inject;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.steps.DetailedOwnerStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.runelite.api.Client;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.eventbus.Subscribe;

public class LadyTableStep
extends DetailedOwnerStep {
    @Inject
    protected Client client;
    private Statue[] statues;
    private final int VARBIT_FINISHED_ROOM = 660;
    private final int VARBIT_STATUE_ANSWER = 667;
    private ObjectStep clickMissingStatue;
    private ObjectStep leaveRoom;
    VarbitRequirement finishedRoom = new VarbitRequirement(660, 1);

    public LadyTableStep(QuestHelper questHelper, Requirement ... requirements) {
        super(questHelper, requirements);
    }

    @Override
    public void startUp() {
        super.startUp();
        Statue answerStatue = this.statues[this.client.getVarbitValue(667)];
        this.clickMissingStatue.setText("Click the " + answerStatue.text + " once it appears.");
        this.clickMissingStatue.setWorldPoint(answerStatue.point);
    }

    @Override
    @Subscribe
    public void onVarbitChanged(VarbitChanged varbitChanged) {
        super.onVarbitChanged(varbitChanged);
        Statue answerStatue = this.statues[this.client.getVarbitValue(667)];
        this.clickMissingStatue.setText("Click the " + answerStatue.text + " once it appears.");
        this.clickMissingStatue.setWorldPoint(answerStatue.point);
    }

    @Override
    public void setupSteps() {
        this.statues = new Statue[]{new Statue("Unknown", new WorldPoint(0, 0, 0)), new Statue("Bronze Halberd", new WorldPoint(2452, 4976, 0)), new Statue("Silver Halberd", new WorldPoint(2452, 4979, 0)), new Statue("Gold Halberd", new WorldPoint(2452, 4982, 0)), new Statue("Bronze 2H", new WorldPoint(2450, 4976, 0)), new Statue("Silver 2H", new WorldPoint(2450, 4979, 0)), new Statue("Gold 2H", new WorldPoint(2450, 4982, 0)), new Statue("Gold Mace", new WorldPoint(2456, 4982, 0)), new Statue("Silver Mace", new WorldPoint(2456, 4979, 0)), new Statue("Bronze mace", new WorldPoint(2456, 4976, 0)), new Statue("Bronze axe", new WorldPoint(2454, 4976, 0)), new Statue("Silver axe", new WorldPoint(2454, 4979, 0)), new Statue("Gold axe", new WorldPoint(2454, 4972, 0))};
        this.leaveRoom = new ObjectStep(this.questHelper, 7302, "Leave through the door to enter the portal and continue.", new Requirement[0]);
        this.clickMissingStatue = new ObjectStep(this.questHelper, 0, this.statues[0].point, "CLick the missing statue.", new Requirement[0]);
        this.clickMissingStatue.addAlternateObjects(7303, 7304, 7305, 7306, 7307, 7308, 7309, 7310, 7311, 7312, 7314);
    }

    @Override
    public Collection<QuestStep> getSteps() {
        ArrayList<QuestStep> step = new ArrayList<QuestStep>();
        step.add(this.clickMissingStatue);
        step.add(this.leaveRoom);
        return step;
    }

    @Override
    protected void updateSteps() {
        if (this.finishedRoom.check(this.client)) {
            this.startUpStep(this.leaveRoom);
        }
        this.startUpStep(this.clickMissingStatue);
    }

    public List<QuestStep> getPanelSteps() {
        ArrayList<QuestStep> steps = new ArrayList<QuestStep>();
        steps.add(this.clickMissingStatue);
        steps.add(this.leaveRoom);
        return steps;
    }

    static class Statue {
        private final String text;
        private final WorldPoint point;

        public Statue(String text, WorldPoint point) {
            this.text = text;
            this.point = point;
        }
    }
}

