/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.recruitmentdrive;

import com.questhelper.QuestHelperPlugin;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.steps.QuestStep;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.util.HashMap;
import java.util.Map;
import net.runelite.api.events.GameTick;
import net.runelite.api.widgets.Widget;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.ui.FontManager;

public class DoorPuzzle
extends QuestStep {
    private Character ENTRY_ONE;
    private Character ENTRY_TWO;
    private Character ENTRY_THREE;
    private Character ENTRY_FOUR;
    private final int SLOT_ONE = 43;
    private final int SLOT_TWO = 44;
    private final int SLOT_THREE = 45;
    private final int SLOT_FOUR = 46;
    private final int ARROW_ONE_LEFT = 47;
    private final int ARROW_ONE_RIGHT = 48;
    private final int ARROW_TWO_LEFT = 49;
    private final int ARROW_TWO_RIGHT = 50;
    private final int ARROW_THREE_LEFT = 51;
    private final int ARROW_THREE_RIGHT = 52;
    private final int ARROW_FOUR_LEFT = 53;
    private final int ARROW_FOUR_RIGHT = 54;
    private final int COMPLETE = 56;
    private final HashMap<Integer, Integer> highlightButtons = new HashMap();
    private final HashMap<Integer, Integer> distance = new HashMap();

    public DoorPuzzle(QuestHelper questHelper, String word) {
        super(questHelper, "Click the highlighted arrows to move the slots to the solution.");
        this.ENTRY_ONE = Character.valueOf(word.charAt(0));
        this.ENTRY_TWO = Character.valueOf(word.charAt(1));
        this.ENTRY_THREE = Character.valueOf(word.charAt(2));
        this.ENTRY_FOUR = Character.valueOf(word.charAt(3));
        this.highlightButtons.put(1, 48);
        this.highlightButtons.put(2, 50);
        this.highlightButtons.put(3, 52);
        this.highlightButtons.put(4, 54);
        this.distance.put(1, 0);
        this.distance.put(2, 0);
        this.distance.put(3, 0);
        this.distance.put(4, 0);
    }

    public void updateWord(String word) {
        this.ENTRY_ONE = Character.valueOf(word.charAt(0));
        this.ENTRY_TWO = Character.valueOf(word.charAt(1));
        this.ENTRY_THREE = Character.valueOf(word.charAt(2));
        this.ENTRY_FOUR = Character.valueOf(word.charAt(3));
        this.setText("Click the highlighted arrows to move the slots to the solution. The answer is " + word + ".");
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        this.updateSolvedPositionState();
    }

    private void updateSolvedPositionState() {
        this.highlightButtons.replace(1, this.matchStateToSolution(43, this.ENTRY_ONE, 48, 47));
        this.highlightButtons.replace(2, this.matchStateToSolution(44, this.ENTRY_TWO, 50, 49));
        this.highlightButtons.replace(3, this.matchStateToSolution(45, this.ENTRY_THREE, 52, 51));
        this.highlightButtons.replace(4, this.matchStateToSolution(46, this.ENTRY_FOUR, 54, 53));
        this.distance.replace(1, this.matchStateToDistance(43, this.ENTRY_ONE));
        this.distance.replace(2, this.matchStateToDistance(44, this.ENTRY_TWO));
        this.distance.replace(3, this.matchStateToDistance(45, this.ENTRY_THREE));
        this.distance.replace(4, this.matchStateToDistance(46, this.ENTRY_FOUR));
        if (this.highlightButtons.get(1) + this.highlightButtons.get(2) + this.highlightButtons.get(3) + this.highlightButtons.get(4) == 0) {
            this.highlightButtons.put(5, 56);
        } else {
            this.highlightButtons.put(5, 0);
        }
    }

    private int matchStateToSolution(int slot, Character target, int arrowRightId, int arrowLeftId) {
        int id;
        Widget widget = this.client.getWidget(285, slot);
        if (widget == null) {
            return 0;
        }
        char current = widget.getText().charAt(0);
        int currentPos = current - 65;
        int n = id = Math.floorMod(currentPos - target.charValue(), 26) < Math.floorMod(target.charValue() - currentPos, 26) ? arrowRightId : arrowLeftId;
        if (current != target.charValue()) {
            return id;
        }
        return 0;
    }

    private int matchStateToDistance(int slot, Character target) {
        Widget widget = this.client.getWidget(285, slot);
        if (widget == null) {
            return 0;
        }
        char current = widget.getText().charAt(0);
        return Math.min(Math.floorMod(current - target.charValue(), 26), Math.floorMod(target.charValue() - current, 26));
    }

    @Override
    public void makeWidgetOverlayHint(Graphics2D graphics, QuestHelperPlugin plugin) {
        super.makeWidgetOverlayHint(graphics, plugin);
        for (Map.Entry<Integer, Integer> entry : this.highlightButtons.entrySet()) {
            Widget widget;
            if (entry.getValue() == 0 || (widget = this.client.getWidget(285, entry.getValue().intValue())) == null) continue;
            graphics.setColor(new Color(this.questHelper.getConfig().targetOverlayColor().getRed(), this.questHelper.getConfig().targetOverlayColor().getGreen(), this.questHelper.getConfig().targetOverlayColor().getBlue(), 65));
            graphics.fill(widget.getBounds());
            graphics.setColor(this.questHelper.getConfig().targetOverlayColor());
            graphics.draw(widget.getBounds());
            if (this.distance.get(entry.getKey()) == null) continue;
            int widgetX = widget.getCanvasLocation().getX() + widget.getWidth() / 2 - 4;
            int widgetY = widget.getCanvasLocation().getY() + widget.getHeight() / 2 + 4;
            Font font = FontManager.getRunescapeFont().deriveFont(1, 16.0f);
            graphics.setFont(font);
            graphics.drawString(Integer.toString(this.distance.get(entry.getKey())), widgetX, widgetY);
        }
    }
}

