/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.recipefordisaster;

import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.questinfo.QuestVarbits;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.Client;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.RECIPE_FOR_DISASTER_START)
public class RFDStart
extends BasicQuestHelper {
    ItemRequirement eyeOfNewt;
    ItemRequirement greenmansAle;
    ItemRequirement rottenTomato;
    ItemRequirement fruitBlast;
    ItemRequirement ashes;
    ItemRequirement ashesHighlighted;
    ItemRequirement fruitBlastHighlighted;
    ItemRequirement dirtyBlast;
    QuestStep talkToCook;
    QuestStep useAshesOnFruitBlast;
    QuestStep talkToCookAgain;
    QuestStep enterDiningRoom;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToCook);
        ConditionalStep goGiveCookItems = new ConditionalStep((QuestHelper)this, this.useAshesOnFruitBlast, new Requirement[0]);
        goGiveCookItems.addStep(this.dirtyBlast.alsoCheckBank(this.questBank), this.talkToCookAgain);
        steps.put(1, goGiveCookItems);
        steps.put(2, this.enterDiningRoom);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.eyeOfNewt = new ItemRequirement("Eye of newt", 221);
        this.greenmansAle = new ItemRequirement("Greenman's ale", 1909);
        this.rottenTomato = new ItemRequirement("Rotten tomato", 2518);
        this.rottenTomato.setTooltip("You can buy one from the crate next to Toby in Varrock for 1gp");
        this.fruitBlast = new ItemRequirement("Fruit blast", 2084);
        this.ashes = new ItemRequirement("Ashes", 592);
        this.ashesHighlighted = new ItemRequirement("Ashes", 592);
        this.ashesHighlighted.setHighlightInInventory(true);
        this.fruitBlastHighlighted = new ItemRequirement("Fruit blast", 2084);
        this.fruitBlastHighlighted.setHighlightInInventory(true);
        this.dirtyBlast = new ItemRequirement("Dirty blast", 7497);
    }

    public void setupConditions() {
    }

    public void setupSteps() {
        this.talkToCook = new NpcStep((QuestHelper)this, 4626, new WorldPoint(3209, 3215, 0), "Talk to the Lumbridge Cook.", this.eyeOfNewt, this.greenmansAle, this.rottenTomato, this.ashes, this.fruitBlast);
        this.talkToCook.addDialogStep("Do you have any other quests for me?");
        this.talkToCook.addDialogSteps("Angry! It makes me angry!", "I don't really care to be honest.");
        this.talkToCook.addDialogStep("What seems to be the problem?");
        this.talkToCook.addDialogStep("YES");
        this.useAshesOnFruitBlast = new DetailedQuestStep((QuestHelper)this, "Use ashes on the fruit blast.", this.ashesHighlighted, this.fruitBlastHighlighted);
        this.talkToCookAgain = new NpcStep((QuestHelper)this, 4626, new WorldPoint(3209, 3215, 0), "Talk to the Lumbridge Cook with the required items.", this.eyeOfNewt, this.greenmansAle, this.rottenTomato, this.dirtyBlast);
        this.talkToCookAgain.addDialogStep("About those ingredients you wanted for the banquet...");
        this.enterDiningRoom = new ObjectStep((QuestHelper)this, 12348, new WorldPoint(3207, 3217, 0), "Enter the Lumbridge Castle dining room.", new Requirement[0]);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.eyeOfNewt, this.greenmansAle, this.rottenTomato, this.ashes, this.fruitBlast);
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new QuestRequirement(QuestHelperQuest.COOKS_ASSISTANT, QuestState.FINISHED));
        req.add(new SkillRequirement(Skill.COOKING, 10));
        return req;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Collections.singletonList(new UnlockReward("Access to the Culinaromancer's Chest"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Help the Cook", Arrays.asList(this.talkToCook, this.useAshesOnFruitBlast, this.talkToCookAgain, this.enterDiningRoom), this.eyeOfNewt, this.greenmansAle, this.rottenTomato, this.ashes, this.fruitBlast));
        return allSteps;
    }

    @Override
    public QuestState getState(Client client) {
        int questState = client.getVarbitValue(QuestVarbits.QUEST_RECIPE_FOR_DISASTER.getId());
        if (questState >= 3) {
            return QuestState.FINISHED;
        }
        return this.getQuest().getState(client, this.configManager);
    }

    @Override
    public boolean isCompleted() {
        return this.client.getVarbitValue(QuestVarbits.QUEST_RECIPE_FOR_DISASTER.getId()) >= 3;
    }
}

