/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.recipefordisaster;

import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.questinfo.QuestVarbits;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.conditional.NpcCondition;
import com.questhelper.requirements.conditional.ObjectCondition;
import com.questhelper.requirements.item.ItemOnTileRequirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.item.ItemRequirements;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.LogicHelper;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ItemStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.Client;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.RECIPE_FOR_DISASTER_SKRACH_UGLOGWEE)
public class RFDSkrachUglogwee
extends BasicQuestHelper {
    ItemRequirement rawJubbly;
    ItemRequirement cookedJubbly;
    ItemRequirement axeHighlighted;
    ItemRequirement ironSpit;
    ItemRequirement log;
    ItemRequirement tinderbox;
    ItemRequirement pickaxe;
    ItemRequirement ogreBellows;
    ItemRequirement ballOfWool;
    ItemRequirement ogreBowAndArrows;
    ItemRequirement ogreBow;
    ItemRequirement ogreArrows;
    ItemRequirement chompy;
    ItemRequirement chompySpitted;
    ItemRequirement ogreBellowsFilled;
    ItemRequirement toad;
    ItemRequirement toadReady;
    ItemRequirement rock;
    ItemRequirement cookedJubblyHighlighted;
    ItemRequirement feldipTeleport;
    ItemRequirement lumbridgeTeleport;
    ItemRequirement karamjaTeleport;
    Requirement inDiningRoom;
    Requirement jubblyNearby;
    Requirement jubblyCarcassNearby;
    Requirement rawJubblyOnFloor;
    Requirement hadBalloonToad;
    Requirement fireLit;
    DetailedQuestStep enterDiningRoom;
    DetailedQuestStep inspectSkrach;
    DetailedQuestStep talkToRantz;
    DetailedQuestStep talkToRantzOnCoast;
    DetailedQuestStep useAxeOnTree;
    DetailedQuestStep useAxeOnTreeAgain;
    DetailedQuestStep talkToRantzOnCoastAgain;
    DetailedQuestStep useSpitOnChompy;
    DetailedQuestStep lightFire;
    DetailedQuestStep cookChompy;
    DetailedQuestStep talkToRantzAfterReturn;
    DetailedQuestStep getToad;
    DetailedQuestStep getRock;
    DetailedQuestStep useBellowOnToadInInv;
    DetailedQuestStep dropBalloonToad;
    DetailedQuestStep killJubbly;
    DetailedQuestStep lootJubbly;
    DetailedQuestStep fillUpBellows;
    DetailedQuestStep cookJubbly;
    DetailedQuestStep enterDiningRoomAgain;
    DetailedQuestStep useJubblyOnSkrach;
    DetailedQuestStep pickUpRawJubbly;
    Zone diningRoom;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        ConditionalStep goInspectSkrach = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterDiningRoom, new Requirement[0]);
        goInspectSkrach.addStep(this.inDiningRoom, this.inspectSkrach);
        steps.put(0, goInspectSkrach);
        steps.put(10, this.talkToRantz);
        steps.put(20, this.talkToRantz);
        steps.put(30, this.talkToRantzOnCoast);
        steps.put(40, this.talkToRantzOnCoast);
        steps.put(50, this.useAxeOnTree);
        steps.put(60, this.useAxeOnTreeAgain);
        steps.put(70, this.talkToRantzOnCoastAgain);
        ConditionalStep getChildrenToKaramja = new ConditionalStep((QuestHelper)this, (QuestStep)this.useSpitOnChompy, new Requirement[0]);
        getChildrenToKaramja.addStep(LogicHelper.and(this.chompySpitted, this.fireLit), this.cookChompy);
        getChildrenToKaramja.addStep(this.chompySpitted, this.lightFire);
        steps.put(80, getChildrenToKaramja);
        steps.put(90, this.talkToRantzAfterReturn);
        steps.put(100, this.talkToRantzAfterReturn);
        ConditionalStep getJubbly = new ConditionalStep((QuestHelper)this, (QuestStep)this.fillUpBellows, new Requirement[0]);
        getJubbly.addStep(this.rawJubbly.alsoCheckBank(this.questBank), this.cookJubbly);
        getJubbly.addStep(this.rawJubblyOnFloor, this.pickUpRawJubbly);
        getJubbly.addStep(this.jubblyCarcassNearby, this.lootJubbly);
        getJubbly.addStep(this.jubblyNearby, this.killJubbly);
        getJubbly.addStep(this.hadBalloonToad, this.dropBalloonToad);
        getJubbly.addStep(new Conditions(this.toad, this.rock, this.ogreBellowsFilled), this.useBellowOnToadInInv);
        getJubbly.addStep(new Conditions(this.toad, this.ogreBellowsFilled), this.getRock);
        getJubbly.addStep(this.ogreBellowsFilled, this.getToad);
        steps.put(110, getJubbly);
        steps.put(120, getJubbly);
        steps.put(130, getJubbly);
        steps.put(140, getJubbly);
        steps.put(150, getJubbly);
        ConditionalStep saveSkrach = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterDiningRoomAgain, new Requirement[0]);
        saveSkrach.addStep(this.inDiningRoom, this.useJubblyOnSkrach);
        steps.put(160, saveSkrach);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.rawJubbly = new ItemRequirement("Raw jubbly", 7566).highlighted();
        this.cookedJubbly = new ItemRequirement("Cooked jubbly", 7568);
        this.cookedJubblyHighlighted = new ItemRequirement("Cooked jubbly", 7568).highlighted();
        this.axeHighlighted = new ItemRequirement("Any axe", ItemCollections.AXES).isNotConsumed().highlighted();
        this.ironSpit = new ItemRequirement("Iron spit", 7225).highlighted().isNotConsumed();
        this.log = new ItemRequirement("Any log to burn", ItemCollections.LOGS_FOR_FIRE);
        this.tinderbox = new ItemRequirement("Tinderbox", 590).isNotConsumed();
        this.pickaxe = new ItemRequirement("Any pickaxe", ItemCollections.PICKAXES).isNotConsumed();
        this.ogreBellows = new ItemRequirement("Ogre bellows", 2871).isNotConsumed();
        this.ogreBellows.addAlternates(2874, 2873, 2872);
        this.ogreBellowsFilled = new ItemRequirement("Ogre bellows", 2874).isNotConsumed();
        this.ogreBellowsFilled.addAlternates(2873, 2872);
        this.ogreBellowsFilled.setHighlightInInventory(true);
        this.ballOfWool = new ItemRequirement("Balls of wool", 1759);
        this.ogreBow = new ItemRequirement("Ogre bow", 2883).isNotConsumed();
        this.ogreBow.addAlternates(4827);
        this.ogreArrows = new ItemRequirement("Ogre arrow", 2866);
        this.ogreArrows.addAlternates(4773, 4778, 4783, 4788, 4793, 4798, 4803);
        this.ogreBowAndArrows = new ItemRequirements("Ogre bow + ogre arrows", this.ogreBow, this.ogreArrows);
        this.chompy = new ItemRequirement("Raw chompy", 2876);
        this.chompySpitted = new ItemRequirement("Skewered chompy", 7230);
        this.toad = new ItemRequirement("Bloated toad", 2875);
        this.toad.setHighlightInInventory(true);
        this.toadReady = new ItemRequirement("Balloon toad", 7564);
        this.rock = new ItemRequirement("Rock", 1480);
        this.rock.setHighlightInInventory(true);
        this.feldipTeleport = new ItemRequirement("Feldip teleport. Fairy Ring (AKS), Gnome Glider", 12404);
        this.feldipTeleport.addAlternates(ItemCollections.FAIRY_STAFF);
        this.lumbridgeTeleport = new ItemRequirement("Lumbridge teleport", 8008);
        this.karamjaTeleport = new ItemRequirement("Karamja teleport. Brimhaven Teleport tablet, Fairy Ring (CKR)", 11745);
        this.karamjaTeleport.addAlternates(ItemCollections.FAIRY_STAFF);
    }

    public void loadZones() {
        this.diningRoom = new Zone(new WorldPoint(1856, 5313, 0), new WorldPoint(1870, 5333, 0));
    }

    public void setupConditions() {
        this.inDiningRoom = new ZoneRequirement(this.diningRoom);
        this.hadBalloonToad = new Conditions(true, this.toadReady);
        this.jubblyNearby = new NpcCondition(4863);
        this.jubblyCarcassNearby = new NpcCondition(4864);
        this.rawJubblyOnFloor = new ItemOnTileRequirement(this.rawJubbly);
        this.fireLit = new ObjectCondition(26185, new Zone(new WorldPoint(2755, 3076, 0), new WorldPoint(2768, 3087, 0)));
    }

    public void setupSteps() {
        this.enterDiningRoom = new ObjectStep((QuestHelper)this, 12349, new WorldPoint(3213, 3221, 0), "Go inspect Skrach Uglogwee in Lumbridge Castle.", new Requirement[0]);
        this.enterDiningRoom.addTeleport(this.lumbridgeTeleport);
        this.inspectSkrach = new ObjectStep((QuestHelper)this, 12343, new WorldPoint(1864, 5329, 0), "Inspect Skrach Uglogwee.", new Requirement[0]);
        this.inspectSkrach.addDialogSteps("Yes, I'm sure I can get some Jubbly Chompy.", "Oh Ok then, I guess I'll talk to Rantz.");
        this.inspectSkrach.addSubSteps(this.enterDiningRoom);
        this.talkToRantz = new NpcStep((QuestHelper)this, 1470, new WorldPoint(2630, 2984, 0), "Talk to Rantz in Feldip Hills.", new Requirement[0]);
        this.talkToRantz.addDialogSteps("I'm trying to free Skrach, can you help?", "Ok, I'll do it.");
        this.talkToRantz.addTeleport(this.feldipTeleport);
        this.talkToRantzOnCoast = new NpcStep((QuestHelper)this, 4855, new WorldPoint(2649, 2964, 0), "Talk to Rantz on the east coast of Feldip Hills.", new Requirement[0]);
        this.talkToRantzOnCoast.addDialogStep("Ok, here I am...I guess this is the watery place? What now?");
        this.useAxeOnTree = new ObjectStep((QuestHelper)this, 12549, new WorldPoint(2655, 2963, 0), "Use an axe on the old tree near Rantz.", this.axeHighlighted);
        this.useAxeOnTree.addIcon(1359);
        this.useAxeOnTreeAgain = new ObjectStep((QuestHelper)this, 12549, new WorldPoint(2655, 2963, 0), "Use an axe on the old tree near Rantz again.", this.axeHighlighted);
        this.useAxeOnTreeAgain.addIcon(1359);
        this.talkToRantzOnCoastAgain = new NpcStep((QuestHelper)this, 4855, new WorldPoint(2649, 2964, 0), "Talk to Rantz again on the east coast of Feldip Hills.", new Requirement[0]);
        this.talkToRantzOnCoastAgain.addDialogStep("Ok, the boat's ready, now tell me how to get a Jubbly?");
        this.useSpitOnChompy = new DetailedQuestStep((QuestHelper)this, "Use an iron spit on a chompy.", this.ironSpit.highlighted(), this.chompy.highlighted());
        this.lightFire = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2760, 3080, 0), "Light a fire on karamja's west coast. Afterwards, use your skewered chompy on it.", this.log.highlighted(), this.tinderbox.highlighted(), this.chompySpitted);
        this.lightFire.addIcon(1511);
        this.lightFire.addTeleport(this.karamjaTeleport);
        this.cookChompy = new ObjectStep((QuestHelper)this, 26185, "Cook the skewered chompy on the fire.", this.chompySpitted.highlighted());
        this.cookChompy.addIcon(7230);
        this.lightFire.addSubSteps(this.cookChompy);
        this.talkToRantzAfterReturn = new NpcStep((QuestHelper)this, 4855, new WorldPoint(2649, 2964, 0), "Travel back with Rantz's kids and talk to Rantz again.", new Requirement[0]);
        this.talkToRantzAfterReturn.addDialogSteps("Yes please, I'll get a lift back with you.", "Ok, now tell me how to get Jubbly!");
        this.fillUpBellows = new ObjectStep((QuestHelper)this, 684, new WorldPoint(2601, 2967, 0), "Fill some ogre bellows on some swamp bubbles.", this.ogreBellows);
        this.getToad = new NpcStep((QuestHelper)this, 1473, new WorldPoint(2601, 2967, 0), "Blow up a toad with the bellows.", this.ogreBellowsFilled);
        this.getToad.addSubSteps(this.fillUpBellows);
        this.getRock = new ObjectStep((QuestHelper)this, 12564, new WorldPoint(2567, 2960, 0), "Mine a pile of rocks near the Feldip Hills Fairy Ring for a rock.", this.pickaxe);
        this.useBellowOnToadInInv = new DetailedQuestStep((QuestHelper)this, "Use the bellows on your toad with a ball of wool in your inventory.", this.ogreBellowsFilled, this.toad, this.ballOfWool);
        this.dropBalloonToad = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2593, 2964, 0), "Drop the balloon toad near a swamp and wait for a Jubbly to arrive.", this.toadReady, this.ogreBowAndArrows);
        this.killJubbly = new NpcStep((QuestHelper)this, 4863, "Kill then pluck jubbly.", this.ogreBowAndArrows);
        this.pickUpRawJubbly = new ItemStep((QuestHelper)this, "Pick up the raw jubbly.", this.rawJubbly);
        this.lootJubbly = new NpcStep((QuestHelper)this, 4864, "Pluck the jubbly's carcass.", new Requirement[0]);
        this.cookJubbly = new ObjectStep((QuestHelper)this, 6895, new WorldPoint(2631, 2990, 0), "Cook the raw jubbly on Rantz's spit.", this.rawJubbly);
        this.cookJubbly.addIcon(7566);
        this.enterDiningRoomAgain = new ObjectStep((QuestHelper)this, 12348, new WorldPoint(3207, 3217, 0), "Go give the jubbly to Skrach Uglogwee to finish the quest.", this.cookedJubbly);
        this.enterDiningRoomAgain.addTeleport(this.lumbridgeTeleport);
        this.useJubblyOnSkrach = new ObjectStep((QuestHelper)this, 12343, new WorldPoint(1864, 5329, 0), "Give the jubbly to Skrach Uglogwee to finish the quest.", this.cookedJubblyHighlighted);
        this.useJubblyOnSkrach.addIcon(7568);
        this.useJubblyOnSkrach.addSubSteps(this.enterDiningRoomAgain);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.axeHighlighted, this.chompy, this.ironSpit, this.log, this.tinderbox, this.pickaxe, this.ogreBellows, this.ballOfWool, this.ogreBowAndArrows);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.lumbridgeTeleport.quantity(2), this.feldipTeleport, this.karamjaTeleport);
    }

    @Override
    public List<String> getCombatRequirements() {
        return Collections.singletonList("Jubbly (level 9)");
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new SkillRequirement(Skill.COOKING, 41, true));
        req.add(new SkillRequirement(Skill.FIREMAKING, 20, true));
        req.add(new QuestRequirement(QuestHelperQuest.BIG_CHOMPY_BIRD_HUNTING, QuestState.FINISHED));
        return req;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Arrays.asList(new ExperienceReward(Skill.WOODCUTTING, 1500), new ExperienceReward(Skill.COOKING, 1500), new ExperienceReward(Skill.CRAFTING, 1500), new ExperienceReward(Skill.RANGED, 1500));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("New method of travel between Karamja and Feldip Hills."), new UnlockReward("Increased access to the Culinaromancer's Chest."));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting off", Collections.singletonList(this.inspectSkrach), Collections.singletonList(this.lumbridgeTeleport)));
        allSteps.add(new PanelDetails("Help Rantz", Arrays.asList(this.talkToRantz, this.talkToRantzOnCoast, this.useAxeOnTree, this.useAxeOnTreeAgain, this.talkToRantzOnCoastAgain, this.useSpitOnChompy, this.lightFire, this.talkToRantzAfterReturn), Arrays.asList(this.axeHighlighted, this.log, this.tinderbox, this.chompy, this.ironSpit, this.ogreBowAndArrows, this.pickaxe, this.ogreBellows, this.ballOfWool), Arrays.asList(this.feldipTeleport, this.karamjaTeleport, this.lumbridgeTeleport)));
        allSteps.add(new PanelDetails("Save Skrach", Arrays.asList(this.getToad, this.getRock, this.useBellowOnToadInInv, this.dropBalloonToad, this.killJubbly, this.lootJubbly, this.pickUpRawJubbly, this.cookJubbly, this.useJubblyOnSkrach), Arrays.asList(this.ogreBowAndArrows, this.pickaxe, this.ogreBellows, this.ballOfWool), Collections.singletonList(this.lumbridgeTeleport)));
        return allSteps;
    }

    @Override
    public QuestState getState(Client client) {
        int questState = client.getVarbitValue(QuestVarbits.QUEST_RECIPE_FOR_DISASTER_SKRACH_UGLOGWEE.getId());
        if (questState == 0) {
            return QuestState.NOT_STARTED;
        }
        if (questState < 170) {
            return QuestState.IN_PROGRESS;
        }
        return QuestState.FINISHED;
    }

    @Override
    public boolean isCompleted() {
        return this.client.getVarbitValue(QuestVarbits.QUEST_RECIPE_FOR_DISASTER_SKRACH_UGLOGWEE.getId()) >= 170 || this.client.getVarbitValue(QuestVarbits.QUEST_RECIPE_FOR_DISASTER.getId()) < 3;
    }
}

