/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.recipefordisaster;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.questinfo.QuestVarPlayer;
import com.questhelper.questinfo.QuestVarbits;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemOnTileRequirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.item.ItemRequirements;
import com.questhelper.requirements.quest.QuestPointRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.util.Operation;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.var.VarplayerRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ItemStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Player;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.RECIPE_FOR_DISASTER_SIR_AMIK_VARZE)
public class RFDSirAmikVarze
extends BasicQuestHelper {
    ItemRequirement combatGear;
    ItemRequirement bucketOfMilk;
    ItemRequirement potOfCream;
    ItemRequirement cornflour;
    ItemRequirement pot;
    ItemRequirement sweetcorn;
    ItemRequirement axe;
    ItemRequirement macheteAndRadimus;
    ItemRequirement machete;
    ItemRequirement vanillaPod;
    ItemRequirement dramenStaffOrLunar;
    ItemRequirement dramenBranch;
    ItemRequirement pestleAndMortar;
    ItemRequirement iceGloves;
    ItemRequirement rawChicken;
    ItemRequirement antidragonShield;
    ItemRequirement antifirePotion;
    ItemRequirement radimusNotes;
    ItemRequirement bruleeWithEgg;
    ItemRequirement baseBrulee;
    ItemRequirement uncookedBrulee;
    ItemRequirement finishedBrulee;
    ItemRequirement finishedBruleeHighlighted;
    ItemRequirement milkyMixture;
    ItemRequirement cornflourMixture;
    ItemRequirement evilEgg;
    ItemRequirement token;
    ItemRequirement cinnamon;
    ItemRequirement pestleAndMortarHighlighted;
    ItemRequirement tokenHighlighted;
    ItemRequirement draynorVillageTele;
    ItemRequirement lumbridgeTele;
    Requirement inDiningRoom;
    Requirement talkedToWom;
    Requirement inEvilChickenLair;
    Requirement inZanaris;
    Requirement inDraynorVillage;
    Requirement hasEggAndToken;
    Requirement tokenNearby;
    Requirement eggNearby;
    QuestStep enterDiningRoom;
    QuestStep inspectAmik;
    QuestStep enterKitchen;
    QuestStep talkToCook;
    QuestStep enterDiningRoomAgain;
    QuestStep useBruleeOnVarze;
    QuestStep talkToWom;
    QuestStep useMilkOnCream;
    QuestStep useCornflourOnMilky;
    QuestStep addPodToCornflourMixture;
    QuestStep enterZanaris;
    QuestStep useChickenOnShrine;
    QuestStep killEvilChicken;
    QuestStep pickUpEgg;
    QuestStep useEggOnBrulee;
    QuestStep killBlackDragon;
    QuestStep pickUpToken;
    QuestStep grindBranch;
    QuestStep useCinnamonOnBrulee;
    QuestStep rubToken;
    ConditionalStep tokenAndEggSteps;
    Zone diningRoom;
    Zone zanaris;
    Zone evilChickenLair;
    Zone draynorVillage;
    int evilChickenLevel = 19;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        this.calculateEvilChickenLevel();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        ConditionalStep goInspectPete = new ConditionalStep((QuestHelper)this, this.enterDiningRoom, new Requirement[0]);
        goInspectPete.addStep(this.inDiningRoom, this.inspectAmik);
        steps.put(0, goInspectPete);
        ConditionalStep goAskCook = new ConditionalStep((QuestHelper)this, this.talkToCook, new Requirement[0]);
        goAskCook.addStep(this.inDiningRoom, this.enterKitchen);
        steps.put(5, goAskCook);
        this.tokenAndEggSteps = new ConditionalStep((QuestHelper)this, this.enterZanaris, new Requirement[0]);
        this.tokenAndEggSteps.addStep(this.tokenNearby, this.pickUpToken);
        this.tokenAndEggSteps.addStep(new Conditions(this.evilEgg.alsoCheckBank(this.questBank), this.inEvilChickenLair), this.killBlackDragon);
        this.tokenAndEggSteps.addStep(this.eggNearby, this.pickUpEgg);
        this.tokenAndEggSteps.addStep(this.inEvilChickenLair, this.killEvilChicken);
        this.tokenAndEggSteps.addStep(this.inZanaris, this.useChickenOnShrine);
        this.tokenAndEggSteps.setLockingCondition(this.hasEggAndToken);
        this.tokenAndEggSteps.setBlocker(true);
        ConditionalStep makeBrulee = new ConditionalStep((QuestHelper)this, this.useMilkOnCream, new Requirement[0]);
        makeBrulee.addStep(new Conditions(this.uncookedBrulee), this.rubToken);
        makeBrulee.addStep(new Conditions(this.bruleeWithEgg, this.cinnamon), this.useCinnamonOnBrulee);
        makeBrulee.addStep(this.bruleeWithEgg, this.grindBranch);
        makeBrulee.addStep(this.baseBrulee, this.useEggOnBrulee);
        makeBrulee.addStep(this.cornflourMixture, this.addPodToCornflourMixture);
        makeBrulee.addStep(this.milkyMixture, this.useCornflourOnMilky);
        ConditionalStep saveAmik = new ConditionalStep((QuestHelper)this, this.talkToWom, new Requirement[0]);
        saveAmik.addStep(new Conditions(this.inDiningRoom, this.finishedBrulee), this.useBruleeOnVarze);
        saveAmik.addStep(this.finishedBrulee.alsoCheckBank(this.questBank), this.enterDiningRoomAgain);
        saveAmik.addStep(this.hasEggAndToken, makeBrulee);
        saveAmik.addStep(this.talkedToWom, this.tokenAndEggSteps);
        steps.put(10, saveAmik);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.bucketOfMilk = new ItemRequirement("Bucket of milk", 1927);
        this.bucketOfMilk.setHighlightInInventory(true);
        this.potOfCream = new ItemRequirement("Pot of cream", 2130);
        this.potOfCream.setHighlightInInventory(true);
        this.cornflour = new ItemRequirement("Pot of cornflour", 7468);
        this.cornflour.setTooltip("You can make this by grinding a sweetcorn in a windmill and collecting it with a pot");
        this.cornflour.setHighlightInInventory(true);
        this.pot = new ItemRequirement("Pot", 1931);
        this.sweetcorn = new ItemRequirement("Sweetcorn", 5986);
        this.axe = new ItemRequirement("Any axe", ItemCollections.AXES).isNotConsumed();
        this.machete = new ItemRequirement("Any machete", ItemCollections.MACHETE).isNotConsumed();
        this.radimusNotes = new ItemRequirement("Radimus notes", 714).isNotConsumed();
        this.radimusNotes.addAlternates(715);
        this.macheteAndRadimus = this.client.getGameState() == GameState.LOGGED_IN && QuestHelperQuest.LEGENDS_QUEST.getState(this.client, this.configManager) == QuestState.FINISHED ? this.machete : new ItemRequirements("Machete and Radimus notes", this.machete, this.radimusNotes);
        this.vanillaPod = new ItemRequirement("Vanilla pod", 7465);
        this.vanillaPod.setTooltip("You can get a pod from the Kharazi Jungle. Bring an axe and machete to get in");
        this.vanillaPod.setHighlightInInventory(true);
        this.dramenStaffOrLunar = new ItemRequirement("Dramen/lunar staff", 772, 1, true).isNotConsumed();
        this.dramenStaffOrLunar.addAlternates(9084);
        this.dramenStaffOrLunar.setDisplayMatchedItemName(true);
        this.dramenBranch = new ItemRequirement("Dramen branch", 771);
        this.dramenBranch.setHighlightInInventory(true);
        this.dramenBranch.setTooltip("You can get one from the dramen tree under Entrana");
        this.pestleAndMortar = new ItemRequirement("Pestle and mortar", 233).isNotConsumed();
        this.pestleAndMortarHighlighted = this.pestleAndMortar.highlighted();
        this.iceGloves = new ItemRequirement("Ice gloves or smiths gloves(i)", 1580).equipped().isNotConsumed();
        this.iceGloves.addAlternates(27031);
        this.iceGloves.setTooltip("Although optional, you'll take a lot of damage if you're not wearing them");
        this.rawChicken = new ItemRequirement("Raw chicken", 2138);
        this.rawChicken.setHighlightInInventory(true);
        this.antidragonShield = new ItemRequirement("Anti-dragon shield", ItemCollections.ANTIFIRE_SHIELDS).isNotConsumed();
        this.antifirePotion = new ItemRequirement("Antifire potion", ItemCollections.ANTIFIRE);
        this.combatGear = new ItemRequirement("Combat gear", -1, -1).isNotConsumed();
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.draynorVillageTele = new ItemRequirement("Draynor Village teleport", ItemCollections.AMULET_OF_GLORIES, 1);
        this.draynorVillageTele.setChargedItem(true);
        this.draynorVillageTele.showConditioned(new Conditions(LogicType.NOR, this.inDraynorVillage));
        this.lumbridgeTele = new ItemRequirement("Lumbridge Teleport", 8008, 1);
        this.milkyMixture = new ItemRequirement("Milky mixture", 7471);
        this.milkyMixture.setHighlightInInventory(true);
        this.cornflourMixture = new ItemRequirement("Cornflour mixture", 7470);
        this.cornflourMixture.setHighlightInInventory(true);
        this.bruleeWithEgg = new ItemRequirement("Brulee", 7473);
        this.bruleeWithEgg.setHighlightInInventory(true);
        this.baseBrulee = new ItemRequirement("Brulee", 7474);
        this.baseBrulee.setHighlightInInventory(true);
        this.uncookedBrulee = new ItemRequirement("Brulee", 7475);
        this.finishedBrulee = new ItemRequirement("Brulee supreme", 7476);
        this.finishedBruleeHighlighted = new ItemRequirement("Brulee supreme", 7476);
        this.finishedBruleeHighlighted.setHighlightInInventory(true);
        this.cinnamon = new ItemRequirement("Cinnamon", 7472);
        this.cinnamon.setHighlightInInventory(true);
        this.evilEgg = new ItemRequirement("Evil chickens egg", 7477);
        this.evilEgg.addAlternates(7473, 7475);
        this.evilEgg.setHighlightInInventory(true);
        this.token = new ItemRequirement("Dragon token", 7478);
        this.token.addAlternates(7476);
        this.tokenHighlighted = new ItemRequirement("Dragon token", 7478);
        this.tokenHighlighted.setHighlightInInventory(true);
    }

    public void loadZones() {
        this.diningRoom = new Zone(new WorldPoint(1856, 5313, 0), new WorldPoint(1870, 5333, 0));
        this.zanaris = new Zone(new WorldPoint(2368, 4353, 0), new WorldPoint(2495, 4479, 0));
        this.evilChickenLair = new Zone(new WorldPoint(2430, 4355, 0), new WorldPoint(2492, 4407, 0));
        this.draynorVillage = new Zone(new WorldPoint(3060, 3221, 0), new WorldPoint(3121, 3283, 0));
    }

    public void setupConditions() {
        this.inDiningRoom = new ZoneRequirement(this.diningRoom);
        this.talkedToWom = new VarbitRequirement(1919, 1, Operation.GREATER_EQUAL);
        this.inEvilChickenLair = new ZoneRequirement(this.evilChickenLair);
        this.inDraynorVillage = new ZoneRequirement(this.draynorVillage);
        this.inZanaris = new ZoneRequirement(this.zanaris);
        this.hasEggAndToken = new Conditions(this.evilEgg, this.token);
        this.tokenNearby = new ItemOnTileRequirement(this.token);
        this.eggNearby = new ItemOnTileRequirement(this.evilEgg);
    }

    public void setupSteps() {
        this.enterDiningRoom = new ObjectStep((QuestHelper)this, 12349, new WorldPoint(3213, 3221, 0), "Go inspect Sir Amik Varze in Lumbridge Castle.", new Requirement[0]);
        this.inspectAmik = new ObjectStep((QuestHelper)this, 12345, new WorldPoint(1865, 5321, 0), "Inspect Sir Amik Varze.", new Requirement[0]);
        this.inspectAmik.addSubSteps(this.enterDiningRoom);
        this.enterKitchen = new ObjectStep((QuestHelper)this, 12351, new WorldPoint(1861, 5316, 0), "Talk to the Lumbridge Cook.", new Requirement[0]);
        this.talkToCook = new NpcStep((QuestHelper)this, 4626, new WorldPoint(3209, 3215, 0), "Talk to the Lumbridge Cook and ask him all the options about Sir Amik Varze.", new Requirement[0]);
        this.talkToCook.addDialogSteps("More...", "Protecting Sir Amik Varze");
        this.talkToCook.addSubSteps(this.enterKitchen);
        this.talkToWom = new NpcStep((QuestHelper)this, 2108, new WorldPoint(3088, 3255, 0), "Talk to the Wise Old Man in Draynor Village about strange beasts and the Evil Chicken.", new Requirement[0]);
        ((NpcStep)this.talkToWom).addTeleport(this.draynorVillageTele.quantity(1).named("Amulet of glory (Draynor Village [3])"));
        this.talkToWom.addDialogSteps("Draynor Village", "I'd just like to ask you something.", "Strange beasts", "The Evil Chicken");
        this.useMilkOnCream = new DetailedQuestStep((QuestHelper)this, "Use a bucket of milk on a pot of cream.", this.bucketOfMilk, this.potOfCream);
        this.useCornflourOnMilky = new DetailedQuestStep((QuestHelper)this, "Use cornflour on the milky mixture.", this.cornflour, this.milkyMixture);
        this.addPodToCornflourMixture = new DetailedQuestStep((QuestHelper)this, "Add a vanilla pod to the cornflour mixture.", this.vanillaPod, this.cornflourMixture);
        this.enterZanaris = new DetailedQuestStep((QuestHelper)this, "Travel to Zanaris.", this.dramenStaffOrLunar);
        this.useChickenOnShrine = new ObjectStep((QuestHelper)this, 12093, new WorldPoint(2453, 4477, 0), "Use a raw chicken on the Chicken Shrine in the north east of Zanaris.", this.rawChicken, this.combatGear);
        this.useChickenOnShrine.addIcon(2138);
        this.killEvilChicken = new NpcStep((QuestHelper)this, 1870, new WorldPoint(2455, 4399, 0), "Kill the Evil Chicken in the north of the range. Pray protect from magic against it.", new Requirement[0]);
        this.pickUpEgg = new ItemStep((QuestHelper)this, "Pick up the evil chicken egg.", this.evilEgg);
        this.useEggOnBrulee = new DetailedQuestStep((QuestHelper)this, "Use the evil chickens egg on the brulee.", this.evilEgg, this.baseBrulee, this.pestleAndMortar);
        this.killBlackDragon = new NpcStep((QuestHelper)this, 252, new WorldPoint(2461, 4367, 0), "Kill a black dragon.", this.combatGear, this.antidragonShield);
        this.pickUpToken = new ItemStep((QuestHelper)this, "Pick up the dragon token.", this.token);
        this.grindBranch = new DetailedQuestStep((QuestHelper)this, "Use a pestle and mortar on the dramen branch.", this.pestleAndMortarHighlighted, this.dramenBranch);
        this.useCinnamonOnBrulee = new DetailedQuestStep((QuestHelper)this, "Use the cinnamon on the brulee.", this.cinnamon, this.bruleeWithEgg);
        this.rubToken = new DetailedQuestStep((QuestHelper)this, "Equip your Ice Gloves and rub the dragon token in Lumbridge or Zanaris. Ask the fairy dragon to cook your brulee.", this.tokenHighlighted, this.uncookedBrulee, this.iceGloves);
        this.rubToken.addDialogStep("Please flambe this creme brulee for me.");
        this.enterDiningRoomAgain = new ObjectStep((QuestHelper)this, 12348, new WorldPoint(3207, 3217, 0), "Go give the Brulee to Sir Amik Varze to finish the quest.", this.finishedBrulee);
        ((ObjectStep)this.enterDiningRoomAgain).addTeleport(this.lumbridgeTele);
        this.useBruleeOnVarze = new ObjectStep((QuestHelper)this, 12345, new WorldPoint(1865, 5321, 0), "Give the Brulee to Sir Amik Varze to finish the quest.", this.finishedBruleeHighlighted);
        this.useBruleeOnVarze.addIcon(7476);
        this.useBruleeOnVarze.addSubSteps(this.enterDiningRoomAgain);
    }

    private void calculateEvilChickenLevel() {
        Player player = this.client.getLocalPlayer();
        if (player == null) {
            return;
        }
        int combatLevel = player.getCombatLevel();
        this.evilChickenLevel = combatLevel <= 10 ? 19 : (combatLevel <= 20 ? 38 : (combatLevel <= 40 ? 69 : (combatLevel <= 60 ? 81 : (combatLevel <= 90 ? 121 : 159))));
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.axe, this.macheteAndRadimus, this.dramenStaffOrLunar, this.rawChicken, this.bucketOfMilk, this.potOfCream, this.cornflour, this.dramenBranch, this.vanillaPod, this.pestleAndMortar, this.iceGloves);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.combatGear, this.antidragonShield, this.antifirePotion, this.draynorVillageTele, this.lumbridgeTele);
    }

    @Override
    public List<String> getCombatRequirements() {
        return Arrays.asList("Evil Chicken (level " + this.evilChickenLevel + ")", "Black dragon (level 227) (Can be safespotted)");
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new QuestPointRequirement(107));
        req.add(new VarplayerRequirement(QuestVarPlayer.QUEST_LEGENDS_QUEST.getId(), 1, Operation.GREATER_EQUAL, "Started Legends' Quest to access the Kharazi Jungle"));
        req.add(new QuestRequirement(QuestHelperQuest.FAMILY_CREST, QuestState.FINISHED));
        req.add(new QuestRequirement(QuestHelperQuest.HEROES_QUEST, QuestState.FINISHED));
        req.add(new QuestRequirement(QuestHelperQuest.SHILO_VILLAGE, QuestState.FINISHED));
        req.add(new QuestRequirement(QuestHelperQuest.UNDERGROUND_PASS, QuestState.FINISHED));
        req.add(new QuestRequirement(QuestHelperQuest.WATERFALL_QUEST, QuestState.FINISHED));
        return req;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Arrays.asList(new ExperienceReward(Skill.COOKING, 4000), new ExperienceReward(Skill.HITPOINTS, 4000));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("Access to the Evil Chickens Lair"), new UnlockReward("Further access to the Culinaromancer's Chest"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting off", Arrays.asList(this.inspectAmik, this.talkToCook, this.talkToWom), null, Arrays.asList(this.draynorVillageTele.quantity(1))));
        PanelDetails tokenAndEggPanel = new PanelDetails("Get token and egg", Arrays.asList(this.enterZanaris, this.useChickenOnShrine, this.killEvilChicken, this.pickUpEgg, this.killBlackDragon, this.pickUpToken), this.dramenStaffOrLunar, this.rawChicken, this.combatGear, this.antidragonShield, this.antifirePotion);
        tokenAndEggPanel.setLockingStep(this.tokenAndEggSteps);
        allSteps.add(tokenAndEggPanel);
        allSteps.add(new PanelDetails("Making the brulee", Arrays.asList(this.useMilkOnCream, this.useCornflourOnMilky, this.addPodToCornflourMixture, this.useEggOnBrulee, this.grindBranch, this.useCinnamonOnBrulee, this.rubToken, this.useBruleeOnVarze), Arrays.asList(this.bucketOfMilk, this.potOfCream, this.cornflourMixture, this.pestleAndMortar, this.dramenBranch, this.vanillaPod, this.evilEgg, this.token, this.iceGloves), Arrays.asList(this.lumbridgeTele)));
        return allSteps;
    }

    @Override
    public QuestState getState(Client client) {
        int questState = client.getVarbitValue(QuestVarbits.QUEST_RECIPE_FOR_DISASTER_SIR_AMIK_VARZE.getId());
        if (questState == 0) {
            return QuestState.NOT_STARTED;
        }
        if (questState < 20) {
            return QuestState.IN_PROGRESS;
        }
        return QuestState.FINISHED;
    }

    @Override
    public boolean isCompleted() {
        return this.client.getVarbitValue(QuestVarbits.QUEST_RECIPE_FOR_DISASTER_SIR_AMIK_VARZE.getId()) >= 20 || this.client.getVarbitValue(QuestVarbits.QUEST_RECIPE_FOR_DISASTER.getId()) < 3;
    }
}

