/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.recipefordisaster;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.helpers.quests.recipefordisaster.AskAboutFishCake;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.questinfo.QuestVarbits;
import com.questhelper.requirements.ComplexRequirement;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.player.WeightRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.util.Operation;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import com.questhelper.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.Client;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.RECIPE_FOR_DISASTER_PIRATE_PETE)
public class RFDPiratePete
extends BasicQuestHelper {
    ItemRequirement combatGear;
    ItemRequirement pestleHighlighted;
    ItemRequirement rawCodHighlighted;
    ItemRequirement knifeHighlighted;
    ItemRequirement breadHighlighted;
    ItemRequirement divingAparatus;
    ItemRequirement divingHelmet;
    ItemRequirement fishBowl;
    ItemRequirement bronzeWire3;
    ItemRequirement needle;
    ItemRequirement fishCake;
    ItemRequirement fishCakeHighlighted;
    ItemRequirement rocks5;
    ItemRequirement mudskipperHide5;
    ItemRequirement crabMeat;
    ItemRequirement kelp;
    ItemRequirement groundKelpHighlighted;
    ItemRequirement groundCrabMeatHighlighted;
    ItemRequirement kelpHighlighted;
    ItemRequirement crabMeatHighlighted;
    ItemRequirement rawFishCake;
    ItemRequirement groundCod;
    ItemRequirement breadcrumbs;
    WeightRequirement canSwim;
    Requirement inDiningRoom;
    Requirement askedCookOptions;
    Requirement inUnderWater;
    Requirement hasEnoughRocks;
    Requirement hasCrabMeat;
    Requirement hasKelp;
    Requirement walkingUnderwater;
    QuestStep enterDiningRoom;
    QuestStep inspectPete;
    QuestStep enterKitchen;
    QuestStep usePestleOnCod;
    QuestStep useKnifeOnBread;
    QuestStep talkToMurphy;
    QuestStep talkToMurphyAgain;
    QuestStep goDiving;
    QuestStep pickKelp;
    QuestStep talkToNung;
    QuestStep pickUpRocks;
    QuestStep enterCave;
    QuestStep killMudksippers5;
    QuestStep returnToNung;
    QuestStep talkToNungAgain;
    QuestStep giveNungWire;
    QuestStep killCrab;
    QuestStep grindKelp;
    QuestStep grindCrab;
    QuestStep climbAnchor;
    QuestStep talkToCookAgain;
    QuestStep useCrabOnKelp;
    QuestStep cookCake;
    QuestStep enterDiningRoomAgain;
    QuestStep useCakeOnPete;
    QuestStep goDivingAgain;
    QuestStep pickUpRocksAgain;
    AskAboutFishCake talkToCook;
    Zone diningRoom;
    Zone underwater;
    ArrayList<Requirement> generalReqs;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        ConditionalStep goInspectPete = new ConditionalStep((QuestHelper)this, this.enterDiningRoom, new Requirement[0]);
        goInspectPete.addStep(this.inDiningRoom, this.inspectPete);
        steps.put(0, goInspectPete);
        ConditionalStep goTalkToCook = new ConditionalStep((QuestHelper)this, (QuestStep)this.talkToCook, new Requirement[0]);
        goTalkToCook.addStep(this.askedCookOptions, this.talkToMurphy);
        steps.put(10, goTalkToCook);
        steps.put(20, goTalkToCook);
        steps.put(30, this.talkToMurphyAgain);
        ConditionalStep goTalkToNung = new ConditionalStep((QuestHelper)this, this.goDiving, new Requirement[0]);
        goTalkToNung.addStep(new Conditions(this.hasKelp, this.inUnderWater), this.talkToNung);
        goTalkToNung.addStep(this.inUnderWater, this.pickKelp);
        steps.put(40, goTalkToNung);
        ConditionalStep goGetHides = new ConditionalStep((QuestHelper)this, this.goDiving, new Requirement[0]);
        goGetHides.addStep(new Conditions(this.hasKelp, this.inUnderWater, this.mudskipperHide5), this.returnToNung);
        goGetHides.addStep(new Conditions(this.hasKelp, this.inUnderWater, this.walkingUnderwater), this.killMudksippers5);
        goGetHides.addStep(new Conditions(this.hasKelp, this.inUnderWater, this.hasEnoughRocks), this.enterCave);
        goGetHides.addStep(new Conditions(this.hasKelp, this.inUnderWater), this.pickUpRocks);
        goGetHides.addStep(this.inUnderWater, this.pickKelp);
        steps.put(50, goGetHides);
        ConditionalStep goTalkToNungAgain = new ConditionalStep((QuestHelper)this, this.goDiving, new Requirement[0]);
        goTalkToNungAgain.addStep(new Conditions(this.hasKelp, this.inUnderWater), this.talkToNungAgain);
        goTalkToNungAgain.addStep(this.inUnderWater, this.pickKelp);
        steps.put(60, goTalkToNungAgain);
        ConditionalStep goBringNungWire = new ConditionalStep((QuestHelper)this, this.goDiving, new Requirement[0]);
        goBringNungWire.addStep(new Conditions(this.hasKelp, this.inUnderWater), this.giveNungWire);
        goBringNungWire.addStep(this.inUnderWater, this.pickKelp);
        steps.put(70, goBringNungWire);
        ConditionalStep goLearnHowToMakeFishCake = new ConditionalStep((QuestHelper)this, this.goDivingAgain, new Requirement[0]);
        goLearnHowToMakeFishCake.addStep(new Conditions(this.fishCake, this.inDiningRoom), this.useCakeOnPete);
        goLearnHowToMakeFishCake.addStep(new Conditions(this.fishCake.alsoCheckBank(this.questBank)), this.enterDiningRoomAgain);
        goLearnHowToMakeFishCake.addStep(new Conditions(this.rawFishCake.alsoCheckBank(this.questBank)), this.cookCake);
        goLearnHowToMakeFishCake.addStep(new Conditions(this.hasKelp, this.hasCrabMeat, this.inUnderWater), this.climbAnchor);
        goLearnHowToMakeFishCake.addStep(new Conditions(this.hasKelp, this.inUnderWater, this.hasEnoughRocks), this.killCrab);
        goLearnHowToMakeFishCake.addStep(new Conditions(this.hasKelp, this.inUnderWater), this.pickUpRocksAgain);
        goLearnHowToMakeFishCake.addStep(new Conditions(this.groundKelpHighlighted, this.groundCrabMeatHighlighted, this.groundCod, this.breadcrumbs), this.talkToCookAgain);
        goLearnHowToMakeFishCake.addStep(new Conditions(this.groundKelpHighlighted, this.groundCrabMeatHighlighted, this.groundCod), this.useKnifeOnBread);
        goLearnHowToMakeFishCake.addStep(new Conditions(this.groundKelpHighlighted, this.groundCrabMeatHighlighted), this.usePestleOnCod);
        goLearnHowToMakeFishCake.addStep(new Conditions(this.hasKelp, this.groundCrabMeatHighlighted), this.grindKelp);
        goLearnHowToMakeFishCake.addStep(new Conditions(this.hasKelp, this.hasCrabMeat), this.grindCrab);
        goLearnHowToMakeFishCake.addStep(this.inUnderWater, this.pickKelp);
        steps.put(80, goLearnHowToMakeFishCake);
        steps.put(90, goLearnHowToMakeFishCake);
        ConditionalStep savePete = new ConditionalStep((QuestHelper)this, this.useCrabOnKelp, new Requirement[0]);
        savePete.addStep(new Conditions(this.fishCake, this.inDiningRoom), this.useCakeOnPete);
        savePete.addStep(new Conditions(this.fishCake.alsoCheckBank(this.questBank)), this.enterDiningRoomAgain);
        savePete.addStep(new Conditions(this.rawFishCake), this.cookCake);
        steps.put(100, savePete);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.canSwim = new WeightRequirement("Weight less than 27kg", 26, Operation.LESS_EQUAL);
        this.pestleHighlighted = new ItemRequirement("Pestle and mortar", 233).isNotConsumed();
        this.pestleHighlighted.setHighlightInInventory(true);
        this.rawCodHighlighted = new ItemRequirement("Raw cod (more if you burn cake)", 341);
        this.rawCodHighlighted.setHighlightInInventory(true);
        this.knifeHighlighted = new ItemRequirement("Knife", 946).isNotConsumed();
        this.knifeHighlighted.setHighlightInInventory(true);
        this.breadHighlighted = new ItemRequirement("Bread (more if you burn cake)", 2309);
        this.breadHighlighted.setTooltip("You can make this by using a knife on bread");
        this.breadHighlighted.setHighlightInInventory(true);
        this.divingAparatus = new ItemRequirement("Diving apparatus", 7535, 1, true).isNotConsumed();
        this.divingHelmet = new ItemRequirement("Fishbowl helmet", 7534, 1, true).isNotConsumed();
        this.fishBowl = new ItemRequirement("Empty fishbowl", 6667);
        this.bronzeWire3 = new ItemRequirement("Bronze wire", 1794, 3);
        this.needle = new ItemRequirement("Needle", 1733).isNotConsumed();
        this.fishCake = new ItemRequirement("Cooked fishcake", 7530);
        this.fishCakeHighlighted = new ItemRequirement("Cooked fishcake", 7530);
        this.fishCakeHighlighted.setHighlightInInventory(true);
        this.rocks5 = new ItemRequirement("Rock", 7533, 5);
        this.mudskipperHide5 = new ItemRequirement("Mudskipper hide", 7532, 5);
        this.kelp = new ItemRequirement("Kelp", 7516);
        this.crabMeat = new ItemRequirement("Crab meat", 7518);
        this.crabMeat.addAlternates(7519);
        this.kelpHighlighted = new ItemRequirement("Kelp", 7516);
        this.kelpHighlighted.setHighlightInInventory(true);
        this.crabMeatHighlighted = new ItemRequirement("Crab meat", 7518);
        this.crabMeatHighlighted.addAlternates(7519);
        this.crabMeatHighlighted.setHighlightInInventory(true);
        this.groundCrabMeatHighlighted = new ItemRequirement("Ground crab meat", 7527);
        this.groundCrabMeatHighlighted.setTooltip("You will need to kill another underwater crab and grind its meat");
        this.groundCrabMeatHighlighted.setHighlightInInventory(true);
        this.groundKelpHighlighted = new ItemRequirement("Ground kelp", 7517);
        this.groundKelpHighlighted.setTooltip("You will need to go underwater with Murphy and pick more kelp to grind");
        this.groundKelpHighlighted.setHighlightInInventory(true);
        this.rawFishCake = new ItemRequirement("Raw fishcake", 7529);
        this.groundCod = new ItemRequirement("Ground cod", 7528);
        this.groundCod.setTooltip("You can make this by use a pestle and mortar on a raw cod");
        this.breadcrumbs = new ItemRequirement("Breadcrumbs", 7515);
        this.combatGear = new ItemRequirement("Combat gear", -1, -1);
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
    }

    public void loadZones() {
        this.diningRoom = new Zone(new WorldPoint(1856, 5313, 0), new WorldPoint(1870, 5333, 0));
        this.underwater = new Zone(new WorldPoint(2944, 9472, 1), new WorldPoint(3007, 9534, 1));
    }

    public void setupConditions() {
        this.inDiningRoom = new ZoneRequirement(this.diningRoom);
        this.walkingUnderwater = new VarbitRequirement(1871, 1);
        this.askedCookOptions = new Conditions(new VarbitRequirement(1873, 1), new VarbitRequirement(1876, 1), new VarbitRequirement(1877, 1));
        this.inUnderWater = new ZoneRequirement(this.underwater);
        this.hasEnoughRocks = new VarbitRequirement(1869, 5);
        this.hasCrabMeat = new Conditions(LogicType.OR, this.crabMeat, this.groundCrabMeatHighlighted);
        this.hasKelp = new Conditions(LogicType.OR, this.kelp, this.groundKelpHighlighted);
        this.generalReqs = new ArrayList();
        this.generalReqs.add(new SkillRequirement(Skill.COOKING, 31));
        if (Utils.getAccountType(this.client).isAnyIronman()) {
            this.generalReqs.add(new ComplexRequirement(LogicType.OR, "42 Crafting or started Rum Deal for a fishbowl", new SkillRequirement(Skill.CRAFTING, 42, true), new QuestRequirement(QuestHelperQuest.RUM_DEAL, QuestState.IN_PROGRESS)));
        }
    }

    public void setupSteps() {
        this.enterDiningRoom = new ObjectStep((QuestHelper)this, 12349, new WorldPoint(3213, 3221, 0), "Go inspect Pirate Pete.", new Requirement[0]);
        this.inspectPete = new ObjectStep((QuestHelper)this, 12337, new WorldPoint(1862, 5323, 0), "Inspect Pirate Pete.", new Requirement[0]);
        this.inspectPete.addSubSteps(this.enterDiningRoom);
        this.enterKitchen = new ObjectStep((QuestHelper)this, 12351, new WorldPoint(1861, 5316, 0), "Talk to the Lumbridge Cook.", new Requirement[0]);
        this.talkToCook = new AskAboutFishCake(this);
        this.talkToCook.addSubSteps(this.enterKitchen);
        this.usePestleOnCod = new DetailedQuestStep((QuestHelper)this, "Use a pestle and mortar on a raw cod.", this.pestleHighlighted, this.rawCodHighlighted);
        this.useKnifeOnBread = new DetailedQuestStep((QuestHelper)this, "Use a knife on some bread and make BREADCRUMBS.", this.knifeHighlighted, this.breadHighlighted);
        this.talkToMurphy = new NpcStep((QuestHelper)this, 5607, new WorldPoint(2664, 3160, 0), "Talk to Murphy in Port Khazard.", this.fishBowl);
        this.talkToMurphy.addDialogStep("Talk about Recipe for Disaster.");
        this.talkToMurphyAgain = new NpcStep((QuestHelper)this, 5607, new WorldPoint(2664, 3160, 0), "Talk to Murphy again.", this.fishBowl);
        this.talkToMurphyAgain.addDialogStep("Talk about Recipe for Disaster.");
        this.goDiving = new NpcStep((QuestHelper)this, 5607, new WorldPoint(2664, 3160, 0), "Talk to Murphy again to go diving.", this.divingAparatus, this.divingHelmet, this.bronzeWire3, this.needle, this.canSwim);
        this.goDiving.addDialogSteps("Talk about Recipe for Disaster.", "Yes, Let's go diving.");
        this.pickKelp = new ObjectStep((QuestHelper)this, 12478, new WorldPoint(2966, 9490, 1), "Pick some kelp. Get 3 or so in case you burn a fishcake or two.", new Requirement[0]);
        this.talkToNung = new NpcStep((QuestHelper)this, 4818, new WorldPoint(2971, 9513, 1), "Talk to Nung in the north of the area.", new Requirement[0]);
        this.pickUpRocks = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2950, 9511, 1), "Pick up 5 rocks in the west of the area.", this.rocks5);
        this.enterCave = new ObjectStep((QuestHelper)this, 12461, new WorldPoint(2950, 9516, 1), "Enter the underwater cave entrance.", new Requirement[0]);
        this.killMudksippers5 = new NpcStep((QuestHelper)this, 4820, new WorldPoint(2951, 9526, 1), "Kill mudskippers for 5 hides.", true, this.mudskipperHide5);
        ((NpcStep)this.killMudksippers5).addAlternateNpcs(4821);
        this.returnToNung = new NpcStep((QuestHelper)this, 4818, new WorldPoint(2971, 9513, 1), "Bring the hides to Nung.", this.mudskipperHide5);
        this.talkToNungAgain = new NpcStep((QuestHelper)this, 4818, new WorldPoint(2971, 9513, 1), "Talk to Nung again.", new Requirement[0]);
        this.returnToNung.addSubSteps(this.talkToNungAgain);
        this.giveNungWire = new NpcStep((QuestHelper)this, 4818, new WorldPoint(2971, 9513, 1), "Bring bronze wire and a needle to Nung.", this.bronzeWire3, this.needle);
        this.goDivingAgain = new NpcStep((QuestHelper)this, 5607, new WorldPoint(2664, 3160, 0), "Talk to Murphy again to go diving.", this.divingAparatus, this.divingHelmet, this.canSwim);
        this.goDiving.addDialogSteps("Talk about Recipe for Disaster.", "Yes, Let's go diving.");
        this.pickUpRocksAgain = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2950, 9511, 1), "Pick up 5 rocks so you can kill the crabs.", this.rocks5);
        this.killCrab = new NpcStep((QuestHelper)this, 4819, new WorldPoint(2977, 9518, 1), "Kill the crabs for some crab meat. Get 2-3 to be safe.", true, this.crabMeat);
        this.killCrab.addSubSteps(this.pickUpRocksAgain);
        this.grindKelp = new DetailedQuestStep((QuestHelper)this, "Use a pestle and mortar on the kelp.", this.pestleHighlighted, this.kelpHighlighted);
        this.grindCrab = new DetailedQuestStep((QuestHelper)this, "Use a pestle and mortar on the crab.", this.pestleHighlighted, this.crabMeatHighlighted);
        this.climbAnchor = new ObjectStep((QuestHelper)this, 12475, new WorldPoint(2963, 9477, 1), "Climb the anchor to the south to return to the surface.", new Requirement[0]);
        this.talkToCookAgain = new NpcStep((QuestHelper)this, 4626, new WorldPoint(3209, 3215, 0), "Talk to the Lumbridge Cook about Pirate Pete again.", this.groundCod, this.groundCrabMeatHighlighted, this.groundKelpHighlighted, this.breadcrumbs);
        this.talkToCookAgain.addDialogStep("Protecting the Pirate");
        this.useCrabOnKelp = new DetailedQuestStep((QuestHelper)this, "Use the ingredients together to make the cake.", this.groundCrabMeatHighlighted, this.groundKelpHighlighted, this.groundCod, this.breadcrumbs);
        this.cookCake = new DetailedQuestStep((QuestHelper)this, "Cook the fishcake. It's possible to burn it.", this.rawFishCake);
        this.enterDiningRoomAgain = new ObjectStep((QuestHelper)this, 12348, new WorldPoint(3207, 3217, 0), "Go give the fishcake to Pirate Pete to finish the quest.", this.fishCake);
        this.useCakeOnPete = new ObjectStep((QuestHelper)this, 12337, new WorldPoint(1862, 5323, 0), "Give the fishcake to Pirate Pete to finish the quest. BE CAREFUL NOT TO EAT IT.", this.fishCakeHighlighted);
        this.useCakeOnPete.addIcon(7530);
        this.useCakeOnPete.addSubSteps(this.enterDiningRoomAgain);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.fishBowl, this.needle, this.bronzeWire3, this.pestleHighlighted, this.rawCodHighlighted, this.breadHighlighted, this.knifeHighlighted);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        ArrayList<ItemRequirement> req = new ArrayList<ItemRequirement>();
        req.add(this.combatGear);
        req.add(new ItemRequirement("Teleport to Khazard", 24957));
        req.add(new ItemRequirement("Teleport to Lumbridge", 8008));
        return req;
    }

    @Override
    public List<String> getCombatRequirements() {
        return Arrays.asList("5 Mudskippers (level 30/31)", "Crab (level 21/23)");
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        return this.generalReqs;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Arrays.asList(new ExperienceReward(Skill.COOKING, 1000), new ExperienceReward(Skill.CRAFTING, 1000), new ExperienceReward(Skill.FISHING, 1000), new ExperienceReward(Skill.SMITHING, 1000));
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Collections.singletonList(new ItemReward("Diving Apparatus", 7535, 1));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("Access to the Mogre Camp"), new UnlockReward("Increased access to the Culinaromancer's Chest"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting off", Arrays.asList(this.inspectPete, this.talkToCook, this.talkToMurphy, this.talkToMurphyAgain), this.fishBowl));
        allSteps.add(new PanelDetails("Get Crab and Kelp", Arrays.asList(this.goDiving, this.pickKelp, this.talkToNung, this.pickUpRocks, this.enterCave, this.killMudksippers5, this.returnToNung, this.giveNungWire, this.killCrab, this.climbAnchor), this.divingHelmet, this.divingAparatus, this.bronzeWire3, this.needle));
        allSteps.add(new PanelDetails("Saving Pete", Arrays.asList(this.grindCrab, this.grindKelp, this.usePestleOnCod, this.useKnifeOnBread, this.talkToCookAgain, this.useCrabOnKelp, this.cookCake, this.useCakeOnPete), this.pestleHighlighted, this.knifeHighlighted, this.rawCodHighlighted, this.breadHighlighted, this.crabMeat, this.kelp));
        return allSteps;
    }

    @Override
    public QuestState getState(Client client) {
        int questState = client.getVarbitValue(QuestVarbits.QUEST_RECIPE_FOR_DISASTER_PIRATE_PETE.getId());
        if (questState == 0) {
            return QuestState.NOT_STARTED;
        }
        if (questState < 110) {
            return QuestState.IN_PROGRESS;
        }
        return QuestState.FINISHED;
    }

    @Override
    public boolean isCompleted() {
        return this.client.getVarbitValue(1895) >= 110 || this.client.getVarbitValue(QuestVarbits.QUEST_RECIPE_FOR_DISASTER.getId()) < 3;
    }
}

