/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.recipefordisaster;

import com.questhelper.collections.ItemCollections;
import com.questhelper.helpers.quests.recipefordisaster.QuizSteps;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.questinfo.QuestVarbits;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.Client;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.RECIPE_FOR_DISASTER_LUMBRIDGE_GUIDE)
public class RFDLumbridgeGuide
extends BasicQuestHelper {
    ItemRequirement milk;
    ItemRequirement egg;
    ItemRequirement flour;
    ItemRequirement tin;
    ItemRequirement rawGuidanceCake;
    ItemRequirement guidanceCake;
    ItemRequirement guidanceCakeHighlighted;
    ItemRequirement enchantedEgg;
    ItemRequirement enchantedMilk;
    ItemRequirement enchantedFlour;
    ItemRequirement tinHighlighted;
    ItemRequirement wizardsTowerTeleport;
    ItemRequirement lumbridgeTeleport;
    Requirement inDiningRoom;
    Requirement inUpstairsTrailborn;
    DetailedQuestStep enterDiningRoom;
    DetailedQuestStep inspectLumbridgeGuide;
    DetailedQuestStep goUpToTraiborn;
    DetailedQuestStep cookCake;
    DetailedQuestStep enterDiningRoomAgain;
    DetailedQuestStep useCakeOnLumbridgeGuide;
    DetailedQuestStep mixIngredients;
    QuizSteps talkToTraiborn;
    Zone diningRoom;
    Zone upstairsTrailborn;
    Zone quizSpot;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        ConditionalStep goInspectGuide = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterDiningRoom, new Requirement[0]);
        goInspectGuide.addStep(this.inDiningRoom, this.inspectLumbridgeGuide);
        steps.put(0, goInspectGuide);
        ConditionalStep goTalkToTrailborn = new ConditionalStep((QuestHelper)this, (QuestStep)this.goUpToTraiborn, new Requirement[0]);
        goTalkToTrailborn.addStep(this.inUpstairsTrailborn, this.talkToTraiborn);
        steps.put(1, goTalkToTrailborn);
        steps.put(2, goTalkToTrailborn);
        ConditionalStep saveGuide = new ConditionalStep((QuestHelper)this, (QuestStep)this.mixIngredients, new Requirement[0]);
        saveGuide.addStep(new Conditions(this.guidanceCake, this.inDiningRoom), this.useCakeOnLumbridgeGuide);
        saveGuide.addStep(this.guidanceCake.alsoCheckBank(this.questBank), this.enterDiningRoomAgain);
        saveGuide.addStep(this.rawGuidanceCake, this.cookCake);
        steps.put(3, saveGuide);
        steps.put(4, saveGuide);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.milk = new ItemRequirement("Bucket of milk", 1927);
        this.flour = new ItemRequirement("Pot of flour", 1933);
        this.egg = new ItemRequirement("Egg", 1944);
        this.tin = new ItemRequirement("Cake tin", 1887);
        this.tinHighlighted = new ItemRequirement("Cake tin", 1887);
        this.tinHighlighted.setHighlightInInventory(true);
        this.enchantedEgg = new ItemRequirement("Enchanted egg", 7544);
        this.enchantedEgg.setTooltip("You can get another from Traiborn if you've lost it");
        this.enchantedFlour = new ItemRequirement("Enchanted flour", 7546);
        this.enchantedFlour.setTooltip("You can get another from Traiborn if you've lost it");
        this.enchantedMilk = new ItemRequirement("Enchanted milk", 7545);
        this.enchantedMilk.setTooltip("You can get another from Traiborn if you've lost it");
        this.enchantedMilk.setHighlightInInventory(true);
        this.rawGuidanceCake = new ItemRequirement("Raw guide cake", 7543);
        this.guidanceCake = new ItemRequirement("Guidance cake", 7542);
        this.guidanceCakeHighlighted = new ItemRequirement("Guidance cake", 7542);
        this.guidanceCakeHighlighted.setHighlightInInventory(true);
        this.lumbridgeTeleport = new ItemRequirement("Lumbridge Teleport", 8008);
        this.wizardsTowerTeleport = new ItemRequirement("Necklace of Passage for Wizards' Tower teleport", ItemCollections.NECKLACE_OF_PASSAGES);
    }

    public void loadZones() {
        this.diningRoom = new Zone(new WorldPoint(1856, 5313, 0), new WorldPoint(1870, 5333, 0));
        this.upstairsTrailborn = new Zone(new WorldPoint(3100, 3152, 1), new WorldPoint(3117, 3168, 1));
        this.quizSpot = new Zone(new WorldPoint(2579, 4625, 0), new WorldPoint(2579, 4625, 0));
    }

    public void setupConditions() {
        this.inDiningRoom = new ZoneRequirement(this.diningRoom);
        this.inUpstairsTrailborn = new ZoneRequirement(this.upstairsTrailborn, this.quizSpot);
    }

    public void setupSteps() {
        this.enterDiningRoom = new ObjectStep((QuestHelper)this, 12349, new WorldPoint(3213, 3221, 0), "Go inspect the Lumbridge Guide in the Lumbridge Castle dining room.", new Requirement[0]);
        this.enterDiningRoom.addTeleport(this.lumbridgeTeleport);
        this.inspectLumbridgeGuide = new ObjectStep((QuestHelper)this, 12339, new WorldPoint(1865, 5325, 0), "Inspect the Lumbridge Guide in the Lumbridge Castle dining room.", new Requirement[0]);
        this.inspectLumbridgeGuide.addDialogSteps("Yes, I'm sure I can make a cake.");
        this.inspectLumbridgeGuide.addSubSteps(this.enterDiningRoom);
        this.goUpToTraiborn = new ObjectStep((QuestHelper)this, 12536, new WorldPoint(3104, 3160, 0), "Go talk to Traiborn in the Wizards' Tower.", this.egg, this.flour, this.milk, this.tin);
        this.goUpToTraiborn.addDialogStep("Wizards' Tower");
        this.goUpToTraiborn.addTeleport(this.wizardsTowerTeleport);
        this.talkToTraiborn = new QuizSteps(this);
        this.cookCake = new DetailedQuestStep((QuestHelper)this, "Cook the Guidance Cake.", this.rawGuidanceCake);
        this.enterDiningRoomAgain = new ObjectStep((QuestHelper)this, 12348, new WorldPoint(3207, 3217, 0), "Use the Guidance Cake on the Lumbridge Guide to finish the quest.", this.guidanceCake);
        this.useCakeOnLumbridgeGuide = new ObjectStep((QuestHelper)this, 12339, new WorldPoint(1865, 5325, 0), "Use the Guidance Cake on the Lumbridge Guide to finish the quest.", this.guidanceCakeHighlighted);
        this.useCakeOnLumbridgeGuide.addIcon(7542);
        this.useCakeOnLumbridgeGuide.addSubSteps(this.enterDiningRoomAgain);
        this.mixIngredients = new DetailedQuestStep((QuestHelper)this, "Talk to Traiborn for the enchanted ingredients, then mix them in a tin.", this.enchantedEgg.highlighted(), this.enchantedFlour.highlighted(), this.enchantedMilk.highlighted(), this.tin.highlighted());
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.milk, this.egg, this.flour, this.tin);
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new SkillRequirement(Skill.COOKING, 40, true));
        req.add(new QuestRequirement(QuestHelperQuest.BIG_CHOMPY_BIRD_HUNTING, QuestState.FINISHED));
        req.add(new QuestRequirement(QuestHelperQuest.BIOHAZARD, QuestState.FINISHED));
        req.add(new QuestRequirement(QuestHelperQuest.DEMON_SLAYER, QuestState.FINISHED));
        req.add(new QuestRequirement(QuestHelperQuest.MURDER_MYSTERY, QuestState.FINISHED));
        req.add(new QuestRequirement(QuestHelperQuest.NATURE_SPIRIT, QuestState.FINISHED));
        req.add(new QuestRequirement(QuestHelperQuest.WITCHS_HOUSE, QuestState.FINISHED));
        return req;
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        ArrayList<ItemRequirement> req = new ArrayList<ItemRequirement>();
        req.add(this.lumbridgeTeleport);
        req.add(this.wizardsTowerTeleport);
        return req;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Arrays.asList(new ExperienceReward(Skill.COOKING, 2500), new ExperienceReward(Skill.MAGIC, 2500));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Collections.singletonList(new UnlockReward("Increased access to the Culinaromancer's Chest"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Saving the Guide", Arrays.asList(this.inspectLumbridgeGuide, this.goUpToTraiborn, this.talkToTraiborn, this.mixIngredients, this.cookCake, this.useCakeOnLumbridgeGuide), this.milk, this.egg, this.flour, this.tin));
        return allSteps;
    }

    @Override
    public QuestState getState(Client client) {
        int questState = client.getVarbitValue(QuestVarbits.QUEST_RECIPE_FOR_DISASTER_LUMBRIDGE_GUIDE.getId());
        if (questState == 0) {
            return QuestState.NOT_STARTED;
        }
        if (questState < 5) {
            return QuestState.IN_PROGRESS;
        }
        return QuestState.FINISHED;
    }

    @Override
    public boolean isCompleted() {
        return this.client.getVarbitValue(1896) >= 5 || this.client.getVarbitValue(QuestVarbits.QUEST_RECIPE_FOR_DISASTER.getId()) < 3;
    }
}

