/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.recipefordisaster;

import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.questinfo.QuestVarbits;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.Operation;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.Client;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.RECIPE_FOR_DISASTER_WARTFACE_AND_BENTNOZE)
public class RFDGoblins
extends BasicQuestHelper {
    ItemRequirement bread;
    ItemRequirement orange;
    ItemRequirement knife;
    ItemRequirement blueGreenPurpledye;
    ItemRequirement spice;
    ItemRequirement fishingBait;
    ItemRequirement bucketOfWater;
    ItemRequirement breadHighlighted;
    ItemRequirement orangeHighlighted;
    ItemRequirement knifeHighlighted;
    ItemRequirement blueGreenPurpledyeHighlighted;
    ItemRequirement spiceHighlighted;
    ItemRequirement fishingBaitHighlighted;
    ItemRequirement bucketOfWaterHighlighted;
    ItemRequirement charcoal;
    ItemRequirement dyedOrange;
    ItemRequirement spicedBait;
    ItemRequirement wetBread;
    ItemRequirement teleportLumbridge;
    ItemRequirement teleportFalador;
    ItemRequirement slop;
    ItemRequirement slopHighlighted;
    ItemRequirement orangeSliceHighlighted;
    Requirement inDiningRoom;
    Requirement inCookRoom;
    QuestStep enterDiningRoom;
    QuestStep inspectGoblin;
    QuestStep goDownToKitchen;
    QuestStep talkToCook;
    QuestStep talkToCookAfterChar;
    QuestStep sliceOrange;
    QuestStep dyeOrange;
    QuestStep spiceBait;
    QuestStep useWaterOnBread;
    QuestStep enterDiningRoomAgain;
    QuestStep useSlopOnGoblin;
    ConditionalStep goTalkCook1;
    ConditionalStep goTalkCook2;
    ConditionalStep goTalkCook3;
    ConditionalStep goTalkCook4;
    Zone diningRoom;
    Zone cookRoom;
    Zone cookRoomDestroyed;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        ConditionalStep goInspectGoblin = new ConditionalStep((QuestHelper)this, this.enterDiningRoom, new Requirement[0]);
        goInspectGoblin.addStep(this.inDiningRoom, this.inspectGoblin);
        steps.put(0, goInspectGoblin);
        steps.put(5, this.goTalkCook1);
        steps.put(10, this.goTalkCook2);
        steps.put(15, this.goTalkCook3);
        ConditionalStep goGetIngredients = new ConditionalStep((QuestHelper)this, this.useWaterOnBread, new Requirement[0]);
        goGetIngredients.addStep(new Conditions(this.wetBread, this.dyedOrange, this.spicedBait), this.goTalkCook4);
        goGetIngredients.addStep(new Conditions(this.wetBread, this.dyedOrange), this.spiceBait);
        goGetIngredients.addStep(new Conditions(this.wetBread, this.orangeSliceHighlighted), this.dyeOrange);
        goGetIngredients.addStep(this.wetBread, this.sliceOrange);
        steps.put(30, goGetIngredients);
        ConditionalStep goGiveSlop = new ConditionalStep((QuestHelper)this, this.enterDiningRoomAgain, new Requirement[0]);
        goGiveSlop.addStep(this.inDiningRoom, this.useSlopOnGoblin);
        steps.put(35, goGiveSlop);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.bread = new ItemRequirement("Bread", 2309);
        this.orange = new ItemRequirement("Orange", 2108);
        this.knife = new ItemRequirement("Knife", 946).isNotConsumed();
        this.blueGreenPurpledye = new ItemRequirement("A blue, green, or purple dye", 1767);
        this.blueGreenPurpledye.addAlternates(1771, 1773);
        this.spice = new ItemRequirement("Spice or gnome spice", 2007).isNotConsumed();
        this.spice.setTooltip("You can get some from the Culinaromancer's chest, or a Gnome Spice from the Tree Gnome Stronghold");
        this.spice.addAlternates(2169);
        this.fishingBait = new ItemRequirement("Fishing bait", 313);
        this.bucketOfWater = new ItemRequirement("Bucket of water", 1929);
        this.breadHighlighted = this.bread.highlighted();
        this.orangeHighlighted = this.orange.highlighted();
        this.knifeHighlighted = this.knife.highlighted();
        this.blueGreenPurpledyeHighlighted = this.blueGreenPurpledye.highlighted();
        this.spiceHighlighted = this.spice.highlighted();
        this.fishingBaitHighlighted = this.fishingBait.highlighted();
        this.bucketOfWaterHighlighted = this.bucketOfWater.highlighted();
        this.orangeSliceHighlighted = new ItemRequirement("Orange slices", 2112);
        this.orangeSliceHighlighted.setHighlightInInventory(true);
        this.charcoal = new ItemRequirement("Charcoal", 973);
        this.charcoal.setTooltip("Can be bought from the general store in Shilo Village or the one northwest of Tai Bwo Wannai");
        this.charcoal.addAlternates(704);
        this.dyedOrange = new ItemRequirement("Dyed orange", 7514);
        this.spicedBait = new ItemRequirement("Spicy maggots", 7513);
        this.wetBread = new ItemRequirement("Soggy bread", 7512);
        this.slop = new ItemRequirement("Slop of compromise", 7511);
        this.slopHighlighted = new ItemRequirement("Slop of compromise", 7511);
        this.slopHighlighted.setHighlightInInventory(true);
        this.teleportFalador = new ItemRequirement("Teleport to Falador", 8009);
        this.teleportLumbridge = new ItemRequirement("Teleport to Lumbridge", 8008);
    }

    public void loadZones() {
        this.diningRoom = new Zone(new WorldPoint(1856, 5313, 0), new WorldPoint(1870, 5333, 0));
        this.cookRoom = new Zone(new WorldPoint(2974, 9906, 0), new WorldPoint(2990, 9917, 0));
        this.cookRoomDestroyed = new Zone(new WorldPoint(2974, 9866, 0), new WorldPoint(2990, 9877, 0));
    }

    public void setupConditions() {
        this.inDiningRoom = new ZoneRequirement(this.diningRoom);
        this.inCookRoom = new ZoneRequirement(this.cookRoom, this.cookRoomDestroyed);
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Arrays.asList(new ExperienceReward(Skill.COOKING, 1000), new ExperienceReward(Skill.FARMING, 1000), new ExperienceReward(Skill.CRAFTING, 1000));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Collections.singletonList(new UnlockReward("Increased access to the Culinaromancer's Chest"));
    }

    public void setupSteps() {
        this.enterDiningRoom = new ObjectStep((QuestHelper)this, 12349, new WorldPoint(3213, 3221, 0), "Go inspect Wartface or Bentnoze.", new Requirement[0]);
        this.inspectGoblin = new ObjectStep((QuestHelper)this, 12332, new WorldPoint(1862, 5325, 0), "Inspect Wartface or Bentnoze.", new Requirement[0]);
        this.inspectGoblin.addSubSteps(this.enterDiningRoom);
        this.goDownToKitchen = new ObjectStep((QuestHelper)this, 12389, new WorldPoint(2960, 3507, 0), "", new Requirement[0]);
        this.talkToCook = new NpcStep((QuestHelper)this, 4850, new WorldPoint(2981, 9909, 0), "", new Requirement[0]);
        ((NpcStep)this.talkToCook).addAlternateNpcs(4852);
        this.talkToCookAfterChar = new NpcStep((QuestHelper)this, 4851, new WorldPoint(2981, 9868, 0), "", new Requirement[0]);
        this.useWaterOnBread = new DetailedQuestStep((QuestHelper)this, "Use a bucket of water on some bread.", this.bucketOfWaterHighlighted, this.breadHighlighted);
        this.sliceOrange = new DetailedQuestStep((QuestHelper)this, "Use a knife on an orange and SLICE it.", this.knifeHighlighted, this.orangeHighlighted);
        this.dyeOrange = new DetailedQuestStep((QuestHelper)this, "Use a dye on the sliced orange.", this.blueGreenPurpledyeHighlighted, this.orangeSliceHighlighted);
        this.spiceBait = new DetailedQuestStep((QuestHelper)this, "Use spices on the fishing bait.", this.spiceHighlighted, this.fishingBaitHighlighted);
        this.enterDiningRoomAgain = new ObjectStep((QuestHelper)this, 12349, new WorldPoint(3213, 3221, 0), "Go use the slop on Wartface or Bentnoze in the Lumbridge Banquet room.", this.slop);
        this.useSlopOnGoblin = new ObjectStep((QuestHelper)this, 12332, new WorldPoint(1862, 5325, 0), "Use the slop on Wartface or Bentnoze.", this.slopHighlighted);
        this.useSlopOnGoblin.addSubSteps(this.enterDiningRoomAgain);
        this.useSlopOnGoblin.addIcon(7511);
        this.goTalkCook1 = new ConditionalStep((QuestHelper)this, this.goDownToKitchen, "Go talk to the Goblin Cook down the ladder in the Goblin Village.", this.bread, this.orange, this.knife, this.blueGreenPurpledye, this.spice, this.fishingBait, this.bucketOfWater, this.charcoal);
        this.goTalkCook1.addStep(this.inCookRoom, this.talkToCook);
        this.goTalkCook1.addDialogSteps("I need your help...", "What do you need? Maybe I can get it for you.");
        this.goTalkCook2 = new ConditionalStep((QuestHelper)this, this.goDownToKitchen, "Give the Goblin Cook some charcoal.", this.charcoal);
        this.goTalkCook2.addStep(this.inCookRoom, this.talkToCook);
        this.goTalkCook2.addDialogSteps("I've got the charcoal you were after.");
        this.goTalkCook3 = new ConditionalStep((QuestHelper)this, this.goDownToKitchen, "Talk to the Goblin Cook again.", this.bread, this.orange, this.knife, this.blueGreenPurpledye, this.spice, this.fishingBait, this.bucketOfWater);
        this.goTalkCook3.addStep(this.inCookRoom, this.talkToCookAfterChar);
        this.goTalkCook3.addDialogSteps("I need your help...");
        this.goTalkCook4 = new ConditionalStep((QuestHelper)this, this.goDownToKitchen, "Talk to the Goblin Cook again with the ingredients.", this.wetBread, this.dyedOrange, this.spicedBait);
        this.goTalkCook4.addStep(this.inCookRoom, this.talkToCookAfterChar);
        this.goTalkCook4.addDialogStep("I've got the ingredients we need...");
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.bread, this.orange, this.knife, this.blueGreenPurpledye, this.spice, this.fishingBait, this.bucketOfWater, this.charcoal);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.teleportFalador, this.teleportLumbridge);
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> reqs = new ArrayList<Requirement>();
        reqs.add(new VarbitRequirement(QuestVarbits.QUEST_RECIPE_FOR_DISASTER.getId(), Operation.GREATER_EQUAL, 3, "Started Recipe for Disaster"));
        reqs.add(new QuestRequirement(QuestHelperQuest.GOBLIN_DIPLOMACY, QuestState.FINISHED));
        return reqs;
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Saving the Generals", Arrays.asList(this.inspectGoblin, this.goTalkCook1, this.goTalkCook2, this.goTalkCook3, this.useWaterOnBread, this.sliceOrange, this.dyeOrange, this.spiceBait, this.goTalkCook4, this.useSlopOnGoblin), this.bread, this.orange, this.knife, this.blueGreenPurpledye, this.spice, this.fishingBait, this.bucketOfWater, this.charcoal));
        return allSteps;
    }

    @Override
    public QuestState getState(Client client) {
        int questState = client.getVarbitValue(QuestVarbits.QUEST_RECIPE_FOR_DISASTER_WARTFACE_AND_BENTNOZE.getId());
        if (questState == 0) {
            return QuestState.NOT_STARTED;
        }
        if (questState < 40) {
            return QuestState.IN_PROGRESS;
        }
        return QuestState.FINISHED;
    }

    @Override
    public boolean isCompleted() {
        return this.getQuest().getVar(this.client) >= 40 || this.client.getVarbitValue(QuestVarbits.QUEST_RECIPE_FOR_DISASTER.getId()) < 3;
    }
}

