/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.recipefordisaster;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.questinfo.QuestVarbits;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.quest.QuestPointRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.Client;
import net.runelite.api.QuestState;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.RECIPE_FOR_DISASTER_FINALE)
public class RFDFinal
extends BasicQuestHelper {
    ItemRequirement iceGloves;
    ItemRequirement restorePotions;
    ItemRequirement combatGear;
    Requirement inFightArena;
    Requirement killedAgrith;
    Requirement killedFlambeed;
    Requirement killedKaramel;
    Requirement killedDessourt;
    Requirement killedMother;
    QuestStep enterPortal;
    QuestStep killAgrith;
    QuestStep enterPortalFlambeed;
    QuestStep killFlambeed;
    QuestStep enterPortalKaramel;
    QuestStep killKaramel;
    QuestStep enterPortalDessourt;
    QuestStep killDessourt;
    QuestStep enterPortalMother;
    QuestStep killMother;
    QuestStep enterPortalCulinaromancer;
    QuestStep killCulinaromancer;
    Zone fightArena;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        ConditionalStep defeatAll = new ConditionalStep((QuestHelper)this, this.enterPortal, new Requirement[0]);
        defeatAll.addStep(new Conditions(this.killedMother, this.inFightArena), this.killCulinaromancer);
        defeatAll.addStep(new Conditions(this.killedMother), this.enterPortalCulinaromancer);
        defeatAll.addStep(new Conditions(this.killedDessourt, this.inFightArena), this.killMother);
        defeatAll.addStep(new Conditions(this.killedDessourt), this.enterPortalMother);
        defeatAll.addStep(new Conditions(this.killedKaramel, this.inFightArena), this.killDessourt);
        defeatAll.addStep(new Conditions(this.killedKaramel), this.enterPortalDessourt);
        defeatAll.addStep(new Conditions(this.killedFlambeed, this.inFightArena), this.killKaramel);
        defeatAll.addStep(new Conditions(this.killedFlambeed), this.enterPortalKaramel);
        defeatAll.addStep(new Conditions(this.killedAgrith, this.inFightArena), this.killFlambeed);
        defeatAll.addStep(new Conditions(this.killedAgrith), this.enterPortalFlambeed);
        defeatAll.addStep(this.inFightArena, this.killAgrith);
        steps.put(4, defeatAll);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.iceGloves = new ItemRequirement("Ice gloves", 1580).isNotConsumed();
        this.iceGloves.addAlternates(27031);
        this.restorePotions = new ItemRequirement("Restore potions for Karamel", ItemCollections.RESTORE_POTIONS);
        this.combatGear = new ItemRequirement("Combat gear, food and potions", -1, -1).isNotConsumed();
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
    }

    public void loadZones() {
        this.fightArena = new Zone(new WorldPoint(1889, 5345, 2), new WorldPoint(1910, 5366, 2));
        this.killedAgrith = new VarbitRequirement(1855, 1);
        this.killedFlambeed = new VarbitRequirement(1855, 2);
        this.killedKaramel = new VarbitRequirement(1855, 3);
        this.killedDessourt = new VarbitRequirement(1855, 4);
        this.killedMother = new VarbitRequirement(1855, 5);
    }

    public void setupConditions() {
        this.inFightArena = new ZoneRequirement(this.fightArena);
    }

    public void setupSteps() {
        this.enterPortal = new ObjectStep((QuestHelper)this, 12354, new WorldPoint(3209, 3218, 0), "Enter the portal in Lumbridge Castle, ready to fight. You can leave between fights to re-gear.", this.combatGear);
        this.killAgrith = new NpcStep((QuestHelper)this, 4880, new WorldPoint(1900, 5355, 2), "Kill Agrith-Na-Na. He uses magic at ranged, and melee up close.", new Requirement[0]);
        this.enterPortalFlambeed = new ObjectStep((QuestHelper)this, 12354, new WorldPoint(3209, 3218, 0), "Enter the portal in Lumbridge Castle, ready to fight kill Flambeed. Water spells are especially effective.", this.combatGear, this.iceGloves);
        this.killFlambeed = new NpcStep((QuestHelper)this, 4881, new WorldPoint(1900, 5355, 2), "Equip ice gloves and kill Flambeed. Water spells are especially effective.", this.iceGloves);
        this.killFlambeed.addSubSteps(this.enterPortalFlambeed);
        this.enterPortalKaramel = new ObjectStep((QuestHelper)this, 12354, new WorldPoint(3209, 3218, 0), "Enter the portal to fight Karamel. Stand in melee distance, and bring restore potions to as they drain your stats. Fire spells are especially effective.", this.combatGear, this.restorePotions);
        this.killKaramel = new NpcStep((QuestHelper)this, 4882, new WorldPoint(1900, 5355, 2), "Kill Karamel. Stand in melee distance, and bring restore potions to as they drain your stats. Fire spells are especially effective.", this.combatGear, this.restorePotions);
        this.killKaramel.addSubSteps(this.enterPortalKaramel);
        this.enterPortalDessourt = new ObjectStep((QuestHelper)this, 12354, new WorldPoint(3209, 3218, 0), "Enter the portal in Lumbridge Castle, ready to fight Dessourt.", this.combatGear);
        this.killDessourt = new NpcStep((QuestHelper)this, 4883, new WorldPoint(1900, 5355, 2), "Kill Dessourt.", new Requirement[0]);
        this.killDessourt.addSubSteps(this.enterPortalDessourt);
        this.enterPortalMother = new ObjectStep((QuestHelper)this, 12354, new WorldPoint(3209, 3218, 0), "Enter the portal in Lumbridge Castle, ready to fight the Gelatinnoth mother. You'll need to use air spells when she's white, earth when brown, fire when red and water when blue.", this.combatGear);
        this.killMother = new NpcStep((QuestHelper)this, 4884, new WorldPoint(1900, 5355, 2), "Kill the Gelatinnoth mother. You'll need to use air spells when she's white, earth when brown, fire when red and water when blue, melee when orange and ranged when green.", new Requirement[0]);
        ((NpcStep)this.killMother).addAlternateNpcs(4885, 4886, 4887, 4888, 4889);
        this.killMother.addSubSteps(this.enterPortalMother);
        this.enterPortalCulinaromancer = new ObjectStep((QuestHelper)this, 12354, new WorldPoint(3209, 3218, 0), "Enter the portal in Lumbridge Castle, ready to fight the Culinaromancer. Try to keep your distance.", this.combatGear);
        this.killCulinaromancer = new NpcStep((QuestHelper)this, 4878, new WorldPoint(1900, 5355, 2), "Kill the Culinaromancer. Try to keep your distance.", new Requirement[0]);
        this.killCulinaromancer.addSubSteps(this.enterPortalCulinaromancer);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.iceGloves, this.restorePotions, this.combatGear);
    }

    @Override
    public List<String> getCombatRequirements() {
        return Arrays.asList("Agrith-Na-Na (level 146)", "Flambeed (level 149)", "Karamel (level 136)", "Dessourt (level 121)", "Gelatinnoth Mother (level 130)", "Culinaromancer (level 75)");
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new QuestPointRequirement(175));
        req.add(new QuestRequirement(QuestHelperQuest.DESERT_TREASURE, QuestState.FINISHED));
        req.add(new QuestRequirement(QuestHelperQuest.HORROR_FROM_THE_DEEP, QuestState.FINISHED));
        return req;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Collections.singletonList(new ItemReward("20,000 Experience Lamp (Any skill over level 50)", 4447, 1));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Collections.singletonList(new UnlockReward("Full access to the Culinaromancer's Chest"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Defeating the Culinaromancer", Arrays.asList(this.enterPortal, this.killAgrith, this.killFlambeed, this.killKaramel, this.killDessourt, this.killMother, this.killCulinaromancer), new Requirement[0]));
        return allSteps;
    }

    @Override
    public QuestState getState(Client client) {
        int questState = client.getVarbitValue(QuestVarbits.QUEST_RECIPE_FOR_DISASTER.getId());
        if (questState < 4) {
            return QuestState.NOT_STARTED;
        }
        return this.getQuest().getState(client, this.configManager);
    }

    @Override
    public boolean isCompleted() {
        return this.client.getVarbitValue(QuestVarbits.QUEST_RECIPE_FOR_DISASTER.getId()) < 4 || super.isCompleted();
    }
}

