/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.recipefordisaster;

import com.questhelper.collections.ItemCollections;
import com.questhelper.collections.NpcCollections;
import com.questhelper.helpers.quests.recipefordisaster.MakeEvilStew;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questhelpers.QuestUtil;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.questinfo.QuestVarbits;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.item.FollowerItemRequirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.Operation;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.Client;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.RECIPE_FOR_DISASTER_EVIL_DAVE)
public class RFDEvilDave
extends BasicQuestHelper {
    ItemRequirement cat;
    ItemRequirement stews;
    ItemRequirement stew;
    ItemRequirement teleportLumbridge;
    ItemRequirement teleportEdgeville;
    ItemRequirement evilStew;
    ItemRequirement evilStewHighlighted;
    Requirement inDiningRoom;
    Requirement inEvilDaveRoom;
    QuestStep enterDiningRoom;
    QuestStep inspectEvilDave;
    QuestStep talkToDoris;
    QuestStep enterBasement;
    QuestStep talkToEvilDave;
    QuestStep goUpToDoris;
    QuestStep enterBasementAgain;
    QuestStep enterDiningRoomAgain;
    QuestStep useStewOnEvilDave;
    QuestStep makeStew;
    Zone diningRoom;
    Zone evilDaveRoom;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        ConditionalStep goInspectEvilDave = new ConditionalStep((QuestHelper)this, this.enterDiningRoom, new Requirement[0]);
        goInspectEvilDave.addStep(this.inDiningRoom, this.inspectEvilDave);
        steps.put(0, goInspectEvilDave);
        ConditionalStep goTalkToEvilDave = new ConditionalStep((QuestHelper)this, this.enterBasement, new Requirement[0]);
        goTalkToEvilDave.addStep(this.inEvilDaveRoom, this.talkToEvilDave);
        steps.put(1, goTalkToEvilDave);
        ConditionalStep goTalkToDoris = new ConditionalStep((QuestHelper)this, this.talkToDoris, new Requirement[0]);
        goTalkToDoris.addStep(this.inEvilDaveRoom, this.goUpToDoris);
        steps.put(2, goTalkToDoris);
        steps.put(3, this.makeStew);
        ConditionalStep goGiveStewToEvilDave = new ConditionalStep((QuestHelper)this, this.enterDiningRoomAgain, new Requirement[0]);
        goGiveStewToEvilDave.addStep(this.inDiningRoom, this.useStewOnEvilDave);
        steps.put(4, goGiveStewToEvilDave);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.teleportLumbridge = new ItemRequirement("Teleport to Lumbridge", 8008);
        this.teleportEdgeville = new ItemRequirement("Teleport to Edgeville", ItemCollections.AMULET_OF_GLORIES);
        this.stew = new ItemRequirement("Stew", 2003);
        this.stews = new ItemRequirement("Many stews", 2003, -1);
        this.cat = new FollowerItemRequirement("A non-overgrown cat for catching rats", ItemCollections.HUNTING_CATS, NpcCollections.getHuntingCats());
        this.evilStew = new ItemRequirement("Spicy stew", 7479);
        this.evilStewHighlighted = new ItemRequirement("Spicy stew", 7479);
        this.evilStewHighlighted.setHighlightInInventory(true);
    }

    public void loadZones() {
        this.diningRoom = new Zone(new WorldPoint(1856, 5313, 0), new WorldPoint(1870, 5333, 0));
        this.evilDaveRoom = new Zone(new WorldPoint(3068, 9874, 0), new WorldPoint(3086, 9904, 0));
    }

    public void setupConditions() {
        this.inDiningRoom = new ZoneRequirement(this.diningRoom);
        this.inEvilDaveRoom = new ZoneRequirement(this.evilDaveRoom);
    }

    public void setupSteps() {
        this.enterDiningRoom = new ObjectStep((QuestHelper)this, 12349, new WorldPoint(3213, 3221, 0), "Go inspect Evil Dave in the Lumbridge Banquet room.", new Requirement[0]);
        this.inspectEvilDave = new ObjectStep((QuestHelper)this, 12341, new WorldPoint(1865, 5323, 0), "Inspect Evil Dave.", new Requirement[0]);
        this.inspectEvilDave.addSubSteps(this.enterDiningRoom);
        this.talkToDoris = new NpcStep((QuestHelper)this, 4808, new WorldPoint(3079, 3494, 0), "Talk to Doris.", new Requirement[0]);
        this.enterBasement = new ObjectStep((QuestHelper)this, 12267, new WorldPoint(3077, 3493, 0), "Enter Doris's basement in Edgeville.", new Requirement[0]);
        ((ObjectStep)this.enterBasement).addAlternateObjects(12268);
        this.talkToEvilDave = new NpcStep((QuestHelper)this, 4806, new WorldPoint(3080, 9889, 0), "Talk to Evil Dave.", new Requirement[0]);
        this.talkToEvilDave.addDialogSteps("What did you eat at the secret council meeting?", "You've got to tell me because the magic requires it!");
        this.goUpToDoris = new ObjectStep((QuestHelper)this, 12265, new WorldPoint(3076, 9893, 0), "Go up to Doris.", new Requirement[0]);
        this.enterBasementAgain = new ObjectStep((QuestHelper)this, 12267, new WorldPoint(3077, 3493, 0), "Go back down to Evil Dave.", new Requirement[0]);
        ((ObjectStep)this.enterBasementAgain).addAlternateObjects(12268);
        this.makeStew = new MakeEvilStew(this);
        this.enterDiningRoomAgain = new ObjectStep((QuestHelper)this, 12349, new WorldPoint(3213, 3221, 0), "Go use the stew on Evil Dave in the Lumbridge Banquet room.", this.evilStew);
        this.useStewOnEvilDave = new ObjectStep((QuestHelper)this, 12341, new WorldPoint(1865, 5323, 0), "Use the stew on Evil Dave.", this.evilStewHighlighted);
        this.useStewOnEvilDave.addSubSteps(this.enterDiningRoomAgain);
        this.useStewOnEvilDave.addIcon(7479);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.cat, this.stews);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.teleportEdgeville, this.teleportLumbridge);
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> reqs = new ArrayList<Requirement>();
        reqs.add(new VarbitRequirement(QuestVarbits.QUEST_RECIPE_FOR_DISASTER.getId(), Operation.GREATER_EQUAL, 3, "Started Recipe for Disaster"));
        reqs.add(new QuestRequirement(QuestHelperQuest.GERTRUDES_CAT, QuestState.FINISHED));
        reqs.add(new QuestRequirement(QuestHelperQuest.SHADOW_OF_THE_STORM, QuestState.FINISHED));
        return reqs;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Collections.singletonList(new ExperienceReward(Skill.COOKING, 7000));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("Ability to catch Hell Rats"), new UnlockReward("Ability to make spicy stews"), new UnlockReward("Ability to own a hell-cat"), new UnlockReward("Increased access to the Culinaromancer's Chest"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        List<QuestStep> steps = QuestUtil.toArrayList(this.inspectEvilDave, this.enterBasement, this.talkToEvilDave, this.goUpToDoris, this.talkToDoris, this.enterBasementAgain);
        steps.addAll(this.makeStew.getSubsteps());
        steps.add(this.useStewOnEvilDave);
        allSteps.add(new PanelDetails("Saving Evil Dave", steps, this.cat, this.stews));
        return allSteps;
    }

    @Override
    public QuestState getState(Client client) {
        int questState = this.getQuest().getVar(client);
        if (questState == 0) {
            return QuestState.NOT_STARTED;
        }
        if (questState < 5) {
            return QuestState.IN_PROGRESS;
        }
        return QuestState.FINISHED;
    }

    @Override
    public boolean isCompleted() {
        return this.getQuest().getVar(this.client) >= 5 || this.client.getVarbitValue(QuestVarbits.QUEST_RECIPE_FOR_DISASTER.getId()) < 3;
    }
}

