/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.recipefordisaster;

import com.questhelper.collections.ItemCollections;
import com.questhelper.helpers.quests.recipefordisaster.GetRohakDrunk;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.questinfo.QuestVarbits;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.util.Operation;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ItemStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.Client;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.RECIPE_FOR_DISASTER_DWARF)
public class RFDDwarf
extends BasicQuestHelper {
    ItemRequirement coins320;
    ItemRequirement milk;
    ItemRequirement flour;
    ItemRequirement egg;
    ItemRequirement bowlOfWater;
    ItemRequirement asgarniaAle4;
    ItemRequirement iceGloves;
    ItemRequirement rockCake;
    ItemRequirement rockCakeHot;
    ItemRequirement teleportFalador2;
    ItemRequirement teleportLumbridge;
    ItemRequirement coin;
    ItemRequirement asgarnianAle;
    ItemRequirement asgoldianAle;
    ItemRequirement asgoldianAle4;
    ItemRequirement coins100;
    ItemRequirement rockCakeHighlighted;
    Requirement inDiningRoom;
    Requirement inTunnel;
    Requirement learnedHowToMakeAle;
    Requirement givenAle;
    Requirement has4AleOrGivenAle;
    QuestStep enterDiningRoom;
    QuestStep inspectDwarf;
    QuestStep talkToKaylee;
    QuestStep makeAle;
    QuestStep enterTunnels;
    QuestStep talkToOldDwarf;
    QuestStep talkToOldDwarfMore;
    QuestStep talkToOldDwarfWithIngredients;
    QuestStep pickUpRockCake;
    QuestStep coolRockCake;
    QuestStep coolRockCakeSidebar;
    QuestStep enterDiningRoomAgain;
    QuestStep useRockCakeOnDwarf;
    Zone diningRoom;
    Zone tunnel;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        ConditionalStep goInspectDwarf = new ConditionalStep((QuestHelper)this, this.enterDiningRoom, new Requirement[0]);
        goInspectDwarf.addStep(this.inDiningRoom, this.inspectDwarf);
        steps.put(0, goInspectDwarf);
        ConditionalStep goGiveAle = new ConditionalStep((QuestHelper)this, this.talkToKaylee, new Requirement[0]);
        goGiveAle.addStep(new Conditions(this.has4AleOrGivenAle, this.inTunnel), this.talkToOldDwarf);
        goGiveAle.addStep(new Conditions(this.has4AleOrGivenAle), this.enterTunnels);
        goGiveAle.addStep(this.learnedHowToMakeAle, this.makeAle);
        steps.put(10, goGiveAle);
        steps.put(20, goGiveAle);
        ConditionalStep haveCakeMade = new ConditionalStep((QuestHelper)this, this.enterTunnels, new Requirement[0]);
        haveCakeMade.addStep(this.inTunnel, this.talkToOldDwarfMore);
        steps.put(30, haveCakeMade);
        ConditionalStep haveCakeMadeP2 = new ConditionalStep((QuestHelper)this, this.enterTunnels, new Requirement[0]);
        haveCakeMadeP2.addStep(this.inTunnel, this.talkToOldDwarfWithIngredients);
        steps.put(40, haveCakeMadeP2);
        ConditionalStep giveCakeToDwarf = new ConditionalStep((QuestHelper)this, this.pickUpRockCake, new Requirement[0]);
        giveCakeToDwarf.addStep(new Conditions(this.rockCake, this.inDiningRoom), this.useRockCakeOnDwarf);
        giveCakeToDwarf.addStep(this.rockCake.alsoCheckBank(this.questBank), this.enterDiningRoomAgain);
        giveCakeToDwarf.addStep(this.rockCakeHot, this.coolRockCake);
        steps.put(50, giveCakeToDwarf);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.coins320 = new ItemRequirement("Coins", ItemCollections.COINS, 320);
        this.coins320.setTooltip("You only need 120 if you wear a Ring of Charos(a)");
        this.coins100 = new ItemRequirement("Coins", ItemCollections.COINS, 100);
        this.milk = new ItemRequirement("Bucket of milk", 1927);
        this.milk.setTooltip("You can buy this from the  Culinaromancer's Chest");
        this.flour = new ItemRequirement("Pot of flour", 1933);
        this.flour.setTooltip("You can buy this from the  Culinaromancer's Chest");
        this.egg = new ItemRequirement("Egg", 1944);
        this.egg.setTooltip("You can buy this from the  Culinaromancer's Chest");
        this.bowlOfWater = new ItemRequirement("Bowl of water", 1921);
        this.bowlOfWater.setTooltip("You can find a bowl in Lumbridge Castle's Basement and fill it in the nearby sink");
        this.asgarniaAle4 = new ItemRequirement("Asgarnian ale", 1905, 4);
        this.asgarniaAle4.setTooltip("You can buy them for 3 coins each from Kaylee during the quest");
        this.iceGloves = new ItemRequirement("Ice gloves/smiths gloves(i)/normal gloves/telekinetic grab", 1580).isNotConsumed();
        this.iceGloves.addAlternates(1059, 27031);
        this.iceGloves.setTooltip("You can use normal gloves/telekenetic grab instead, but you'll then need to kill an Ice Fiend");
        this.rockCake = new ItemRequirement("Dwarven rock cake", 7510);
        this.rockCakeHighlighted = new ItemRequirement("Dwarven rock cake", 7510);
        this.rockCakeHighlighted.setHighlightInInventory(true);
        this.rockCakeHot = new ItemRequirement("Dwarven rock cake", 7509);
        this.teleportFalador2 = new ItemRequirement("Teleport to Falador", 8009, 2);
        this.teleportLumbridge = new ItemRequirement("Teleport to Lumbridge", 8008);
        this.coin = new ItemRequirement("Coin", ItemCollections.COINS);
        this.coin.setHighlightInInventory(true);
        this.asgarnianAle = new ItemRequirement("Asgarnian ale", 1905);
        this.asgarnianAle.setHighlightInInventory(true);
        this.asgoldianAle = new ItemRequirement("Asgoldian ale", 7508);
        this.asgoldianAle.setHighlightInInventory(true);
        this.asgoldianAle4 = new ItemRequirement("Asgoldian ale", 7508, 4);
    }

    public void loadZones() {
        this.diningRoom = new Zone(new WorldPoint(1856, 5313, 0), new WorldPoint(1870, 5333, 0));
        this.tunnel = new Zone(new WorldPoint(2815, 9859, 0), new WorldPoint(2879, 9885, 0));
    }

    public void setupConditions() {
        this.inDiningRoom = new ZoneRequirement(this.diningRoom);
        this.inTunnel = new ZoneRequirement(this.tunnel);
        this.learnedHowToMakeAle = new VarbitRequirement(1891, 1);
        this.givenAle = new VarbitRequirement(1893, 1);
        this.has4AleOrGivenAle = new Conditions(LogicType.OR, this.asgoldianAle4, this.givenAle);
    }

    public void setupSteps() {
        this.enterDiningRoom = new ObjectStep((QuestHelper)this, 12349, new WorldPoint(3213, 3221, 0), "Go inspect the dwarf.", new Requirement[0]);
        this.inspectDwarf = new ObjectStep((QuestHelper)this, 12330, new WorldPoint(1862, 5321, 0), "Inspect the dwarf.", new Requirement[0]);
        this.inspectDwarf.addSubSteps(this.enterDiningRoom);
        this.talkToKaylee = new NpcStep((QuestHelper)this, 1316, new WorldPoint(2957, 3371, 0), "Talk to Kaylee in the pub in Falador.", this.coins320);
        this.talkToKaylee.addDialogSteps("What can you tell me about dwarves and ale?", "I could offer you some in return, how about 200 gold?");
        this.makeAle = new DetailedQuestStep((QuestHelper)this, "Add coins to asgarnian ale to make 4 asgoldian ale. You can buy ale from Kaylee for 3gp each.", this.coin, this.asgarnianAle);
        this.enterTunnels = new ObjectStep((QuestHelper)this, 57, new WorldPoint(2877, 3481, 0), "Enter the tunnel under White Wolf Mountain.", this.asgoldianAle4, this.milk, this.flour, this.egg, this.bowlOfWater, this.iceGloves);
        this.talkToOldDwarf = new GetRohakDrunk((QuestHelper)this, this.asgoldianAle4);
        this.talkToOldDwarfMore = new NpcStep((QuestHelper)this, 4812, new WorldPoint(2865, 9876, 0), "Talk to Rohak more.", this.coins100, this.milk, this.flour, this.egg, this.bowlOfWater);
        this.talkToOldDwarfWithIngredients = new NpcStep((QuestHelper)this, 4812, new WorldPoint(2865, 9876, 0), "Talk to Rohak more.", this.milk, this.flour, this.egg, this.bowlOfWater);
        this.talkToOldDwarfMore.addSubSteps(this.talkToOldDwarfWithIngredients);
        this.pickUpRockCake = new ItemStep((QuestHelper)this, "Pick up the dwarven rock cake. If you have ice gloves, wear them to pick it up. Otherwise, wear other gloves or telegrab it. If it despawns you'll need to bring Rohak more ingredients.", this.rockCakeHot);
        this.coolRockCake = new NpcStep((QuestHelper)this, 3140, new WorldPoint(3008, 3471, 0), "Kill an icefiend to cool the rock cake.", this.rockCakeHot);
        this.coolRockCakeSidebar = new NpcStep((QuestHelper)this, 3140, new WorldPoint(3008, 3471, 0), "If you didn't pick up the rock cake with ice gloves, kill an icefiend to cool the rock cake.", this.rockCakeHot);
        this.coolRockCakeSidebar.addSubSteps(this.coolRockCake);
        this.enterDiningRoomAgain = new ObjectStep((QuestHelper)this, 12349, new WorldPoint(3213, 3221, 0), "Go use the dwarven rock cake on the dwarf.", new Requirement[0]);
        this.useRockCakeOnDwarf = new ObjectStep((QuestHelper)this, 12330, new WorldPoint(1862, 5321, 0), "Use the dwarven rock cake on the dwarf.", this.rockCakeHighlighted);
        this.useRockCakeOnDwarf.addIcon(7510);
        this.useRockCakeOnDwarf.addSubSteps(this.enterDiningRoomAgain);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.coins320, this.milk, this.flour, this.egg, this.bowlOfWater, this.asgarniaAle4, this.iceGloves);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.teleportFalador2, this.teleportLumbridge);
    }

    @Override
    public List<String> getCombatRequirements() {
        return Collections.singletonList("Icefiend if you don't have Ice Gloves");
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> reqs = new ArrayList<Requirement>();
        reqs.add(new VarbitRequirement(QuestVarbits.QUEST_RECIPE_FOR_DISASTER.getId(), Operation.GREATER_EQUAL, 3, "Started Recipe for Disaster"));
        reqs.add(new QuestRequirement(QuestHelperQuest.FISHING_CONTEST, QuestState.FINISHED));
        return reqs;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Arrays.asList(new ExperienceReward(Skill.COOKING, 1000), new ExperienceReward(Skill.SLAYER, 1000));
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Collections.singletonList(new ItemReward("A Dwarven Rock Cake", 7509, 1));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Collections.singletonList(new UnlockReward("Increased access to the Culinaromancer's Chest"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Saving the Dwarf", Arrays.asList(this.inspectDwarf, this.talkToKaylee, this.makeAle, this.enterTunnels, this.talkToOldDwarf, this.talkToOldDwarfMore, this.pickUpRockCake, this.coolRockCakeSidebar, this.useRockCakeOnDwarf), this.coins320, this.milk, this.flour, this.egg, this.bowlOfWater, this.asgarniaAle4, this.iceGloves));
        return allSteps;
    }

    @Override
    public QuestState getState(Client client) {
        int questState = client.getVarbitValue(QuestVarbits.QUEST_RECIPE_FOR_DISASTER_DWARF.getId());
        if (questState == 0) {
            return QuestState.NOT_STARTED;
        }
        if (questState < 60) {
            return QuestState.IN_PROGRESS;
        }
        return QuestState.FINISHED;
    }

    @Override
    public boolean isCompleted() {
        return this.getQuest().getVar(this.client) >= 60 || this.client.getVarbitValue(QuestVarbits.QUEST_RECIPE_FOR_DISASTER.getId()) < 3;
    }
}

